/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi;

import sqldelight.com.intellij.lang.FileASTNode;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.FileViewProvider;
import sqldelight.com.intellij.psi.PsiDirectory;
import sqldelight.com.intellij.psi.PsiFileSystemItem;
import sqldelight.com.intellij.psi.tree.IFileElementType;
import sqldelight.com.intellij.psi.util.PsiUtilCore;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public interface PsiFile
extends PsiFileSystemItem {
    public static final PsiFile[] EMPTY_ARRAY = new PsiFile[0];

    @Override
    public VirtualFile getVirtualFile();

    public PsiDirectory getContainingDirectory();

    @Override
    public PsiDirectory getParent();

    public long getModificationStamp();

    @NotNull
    public PsiFile getOriginalFile();

    @NotNull
    public FileType getFileType();

    @Deprecated
    public PsiFile @NotNull [] getPsiRoots();

    @NotNull
    public FileViewProvider getViewProvider();

    @Override
    public FileASTNode getNode();

    public void subtreeChanged();

    default public void clearCaches() {
    }

    @Nullable
    default public IFileElementType getFileElementType() {
        return ObjectUtils.tryCast(PsiUtilCore.getElementType(this.getNode()), IFileElementType.class);
    }
}

