/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.codeStyle;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.DefaultJDOMExternalizer;
import sqldelight.com.intellij.openapi.util.DifferenceFilter;
import sqldelight.com.intellij.openapi.util.InvalidDataException;
import sqldelight.com.intellij.openapi.util.WriteExternalException;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSchemes;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSettings;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSettingsService;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSettingsServiceListener;
import sqldelight.com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import sqldelight.com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import sqldelight.com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import sqldelight.com.intellij.psi.codeStyle.FileTypeIndentOptionsFactory;
import sqldelight.com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import sqldelight.com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.containers.WeakList;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.TestOnly;

public class CodeStyleSettingsManager
implements PersistentStateComponentWithModificationTracker<Element> {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsManager.class);
    @Deprecated(forRemoval=true)
    @Nullable
    public volatile CodeStyleSettings PER_PROJECT_SETTINGS;
    public volatile boolean USE_PER_PROJECT_SETTINGS;
    public volatile String PREFERRED_PROJECT_CODE_STYLE;
    private volatile CodeStyleSettings myTemporarySettings;
    private final List<CodeStyleSettingsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final WeakList<CodeStyleSettings> ourReferencedSettings = new WeakList();

    @NotNull
    public CodeStyleSettings createSettings() {
        CodeStyleSettings newSettings = new CodeStyleSettings(true, false);
        CodeStyleSettingsManager.registerSettings(newSettings);
        CodeStyleSettings codeStyleSettings = newSettings;
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        return codeStyleSettings;
    }

    static void registerSettings(@NotNull CodeStyleSettings newSettings) {
        if (newSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        ourReferencedSettings.add(newSettings);
    }

    @TestOnly
    @NotNull
    public final CodeStyleSettings createTemporarySettings() {
        CodeStyleSettings codeStyleSettings = this.myTemporarySettings = new CodeStyleSettings(true, false);
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    @NotNull
    public final CodeStyleSettings cloneSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(3);
        }
        CodeStyleSettings clonedSettings = new CodeStyleSettings(true, false);
        clonedSettings.copyFrom(settings);
        CodeStyleSettingsManager.registerSettings(clonedSettings);
        CodeStyleSettings codeStyleSettings = clonedSettings;
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        return codeStyleSettings;
    }

    @TestOnly
    @NotNull
    public static CodeStyleSettings createTestSettings(@Nullable CodeStyleSettings baseSettings) {
        CodeStyleSettings testSettings = new CodeStyleSettings(true, false);
        if (baseSettings != null) {
            testSettings.copyFrom(baseSettings);
        }
        CodeStyleSettings codeStyleSettings = testSettings;
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        return codeStyleSettings;
    }

    @NotNull
    private Collection<CodeStyleSettings> getAllSettings() {
        ArrayList<CodeStyleSettings> allSettings = new ArrayList<CodeStyleSettings>(this.enumSettings());
        allSettings.addAll(ourReferencedSettings.toStrongList());
        ArrayList<CodeStyleSettings> arrayList = allSettings;
        if (arrayList == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    public long getStateModificationCount() {
        return this.enumSettings().stream().mapToLong(settings -> settings.getModificationTracker().getModificationCount()).sum();
    }

    public static CodeStyleSettingsManager getInstance(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return CodeStyleSettingsManager.getInstance();
        }
        return project.getService(ProjectCodeStyleSettingsManager.class);
    }

    public static CodeStyleSettingsManager getInstance() {
        return ApplicationManager.getApplication().getService(AppCodeStyleSettingsManager.class);
    }

    protected void registerExtensionPointListeners(@Nullable Disposable disposable) {
        FileIndentOptionsProvider.EP_NAME.addChangeListener(this::notifyCodeStyleSettingsChanged, disposable);
        CodeStyleSettingsService.getInstance().addListener(new CodeStyleSettingsServiceListener(){

            @Override
            public void fileTypeIndentOptionsFactoryAdded(@NotNull FileTypeIndentOptionsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(0);
                }
                CodeStyleSettingsManager.this.registerFileTypeIndentOptions(CodeStyleSettingsManager.this.getAllSettings(), factory.getFileType(), factory.createIndentOptions());
            }

            @Override
            public void fileTypeIndentOptionsFactoryRemoved(@NotNull FileTypeIndentOptionsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(1);
                }
                CodeStyleSettingsManager.this.unregisterFileTypeIndentOptions(CodeStyleSettingsManager.this.getAllSettings(), factory.getFileType());
            }

            @Override
            public void languageCodeStyleProviderAdded(@NotNull LanguageCodeStyleProvider provider) {
                if (provider == null) {
                    1.$$$reportNull$$$0(2);
                }
                CodeStyleSettingsManager.this.registerLanguageSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
            }

            @Override
            public void languageCodeStyleProviderRemoved(@NotNull LanguageCodeStyleProvider provider) {
                if (provider == null) {
                    1.$$$reportNull$$$0(3);
                }
                CodeStyleSettingsManager.this.unregisterLanguageSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
            }

            @Override
            public void customCodeStyleSettingsFactoryAdded(@NotNull CustomCodeStyleSettingsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(4);
                }
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), factory);
            }

            @Override
            public void customCodeStyleSettingsFactoryRemoved(@NotNull CustomCodeStyleSettingsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(5);
                }
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), factory);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                }
                objectArray2[1] = "sqldelight/com/intellij/psi/codeStyle/CodeStyleSettingsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypeIndentOptionsFactoryAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypeIndentOptionsFactoryRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "languageCodeStyleProviderAdded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "languageCodeStyleProviderRemoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "customCodeStyleSettingsFactoryAdded";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "customCodeStyleSettingsFactoryRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
    }

    @NotNull
    protected Collection<CodeStyleSettings> enumSettings() {
        List<CodeStyleSettings> list = Collections.emptyList();
        if (list == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @ApiStatus.Internal
    public final void registerFileTypeIndentOptions(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull FileType fileType, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        if (fileType == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(9);
        }
        if (indentOptions == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(10);
        }
        allSettings.forEach(settings -> settings.registerAdditionalIndentOptions(fileType, indentOptions));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterFileTypeIndentOptions(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull FileType fileType) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(11);
        }
        if (fileType == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(12);
        }
        allSettings.forEach(settings -> settings.unregisterAdditionalIndentOptions(fileType));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerLanguageSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(13);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(14);
        }
        allSettings.forEach(settings -> settings.registerCommonSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterLanguageSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(15);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(16);
        }
        allSettings.forEach(settings -> settings.removeCommonSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerCustomSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull CustomCodeStyleSettingsFactory provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(17);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(18);
        }
        allSettings.forEach(settings -> settings.registerCustomSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterCustomSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull CustomCodeStyleSettingsFactory provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(19);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(20);
        }
        allSettings.forEach(settings -> settings.removeCustomSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @Deprecated
    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(21);
        }
        return codeStyleSettings;
    }

    protected void checkState() {
    }

    @Deprecated
    @NotNull
    public CodeStyleSettings getCurrentSettings() {
        CodeStyleSettings temporarySettings = this.myTemporarySettings;
        if (temporarySettings != null) {
            CodeStyleSettings codeStyleSettings = temporarySettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(22);
            }
            return codeStyleSettings;
        }
        this.checkState();
        CodeStyleSettings projectSettings = this.getMainProjectCodeStyle();
        if (this.USE_PER_PROJECT_SETTINGS && projectSettings != null) {
            CodeStyleSettings codeStyleSettings = projectSettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(23);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSchemes.getInstance().findPreferredScheme(this.PREFERRED_PROJECT_CODE_STYLE).getCodeStyleSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(24);
        }
        return codeStyleSettings;
    }

    @Override
    public Element getState() {
        Element result = new Element("state");
        try {
            DefaultJDOMExternalizer.write(this, result, (Predicate<? super Field>)new DifferenceFilter<CodeStyleSettingsManager>(this, new CodeStyleSettingsManager()){

                @Override
                public boolean test(@NotNull Field field) {
                    if (field == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return !CodeStyleSettingsManager.this.isIgnoredOnSave(field.getName()) && super.test(field);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "sqldelight/com/intellij/psi/codeStyle/CodeStyleSettingsManager$2", "test"));
                }
            });
        }
        catch (WriteExternalException e) {
            LOG.error(e);
        }
        return result;
    }

    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        if (fieldName == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(25);
        }
        return false;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(26);
        }
        try {
            DefaultJDOMExternalizer.readExternal(this, state);
        }
        catch (InvalidDataException e) {
            LOG.error(e);
        }
    }

    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.PER_PROJECT_SETTINGS = settings;
    }

    @Nullable
    public CodeStyleSettings getMainProjectCodeStyle() {
        return this.PER_PROJECT_SETTINGS;
    }

    @TestOnly
    public void setTemporarySettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(27);
        }
        this.myTemporarySettings = settings;
    }

    @TestOnly
    public void dropTemporarySettings() {
        this.myTemporarySettings = null;
    }

    @Nullable
    @TestOnly
    public CodeStyleSettings getTemporarySettings() {
        return this.myTemporarySettings;
    }

    public void addListener(@NotNull CodeStyleSettingsListener listener) {
        if (listener == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(28);
        }
        this.myListeners.add(listener);
    }

    private void removeListener(@NotNull CodeStyleSettingsListener listener) {
        if (listener == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(29);
        }
        this.myListeners.remove(listener);
    }

    public static void removeListener(@Nullable Project project, @NotNull CodeStyleSettingsListener listener) {
        CodeStyleSettingsManager projectInstance;
        if (listener == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(30);
        }
        if (project == null || project.isDefault()) {
            CodeStyleSettingsManager.getInstance().removeListener(listener);
        } else if (!project.isDisposed() && (projectInstance = (CodeStyleSettingsManager)project.getService(ProjectCodeStyleSettingsManager.class)) != null) {
            projectInstance.removeListener(listener);
        }
    }

    public void fireCodeStyleSettingsChanged(@Nullable PsiFile file) {
        for (CodeStyleSettingsListener listener : this.myListeners) {
            listener.codeStyleSettingsChanged(new CodeStyleSettingsChangeEvent(file));
        }
    }

    public final void notifyCodeStyleSettingsChanged() {
        this.updateSettingsTracker();
        this.fireCodeStyleSettingsChanged(null);
    }

    @ApiStatus.Internal
    public void updateSettingsTracker() {
        CodeStyleSettings settings = this.getCurrentSettings();
        settings.getModificationTracker().incModificationCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated code style settings modification tracker to " + settings.getModificationTracker().getModificationCount());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 3: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSettings";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporarySettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "enumSettings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneSettings";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypeIndentOptions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileTypeIndentOptions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerLanguageSettings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLanguageSettings";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomSettings";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unregisterCustomSettings";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOnSave";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

