/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.codeStyle;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.application.options.CodeStyle;
import sqldelight.com.intellij.application.options.codeStyle.properties.CommaSeparatedValues;
import sqldelight.com.intellij.configurationStore.Property;
import sqldelight.com.intellij.configurationStore.XmlSerializer;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.editor.Editor;
import sqldelight.com.intellij.openapi.util.Comparing;
import sqldelight.com.intellij.openapi.util.DefaultJDOMExternalizer;
import sqldelight.com.intellij.openapi.util.DifferenceFilter;
import sqldelight.com.intellij.openapi.util.JDOMExternalizable;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.psi.PsiDocumentManager;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSettings;
import sqldelight.com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import sqldelight.com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import sqldelight.com.intellij.psi.codeStyle.SoftMargins;
import sqldelight.com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import sqldelight.com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import sqldelight.com.intellij.psi.codeStyle.arrangement.Rearranger;
import sqldelight.com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class CommonCodeStyleSettings {
    @NonNls
    private static final String ARRANGEMENT_ELEMENT_NAME = "arrangement";
    @NotNull
    private final String myLangId;
    private ArrangementSettings myArrangementSettings;
    private CodeStyleSettings myRootSettings;
    @Nullable
    private IndentOptions myIndentOptions;
    private boolean myForceArrangeMenuAvailable;
    private final SoftMargins mySoftMargins;
    @NonNls
    private static final String INDENT_OPTIONS_TAG = "indentOptions";
    private static final Logger LOG = Logger.getInstance(CommonCodeStyleSettings.class);
    @Property(externalName="max_line_length")
    public int RIGHT_MARGIN;
    public boolean LINE_COMMENT_AT_FIRST_COLUMN;
    public boolean BLOCK_COMMENT_AT_FIRST_COLUMN;
    public boolean LINE_COMMENT_ADD_SPACE;
    public boolean BLOCK_COMMENT_ADD_SPACE;
    public boolean LINE_COMMENT_ADD_SPACE_ON_REFORMAT;
    public boolean KEEP_LINE_BREAKS;
    public boolean KEEP_FIRST_COLUMN_COMMENT;
    public boolean KEEP_CONTROL_STATEMENT_IN_ONE_LINE;
    public int KEEP_BLANK_LINES_IN_DECLARATIONS;
    public int KEEP_BLANK_LINES_IN_CODE;
    public int KEEP_BLANK_LINES_BETWEEN_PACKAGE_DECLARATION_AND_HEADER;
    @Property(externalName="keep_blank_lines_before_right_brace")
    public int KEEP_BLANK_LINES_BEFORE_RBRACE;
    public int BLANK_LINES_BEFORE_PACKAGE;
    public int BLANK_LINES_AFTER_PACKAGE;
    public int BLANK_LINES_BEFORE_IMPORTS;
    public int BLANK_LINES_AFTER_IMPORTS;
    public int BLANK_LINES_AROUND_CLASS;
    public int BLANK_LINES_AROUND_FIELD;
    public int BLANK_LINES_AROUND_METHOD;
    public int BLANK_LINES_BEFORE_METHOD_BODY;
    public int BLANK_LINES_AROUND_FIELD_IN_INTERFACE;
    public int BLANK_LINES_AROUND_METHOD_IN_INTERFACE;
    public int BLANK_LINES_AFTER_CLASS_HEADER;
    public int BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER;
    public int BLANK_LINES_BEFORE_CLASS_END;
    public static final int END_OF_LINE = 1;
    public static final int NEXT_LINE = 2;
    public static final int NEXT_LINE_SHIFTED = 3;
    public static final int NEXT_LINE_SHIFTED2 = 4;
    public static final int NEXT_LINE_IF_WRAPPED = 5;
    @Property(externalName="block_brace_style")
    @BraceStyleConstant
    public int BRACE_STYLE;
    @BraceStyleConstant
    public int CLASS_BRACE_STYLE;
    @BraceStyleConstant
    public int METHOD_BRACE_STYLE;
    @BraceStyleConstant
    public int LAMBDA_BRACE_STYLE;
    public boolean DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS;
    public boolean ELSE_ON_NEW_LINE;
    public boolean WHILE_ON_NEW_LINE;
    public boolean CATCH_ON_NEW_LINE;
    public boolean FINALLY_ON_NEW_LINE;
    public boolean INDENT_CASE_FROM_SWITCH;
    @Property(externalName="case_statement_on_separate_line")
    public boolean CASE_STATEMENT_ON_NEW_LINE;
    public boolean INDENT_BREAK_FROM_CASE;
    public boolean SPECIAL_ELSE_IF_TREATMENT;
    public boolean ALIGN_MULTILINE_CHAINED_METHODS;
    public boolean ALIGN_MULTILINE_PARAMETERS;
    public boolean ALIGN_MULTILINE_PARAMETERS_IN_CALLS;
    public boolean ALIGN_MULTILINE_RESOURCES;
    public boolean ALIGN_MULTILINE_FOR;
    public boolean ALIGN_MULTILINE_BINARY_OPERATION;
    public boolean ALIGN_MULTILINE_ASSIGNMENT;
    public boolean ALIGN_MULTILINE_TERNARY_OPERATION;
    public boolean ALIGN_MULTILINE_THROWS_LIST;
    public boolean ALIGN_THROWS_KEYWORD;
    public boolean ALIGN_MULTILINE_EXTENDS_LIST;
    @Property(externalName="align_multiline_method_parentheses")
    public boolean ALIGN_MULTILINE_METHOD_BRACKETS;
    public boolean ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION;
    public boolean ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION;
    public boolean ALIGN_GROUP_FIELD_DECLARATIONS;
    public boolean ALIGN_CONSECUTIVE_VARIABLE_DECLARATIONS;
    public boolean ALIGN_CONSECUTIVE_ASSIGNMENTS;
    public boolean ALIGN_SUBSEQUENT_SIMPLE_METHODS;
    public boolean SPACE_AROUND_ASSIGNMENT_OPERATORS;
    public boolean SPACE_AROUND_LOGICAL_OPERATORS;
    public boolean SPACE_AROUND_EQUALITY_OPERATORS;
    public boolean SPACE_AROUND_RELATIONAL_OPERATORS;
    public boolean SPACE_AROUND_BITWISE_OPERATORS;
    public boolean SPACE_AROUND_ADDITIVE_OPERATORS;
    public boolean SPACE_AROUND_MULTIPLICATIVE_OPERATORS;
    public boolean SPACE_AROUND_SHIFT_OPERATORS;
    public boolean SPACE_AROUND_UNARY_OPERATOR;
    public boolean SPACE_AROUND_LAMBDA_ARROW;
    public boolean SPACE_AROUND_METHOD_REF_DBL_COLON;
    public boolean SPACE_AFTER_COMMA;
    public boolean SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS;
    public boolean SPACE_BEFORE_COMMA;
    @Property(externalName="space_after_for_semicolon")
    public boolean SPACE_AFTER_SEMICOLON;
    @Property(externalName="space_before_for_semicolon")
    public boolean SPACE_BEFORE_SEMICOLON;
    public boolean SPACE_WITHIN_PARENTHESES;
    public boolean SPACE_WITHIN_METHOD_CALL_PARENTHESES;
    @Property(externalName="space_within_empty_method_call_parentheses")
    public boolean SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES;
    public boolean SPACE_WITHIN_METHOD_PARENTHESES;
    @Property(externalName="space_within_empty_method_parentheses")
    public boolean SPACE_WITHIN_EMPTY_METHOD_PARENTHESES;
    public boolean SPACE_WITHIN_IF_PARENTHESES;
    public boolean SPACE_WITHIN_WHILE_PARENTHESES;
    public boolean SPACE_WITHIN_FOR_PARENTHESES;
    public boolean SPACE_WITHIN_TRY_PARENTHESES;
    public boolean SPACE_WITHIN_CATCH_PARENTHESES;
    public boolean SPACE_WITHIN_SWITCH_PARENTHESES;
    public boolean SPACE_WITHIN_SYNCHRONIZED_PARENTHESES;
    public boolean SPACE_WITHIN_CAST_PARENTHESES;
    public boolean SPACE_WITHIN_BRACKETS;
    public boolean SPACE_WITHIN_BRACES;
    public boolean SPACE_WITHIN_ARRAY_INITIALIZER_BRACES;
    @Property(externalName="space_within_empty_array_initializer_braces")
    public boolean SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES;
    public boolean SPACE_AFTER_TYPE_CAST;
    public boolean SPACE_BEFORE_METHOD_CALL_PARENTHESES;
    public boolean SPACE_BEFORE_METHOD_PARENTHESES;
    public boolean SPACE_BEFORE_IF_PARENTHESES;
    public boolean SPACE_BEFORE_WHILE_PARENTHESES;
    public boolean SPACE_BEFORE_FOR_PARENTHESES;
    public boolean SPACE_BEFORE_TRY_PARENTHESES;
    public boolean SPACE_BEFORE_CATCH_PARENTHESES;
    public boolean SPACE_BEFORE_SWITCH_PARENTHESES;
    public boolean SPACE_BEFORE_SYNCHRONIZED_PARENTHESES;
    @Property(externalName="space_before_class_left_brace")
    public boolean SPACE_BEFORE_CLASS_LBRACE;
    @Property(externalName="space_before_method_left_brace")
    public boolean SPACE_BEFORE_METHOD_LBRACE;
    @Property(externalName="space_before_if_left_brace")
    public boolean SPACE_BEFORE_IF_LBRACE;
    @Property(externalName="space_before_else_left_brace")
    public boolean SPACE_BEFORE_ELSE_LBRACE;
    @Property(externalName="space_before_while_left_brace")
    public boolean SPACE_BEFORE_WHILE_LBRACE;
    @Property(externalName="space_before_for_left_brace")
    public boolean SPACE_BEFORE_FOR_LBRACE;
    @Property(externalName="space_before_do_left_brace")
    public boolean SPACE_BEFORE_DO_LBRACE;
    @Property(externalName="space_before_switch_left_brace")
    public boolean SPACE_BEFORE_SWITCH_LBRACE;
    @Property(externalName="space_before_try_left_brace")
    public boolean SPACE_BEFORE_TRY_LBRACE;
    @Property(externalName="space_before_catch_left_brace")
    public boolean SPACE_BEFORE_CATCH_LBRACE;
    @Property(externalName="space_before_finally_left_brace")
    public boolean SPACE_BEFORE_FINALLY_LBRACE;
    @Property(externalName="space_before_synchronized_left_brace")
    public boolean SPACE_BEFORE_SYNCHRONIZED_LBRACE;
    @Property(externalName="space_before_array_initializer_left_brace")
    public boolean SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE;
    @Property(externalName="space_before_annotation_array_initializer_left_brace")
    public boolean SPACE_BEFORE_ANNOTATION_ARRAY_INITIALIZER_LBRACE;
    public boolean SPACE_BEFORE_ELSE_KEYWORD;
    public boolean SPACE_BEFORE_WHILE_KEYWORD;
    public boolean SPACE_BEFORE_CATCH_KEYWORD;
    public boolean SPACE_BEFORE_FINALLY_KEYWORD;
    public boolean SPACE_BEFORE_QUEST;
    public boolean SPACE_AFTER_QUEST;
    public boolean SPACE_BEFORE_COLON;
    public boolean SPACE_AFTER_COLON;
    public boolean SPACE_BEFORE_TYPE_PARAMETER_LIST;
    public static final int DO_NOT_WRAP = 0;
    public static final int WRAP_AS_NEEDED = 1;
    public static final int WRAP_ALWAYS = 2;
    public static final int WRAP_ON_EVERY_ITEM = 4;
    @WrapConstant
    public int CALL_PARAMETERS_WRAP;
    public boolean PREFER_PARAMETERS_WRAP;
    @Property(externalName="call_parameters_new_line_after_left_paren")
    public boolean CALL_PARAMETERS_LPAREN_ON_NEXT_LINE;
    @Property(externalName="call_parameters_right_paren_on_new_line")
    public boolean CALL_PARAMETERS_RPAREN_ON_NEXT_LINE;
    @WrapConstant
    public int METHOD_PARAMETERS_WRAP;
    @Property(externalName="method_parameters_new_line_after_left_paren")
    public boolean METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE;
    @Property(externalName="method_parameters_right_paren_on_new_line")
    public boolean METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE;
    @WrapConstant
    public int RESOURCE_LIST_WRAP;
    @Property(externalName="resource_list_new_line_after_left_paren")
    public boolean RESOURCE_LIST_LPAREN_ON_NEXT_LINE;
    @Property(externalName="resource_list_right_paren_on_new_line")
    public boolean RESOURCE_LIST_RPAREN_ON_NEXT_LINE;
    @WrapConstant
    public int EXTENDS_LIST_WRAP;
    @WrapConstant
    public int THROWS_LIST_WRAP;
    @WrapConstant
    public int EXTENDS_KEYWORD_WRAP;
    @WrapConstant
    public int THROWS_KEYWORD_WRAP;
    @WrapConstant
    public int METHOD_CALL_CHAIN_WRAP;
    public boolean WRAP_FIRST_METHOD_IN_CALL_CHAIN;
    @Property(externalName="parentheses_expression_new_line_after_left_paren")
    public boolean PARENTHESES_EXPRESSION_LPAREN_WRAP;
    @Property(externalName="parentheses_expression_right_paren_on_new_line")
    public boolean PARENTHESES_EXPRESSION_RPAREN_WRAP;
    @WrapConstant
    public int BINARY_OPERATION_WRAP;
    public boolean BINARY_OPERATION_SIGN_ON_NEXT_LINE;
    @WrapConstant
    public int TERNARY_OPERATION_WRAP;
    public boolean TERNARY_OPERATION_SIGNS_ON_NEXT_LINE;
    @WrapConstant
    public boolean MODIFIER_LIST_WRAP;
    public boolean KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
    public boolean KEEP_SIMPLE_METHODS_IN_ONE_LINE;
    public boolean KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE;
    public boolean KEEP_SIMPLE_CLASSES_IN_ONE_LINE;
    public boolean KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE;
    @WrapConstant
    public int FOR_STATEMENT_WRAP;
    @Property(externalName="for_statement_new_line_after_left_paren")
    public boolean FOR_STATEMENT_LPAREN_ON_NEXT_LINE;
    @Property(externalName="for_statement_right_paren_on_new_line")
    public boolean FOR_STATEMENT_RPAREN_ON_NEXT_LINE;
    @WrapConstant
    public int ARRAY_INITIALIZER_WRAP;
    @Property(externalName="array_initializer_new_line_after_left_brace")
    public boolean ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE;
    @Property(externalName="array_initializer_right_brace_on_new_line")
    public boolean ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE;
    @WrapConstant
    public int ASSIGNMENT_WRAP;
    public boolean PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE;
    public boolean WRAP_COMMENTS;
    @WrapConstant
    public int ASSERT_STATEMENT_WRAP;
    public boolean ASSERT_STATEMENT_COLON_ON_NEXT_LINE;
    public static final int DO_NOT_FORCE = 0;
    public static final int FORCE_BRACES_IF_MULTILINE = 1;
    public static final int FORCE_BRACES_ALWAYS = 3;
    @ForceBraceConstant
    public int IF_BRACE_FORCE;
    @Property(externalName="do_while_brace_force")
    @ForceBraceConstant
    public int DOWHILE_BRACE_FORCE;
    @ForceBraceConstant
    public int WHILE_BRACE_FORCE;
    @ForceBraceConstant
    public int FOR_BRACE_FORCE;
    public boolean WRAP_LONG_LINES;
    @WrapConstant
    public int METHOD_ANNOTATION_WRAP;
    @WrapConstant
    public int CLASS_ANNOTATION_WRAP;
    @WrapConstant
    public int FIELD_ANNOTATION_WRAP;
    @WrapConstant
    public int PARAMETER_ANNOTATION_WRAP;
    @WrapConstant
    public int VARIABLE_ANNOTATION_WRAP;
    @Property(externalName="space_before_annotation_parameter_list")
    public boolean SPACE_BEFORE_ANOTATION_PARAMETER_LIST;
    public boolean SPACE_WITHIN_ANNOTATION_PARENTHESES;
    @WrapConstant
    public int ENUM_CONSTANTS_WRAP;
    @CommaSeparatedValues
    @NonNls
    public String BUILDER_METHODS;
    public boolean KEEP_BUILDER_METHODS_INDENTS;
    @NotNull
    private final Set<String> myBuilderMethodsNameCache;
    @NotNull
    private String myCachedBuilderMethods;
    public static final int REARRANGE_ACCORDIND_TO_DIALOG = 0;
    public static final int REARRANGE_ALWAYS = 1;
    public static final int REARRANGE_NEVER = 2;
    public int FORCE_REARRANGE_MODE;
    public int WRAP_ON_TYPING;

    public CommonCodeStyleSettings(@Nullable Language language) {
        this(ObjectUtils.notNull(language, Language.ANY).getID());
    }

    private CommonCodeStyleSettings(@NotNull String langId) {
        if (langId == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(0);
        }
        this.mySoftMargins = new SoftMargins();
        this.RIGHT_MARGIN = -1;
        this.LINE_COMMENT_AT_FIRST_COLUMN = true;
        this.BLOCK_COMMENT_AT_FIRST_COLUMN = true;
        this.LINE_COMMENT_ADD_SPACE = false;
        this.BLOCK_COMMENT_ADD_SPACE = false;
        this.LINE_COMMENT_ADD_SPACE_ON_REFORMAT = false;
        this.KEEP_LINE_BREAKS = true;
        this.KEEP_FIRST_COLUMN_COMMENT = true;
        this.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = true;
        this.KEEP_BLANK_LINES_IN_DECLARATIONS = 2;
        this.KEEP_BLANK_LINES_IN_CODE = 2;
        this.KEEP_BLANK_LINES_BETWEEN_PACKAGE_DECLARATION_AND_HEADER = 2;
        this.KEEP_BLANK_LINES_BEFORE_RBRACE = 2;
        this.BLANK_LINES_BEFORE_PACKAGE = 0;
        this.BLANK_LINES_AFTER_PACKAGE = 1;
        this.BLANK_LINES_BEFORE_IMPORTS = 1;
        this.BLANK_LINES_AFTER_IMPORTS = 1;
        this.BLANK_LINES_AROUND_CLASS = 1;
        this.BLANK_LINES_AROUND_FIELD = 0;
        this.BLANK_LINES_AROUND_METHOD = 1;
        this.BLANK_LINES_BEFORE_METHOD_BODY = 0;
        this.BLANK_LINES_AROUND_FIELD_IN_INTERFACE = 0;
        this.BLANK_LINES_AROUND_METHOD_IN_INTERFACE = 1;
        this.BLANK_LINES_AFTER_CLASS_HEADER = 0;
        this.BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER = 0;
        this.BLANK_LINES_BEFORE_CLASS_END = 0;
        this.BRACE_STYLE = 1;
        this.CLASS_BRACE_STYLE = 1;
        this.METHOD_BRACE_STYLE = 1;
        this.LAMBDA_BRACE_STYLE = 1;
        this.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = false;
        this.ELSE_ON_NEW_LINE = false;
        this.WHILE_ON_NEW_LINE = false;
        this.CATCH_ON_NEW_LINE = false;
        this.FINALLY_ON_NEW_LINE = false;
        this.INDENT_CASE_FROM_SWITCH = true;
        this.CASE_STATEMENT_ON_NEW_LINE = true;
        this.INDENT_BREAK_FROM_CASE = true;
        this.SPECIAL_ELSE_IF_TREATMENT = true;
        this.ALIGN_MULTILINE_CHAINED_METHODS = false;
        this.ALIGN_MULTILINE_PARAMETERS = true;
        this.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
        this.ALIGN_MULTILINE_RESOURCES = true;
        this.ALIGN_MULTILINE_FOR = true;
        this.ALIGN_MULTILINE_BINARY_OPERATION = false;
        this.ALIGN_MULTILINE_ASSIGNMENT = false;
        this.ALIGN_MULTILINE_TERNARY_OPERATION = false;
        this.ALIGN_MULTILINE_THROWS_LIST = false;
        this.ALIGN_THROWS_KEYWORD = false;
        this.ALIGN_MULTILINE_EXTENDS_LIST = false;
        this.ALIGN_MULTILINE_METHOD_BRACKETS = false;
        this.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION = false;
        this.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = false;
        this.ALIGN_GROUP_FIELD_DECLARATIONS = false;
        this.ALIGN_CONSECUTIVE_VARIABLE_DECLARATIONS = false;
        this.ALIGN_CONSECUTIVE_ASSIGNMENTS = false;
        this.ALIGN_SUBSEQUENT_SIMPLE_METHODS = false;
        this.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        this.SPACE_AROUND_LOGICAL_OPERATORS = true;
        this.SPACE_AROUND_EQUALITY_OPERATORS = true;
        this.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        this.SPACE_AROUND_BITWISE_OPERATORS = true;
        this.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        this.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        this.SPACE_AROUND_SHIFT_OPERATORS = true;
        this.SPACE_AROUND_UNARY_OPERATOR = false;
        this.SPACE_AROUND_LAMBDA_ARROW = true;
        this.SPACE_AROUND_METHOD_REF_DBL_COLON = false;
        this.SPACE_AFTER_COMMA = true;
        this.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS = true;
        this.SPACE_BEFORE_COMMA = false;
        this.SPACE_AFTER_SEMICOLON = true;
        this.SPACE_BEFORE_SEMICOLON = false;
        this.SPACE_WITHIN_PARENTHESES = false;
        this.SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
        this.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES = false;
        this.SPACE_WITHIN_METHOD_PARENTHESES = false;
        this.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES = false;
        this.SPACE_WITHIN_IF_PARENTHESES = false;
        this.SPACE_WITHIN_WHILE_PARENTHESES = false;
        this.SPACE_WITHIN_FOR_PARENTHESES = false;
        this.SPACE_WITHIN_TRY_PARENTHESES = false;
        this.SPACE_WITHIN_CATCH_PARENTHESES = false;
        this.SPACE_WITHIN_SWITCH_PARENTHESES = false;
        this.SPACE_WITHIN_SYNCHRONIZED_PARENTHESES = false;
        this.SPACE_WITHIN_CAST_PARENTHESES = false;
        this.SPACE_WITHIN_BRACKETS = false;
        this.SPACE_WITHIN_BRACES = false;
        this.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
        this.SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES = false;
        this.SPACE_AFTER_TYPE_CAST = true;
        this.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
        this.SPACE_BEFORE_METHOD_PARENTHESES = false;
        this.SPACE_BEFORE_IF_PARENTHESES = true;
        this.SPACE_BEFORE_WHILE_PARENTHESES = true;
        this.SPACE_BEFORE_FOR_PARENTHESES = true;
        this.SPACE_BEFORE_TRY_PARENTHESES = true;
        this.SPACE_BEFORE_CATCH_PARENTHESES = true;
        this.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        this.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES = true;
        this.SPACE_BEFORE_CLASS_LBRACE = true;
        this.SPACE_BEFORE_METHOD_LBRACE = true;
        this.SPACE_BEFORE_IF_LBRACE = true;
        this.SPACE_BEFORE_ELSE_LBRACE = true;
        this.SPACE_BEFORE_WHILE_LBRACE = true;
        this.SPACE_BEFORE_FOR_LBRACE = true;
        this.SPACE_BEFORE_DO_LBRACE = true;
        this.SPACE_BEFORE_SWITCH_LBRACE = true;
        this.SPACE_BEFORE_TRY_LBRACE = true;
        this.SPACE_BEFORE_CATCH_LBRACE = true;
        this.SPACE_BEFORE_FINALLY_LBRACE = true;
        this.SPACE_BEFORE_SYNCHRONIZED_LBRACE = true;
        this.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE = false;
        this.SPACE_BEFORE_ANNOTATION_ARRAY_INITIALIZER_LBRACE = false;
        this.SPACE_BEFORE_ELSE_KEYWORD = true;
        this.SPACE_BEFORE_WHILE_KEYWORD = true;
        this.SPACE_BEFORE_CATCH_KEYWORD = true;
        this.SPACE_BEFORE_FINALLY_KEYWORD = true;
        this.SPACE_BEFORE_QUEST = true;
        this.SPACE_AFTER_QUEST = true;
        this.SPACE_BEFORE_COLON = true;
        this.SPACE_AFTER_COLON = true;
        this.SPACE_BEFORE_TYPE_PARAMETER_LIST = false;
        this.CALL_PARAMETERS_WRAP = 0;
        this.PREFER_PARAMETERS_WRAP = false;
        this.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
        this.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
        this.METHOD_PARAMETERS_WRAP = 0;
        this.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
        this.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
        this.RESOURCE_LIST_WRAP = 0;
        this.RESOURCE_LIST_LPAREN_ON_NEXT_LINE = false;
        this.RESOURCE_LIST_RPAREN_ON_NEXT_LINE = false;
        this.EXTENDS_LIST_WRAP = 0;
        this.THROWS_LIST_WRAP = 0;
        this.EXTENDS_KEYWORD_WRAP = 0;
        this.THROWS_KEYWORD_WRAP = 0;
        this.METHOD_CALL_CHAIN_WRAP = 0;
        this.WRAP_FIRST_METHOD_IN_CALL_CHAIN = false;
        this.PARENTHESES_EXPRESSION_LPAREN_WRAP = false;
        this.PARENTHESES_EXPRESSION_RPAREN_WRAP = false;
        this.BINARY_OPERATION_WRAP = 0;
        this.BINARY_OPERATION_SIGN_ON_NEXT_LINE = false;
        this.TERNARY_OPERATION_WRAP = 0;
        this.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = false;
        this.MODIFIER_LIST_WRAP = false;
        this.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
        this.KEEP_SIMPLE_METHODS_IN_ONE_LINE = false;
        this.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE = false;
        this.KEEP_SIMPLE_CLASSES_IN_ONE_LINE = false;
        this.KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE = false;
        this.FOR_STATEMENT_WRAP = 0;
        this.FOR_STATEMENT_LPAREN_ON_NEXT_LINE = false;
        this.FOR_STATEMENT_RPAREN_ON_NEXT_LINE = false;
        this.ARRAY_INITIALIZER_WRAP = 0;
        this.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = false;
        this.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = false;
        this.ASSIGNMENT_WRAP = 0;
        this.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE = false;
        this.WRAP_COMMENTS = false;
        this.ASSERT_STATEMENT_WRAP = 0;
        this.ASSERT_STATEMENT_COLON_ON_NEXT_LINE = false;
        this.IF_BRACE_FORCE = 0;
        this.DOWHILE_BRACE_FORCE = 0;
        this.WHILE_BRACE_FORCE = 0;
        this.FOR_BRACE_FORCE = 0;
        this.WRAP_LONG_LINES = false;
        this.METHOD_ANNOTATION_WRAP = 2;
        this.CLASS_ANNOTATION_WRAP = 2;
        this.FIELD_ANNOTATION_WRAP = 2;
        this.PARAMETER_ANNOTATION_WRAP = 0;
        this.VARIABLE_ANNOTATION_WRAP = 0;
        this.SPACE_BEFORE_ANOTATION_PARAMETER_LIST = false;
        this.SPACE_WITHIN_ANNOTATION_PARENTHESES = false;
        this.ENUM_CONSTANTS_WRAP = 0;
        this.BUILDER_METHODS = "";
        this.KEEP_BUILDER_METHODS_INDENTS = false;
        this.myBuilderMethodsNameCache = new HashSet<String>();
        this.myCachedBuilderMethods = "";
        this.FORCE_REARRANGE_MODE = 0;
        this.WRAP_ON_TYPING = WrapOnTyping.DEFAULT.intValue;
        this.myLangId = langId;
    }

    void setRootSettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(1);
        }
        this.myRootSettings = rootSettings;
    }

    @NotNull
    public Language getLanguage() {
        Language language = Language.findLanguageByID(this.myLangId);
        if (language == null) {
            LOG.error("Can't find the language with ID " + this.myLangId);
            Language language2 = Language.ANY;
            if (language2 == null) {
                CommonCodeStyleSettings.$$$reportNull$$$0(2);
            }
            return language2;
        }
        Language language3 = language;
        if (language3 == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(3);
        }
        return language3;
    }

    @NotNull
    public IndentOptions initIndentOptions() {
        IndentOptions indentOptions = this.myIndentOptions = new IndentOptions();
        if (indentOptions == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(4);
        }
        return indentOptions;
    }

    @NotNull
    public CodeStyleSettings getRootSettings() {
        CodeStyleSettings codeStyleSettings = this.myRootSettings;
        if (codeStyleSettings == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(5);
        }
        return codeStyleSettings;
    }

    @Nullable
    public IndentOptions getIndentOptions() {
        return this.myIndentOptions;
    }

    @Nullable
    public ArrangementSettings getArrangementSettings() {
        return this.myArrangementSettings;
    }

    public void setArrangementSettings(@NotNull ArrangementSettings settings) {
        if (settings == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(6);
        }
        this.myArrangementSettings = settings;
    }

    public void setForceArrangeMenuAvailable(boolean value) {
        this.myForceArrangeMenuAvailable = value;
    }

    public boolean isForceArrangeMenuAvailable() {
        return this.myForceArrangeMenuAvailable;
    }

    public CommonCodeStyleSettings clone(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(7);
        }
        CommonCodeStyleSettings commonSettings = new CommonCodeStyleSettings(this.myLangId);
        CommonCodeStyleSettings.copyPublicFields(this, commonSettings);
        commonSettings.setRootSettings(rootSettings);
        commonSettings.myForceArrangeMenuAvailable = this.myForceArrangeMenuAvailable;
        if (this.myIndentOptions != null) {
            IndentOptions targetIndentOptions = commonSettings.initIndentOptions();
            targetIndentOptions.copyFrom(this.myIndentOptions);
        }
        if (this.myArrangementSettings != null) {
            commonSettings.setArrangementSettings(this.myArrangementSettings.clone());
        }
        commonSettings.setSoftMargins(this.getSoftMargins());
        return commonSettings;
    }

    protected static void copyPublicFields(Object from, Object to) {
        assert (from != to);
        ReflectionUtil.copyFields(to.getClass().getFields(), from, to);
    }

    public void copyFrom(@NotNull CommonCodeStyleSettings source) {
        IndentOptions sourceIndentOptions;
        if (source == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(8);
        }
        CommonCodeStyleSettings.copyPublicFields(source, this);
        if (this.myIndentOptions != null && (sourceIndentOptions = source.getIndentOptions()) != null) {
            this.myIndentOptions.copyFrom(sourceIndentOptions);
        }
        this.setSoftMargins(source.getSoftMargins());
    }

    public void readExternal(Element element) {
        Element arrangementRulesContainer;
        Element indentOptionsElement;
        DefaultJDOMExternalizer.readExternal(this, element);
        if (this.myIndentOptions != null && (indentOptionsElement = element.getChild(INDENT_OPTIONS_TAG)) != null) {
            this.myIndentOptions.deserialize(indentOptionsElement);
        }
        if ((arrangementRulesContainer = element.getChild(ARRANGEMENT_ELEMENT_NAME)) != null) {
            this.myArrangementSettings = ArrangementUtil.readExternal(arrangementRulesContainer, this.getLanguage());
        }
        this.mySoftMargins.deserializeFrom(element);
        LOG.info("Loaded " + this.getLanguage().getDisplayName() + " common code style settings");
    }

    public void writeExternal(Element element) {
        LanguageCodeStyleProvider provider = LanguageCodeStyleProvider.forLanguage(this.getLanguage());
        if (provider != null) {
            this.writeExternal(element, provider);
        }
    }

    public void writeExternal(@NotNull Element element, @NotNull LanguageCodeStyleProvider provider) {
        if (element == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(9);
        }
        if (provider == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(10);
        }
        CommonCodeStyleSettings defaultSettings = provider.getDefaultCommonSettings();
        Set<String> supportedFields = provider.getSupportedFields();
        if (supportedFields == null) {
            return;
        }
        supportedFields.add("FORCE_REARRANGE_MODE");
        DefaultJDOMExternalizer.write(this, element, new SupportedFieldsDiffFilter(this, supportedFields, defaultSettings));
        this.mySoftMargins.serializeInto(element);
        if (this.myIndentOptions != null) {
            IndentOptions defaultIndentOptions = defaultSettings.getIndentOptions();
            Element indentOptionsElement = new Element(INDENT_OPTIONS_TAG);
            this.myIndentOptions.serialize(indentOptionsElement, defaultIndentOptions);
            if (!indentOptionsElement.getChildren().isEmpty()) {
                element.addContent(indentOptionsElement);
            }
        }
        if (this.myArrangementSettings != null) {
            Element container = new Element(ARRANGEMENT_ELEMENT_NAME);
            ArrangementUtil.writeExternal(container, this.myArrangementSettings, provider.getLanguage());
            if (!container.getChildren().isEmpty()) {
                element.addContent(container);
            }
        }
    }

    public boolean isBuilderMethod(@NotNull String methodName) {
        if (methodName == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(11);
        }
        if (!StringUtil.equals(this.BUILDER_METHODS, this.myCachedBuilderMethods)) {
            this.myCachedBuilderMethods = this.BUILDER_METHODS;
            this.myBuilderMethodsNameCache.clear();
            Arrays.stream(this.BUILDER_METHODS.split(",")).filter(chunk -> !StringUtil.isEmptyOrSpaces(chunk)).forEach(chunk -> this.myBuilderMethodsNameCache.add(chunk.trim()));
        }
        return this.myBuilderMethodsNameCache.contains(methodName);
    }

    public boolean equals(Object obj) {
        return obj instanceof CommonCodeStyleSettings && ReflectionUtil.comparePublicNonFinalFields(this, obj) && this.mySoftMargins.equals(((CommonCodeStyleSettings)obj).mySoftMargins) && Comparing.equal(this.myIndentOptions, ((CommonCodeStyleSettings)obj).getIndentOptions()) && this.arrangementSettingsEqual((CommonCodeStyleSettings)obj);
    }

    protected boolean arrangementSettingsEqual(CommonCodeStyleSettings obj) {
        Rearranger<?> rearranger;
        ArrangementSettings theseSettings = this.myArrangementSettings;
        ArrangementSettings otherSettings = obj.getArrangementSettings();
        if (theseSettings == null && otherSettings != null && (rearranger = Rearranger.EXTENSION.forLanguage(this.getLanguage())) instanceof ArrangementStandardSettingsAware) {
            theseSettings = ((ArrangementStandardSettingsAware)((Object)rearranger)).getDefaultSettings();
        }
        return Comparing.equal(theseSettings, obj.getArrangementSettings());
    }

    @NotNull
    public List<Integer> getSoftMargins() {
        List<Integer> list = this.mySoftMargins.getValues();
        if (list == null) {
            CommonCodeStyleSettings.$$$reportNull$$$0(12);
        }
        return list;
    }

    void setSoftMargins(List<Integer> values) {
        this.mySoftMargins.setValues(values);
    }

    @Deprecated(forRemoval=true)
    public static CommonCodeStyleSettings getLocalCodeStyleSettings(Editor editor, int tailOffset) {
        return CodeStyle.getLocalLanguageSettings(editor, tailOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langId";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/codeStyle/CommonCodeStyleSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/codeStyle/CommonCodeStyleSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initIndentOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootSettings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftMargins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRootSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setArrangementSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBuilderMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IndentOptions
    implements Cloneable,
    JDOMExternalizable {
        public static final IndentOptions DEFAULT_INDENT_OPTIONS = new IndentOptions();
        public int INDENT_SIZE = 4;
        public int CONTINUATION_INDENT_SIZE = 8;
        @Property(externalName="tab_width")
        public int TAB_SIZE = 4;
        public boolean USE_TAB_CHARACTER = false;
        public boolean SMART_TABS = false;
        public int LABEL_INDENT_SIZE = 0;
        public boolean LABEL_INDENT_ABSOLUTE = false;
        public boolean USE_RELATIVE_INDENTS = false;
        public boolean KEEP_INDENTS_ON_EMPTY_LINES = false;
        public int DECLARATION_PARAMETER_INDENT = -1;
        public int GENERIC_TYPE_PARAMETER_INDENT = -1;
        public int CALL_PARAMETER_INDENT = -1;
        public int CHAINED_CALL_INDENT = -1;
        public int ARRAY_ELEMENT_INDENT = -1;
        private FileIndentOptionsProvider myFileIndentOptionsProvider;
        private static final Key<IndentOptions> INDENT_OPTIONS_KEY = Key.create("INDENT_OPTIONS_KEY");
        private boolean myOverrideLanguageOptions;

        @Override
        public void readExternal(Element element) {
            this.deserialize(element);
        }

        @Override
        public void writeExternal(Element element) {
            this.serialize(element, DEFAULT_INDENT_OPTIONS);
        }

        public void serialize(@NotNull Element indentOptionsElement, final @Nullable IndentOptions defaultOptions) {
            if (indentOptionsElement == null) {
                IndentOptions.$$$reportNull$$$0(0);
            }
            SkipDefaultValuesSerializationFilters filter = null;
            if (defaultOptions != null) {
                filter = new SkipDefaultValuesSerializationFilters(){

                    @Override
                    protected void configure(@NotNull Object o) {
                        if (o == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (o instanceof IndentOptions) {
                            ((IndentOptions)o).copyFrom(defaultOptions);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "sqldelight/com/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions$1", "configure"));
                    }
                };
            }
            XmlSerializer.serializeObjectInto(this, indentOptionsElement, filter);
        }

        public void deserialize(Element indentOptionsElement) {
            XmlSerializer.deserializeInto(indentOptionsElement, this);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndentOptions)) {
                return false;
            }
            IndentOptions that = (IndentOptions)o;
            if (this.CONTINUATION_INDENT_SIZE != that.CONTINUATION_INDENT_SIZE) {
                return false;
            }
            if (this.INDENT_SIZE != that.INDENT_SIZE) {
                return false;
            }
            if (this.LABEL_INDENT_ABSOLUTE != that.LABEL_INDENT_ABSOLUTE) {
                return false;
            }
            if (this.USE_RELATIVE_INDENTS != that.USE_RELATIVE_INDENTS) {
                return false;
            }
            if (this.LABEL_INDENT_SIZE != that.LABEL_INDENT_SIZE) {
                return false;
            }
            if (this.SMART_TABS != that.SMART_TABS) {
                return false;
            }
            if (this.TAB_SIZE != that.TAB_SIZE) {
                return false;
            }
            if (this.USE_TAB_CHARACTER != that.USE_TAB_CHARACTER) {
                return false;
            }
            if (this.DECLARATION_PARAMETER_INDENT != that.DECLARATION_PARAMETER_INDENT) {
                return false;
            }
            if (this.GENERIC_TYPE_PARAMETER_INDENT != that.GENERIC_TYPE_PARAMETER_INDENT) {
                return false;
            }
            if (this.CALL_PARAMETER_INDENT != that.CALL_PARAMETER_INDENT) {
                return false;
            }
            if (this.CHAINED_CALL_INDENT != that.CHAINED_CALL_INDENT) {
                return false;
            }
            return this.ARRAY_ELEMENT_INDENT == that.ARRAY_ELEMENT_INDENT;
        }

        public int hashCode() {
            int result = this.INDENT_SIZE;
            result = 31 * result + this.CONTINUATION_INDENT_SIZE;
            result = 31 * result + this.TAB_SIZE;
            result = 31 * result + (this.USE_TAB_CHARACTER ? 1 : 0);
            result = 31 * result + (this.SMART_TABS ? 1 : 0);
            result = 31 * result + this.LABEL_INDENT_SIZE;
            result = 31 * result + (this.LABEL_INDENT_ABSOLUTE ? 1 : 0);
            result = 31 * result + (this.USE_RELATIVE_INDENTS ? 1 : 0);
            return result;
        }

        public void copyFrom(IndentOptions other) {
            CommonCodeStyleSettings.copyPublicFields(other, this);
        }

        @Nullable
        public FileIndentOptionsProvider getFileIndentOptionsProvider() {
            return this.myFileIndentOptionsProvider;
        }

        void setFileIndentOptionsProvider(@NotNull FileIndentOptionsProvider provider) {
            if (provider == null) {
                IndentOptions.$$$reportNull$$$0(1);
            }
            this.myFileIndentOptionsProvider = provider;
        }

        public void associateWithDocument(@NotNull Document document) {
            if (document == null) {
                IndentOptions.$$$reportNull$$$0(2);
            }
            document.putUserData(INDENT_OPTIONS_KEY, this);
        }

        @Nullable
        public static IndentOptions retrieveFromAssociatedDocument(@NotNull PsiFile file) {
            Document document;
            if (file == null) {
                IndentOptions.$$$reportNull$$$0(3);
            }
            return (document = PsiDocumentManager.getInstance(file.getProject()).getDocument(file)) != null ? document.getUserData(INDENT_OPTIONS_KEY) : null;
        }

        public boolean isOverrideLanguageOptions() {
            return this.myOverrideLanguageOptions;
        }

        public void setOverrideLanguageOptions(boolean overrideLanguageOptions) {
            this.myOverrideLanguageOptions = overrideLanguageOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indentOptionsElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "sqldelight/com/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serialize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFileIndentOptionsProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "associateWithDocument";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "retrieveFromAssociatedDocument";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum WrapOnTyping {
        DEFAULT(-1),
        NO_WRAP(0),
        WRAP(1);

        public int intValue;

        private WrapOnTyping(int i) {
            this.intValue = i;
        }
    }

    public static @interface ForceBraceConstant {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface WrapConstant {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BraceStyleConstant {
    }

    public static final class SupportedFieldsDiffFilter
    extends DifferenceFilter<CommonCodeStyleSettings> {
        private final Set<String> mySupportedFieldNames;

        public SupportedFieldsDiffFilter(CommonCodeStyleSettings object, Set<String> supportedFiledNames, CommonCodeStyleSettings parentObject) {
            super(object, parentObject);
            this.mySupportedFieldNames = supportedFiledNames;
        }

        @Override
        public boolean test(@NotNull Field field) {
            if (field == null) {
                SupportedFieldsDiffFilter.$$$reportNull$$$0(0);
            }
            if (this.mySupportedFieldNames != null && this.mySupportedFieldNames.contains(field.getName())) {
                return super.test(field);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "sqldelight/com/intellij/psi/codeStyle/CommonCodeStyleSettings$SupportedFieldsDiffFilter", "test"));
        }
    }
}

