/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.codeStyle;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import sqldelight.com.intellij.diagnostic.PluginException;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.InvalidDataException;
import sqldelight.com.intellij.openapi.util.JDOMUtil;
import sqldelight.com.intellij.openapi.util.RecursionManager;
import sqldelight.com.intellij.openapi.util.Ref;
import sqldelight.com.intellij.openapi.util.WriteExternalException;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSettings;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSettingsService;
import sqldelight.com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import sqldelight.com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import sqldelight.com.intellij.util.ArrayUtilRt;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jdom.Content;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

final class CommonCodeStyleSettingsManager {
    private volatile Map<String, CommonCodeStyleSettings> myCommonSettingsMap;
    private volatile Map<String, Element> myUnknownSettingsMap;
    @NotNull
    private final CodeStyleSettings myParentSettings;
    @NonNls
    static final String COMMON_SETTINGS_TAG = "codeStyleSettings";
    private static final String LANGUAGE_ATTR = "language";
    private static final Logger LOG = Logger.getInstance(CommonCodeStyleSettingsManager.class);

    CommonCodeStyleSettingsManager(@NotNull CodeStyleSettings parentSettings) {
        if (parentSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        this.myParentSettings = parentSettings;
    }

    @Nullable
    CommonCodeStyleSettings getCommonSettings(@Nullable Language lang) {
        Map<String, CommonCodeStyleSettings> commonSettingsMap = this.getCommonSettingsMap();
        for (Language baseLang = ObjectUtils.notNull(lang, Language.ANY); baseLang != null; baseLang = baseLang.getBaseLanguage()) {
            CommonCodeStyleSettings settings = commonSettingsMap.get(baseLang.getID());
            if (settings == null) continue;
            return settings;
        }
        return null;
    }

    CommonCodeStyleSettings getDefaults() {
        return DefaultsHolder.SETTINGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<String, CommonCodeStyleSettings> getCommonSettingsMap() {
        Map<String, CommonCodeStyleSettings> commonSettingsMap = this.myCommonSettingsMap;
        if (commonSettingsMap == null) {
            CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
            synchronized (commonCodeStyleSettingsManager) {
                commonSettingsMap = this.myCommonSettingsMap;
                if (commonSettingsMap == null) {
                    commonSettingsMap = this.initCommonSettingsMap();
                    this.initNonReadSettings();
                }
            }
        }
        Map<String, CommonCodeStyleSettings> map = commonSettingsMap;
        if (map == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@NotNull String langName) {
        if (langName == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        Map<String, CommonCodeStyleSettings> map = this.getCommonSettingsMap();
        for (Language language : Language.getRegisteredLanguages()) {
            CommonCodeStyleSettings settings;
            if (!langName.equals(language.getDisplayName()) || (settings = map.get(language.getID())) == null) continue;
            CommonCodeStyleSettings commonCodeStyleSettings = settings;
            if (commonCodeStyleSettings == null) {
                CommonCodeStyleSettingsManager.$$$reportNull$$$0(3);
            }
            return commonCodeStyleSettings;
        }
        return new CommonCodeStyleSettings(Language.ANY);
    }

    private void initNonReadSettings() {
        for (LanguageCodeStyleProvider languageCodeStyleProvider : CodeStyleSettingsService.getInstance().getLanguageCodeStyleProviders()) {
            CommonCodeStyleSettings initialSettings;
            Language target = languageCodeStyleProvider.getLanguage();
            if (this.myCommonSettingsMap.containsKey(target.getID()) || (initialSettings = CommonCodeStyleSettingsManager.safelyGetDefaults(languageCodeStyleProvider)) == null) continue;
            this.init(initialSettings, target.getID());
        }
    }

    private void init(@NotNull CommonCodeStyleSettings initialSettings, @NotNull String langId) {
        if (initialSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        if (langId == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        initialSettings.setRootSettings(this.myParentSettings);
        this.registerCommonSettings(langId, initialSettings);
    }

    private Map<String, CommonCodeStyleSettings> initCommonSettingsMap() {
        LinkedHashMap<String, CommonCodeStyleSettings> map = new LinkedHashMap<String, CommonCodeStyleSettings>();
        this.myCommonSettingsMap = map;
        this.myUnknownSettingsMap = new LinkedHashMap<String, Element>();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCommonSettings(@NotNull String langId, @NotNull CommonCodeStyleSettings settings) {
        if (langId == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (!this.myCommonSettingsMap.containsKey(langId)) {
                this.myCommonSettingsMap.put(langId, settings);
                settings.getRootSettings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CommonCodeStyleSettingsManager clone(@NotNull CodeStyleSettings parentSettings) {
        if (parentSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager2 = this;
        // MONITORENTER : commonCodeStyleSettingsManager2
        CommonCodeStyleSettingsManager settingsManager = new CommonCodeStyleSettingsManager(parentSettings);
        if (this.myCommonSettingsMap != null && !this.myCommonSettingsMap.isEmpty()) {
            settingsManager.initCommonSettingsMap();
            for (Map.Entry<String, CommonCodeStyleSettings> entry : this.myCommonSettingsMap.entrySet()) {
                CommonCodeStyleSettings clonedSettings = entry.getValue().clone(parentSettings);
                settingsManager.registerCommonSettings(entry.getKey(), clonedSettings);
            }
            settingsManager.myUnknownSettingsMap.putAll(this.myUnknownSettingsMap);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = settingsManager;
        // MONITOREXIT : commonCodeStyleSettingsManager2
        if (commonCodeStyleSettingsManager != null) return commonCodeStyleSettingsManager;
        CommonCodeStyleSettingsManager.$$$reportNull$$$0(9);
        return commonCodeStyleSettingsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(10);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            this.initCommonSettingsMap();
            CodeStyleSettingsService settingsService = CodeStyleSettingsService.getInstance();
            for (Element commonSettingsElement : element.getChildren(COMMON_SETTINGS_TAG)) {
                String languageId = commonSettingsElement.getAttributeValue(LANGUAGE_ATTR);
                if (StringUtil.isEmpty(languageId)) continue;
                LanguageCodeStyleProvider provider = (LanguageCodeStyleProvider)((Object)ContainerUtil.find(settingsService.getLanguageCodeStyleProviders(), p -> languageId.equals(p.getLanguage().getID())));
                if (provider != null) {
                    CommonCodeStyleSettings commonSettings = CommonCodeStyleSettingsManager.readExternal(provider, commonSettingsElement);
                    if (commonSettings == null) continue;
                    this.init(commonSettings, provider.getLanguage().getID());
                    continue;
                }
                this.myUnknownSettingsMap.put(languageId, JDOMUtil.internElement(commonSettingsElement));
            }
            this.initNonReadSettings();
        }
    }

    @Nullable
    private static CommonCodeStyleSettings safelyGetDefaults(LanguageCodeStyleProvider provider) {
        Ref defaultSettingsRef = RecursionManager.doPreventingRecursion(provider, true, () -> new Ref<CommonCodeStyleSettings>(provider.getDefaultCommonSettings()));
        if (defaultSettingsRef == null) {
            LOG.error(PluginException.createByClass(provider.getClass().getCanonicalName() + ".getDefaultCommonSettings() recursively creates root settings.", null, provider.getClass()));
            return null;
        }
        CommonCodeStyleSettings defaultSettings = (CommonCodeStyleSettings)defaultSettingsRef.get();
        if (defaultSettings instanceof CodeStyleSettings) {
            LOG.error(PluginException.createByClass(provider.getClass().getName() + ".getDefaultCommonSettings() creates root CodeStyleSettings instead of CommonCodeStyleSettings", null, provider.getClass()));
        }
        return defaultSettings;
    }

    @Nullable
    private static CommonCodeStyleSettings readExternal(@NotNull LanguageCodeStyleProvider provider, @NotNull Element commonSettingsElement) {
        CommonCodeStyleSettings settings;
        if (provider == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(11);
        }
        if (commonSettingsElement == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(12);
        }
        if ((settings = CommonCodeStyleSettingsManager.safelyGetDefaults(provider)) != null) {
            settings.readExternal(commonSettingsElement);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(13);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (this.myCommonSettingsMap == null) {
                return;
            }
            Object[] langIds = ArrayUtilRt.toStringArray(ContainerUtil.union(this.myUnknownSettingsMap.keySet(), this.myCommonSettingsMap.keySet()));
            Arrays.sort(langIds);
            for (Object id : langIds) {
                Language language = Language.findLanguageByID((String)id);
                if (language != null && this.myCommonSettingsMap.containsKey(id)) {
                    Element commonSettingsElement;
                    CommonCodeStyleSettings commonSettings = this.myCommonSettingsMap.get(id);
                    LanguageCodeStyleProvider provider = LanguageCodeStyleProvider.forLanguage(language);
                    if (provider == null || (commonSettingsElement = CommonCodeStyleSettingsManager.writeCommonSettings((String)id, commonSettings, provider)).getChildren().isEmpty()) continue;
                    element.addContent(commonSettingsElement);
                    continue;
                }
                Content unknown = this.myUnknownSettingsMap.get(id);
                if (unknown == null) continue;
                element.addContent(unknown.clone());
            }
        }
    }

    private static Element writeCommonSettings(@NotNull String langId, @NotNull CommonCodeStyleSettings commonSettings, @NotNull LanguageCodeStyleProvider provider) {
        if (langId == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(14);
        }
        if (commonSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(15);
        }
        if (provider == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(16);
        }
        Element commonSettingsElement = new Element(COMMON_SETTINGS_TAG);
        commonSettings.writeExternal(commonSettingsElement, provider);
        commonSettingsElement.setAttribute(LANGUAGE_ATTR, langId);
        return commonSettingsElement;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommonCodeStyleSettingsManager) {
            CommonCodeStyleSettingsManager other = (CommonCodeStyleSettingsManager)obj;
            if (this.getCommonSettingsMap().size() != other.getCommonSettingsMap().size() || this.myUnknownSettingsMap.size() != other.myUnknownSettingsMap.size()) {
                return false;
            }
            for (String langId : this.myCommonSettingsMap.keySet()) {
                CommonCodeStyleSettings otherSettings;
                CommonCodeStyleSettings theseSettings = this.myCommonSettingsMap.get(langId);
                if (theseSettings.equals(otherSettings = other.myCommonSettingsMap.get(langId))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void removeLanguageSettings(@NotNull LanguageCodeStyleProvider provider) {
        String langId;
        Map<String, CommonCodeStyleSettings> settingsMap;
        CommonCodeStyleSettings commonSettings;
        if (provider == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(17);
        }
        if ((commonSettings = (settingsMap = this.getCommonSettingsMap()).get(langId = provider.getLanguage().getID())) != null) {
            Element serialized = CommonCodeStyleSettingsManager.writeCommonSettings(langId, settingsMap.get(langId), provider);
            if (!serialized.getChildren().isEmpty()) {
                this.myUnknownSettingsMap.put(langId, JDOMUtil.internElement(serialized));
            }
            settingsMap.remove(langId);
        }
    }

    void addLanguageSettings(@NotNull LanguageCodeStyleProvider provider) {
        CommonCodeStyleSettings commonSettings;
        if (provider == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(18);
        }
        this.getCommonSettingsMap();
        String langId = provider.getLanguage().getID();
        if (this.myUnknownSettingsMap.containsKey(langId)) {
            commonSettings = CommonCodeStyleSettingsManager.readExternal(provider, this.myUnknownSettingsMap.get(langId));
            if (commonSettings != null) {
                this.myUnknownSettingsMap.remove(langId);
            }
        } else {
            commonSettings = CommonCodeStyleSettingsManager.safelyGetDefaults(provider);
        }
        if (commonSettings != null) {
            this.init(commonSettings, langId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/codeStyle/CommonCodeStyleSettingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettingsElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/codeStyle/CommonCodeStyleSettingsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettingsMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerCommonSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeCommonSettings";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeLanguageSettings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addLanguageSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultsHolder {
        private static final CommonCodeStyleSettings SETTINGS = new CommonCodeStyleSettings(Language.ANY);

        private DefaultsHolder() {
        }

        static {
            SETTINGS.initIndentOptions();
            SETTINGS.setRootSettings(CodeStyleSettings.getDefaults());
        }
    }
}

