/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.codeStyle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sqldelight.com.intellij.application.options.CodeStyle;
import sqldelight.com.intellij.formatting.fileSet.FileSetDescriptor;
import sqldelight.com.intellij.formatting.fileSet.FileSetDescriptorFactory;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.xmlb.XmlSerializer;
import sqldelight.com.intellij.util.xmlb.annotations.OptionTag;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.NotNull;

public class ExcludedFiles {
    private final List<FileSetDescriptor> myDescriptors = new ArrayList<FileSetDescriptor>();
    private final State myState = new State();

    public void serializeInto(@NotNull Element element) {
        if (element == null) {
            ExcludedFiles.$$$reportNull$$$0(0);
        }
        if (this.myDescriptors.size() > 0) {
            XmlSerializer.serializeInto(this.myState, element);
        }
    }

    public void deserializeFrom(@NotNull Element element) {
        if (element == null) {
            ExcludedFiles.$$$reportNull$$$0(1);
        }
        XmlSerializer.deserializeInto(this.myState, element);
    }

    public void addDescriptor(@NotNull FileSetDescriptor descriptor) {
        if (descriptor == null) {
            ExcludedFiles.$$$reportNull$$$0(2);
        }
        this.myDescriptors.add(descriptor);
    }

    public List<FileSetDescriptor> getDescriptors() {
        return this.myDescriptors;
    }

    public void setDescriptors(@NotNull List<? extends FileSetDescriptor> descriptors) {
        if (descriptors == null) {
            ExcludedFiles.$$$reportNull$$$0(3);
        }
        this.myDescriptors.clear();
        this.myDescriptors.addAll(descriptors);
    }

    public boolean contains(@NotNull PsiFile file) {
        PsiFile settingsFile;
        if (file == null) {
            ExcludedFiles.$$$reportNull$$$0(4);
        }
        if ((settingsFile = CodeStyle.getSettingsPsi(file)) != null) {
            for (FileSetDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.matches(settingsFile)) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.myDescriptors.clear();
    }

    public List<FileSetDescriptor> getDescriptors(@NotNull String descriptorType) {
        if (descriptorType == null) {
            ExcludedFiles.$$$reportNull$$$0(5);
        }
        return ContainerUtil.filter(this.myDescriptors, descriptor -> descriptorType.equals(descriptor.getType()));
    }

    public void setDescriptors(@NotNull String descriptorType, @NotNull List<FileSetDescriptor> descriptors) {
        if (descriptorType == null) {
            ExcludedFiles.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            ExcludedFiles.$$$reportNull$$$0(7);
        }
        this.myDescriptors.removeIf(descriptor -> descriptorType.equals(descriptor.getType()));
        this.myDescriptors.addAll(descriptors);
        Collections.sort(this.myDescriptors, (d1, d2) -> {
            int result = StringUtil.compare(d1.getType(), d2.getType(), false);
            if (result != 0) {
                return result;
            }
            result = StringUtil.compare(d1.getName(), d2.getName(), false);
            if (result != 0) {
                return result;
            }
            return StringUtil.compare(d1.getPattern(), d2.getPattern(), false);
        });
    }

    public boolean equals(@NotNull Object o) {
        if (o == null) {
            ExcludedFiles.$$$reportNull$$$0(8);
        }
        return o instanceof ExcludedFiles && this.myDescriptors.equals(((ExcludedFiles)o).myDescriptors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/psi/codeStyle/ExcludedFiles";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "serializeInto";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deserializeFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addDescriptor";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDescriptors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "equals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class State {
        @OptionTag(value="DO_NOT_FORMAT")
        public List<FileSetDescriptor.State> getDescriptors() {
            return ContainerUtil.map(ExcludedFiles.this.myDescriptors, descriptor -> descriptor.getState());
        }

        public void setDescriptors(@NotNull List<FileSetDescriptor.State> states) {
            if (states == null) {
                State.$$$reportNull$$$0(0);
            }
            ExcludedFiles.this.myDescriptors.clear();
            for (FileSetDescriptor.State state : states) {
                for (FileSetDescriptorFactory factory : FileSetDescriptorFactory.EP_NAME.getExtensionList()) {
                    FileSetDescriptor descriptor = factory.createDescriptor(state);
                    if (descriptor == null) continue;
                    ExcludedFiles.this.myDescriptors.add(descriptor);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "sqldelight/com/intellij/psi/codeStyle/ExcludedFiles$State", "setDescriptors"));
        }
    }
}

