/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.codeStyle;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import sqldelight.com.intellij.openapi.util.text.Strings;
import sqldelight.com.intellij.psi.codeStyle.AllOccurrencesMatcher;
import sqldelight.com.intellij.psi.codeStyle.FixingLayoutMatcher;
import sqldelight.com.intellij.psi.codeStyle.FixingLayoutTypoTolerantMatcher;
import sqldelight.com.intellij.psi.codeStyle.MatcherWithFallback;
import sqldelight.com.intellij.psi.codeStyle.MinusculeMatcher;
import sqldelight.com.intellij.psi.codeStyle.PinyinMatcher;
import sqldelight.com.intellij.psi.codeStyle.PreferStartMatchMatcherWrapper;
import sqldelight.com.intellij.util.text.Matcher;
import sqldelight.com.intellij.util.text.NameUtilCore;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class NameUtil {
    private static final int MAX_LENGTH = 40;

    private NameUtil() {
    }

    @NotNull
    public static List<String> nameToWordsLowerCase(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(0);
        }
        String[] words = NameUtilCore.nameToWords(name);
        ArrayList<String> list = new ArrayList<String>(words.length);
        for (String word : words) {
            list.add(Strings.toLowerCase(word));
        }
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            NameUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(2);
        }
        return NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower, false, false);
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords, boolean forCompletion) {
        boolean endsWithSpace;
        int eol;
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(3);
        }
        if ((eol = pattern.indexOf(10)) != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 40) {
            pattern = pattern.substring(0, 40);
        }
        @NonNls StringBuilder buffer = new StringBuilder();
        boolean bl = endsWithSpace = !forCompletion && Strings.endsWithChar(pattern, ' ');
        if (!forCompletion) {
            pattern = pattern.trim();
        }
        exactPrefixLen = Math.min(exactPrefixLen, pattern.length());
        boolean prevIsUppercase = false;
        if (exactPrefixLen > 0) {
            char c = pattern.charAt(exactPrefixLen - 1);
            prevIsUppercase = Character.isUpperCase(c) || Character.isDigit(c);
        }
        for (int i = 0; i != exactPrefixLen; ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\").append(c);
        }
        if (exactPrefixLen == 0) {
            buffer.append("_*");
        }
        boolean firstIdentifierLetter = exactPrefixLen == 0;
        boolean lastIsUppercase = false;
        for (int i = exactPrefixLen; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            lastIsUppercase = false;
            if (Character.isLetterOrDigit(c)) {
                prevIsUppercase = false;
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    prevIsUppercase = true;
                    lastIsUppercase = true;
                    buffer.append('(');
                    if (!firstIdentifierLetter) {
                        buffer.append("[a-z\\s0-9\\$]*");
                    }
                    buffer.append(c);
                    if (allowToLower) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    if (!firstIdentifierLetter) {
                        buffer.append("|[A-Za-z\\s0-9\\$]*[_-]+[");
                        buffer.append(c);
                        buffer.append(Character.toLowerCase(c));
                        buffer.append("]");
                    }
                    buffer.append(')');
                } else if (Character.isLowerCase(c) && allowToUpper) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                    if (lowerCaseWords) {
                        buffer.append("([a-z\\s0-9\\$]*[-_]+)?");
                    }
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                if (!firstIdentifierLetter) {
                    buffer.append("[a-z\\s0-9\\$]*\\.");
                } else {
                    buffer.append("\\.");
                }
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append("([a-z\\s0-9\\$_-]*[\\ _-]+)+");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ':' || prevIsUppercase) {
                buffer.append("[A-Za-z\\s0-9\\$]*");
            }
            firstIdentifierLetter = true;
            buffer.append("\\").append(c);
        }
        if (!endsWithSpace) {
            buffer.append(".*");
        } else if (lastIsUppercase) {
            buffer.append("[a-z\\s0-9\\$]*");
        }
        String string = buffer.toString();
        if (string == null) {
            NameUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static List<String> getSuggestionsByName(@NotNull String name, @NotNull String prefix, @NotNull String suffix, boolean upperCaseStyle, boolean preferLongerNames, boolean isArray) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            NameUtil.$$$reportNull$$$0(6);
        }
        if (suffix == null) {
            NameUtil.$$$reportNull$$$0(7);
        }
        ArrayList<String> answer = new ArrayList<String>();
        String[] words = NameUtilCore.nameToWords(name);
        for (int step = 0; step < words.length; ++step) {
            int wordCount = preferLongerNames ? words.length - step : step + 1;
            String startWord = words[words.length - wordCount];
            char c = startWord.charAt(0);
            if (c == '_' || !Character.isJavaIdentifierStart(c)) continue;
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, false) + suffix);
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, true) + suffix);
        }
        ArrayList<String> arrayList = answer;
        if (arrayList == null) {
            NameUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static String compoundSuggestion(@NotNull String prefix, boolean upperCaseStyle, String @NotNull [] words, int wordCount, @NotNull String startWord, char c, boolean isArray, boolean skip_) {
        if (prefix == null) {
            NameUtil.$$$reportNull$$$0(9);
        }
        if (startWord == null) {
            NameUtil.$$$reportNull$$$0(10);
        }
        if (words == null) {
            NameUtil.$$$reportNull$$$0(11);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        startWord = upperCaseStyle ? Strings.toUpperCase(startWord) : (prefix.isEmpty() || Strings.endsWithChar(prefix, '_') ? Strings.toLowerCase(startWord) : Character.toUpperCase(c) + startWord.substring(1));
        buffer.append(startWord);
        for (int i = words.length - wordCount + 1; i < words.length; ++i) {
            String word = words[i];
            String prevWord = words[i - 1];
            if (upperCaseStyle) {
                word = Strings.toUpperCase(word);
                if (prevWord.charAt(prevWord.length() - 1) != '_' && word.charAt(0) != '_') {
                    word = "_" + word;
                }
            } else {
                if (prevWord.charAt(prevWord.length() - 1) == '_') {
                    word = Strings.toLowerCase(word);
                }
                if (skip_) {
                    if (word.equals("_")) continue;
                    if (prevWord.equals("_")) {
                        word = Strings.capitalize(word);
                    }
                }
            }
            buffer.append(word);
        }
        String suggestion = buffer.toString();
        if (isArray) {
            suggestion = Strings.pluralize(suggestion);
            if (upperCaseStyle) {
                suggestion = Strings.toUpperCase(suggestion);
            }
        }
        String string = suggestion;
        if (string == null) {
            NameUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static String @NotNull [] splitNameIntoWords(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(13);
        }
        String[] stringArray = NameUtilCore.splitNameIntoWords(name);
        if (stringArray == null) {
            NameUtil.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    public static String @NotNull [] nameToWords(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(15);
        }
        String[] stringArray = NameUtilCore.nameToWords(name);
        if (stringArray == null) {
            NameUtil.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    public static Matcher buildMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(17);
        }
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        return NameUtil.buildMatcher(pattern, options);
    }

    @NotNull
    public static MatcherBuilder buildMatcher(@NotNull String pattern) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(18);
        }
        return new MatcherBuilder(pattern);
    }

    @NotNull
    public static MinusculeMatcher buildMatcher(@NotNull String pattern, @NotNull MatchingCaseSensitivity options) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(19);
        }
        if (options == null) {
            NameUtil.$$$reportNull$$$0(20);
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern).withCaseSensitivity(options).build();
        if (minusculeMatcher == null) {
            NameUtil.$$$reportNull$$$0(21);
        }
        return minusculeMatcher;
    }

    public static MinusculeMatcher buildMatcherWithFallback(@NotNull String pattern, @NotNull String fallbackPattern, @NotNull MatchingCaseSensitivity options) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(22);
        }
        if (fallbackPattern == null) {
            NameUtil.$$$reportNull$$$0(23);
        }
        if (options == null) {
            NameUtil.$$$reportNull$$$0(24);
        }
        return pattern.equals(fallbackPattern) ? NameUtil.buildMatcher(pattern, options) : new MatcherWithFallback(NameUtil.buildMatcher(pattern, options), NameUtil.buildMatcher(fallbackPattern, options));
    }

    @NotNull
    public static String capitalizeAndUnderscore(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(25);
        }
        return NameUtil.splitWords(name, '_', Strings::toUpperCase);
    }

    @NotNull
    public static String splitWords(@NotNull String text, char separator, @NotNull Function<? super String, String> transformWord) {
        if (text == null) {
            NameUtil.$$$reportNull$$$0(26);
        }
        if (transformWord == null) {
            NameUtil.$$$reportNull$$$0(27);
        }
        String[] words = NameUtilCore.nameToWords(text);
        boolean insertSeparator = false;
        StringBuilder buf = new StringBuilder();
        for (String word : words) {
            if (!Character.isLetterOrDigit(word.charAt(0))) {
                buf.append(separator);
                insertSeparator = false;
                continue;
            }
            if (insertSeparator) {
                buf.append(separator);
            } else {
                insertSeparator = true;
            }
            buf.append(transformWord.apply(word));
        }
        String string = buf.toString();
        if (string == null) {
            NameUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/codeStyle/NameUtil";
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startWord";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackPattern";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/codeStyle/NameUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWordsLowerCase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRegexp";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsByName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "compoundSuggestion";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNameIntoWords";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWords";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMatcher";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "splitWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nameToWordsLowerCase";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 28: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildRegexp";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsByName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compoundSuggestion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "splitNameIntoWords";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "nameToWords";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcherWithFallback";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeAndUnderscore";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "splitWords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum MatchingCaseSensitivity {
        NONE,
        FIRST_LETTER,
        ALL;

    }

    public static class MatcherBuilder {
        private final String pattern;
        private String separators = "";
        private MatchingCaseSensitivity caseSensitivity = MatchingCaseSensitivity.NONE;
        private boolean typoTolerant = false;
        private boolean preferStartMatches = false;
        private boolean allOccurrences = false;

        public MatcherBuilder(String pattern) {
            this.pattern = pattern;
        }

        public MatcherBuilder withCaseSensitivity(MatchingCaseSensitivity caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
            return this;
        }

        public MatcherBuilder withSeparators(String separators) {
            this.separators = separators;
            return this;
        }

        public MatcherBuilder typoTolerant() {
            this.typoTolerant = true;
            return this;
        }

        public MatcherBuilder preferringStartMatches() {
            this.preferStartMatches = true;
            return this;
        }

        public MatcherBuilder allOccurrences() {
            this.allOccurrences = true;
            return this;
        }

        public MinusculeMatcher build() {
            MinusculeMatcher matcher;
            MinusculeMatcher minusculeMatcher = this.typoTolerant ? FixingLayoutTypoTolerantMatcher.create(this.pattern, this.caseSensitivity, this.separators) : (matcher = this.allOccurrences ? AllOccurrencesMatcher.create(this.pattern, this.caseSensitivity, this.separators) : new FixingLayoutMatcher(this.pattern, this.caseSensitivity, this.separators));
            if (this.preferStartMatches) {
                matcher = new PreferStartMatchMatcherWrapper(matcher);
            }
            matcher = PinyinMatcher.create(matcher);
            return matcher;
        }
    }
}

