/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.codeStyle.arrangement.std;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sqldelight.com.intellij.CodeStyleBundle;
import sqldelight.com.intellij.openapi.util.NotNullLazyValue;
import sqldelight.com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import sqldelight.com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementToken;
import sqldelight.com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import sqldelight.com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import sqldelight.com.intellij.psi.codeStyle.arrangement.std.StdInvertibleArrangementSettingsToken;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.PropertyKey;

public final class StdArrangementTokens {
    private static final Map<String, StdArrangementSettingsToken> TOKENS_BY_ID = new HashMap<String, StdArrangementSettingsToken>();
    private static final NotNullLazyValue<Integer> NESTED_CLASSES_INITIALIZER = NotNullLazyValue.createValue(() -> {
        int dummy = 0;
        for (Class<?> clazz : StdArrangementTokens.class.getClasses()) {
            try {
                dummy += clazz.getDeclaredFields()[0].get(null).hashCode();
            }
            catch (IllegalAccessException e) {
                assert (false);
            }
        }
        return dummy;
    });

    private StdArrangementTokens() {
    }

    @Nullable
    public static ArrangementSettingsToken byId(@NotNull String id) {
        if (id == null) {
            StdArrangementTokens.$$$reportNull$$$0(0);
        }
        NESTED_CLASSES_INITIALIZER.getValue();
        return TOKENS_BY_ID.get(id);
    }

    private static NotNullLazyValue<Set<ArrangementSettingsToken>> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            StdArrangementTokens.$$$reportNull$$$0(1);
        }
        return NotNullLazyValue.createValue(() -> {
            HashSet<ArrangementSettingsToken> result = new HashSet<ArrangementSettingsToken>();
            for (Field field : clazz.getFields()) {
                if (!ArrangementSettingsToken.class.isAssignableFrom(field.getType())) continue;
                try {
                    result.add((ArrangementSettingsToken)field.get(null));
                }
                catch (IllegalAccessException e) {
                    assert (false) : e;
                }
            }
            return result;
        });
    }

    private static StdArrangementSettingsToken invertible(@NotNull String id, @PropertyKey(resourceBundle="messages.CodeStyleBundle") @NotNull @PropertyKey(resourceBundle="messages.CodeStyleBundle") @NotNull String displayNameKey, @PropertyKey(resourceBundle="messages.CodeStyleBundle") @NotNull @PropertyKey(resourceBundle="messages.CodeStyleBundle") @NotNull String invertedNameKey, @NotNull StdArrangementTokenType type2) {
        if (id == null) {
            StdArrangementTokens.$$$reportNull$$$0(2);
        }
        if (displayNameKey == null) {
            StdArrangementTokens.$$$reportNull$$$0(3);
        }
        if (invertedNameKey == null) {
            StdArrangementTokens.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            StdArrangementTokens.$$$reportNull$$$0(5);
        }
        StdInvertibleArrangementSettingsToken result = StdInvertibleArrangementSettingsToken.invertibleToken(id, CodeStyleBundle.message(displayNameKey, new Object[0]), CodeStyleBundle.message(invertedNameKey, new Object[0]), type2);
        TOKENS_BY_ID.put(id, result);
        return result;
    }

    private static StdArrangementSettingsToken compositeToken(@NonNls @NotNull String id, @PropertyKey(resourceBundle="messages.CodeStyleBundle") @NotNull @PropertyKey(resourceBundle="messages.CodeStyleBundle") @NotNull String key, ArrangementSettingsToken ... alternativeTokens) {
        if (id == null) {
            StdArrangementTokens.$$$reportNull$$$0(6);
        }
        if (key == null) {
            StdArrangementTokens.$$$reportNull$$$0(7);
        }
        if (alternativeTokens == null) {
            StdArrangementTokens.$$$reportNull$$$0(8);
        }
        CompositeArrangementToken result = CompositeArrangementToken.create(id, CodeStyleBundle.message(key, new Object[0]), StdArrangementTokenType.MODIFIER, alternativeTokens);
        TOKENS_BY_ID.put(id, result);
        return result;
    }

    private static StdArrangementSettingsToken token(@NotNull String id, @NotNull @PropertyKey(resourceBundle="messages.CodeStyleBundle") @NotNull @PropertyKey(resourceBundle="messages.CodeStyleBundle") String key, @NotNull StdArrangementTokenType type2) {
        if (id == null) {
            StdArrangementTokens.$$$reportNull$$$0(9);
        }
        if (key == null) {
            StdArrangementTokens.$$$reportNull$$$0(10);
        }
        if (type2 == null) {
            StdArrangementTokens.$$$reportNull$$$0(11);
        }
        StdArrangementSettingsToken result = StdArrangementSettingsToken.tokenByBundle(id, key, type2);
        TOKENS_BY_ID.put(id, result);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayNameKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invertedNameKey";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alternativeTokens";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "byId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "collectFields";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invertible";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "compositeToken";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "token";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Order {
        @NotNull
        public static final ArrangementSettingsToken KEEP = StdArrangementTokens.token("KEEP", "arrangement.settings.order.type.keep", StdArrangementTokenType.ORDER);
        @NotNull
        public static final ArrangementSettingsToken BY_NAME = StdArrangementTokens.token("BY_NAME", "arrangement.settings.order.type.by.name", StdArrangementTokenType.ORDER);
        @NotNull
        public static final ArrangementSettingsToken DEPTH_FIRST = StdArrangementTokens.token("DEPTH_FIRST", "arrangement.settings.order.type.depth.first", StdArrangementTokenType.ORDER);
        @NotNull
        public static final ArrangementSettingsToken BREADTH_FIRST = StdArrangementTokens.token("BREADTH_FIRST", "arrangement.settings.order.type.breadth.first", StdArrangementTokenType.ORDER);

        private Order() {
        }
    }

    public static final class Grouping {
        @NotNull
        public static final ArrangementSettingsToken GETTERS_AND_SETTERS = StdArrangementTokens.token("GETTERS_AND_SETTERS", "arrangement.settings.groups.getters.and.setters.together", StdArrangementTokenType.GROUPING);
        @NotNull
        public static final ArrangementSettingsToken OVERRIDDEN_METHODS = StdArrangementTokens.token("OVERRIDDEN_METHODS", "arrangement.settings.groups.overridden.methods", StdArrangementTokenType.GROUPING);
        @NotNull
        public static final ArrangementSettingsToken DEPENDENT_METHODS = StdArrangementTokens.token("DEPENDENT_METHODS", "arrangement.settings.groups.dependent.methods", StdArrangementTokenType.GROUPING);
        @NotNull
        public static final ArrangementSettingsToken GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER = StdArrangementTokens.token("GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER", "arrangement.settings.groups.property.field", StdArrangementTokenType.GROUPING);

        private Grouping() {
        }
    }

    public static final class Modifier {
        @NotNull
        public static final ArrangementSettingsToken PUBLIC = StdArrangementTokens.invertible("PUBLIC", "arrangement.settings.text.modifier.public", "arrangement.settings.text.modifier.public.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken PROTECTED = StdArrangementTokens.invertible("PROTECTED", "arrangement.settings.text.modifier.protected", "arrangement.settings.text.modifier.protected.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken PRIVATE = StdArrangementTokens.invertible("PRIVATE", "arrangement.settings.text.modifier.private", "arrangement.settings.text.modifier.private.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken PACKAGE_PRIVATE = StdArrangementTokens.invertible("PACKAGE_PRIVATE", "arrangement.settings.text.modifier.package.private", "arrangement.settings.text.modifier.package.private.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken STATIC = StdArrangementTokens.invertible("STATIC", "arrangement.settings.text.modifier.static", "arrangement.settings.text.modifier.static.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken FINAL = StdArrangementTokens.invertible("FINAL", "arrangement.settings.text.modifier.final", "arrangement.settings.text.modifier.final.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken READONLY = StdArrangementTokens.invertible("READONLY", "arrangement.settings.text.modifier.readonly", "arrangement.settings.text.modifier.readonly.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken TRANSIENT = StdArrangementTokens.invertible("TRANSIENT", "arrangement.settings.text.modifier.transient", "arrangement.settings.text.modifier.transient.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken VOLATILE = StdArrangementTokens.invertible("VOLATILE", "arrangement.settings.text.modifier.volatile", "arrangement.settings.text.modifier.volatile.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken SYNCHRONIZED = StdArrangementTokens.invertible("SYNCHRONIZED", "arrangement.settings.text.modifier.synchronized", "arrangement.settings.text.modifier.synchronized.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken ABSTRACT = StdArrangementTokens.invertible("ABSTRACT", "arrangement.settings.text.modifier.abstract", "arrangement.settings.text.modifier.abstract.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken OVERRIDE = StdArrangementTokens.invertible("OVERRIDE", "arrangement.settings.text.modifier.override", "arrangement.settings.text.modifier.override.inverted", StdArrangementTokenType.MODIFIER);
        @NotNull
        public static final ArrangementSettingsToken GETTER = StdArrangementTokens.compositeToken("GETTER", "arrangement.settings.text.modifier.getter", EntryType.METHOD, PUBLIC);
        @NotNull
        public static final ArrangementSettingsToken SETTER = StdArrangementTokens.compositeToken("SETTER", "arrangement.settings.text.modifier.setter", EntryType.METHOD, PUBLIC);
        @NotNull
        public static final ArrangementSettingsToken OVERRIDDEN = StdArrangementTokens.compositeToken("OVERRIDDEN", "arrangement.settings.text.modifier.overridden", EntryType.METHOD, PUBLIC, PROTECTED);
        private static final NotNullLazyValue<Set<ArrangementSettingsToken>> TOKENS = StdArrangementTokens.collectFields(Modifier.class);
        public static final Set<ArrangementSettingsToken> MODIFIER_AS_TYPE = ContainerUtil.newHashSet(GETTER, SETTER, OVERRIDDEN);

        private Modifier() {
        }

        @NotNull
        public static Set<ArrangementSettingsToken> values() {
            Set<ArrangementSettingsToken> set = TOKENS.getValue();
            if (set == null) {
                Modifier.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens$Modifier", "values"));
        }
    }

    public static final class EntryType {
        @NotNull
        public static final ArrangementSettingsToken CLASS = StdArrangementTokens.invertible("CLASS", "arrangement.settings.text.entry.type.class", "arrangement.settings.text.entry.type.class.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken ANONYMOUS_CLASS = StdArrangementTokens.invertible("ANONYMOUS_CLASS", "arrangement.settings.text.entry.type.anonymous.class", "arrangement.settings.text.entry.type.anonymous.class.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken FIELD = StdArrangementTokens.invertible("FIELD", "arrangement.settings.text.entry.type.field", "arrangement.settings.text.entry.type.field.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken CONSTRUCTOR = StdArrangementTokens.invertible("CONSTRUCTOR", "arrangement.settings.text.entry.type.constructor", "arrangement.settings.text.entry.type.constructor.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken METHOD = StdArrangementTokens.invertible("METHOD", "arrangement.settings.text.entry.type.method", "arrangement.settings.text.entry.type.method.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken ENUM = StdArrangementTokens.invertible("ENUM", "arrangement.settings.text.entry.type.enum", "arrangement.settings.text.entry.type.enum.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken INTERFACE = StdArrangementTokens.invertible("INTERFACE", "arrangement.settings.text.entry.type.interface", "arrangement.settings.text.entry.type.interface.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken CONST = StdArrangementTokens.invertible("CONST", "arrangement.settings.text.entry.type.const", "arrangement.settings.text.entry.type.const.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken VAR = StdArrangementTokens.invertible("VAR", "arrangement.settings.text.entry.type.var", "arrangement.settings.text.entry.type.var.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken PROPERTY = StdArrangementTokens.invertible("PROPERTY", "arrangement.settings.text.entry.type.property", "arrangement.settings.text.entry.type.property.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken EVENT_HANDLER = StdArrangementTokens.invertible("EVENT_HANDLER", "arrangement.settings.text.entry.type.event.handler", "arrangement.settings.text.entry.type.event.handler.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken STATIC_INIT = StdArrangementTokens.invertible("STATIC_INIT", "arrangement.settings.text.entry.type.static.init", "arrangement.settings.text.entry.type.static.init.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken INIT_BLOCK = StdArrangementTokens.invertible("INITIALIZER_BLOCK", "arrangement.settings.text.entry.type.initializer.block", "arrangement.settings.text.entry.type.initializer.block.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken NAMESPACE = StdArrangementTokens.invertible("NAMESPACE", "arrangement.settings.text.entry.type.namespace", "arrangement.settings.text.entry.type.namespace.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken TRAIT = StdArrangementTokens.invertible("TRAIT", "arrangement.settings.text.entry.type.trait", "arrangement.settings.text.entry.type.trait.inverted", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken XML_TAG = StdArrangementTokens.token("XML_TAG", "arrangement.settings.text.entry.type.xml.tag", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final StdArrangementSettingsToken XML_ATTRIBUTE = StdArrangementTokens.token("XML_ATTRIBUTE", "arrangement.settings.text.entry.type.xml.attribute", StdArrangementTokenType.ENTRY_TYPE);
        private static final NotNullLazyValue<Set<ArrangementSettingsToken>> TOKENS = StdArrangementTokens.collectFields(EntryType.class);

        private EntryType() {
        }

        @NotNull
        public static Set<ArrangementSettingsToken> values() {
            Set<ArrangementSettingsToken> set = TOKENS.getValue();
            if (set == null) {
                EntryType.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/psi/codeStyle/arrangement/std/StdArrangementTokens$EntryType", "values"));
        }
    }

    public static final class Regexp {
        @NotNull
        public static final StdArrangementSettingsToken NAME = StdArrangementTokens.token("NAME", "arrangement.settings.text.general.name", StdArrangementTokenType.REG_EXP);
        @NotNull
        public static final StdArrangementSettingsToken XML_NAMESPACE = StdArrangementTokens.token("XML_NAMESPACE", "arrangement.settings.text.general.xml.namespace", StdArrangementTokenType.REG_EXP);
        @NotNull
        public static final StdArrangementSettingsToken TEXT = StdArrangementTokens.token("TEXT", "arrangement.settings.text.general.text", StdArrangementTokenType.REG_EXP);

        private Regexp() {
        }
    }

    public static final class Section {
        @NotNull
        public static final ArrangementSettingsToken START_SECTION = StdArrangementTokens.token("SECTION_START", "arrangement.settings.text.section.start", StdArrangementTokenType.ENTRY_TYPE);
        @NotNull
        public static final ArrangementSettingsToken END_SECTION = StdArrangementTokens.token("SECTION_END", "arrangement.settings.text.section.end", StdArrangementTokenType.ENTRY_TYPE);

        private Section() {
        }
    }

    public static final class General {
        @NotNull
        public static final ArrangementSettingsToken TYPE = StdArrangementTokens.token("TYPE", "arrangement.settings.text.general.type", StdArrangementTokenType.GENERAL);
        @NotNull
        public static final ArrangementSettingsToken MODIFIER = StdArrangementTokens.token("MODIFIER", "arrangement.settings.text.general.modifier", StdArrangementTokenType.GENERAL);
        @NotNull
        public static final ArrangementSettingsToken ORDER = StdArrangementTokens.token("ORDER", "arrangement.settings.text.general.order", StdArrangementTokenType.GENERAL);
        @NotNull
        public static final ArrangementSettingsToken ALIAS = StdArrangementTokens.token("ALIAS", "arrangement.settings.text.general.sequence", StdArrangementTokenType.GENERAL);

        private General() {
        }
    }
}

