/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl;

import java.util.function.Function;
import javax.swing.Icon;
import sqldelight.com.intellij.icons.AllIcons;
import sqldelight.com.intellij.navigation.ItemPresentation;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.fileTypes.INativeFileType;
import sqldelight.com.intellij.openapi.fileTypes.UnknownFileType;
import sqldelight.com.intellij.openapi.progress.ProcessCanceledException;
import sqldelight.com.intellij.openapi.project.IndexNotReadyException;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Iconable;
import sqldelight.com.intellij.openapi.util.LastComputedIconCache;
import sqldelight.com.intellij.openapi.util.NotNullLazyValue;
import sqldelight.com.intellij.openapi.util.UserDataHolderBase;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.SmartPointerManager;
import sqldelight.com.intellij.psi.SmartPsiElementPointer;
import sqldelight.com.intellij.ui.CoreAwareIconManager;
import sqldelight.com.intellij.ui.IconManager;
import sqldelight.com.intellij.ui.icons.RowIcon;
import sqldelight.com.intellij.util.AstLoadingFilter;
import sqldelight.com.intellij.util.BitUtil;
import sqldelight.com.intellij.util.PlatformIcons;
import sqldelight.com.intellij.util.PsiIconUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance(ElementBase.class);
    public static final int FLAGS_LOCKED = 2048;
    private static final Function<ElementIconRequest, Icon> ICON_COMPUTE = request -> {
        Object element = ((ElementIconRequest)request).myPointer.getElement();
        if (element == null) {
            return null;
        }
        Icon icon2 = ElementBase.computeIconNow(element, ((ElementIconRequest)request).myFlags);
        LastComputedIconCache.put(element, icon2, ((ElementIconRequest)request).myFlags);
        return icon2;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = NotNullLazyValue.createValue(() -> IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON));

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(@Iconable.IconFlags int flags) {
        PsiElement psiElement = (PsiElement)((Object)this);
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is("psi.deferIconLoading", true)) {
            Icon baseIcon = LastComputedIconCache.get(psiElement, flags);
            if (baseIcon == null) {
                baseIcon = AstLoadingFilter.disallowTreeLoading(() -> this.computeBaseIcon(flags));
            }
            return baseIcon == null ? null : IconManager.getInstance().createDeferredIcon(baseIcon, new ElementIconRequest(psiElement, psiElement.getProject(), flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            ElementBase.$$$reportNull$$$0(0);
        }
        return AstLoadingFilter.disallowTreeLoading(() -> ElementBase.doComputeIconNow(element, flags));
    }

    private static Icon doComputeIconNow(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        Icon providersIcon;
        if (element == null) {
            ElementBase.$$$reportNull$$$0(1);
        }
        if ((providersIcon = PsiIconUtil.getProvidersIcon(element, flags)) != null) {
            if (providersIcon instanceof RowIcon) {
                return providersIcon;
            }
            return IconManager.getInstance().createLayeredIcon(element, providersIcon, flags);
        }
        return ((ElementBase)((Object)element)).getElementIcon(flags);
    }

    protected Icon computeBaseIcon(@Iconable.IconFlags int flags) {
        PsiFile file;
        Icon baseIcon;
        Icon icon2 = baseIcon = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
        if (this instanceof PsiElement && (file = ((PsiElement)((Object)this)).getContainingFile()) != null) {
            return IconManager.getInstance().createLayeredIcon(file, baseIcon, flags);
        }
        return baseIcon;
    }

    protected Icon getBaseIcon() {
        PsiFile file;
        if (this instanceof PsiElement && (file = ((PsiElement)((Object)this)).getContainingFile()) != null && !ElementBase.isNativeFileType(file.getFileType())) {
            try {
                return file.getFileType().getIcon();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return AllIcons.Nodes.NodePlaceholder;
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(Icon icon2, @Iconable.IconFlags int flags) {
        if (BitUtil.isSet(flags, 1)) {
            return IconManager.getInstance().createRowIcon(icon2, VISIBILITY_ICON_PLACEHOLDER.getValue());
        }
        return icon2;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = IconManager.getInstance().createRowIcon(baseIcon, visibilityIcon);
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(2);
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(@Iconable.IconFlags int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet(flags, 1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon baseIcon;
        int elementFlags;
        PsiElement element = (PsiElement)((Object)this);
        if (!element.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(flags, 2) && !element.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (element instanceof ItemPresentation && (baseIcon = ((ItemPresentation)((Object)element)).getIcon(false)) != null) {
            return IconManager.getInstance().createLayeredIcon(this, baseIcon, elementFlags);
        }
        if (element instanceof PsiFile) {
            Icon baseIcon2;
            PsiFile psiFile = (PsiFile)element;
            VirtualFile vFile = psiFile.getVirtualFile();
            if (vFile == null) {
                baseIcon2 = psiFile.getFileType().getIcon();
            } else {
                IconManager iconManager = IconManager.getInstance();
                if (iconManager instanceof CoreAwareIconManager) {
                    baseIcon2 = ((CoreAwareIconManager)((Object)iconManager)).getIcon(vFile, flags & 0xFFFFFFFD, psiFile.getProject());
                } else {
                    return null;
                }
            }
            return IconManager.getInstance().createLayeredIcon(this, baseIcon2, elementFlags);
        }
        return null;
    }

    public static int transformFlags(PsiElement element, @Iconable.IconFlags int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear(_flags, 2);
        boolean bl = isLocked = BitUtil.isSet(_flags, 2) && !element.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/impl/ElementBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/impl/ElementBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRowIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeIconNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconNow";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        @Iconable.IconFlags
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element, @NotNull Project project, @Iconable.IconFlags int flags) {
            if (element == null) {
                ElementIconRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ElementIconRequest.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(element);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer.equals(request.myPointer);
        }

        public int hashCode() {
            int result = this.myPointer.hashCode();
            result = 31 * result + this.myFlags;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "sqldelight/com/intellij/psi/impl/ElementBase$ElementIconRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

