/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl.source.tree;

import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.openapi.progress.ProgressIndicatorProvider;
import sqldelight.com.intellij.psi.PsiComment;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiWhiteSpace;
import sqldelight.com.intellij.psi.impl.source.tree.CompositeElement;
import sqldelight.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import sqldelight.com.intellij.psi.impl.source.tree.LazyParseableElement;
import sqldelight.com.intellij.psi.impl.source.tree.LeafElement;
import sqldelight.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import sqldelight.com.intellij.psi.impl.source.tree.TreeElement;
import sqldelight.com.intellij.util.text.CharArrayCharSequence;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class AstBufferUtil {
    private AstBufferUtil() {
    }

    public static int toBuffer(@NotNull ASTNode element, char @Nullable [] buffer, int offset) {
        if (element == null) {
            AstBufferUtil.$$$reportNull$$$0(0);
        }
        return AstBufferUtil.toBuffer(element, buffer, offset, false);
    }

    public static int toBuffer(@NotNull ASTNode element, char @Nullable [] buffer, int offset, boolean skipWhitespaceAndComments) {
        if (element == null) {
            AstBufferUtil.$$$reportNull$$$0(1);
        }
        BufferVisitor visitor = new BufferVisitor(skipWhitespaceAndComments, skipWhitespaceAndComments, offset, buffer);
        ((TreeElement)element).acceptTree(visitor);
        return visitor.end;
    }

    public static String getTextSkippingWhitespaceComments(@NotNull ASTNode element) {
        if (element == null) {
            AstBufferUtil.$$$reportNull$$$0(2);
        }
        int length = AstBufferUtil.toBuffer(element, null, 0, true);
        char[] buffer = new char[length];
        AstBufferUtil.toBuffer(element, buffer, 0, true);
        return new String(buffer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "sqldelight/com/intellij/psi/impl/source/tree/AstBufferUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "toBuffer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextSkippingWhitespaceComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BufferVisitor
    extends RecursiveTreeElementWalkingVisitor {
        private final boolean skipWhitespace;
        private final boolean skipComments;
        protected final int offset;
        protected int end;
        protected final char[] buffer;

        public BufferVisitor(PsiElement element, boolean skipWhitespace, boolean skipComments) {
            this(skipWhitespace, skipComments, 0, new char[element.getTextLength()]);
            ((TreeElement)element.getNode()).acceptTree(this);
        }

        public BufferVisitor(boolean skipWhitespace, boolean skipComments, int offset, char @Nullable [] buffer) {
            super(false);
            this.skipWhitespace = skipWhitespace;
            this.skipComments = skipComments;
            this.buffer = buffer;
            this.offset = offset;
            this.end = offset;
        }

        public int getEnd() {
            return this.end;
        }

        public char @NotNull [] getBuffer() {
            assert (this.buffer != null);
            if (this.buffer == null) {
                BufferVisitor.$$$reportNull$$$0(0);
            }
            return this.buffer;
        }

        public CharSequence createCharSequence() {
            assert (this.buffer != null);
            return new CharArrayCharSequence(this.buffer, this.offset, this.end);
        }

        @Override
        public void visitLeaf(LeafElement element) {
            ProgressIndicatorProvider.checkCanceled();
            if (!this.isIgnored(element)) {
                this.end = element.copyTo(this.buffer, this.end);
            }
        }

        protected boolean isIgnored(LeafElement element) {
            return element instanceof ForeignLeafPsiElement || this.skipWhitespace && element instanceof PsiWhiteSpace || this.skipComments && element instanceof PsiComment;
        }

        @Override
        public void visitComposite(CompositeElement composite) {
            if (composite instanceof LazyParseableElement) {
                LazyParseableElement lpe = (LazyParseableElement)composite;
                int lpeResult = lpe.copyTo(this.buffer, this.end);
                if (lpeResult >= 0) {
                    this.end = lpeResult;
                    return;
                }
                assert (lpe.isParsed());
            }
            super.visitComposite(composite);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/psi/impl/source/tree/AstBufferUtil$BufferVisitor", "getBuffer"));
        }
    }
}

