/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl.source.tree;

import java.util.ArrayList;
import java.util.List;
import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.lang.FCTSBackedLighterAST;
import sqldelight.com.intellij.lang.FileASTNode;
import sqldelight.com.intellij.lang.LighterAST;
import sqldelight.com.intellij.lang.TreeBackedLighterAST;
import sqldelight.com.intellij.openapi.util.RecursionManager;
import sqldelight.com.intellij.openapi.util.StackOverflowPreventedException;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiInvalidElementAccessException;
import sqldelight.com.intellij.psi.StubBuilder;
import sqldelight.com.intellij.psi.impl.PsiManagerEx;
import sqldelight.com.intellij.psi.impl.source.CharTableImpl;
import sqldelight.com.intellij.psi.impl.source.PsiFileImpl;
import sqldelight.com.intellij.psi.impl.source.tree.AstSpine;
import sqldelight.com.intellij.psi.impl.source.tree.CompositeElement;
import sqldelight.com.intellij.psi.impl.source.tree.LazyParseableElement;
import sqldelight.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import sqldelight.com.intellij.psi.stubs.IStubElementType;
import sqldelight.com.intellij.psi.tree.IElementType;
import sqldelight.com.intellij.psi.tree.ILightStubFileElementType;
import sqldelight.com.intellij.psi.tree.IStubFileElementType;
import sqldelight.com.intellij.util.CharTable;
import sqldelight.org.jetbrains.annotations.NotNull;

public class FileElement
extends LazyParseableElement
implements FileASTNode {
    public static final FileElement[] EMPTY_ARRAY = new FileElement[0];
    private volatile CharTable myCharTable;
    private volatile boolean myDetached;
    private volatile AstSpine myStubbedSpine;

    @Override
    protected PsiElement createPsiNoLock() {
        return this.myDetached ? null : super.createPsiNoLock();
    }

    public void detachFromFile() {
        this.myDetached = true;
        this.clearPsi();
    }

    @Override
    @NotNull
    public CharTable getCharTable() {
        CharTable charTable = this.myCharTable;
        if (charTable == null) {
            FileElement.$$$reportNull$$$0(0);
        }
        return charTable;
    }

    @Override
    @NotNull
    public LighterAST getLighterAST() {
        IElementType contentType = this.getElementType();
        if (!this.isParsed() && contentType instanceof ILightStubFileElementType) {
            return new FCTSBackedLighterAST(this.getCharTable(), ((ILightStubFileElementType)contentType).parseContentsLight(this));
        }
        return new TreeBackedLighterAST(this);
    }

    public FileElement(@NotNull IElementType type2, CharSequence text) {
        if (type2 == null) {
            FileElement.$$$reportNull$$$0(1);
        }
        super(type2, text);
        this.myCharTable = new CharTableImpl();
    }

    @Override
    public PsiManagerEx getManager() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent != null) {
            return treeParent.getManager();
        }
        PsiElement psi = this.getPsi();
        if (psi == null) {
            throw PsiInvalidElementAccessException.createByNode(this, null);
        }
        return (PsiManagerEx)psi.getManager();
    }

    @Override
    public ASTNode copyElement() {
        PsiFileImpl psiElement = (PsiFileImpl)this.getPsi();
        PsiFileImpl psiElementCopy = (PsiFileImpl)psiElement.copy();
        return psiElementCopy.getTreeElement();
    }

    public void setCharTable(@NotNull CharTable table) {
        if (table == null) {
            FileElement.$$$reportNull$$$0(2);
        }
        this.myCharTable = table;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myStubbedSpine = null;
    }

    @NotNull
    public final AstSpine getStubbedSpine() {
        AstSpine result = this.myStubbedSpine;
        if (result == null) {
            PsiFileImpl file = (PsiFileImpl)this.getPsi();
            IStubFileElementType<?> type2 = file.getElementTypeForStubBuilder();
            if (type2 == null) {
                AstSpine astSpine = AstSpine.EMPTY_SPINE;
                if (astSpine == null) {
                    FileElement.$$$reportNull$$$0(3);
                }
                return astSpine;
            }
            result = RecursionManager.doPreventingRecursion(file, false, () -> new AstSpine(this.calcStubbedDescendants(type2.getBuilder())));
            if (result == null) {
                throw new StackOverflowPreventedException("Endless recursion prevented");
            }
            this.myStubbedSpine = result;
        }
        AstSpine astSpine = result;
        if (astSpine == null) {
            FileElement.$$$reportNull$$$0(4);
        }
        return astSpine;
    }

    private List<CompositeElement> calcStubbedDescendants(final StubBuilder builder) {
        final ArrayList<CompositeElement> result = new ArrayList<CompositeElement>();
        result.add(this);
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitComposite(CompositeElement node) {
                CompositeElement parent = node.getTreeParent();
                if (parent != null && builder.skipChildProcessingWhenBuildingStubs(parent, node)) {
                    return;
                }
                IElementType type2 = node.getElementType();
                if (type2 instanceof IStubElementType && ((IStubElementType)type2).shouldCreateStub(node)) {
                    result.add(node);
                }
                super.visitNode(node);
            }
        });
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCharTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

