/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.PluginDescriptor;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.stubs.StubElement;
import sqldelight.com.intellij.psi.stubs.StubElementTypeHolderEP;
import sqldelight.com.intellij.psi.stubs.StubFieldAccessor;
import sqldelight.com.intellij.psi.stubs.StubSerializer;
import sqldelight.com.intellij.psi.tree.IElementType;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class IStubElementType<StubT extends StubElement<?>, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    private static volatile boolean ourInitializedStubs;
    private static volatile Set<String> ourLazyExternalIds;
    private static final Logger LOG;

    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            IStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, language);
        if (!this.isLazilyRegistered()) {
            IStubElementType.checkNotInstantiatedTooLate(this.getClass());
        }
    }

    public static void checkNotInstantiatedTooLate(@NotNull Class<?> aClass) {
        if (aClass == null) {
            IStubElementType.$$$reportNull$$$0(1);
        }
        if (ourInitializedStubs) {
            LOG.error("All stub element types should be created before index initialization is complete.\nPlease add the " + aClass + " containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + StubElementTypeHolderEP.EP_NAME.getExtensionList());
        }
    }

    private boolean isLazilyRegistered() {
        try {
            return ourLazyExternalIds.contains(this.getExternalId());
        }
        catch (Throwable e) {
            return false;
        }
    }

    static void dropRegisteredTypes() {
        ourInitializedStubs = false;
    }

    @NotNull
    static List<StubFieldAccessor> loadRegisteredStubElementTypes() {
        ArrayList<StubFieldAccessor> result = new ArrayList<StubFieldAccessor>();
        StubElementTypeHolderEP.EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> bean.initializeOptimized((PluginDescriptor)pluginDescriptor, (List<? super StubFieldAccessor>)result));
        HashSet<String> lazyIds = new HashSet<String>(result.size());
        for (StubFieldAccessor accessor : result) {
            lazyIds.add(accessor.externalId);
        }
        ourInitializedStubs = true;
        ourLazyExternalIds = lazyIds;
        ArrayList<StubFieldAccessor> arrayList = result;
        if (arrayList == null) {
            IStubElementType.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    @NotNull
    public abstract StubT createStub(@NotNull PsiT var1, StubElement<? extends PsiElement> var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    static {
        ourLazyExternalIds = Collections.emptySet();
        LOG = Logger.getInstance(IStubElementType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/stubs/IStubElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/stubs/IStubElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRegisteredStubElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkNotInstantiatedTooLate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

