/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.tree;

import java.io.IOException;
import java.util.Arrays;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.util.AtomicClearableLazyValue;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.StubBuilder;
import sqldelight.com.intellij.psi.stubs.DefaultStubBuilder;
import sqldelight.com.intellij.psi.stubs.IStubElementType;
import sqldelight.com.intellij.psi.stubs.IndexSink;
import sqldelight.com.intellij.psi.stubs.PsiFileStub;
import sqldelight.com.intellij.psi.stubs.PsiFileStubImpl;
import sqldelight.com.intellij.psi.stubs.StubElement;
import sqldelight.com.intellij.psi.stubs.StubInputStream;
import sqldelight.com.intellij.psi.stubs.StubOutputStream;
import sqldelight.com.intellij.psi.templateLanguages.TemplateLanguage;
import sqldelight.com.intellij.psi.tree.IElementType;
import sqldelight.com.intellij.psi.tree.StubFileElementType;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;

public class IStubFileElementType<T extends PsiFileStub>
extends StubFileElementType<T> {
    private static final AtomicClearableLazyValue<Integer> TEMPLATE_STUB_BASE_VERSION = new AtomicClearableLazyValue<Integer>(){

        @Override
        @NotNull
        protected Integer compute() {
            Integer n = IStubFileElementType.calcTemplateStubBaseVersion();
            if (n == null) {
                1.$$$reportNull$$$0(0);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/psi/tree/IStubFileElementType$1", "compute"));
        }
    };

    public IStubFileElementType(Language language) {
        super(language);
    }

    public IStubFileElementType(@NonNls String debugName, Language language) {
        super(debugName, language);
        if (this.hasNonTrivialExternalId() && !this.isOutOfOurControl()) {
            IStubElementType.checkNotInstantiatedTooLate(this.getClass());
        }
        IStubFileElementType.dropTemplateStubBaseVersion();
    }

    private boolean hasNonTrivialExternalId() {
        return ReflectionUtil.getMethodDeclaringClass(this.getClass(), "getExternalId", new Class[0]) != IStubFileElementType.class;
    }

    private boolean isOutOfOurControl() {
        return this.getClass().getName().contains(".kotlin.");
    }

    public int getStubVersion() {
        return this.getLanguage() instanceof TemplateLanguage ? TEMPLATE_STUB_BASE_VERSION.getValue() : 0;
    }

    public StubBuilder getBuilder() {
        return new DefaultStubBuilder();
    }

    @Override
    @NonNls
    @NotNull
    public String getExternalId() {
        return "psi.file";
    }

    @Override
    public void serialize(@NotNull T stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            IStubFileElementType.$$$reportNull$$$0(0);
        }
        if (dataStream == null) {
            IStubFileElementType.$$$reportNull$$$0(1);
        }
    }

    @Override
    @NotNull
    public T deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            IStubFileElementType.$$$reportNull$$$0(2);
        }
        return (T)new PsiFileStubImpl<Object>(null);
    }

    @Override
    public void indexStub(@NotNull PsiFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            IStubFileElementType.$$$reportNull$$$0(3);
        }
        if (sink == null) {
            IStubFileElementType.$$$reportNull$$$0(4);
        }
    }

    public boolean shouldBuildStubFor(VirtualFile file) {
        return true;
    }

    public static int getTemplateStubBaseVersion() {
        return TEMPLATE_STUB_BASE_VERSION.getValue();
    }

    private static int calcTemplateStubBaseVersion() {
        IElementType[] dataElementTypes = IElementType.enumerate(elementType -> elementType instanceof IStubFileElementType && !(elementType.getLanguage() instanceof TemplateLanguage));
        return Arrays.stream(dataElementTypes).mapToInt(e -> ((IStubFileElementType)e).getStubVersion()).sum();
    }

    @ApiStatus.Internal
    public static void dropTemplateStubBaseVersion() {
        TEMPLATE_STUB_BASE_VERSION.drop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/psi/tree/IStubFileElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

