/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.util;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.psi.util.CachedValueProvider;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CachedValueProfiler {
    private static final Logger LOG = Logger.getInstance(CachedValueProfiler.class);
    private static volatile GlobalContext ourGlobalContext = new GlobalContext(null, 0);
    private static final ThreadLocal<ThreadContext> ourContext = ThreadLocal.withInitial(() -> new ThreadContext(ourGlobalContext));
    private static final AtomicLong ourFrameId = new AtomicLong();
    private static final Overhead ourFrameOverhead = new Overhead();
    private static final Overhead ourTrackerOverhead = new Overhead();

    public static boolean isProfiling() {
        return CachedValueProfiler.ourGlobalContext.consumer != null;
    }

    @Nullable
    public static EventConsumer setEventConsumer(@Nullable EventConsumer eventConsumer) {
        GlobalContext prev = ourGlobalContext;
        if (prev.consumer == null && eventConsumer == null) {
            return null;
        }
        ourGlobalContext = new GlobalContext(eventConsumer, prev.epoch + 1);
        if (prev.consumer != null) {
            LOG.info(ourFrameOverhead.resetAndReport("doCompute()"));
            LOG.info(ourTrackerOverhead.resetAndReport("getValue()"));
        }
        return prev.consumer;
    }

    @NotNull
    public static Frame newFrame() {
        return new Frame();
    }

    static void onResultCreated(@NotNull CachedValueProvider.Result<?> result, @Nullable Object original) {
        EventPlace place;
        if (result == null) {
            CachedValueProfiler.$$$reportNull$$$0(0);
        }
        long time = CachedValueProfiler.currentTime();
        ThreadContext context2 = ourContext.get();
        if (context2.consumer == null || context2.epoch != CachedValueProfiler.ourGlobalContext.epoch) {
            return;
        }
        Frame frame = context2.topFrame;
        if (frame == null) {
            return;
        }
        EventPlace eventPlace = original == null ? CachedValueProfiler.place(CachedValueProfiler::findComputationPlace) : (original instanceof CachedValueProvider.Result ? (EventPlace)frame.places.get(original) : (place = original instanceof Function ? CachedValueProfiler.place(CachedValueProfiler::findCallerPlace) : null));
        if (place == null) {
            return;
        }
        frame.places.put(result, place);
        CachedValueProfiler.ourFrameOverhead.overhead.addAndGet(CachedValueProfiler.currentTime() - time);
    }

    @Nullable
    static ValueTracker onResultReturned(@NotNull Frame frame, @NotNull CachedValueProvider.Result<?> result) {
        if (frame == null) {
            CachedValueProfiler.$$$reportNull$$$0(1);
        }
        if (result == null) {
            CachedValueProfiler.$$$reportNull$$$0(2);
        }
        long time = CachedValueProfiler.currentTime();
        ThreadContext context2 = ourContext.get();
        if (context2.consumer == null) {
            return null;
        }
        EventPlace place = (EventPlace)frame.places.get(result);
        if (place == null) {
            place = CachedValueProfiler.place(CachedValueProfiler::findCallerPlace);
        }
        context2.consumer.onValueComputed(frame.id, place, frame.timeConfigured, time);
        return new ValueTracker(place, frame.timeConfigured, time, context2.epoch);
    }

    static EventPlace place(final Function<? super Throwable, ? extends StackTraceElement> function) {
        final Throwable throwable = new Throwable();
        return new EventPlace(){

            @Override
            public StackTraceElement getStackFrame() {
                return (StackTraceElement)function.apply(throwable);
            }

            @Override
            public StackTraceElement @Nullable [] getStackTrace() {
                return throwable.getStackTrace();
            }
        };
    }

    @Nullable
    static StackTraceElement findComputationPlace(Throwable stackTraceHolder) {
        String className;
        int idx;
        StackTraceElement[] stackTrace = stackTraceHolder.getStackTrace();
        int len = stackTrace.length;
        for (idx = 2; idx < len; ++idx) {
            String method = stackTrace[idx].getMethodName();
            String className2 = stackTrace[idx].getClassName();
            if (!(!"doCompute".equals(method) || !className2.endsWith("CachedValueImpl") && !className2.endsWith("CachedValue") || !className2.startsWith("sqldelight.com.intellij.util.") && !className2.startsWith("sqldelight.com.intellij.psi."))) break;
        }
        if (idx >= len) {
            return null;
        }
        --idx;
        while (idx > 0 && ((className = stackTrace[idx].getClassName()).startsWith("sqldelight.com.intellij.util.CachedValue") || className.startsWith("sqldelight.com.intellij.psi.util.CachedValue") || className.startsWith("sqldelight.com.intellij.psi.impl.PsiCachedValue") || className.startsWith("sqldelight.com.intellij.openapi.util.Recursion"))) {
            --idx;
        }
        if (idx > 0) {
            return stackTrace[idx];
        }
        return null;
    }

    @NotNull
    static StackTraceElement findCallerPlace(Throwable stackTraceHolder) {
        StackTraceElement[] stackTrace = stackTraceHolder.getStackTrace();
        int len = stackTrace.length;
        for (int idx = 2; idx < len; ++idx) {
            String className = stackTrace[idx].getClassName();
            if (className.startsWith("sqldelight.com.intellij.util.CachedValue") || className.startsWith("sqldelight.com.intellij.psi.util.CachedValue") || className.startsWith("sqldelight.com.intellij.psi.impl.PsiCachedValue") || className.startsWith("sqldelight.com.intellij.openapi.util.Recursion") || className.startsWith("sqldelight.com.intellij.psi.impl.PsiParameterizedCachedValue")) continue;
            StackTraceElement stackTraceElement = stackTrace[idx];
            if (stackTraceElement == null) {
                CachedValueProfiler.$$$reportNull$$$0(3);
            }
            return stackTraceElement;
        }
        return new StackTraceElement("unknown", "unknown", "", -1);
    }

    static long currentTime() {
        return System.nanoTime();
    }

    static /* synthetic */ AtomicLong access$100() {
        return ourFrameId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/util/CachedValueProfiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/util/CachedValueProfiler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findCallerPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onResultCreated";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onResultReturned";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Overhead {
        final AtomicLong total = new AtomicLong();
        final AtomicLong overhead = new AtomicLong();
        final AtomicLong count = new AtomicLong();

        private Overhead() {
        }

        String resetAndReport(String eventName) {
            long total = this.total.getAndSet(0L);
            long overhead = this.overhead.getAndSet(0L);
            long count = this.count.getAndSet(0L);
            NumberFormat format = NumberFormat.getInstance(Locale.US);
            return format.format(count) + " " + eventName + " calls, " + format.format(overhead) + " overhead ns" + (count == 0L && total == 0L ? "" : " (" + StringUtil.join(Arrays.asList(count == 0L ? null : format.format(overhead / count) + " ns/call", total == 0L ? null : String.format("%.2f", (double)overhead / (double)(total / 100L)) + " %"), ", ") + ")");
        }
    }

    private static class GlobalContext {
        final EventConsumer consumer;
        final int epoch;

        GlobalContext(@Nullable EventConsumer consumer, int epoch) {
            this.consumer = consumer;
            this.epoch = epoch;
        }
    }

    private static class ThreadContext {
        @Nullable
        final EventConsumer consumer;
        final int epoch;
        @Nullable
        Frame topFrame;

        ThreadContext(@NotNull GlobalContext globalContext) {
            if (globalContext == null) {
                ThreadContext.$$$reportNull$$$0(0);
            }
            this.consumer = globalContext.consumer;
            this.epoch = globalContext.epoch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "sqldelight/com/intellij/psi/util/CachedValueProfiler$ThreadContext", "<init>"));
        }
    }

    public static interface EventPlace {
        @Nullable
        public StackTraceElement getStackFrame();

        public StackTraceElement @Nullable [] getStackTrace();
    }

    public static final class ValueTracker {
        final EventPlace place;
        final long start;
        final long computed;
        final int epoch;
        volatile long used;

        /*
         * WARNING - void declaration
         */
        ValueTracker(@NotNull EventPlace place, long start, long computed, int n) {
            void epoch;
            if (place == null) {
                ValueTracker.$$$reportNull$$$0(0);
            }
            this.place = place;
            this.start = start;
            this.computed = computed;
            this.epoch = epoch;
        }

        public void onValueInvalidated() {
            long time = CachedValueProfiler.currentTime();
            ThreadContext context2 = (ThreadContext)ourContext.get();
            if (context2.consumer == null || context2.epoch != ourGlobalContext.epoch) {
                return;
            }
            if (this.epoch != context2.epoch) {
                return;
            }
            context2.consumer.onValueInvalidated(context2.topFrame == null ? 0L : context2.topFrame.id, this.place, this.used, time);
            ourTrackerOverhead.overhead.addAndGet(CachedValueProfiler.currentTime() - time);
        }

        public void onValueUsed() {
            long time;
            this.used = time = CachedValueProfiler.currentTime();
            ThreadContext context2 = (ThreadContext)ourContext.get();
            if (context2.consumer == null || context2.epoch != ourGlobalContext.epoch) {
                return;
            }
            if (this.epoch != context2.epoch) {
                return;
            }
            context2.consumer.onValueUsed(context2.topFrame == null ? 0L : context2.topFrame.id, this.place, this.computed, time);
            ourTrackerOverhead.count.incrementAndGet();
            ourTrackerOverhead.overhead.addAndGet(CachedValueProfiler.currentTime() - time);
        }

        public void onValueRejected() {
            long time = CachedValueProfiler.currentTime();
            ThreadContext context2 = (ThreadContext)ourContext.get();
            if (context2.consumer == null || context2.epoch != ourGlobalContext.epoch) {
                return;
            }
            if (this.epoch != context2.epoch) {
                return;
            }
            context2.consumer.onValueRejected(context2.topFrame == null ? 0L : context2.topFrame.id, this.place, this.start, this.computed, time);
            ourTrackerOverhead.overhead.addAndGet(CachedValueProfiler.currentTime() - time);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "sqldelight/com/intellij/psi/util/CachedValueProfiler$ValueTracker", "<init>"));
        }
    }

    public static final class Frame
    implements AutoCloseable {
        final long start = CachedValueProfiler.currentTime();
        final long id = CachedValueProfiler.access$100().incrementAndGet();
        final Frame parent;
        private final Map<CachedValueProvider.Result<?>, EventPlace> places = new HashMap();
        private long timeConfigured;
        private long timeComputed;

        Frame() {
            ThreadContext context2 = (ThreadContext)ourContext.get();
            this.parent = context2.topFrame;
            context2.topFrame = this;
            if (context2.consumer == null || context2.epoch != ourGlobalContext.epoch) {
                return;
            }
            EventPlace place = CachedValueProfiler.place(CachedValueProfiler::findCallerPlace);
            context2.consumer.onFrameEnter(this.id, place, this.parent == null ? 0L : this.parent.id, this.start);
            this.timeConfigured = CachedValueProfiler.currentTime();
            ourFrameOverhead.count.incrementAndGet();
            ourFrameOverhead.overhead.addAndGet(this.timeConfigured - this.start);
        }

        @Override
        public void close() {
            ThreadContext context2 = (ThreadContext)ourContext.get();
            this.places.clear();
            if (context2.topFrame != this) {
                LOG.warn("unexpected frame: " + (context2.topFrame == null ? "null" : Long.valueOf(context2.topFrame.id)) + ", expected: " + this.id, new Throwable());
            }
            context2.topFrame = this.parent;
            if (this.parent == null) {
                ourContext.remove();
            }
            if (context2.consumer == null || context2.epoch != ourGlobalContext.epoch) {
                return;
            }
            context2.consumer.onFrameExit(this.id, this.start, this.timeComputed, CachedValueProfiler.currentTime());
            long cur = CachedValueProfiler.currentTime();
            ourFrameOverhead.total.addAndGet(cur - this.start);
            if (this.timeComputed != 0L) {
                ourFrameOverhead.overhead.addAndGet(cur - this.timeComputed);
            }
        }

        @Nullable
        public ValueTracker newValueTracker(@NotNull CachedValueProvider.Result<?> result) {
            if (result == null) {
                Frame.$$$reportNull$$$0(0);
            }
            this.timeComputed = CachedValueProfiler.currentTime();
            return CachedValueProfiler.onResultReturned(this, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "sqldelight/com/intellij/psi/util/CachedValueProfiler$Frame", "newValueTracker"));
        }
    }

    public static interface EventConsumer {
        public void onFrameEnter(long var1, EventPlace var3, long var4, long var6);

        public void onFrameExit(long var1, long var3, long var5, long var7);

        public void onValueComputed(long var1, EventPlace var3, long var4, long var6);

        public void onValueUsed(long var1, EventPlace var3, long var4, long var6);

        public void onValueInvalidated(long var1, EventPlace var3, long var4, long var6);

        public void onValueRejected(long var1, EventPlace var3, long var4, long var6, long var8);
    }
}

