/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import sqldelight.com.intellij.psi.PsiEllipsisType;
import sqldelight.com.intellij.psi.PsiParameter;
import sqldelight.com.intellij.psi.PsiParameterList;
import sqldelight.com.intellij.psi.PsiQualifiedNamedElement;
import sqldelight.com.intellij.psi.PsiSubstitutor;
import sqldelight.com.intellij.psi.PsiType;
import sqldelight.com.intellij.psi.PsiTypeParameter;
import sqldelight.com.intellij.psi.PsiTypeParameterList;
import sqldelight.com.intellij.psi.util.MethodSignature;
import sqldelight.com.intellij.psi.util.MethodSignatureUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class MethodSignatureBase
implements MethodSignature {
    private final PsiSubstitutor mySubstitutor;
    private final PsiType[] myParameterTypes;
    private volatile PsiType[] myErasedParameterTypes;
    protected final PsiTypeParameter[] myTypeParameters;

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor, PsiType @NotNull [] parameterTypes, PsiTypeParameter @NotNull [] typeParameters) {
        if (substitutor == null) {
            MethodSignatureBase.$$$reportNull$$$0(0);
        }
        if (parameterTypes == null) {
            MethodSignatureBase.$$$reportNull$$$0(1);
        }
        if (typeParameters == null) {
            MethodSignatureBase.$$$reportNull$$$0(2);
        }
        this.mySubstitutor = substitutor;
        assert (substitutor.isValid());
        this.myParameterTypes = PsiType.createArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiType type2 = parameterTypes[i];
            if (type2 instanceof PsiEllipsisType) {
                type2 = ((PsiEllipsisType)type2).toArrayType();
            }
            this.myParameterTypes[i] = substitutor.substitute(type2);
        }
        this.myTypeParameters = typeParameters;
    }

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor, @Nullable PsiParameterList parameterList, @Nullable PsiTypeParameterList typeParameterList) {
        if (substitutor == null) {
            MethodSignatureBase.$$$reportNull$$$0(3);
        }
        this.mySubstitutor = substitutor;
        if (parameterList == null) {
            this.myParameterTypes = PsiType.EMPTY_ARRAY;
        } else {
            PsiParameter[] parameters2 = parameterList.getParameters();
            this.myParameterTypes = PsiType.createArray(parameters2.length);
            for (int i = 0; i < parameters2.length; ++i) {
                PsiType type2 = parameters2[i].getType();
                if (type2 instanceof PsiEllipsisType) {
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                }
                this.myParameterTypes[i] = substitutor.substitute(type2);
            }
        }
        this.myTypeParameters = typeParameterList == null ? PsiTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
    }

    @Override
    public PsiType @NotNull [] getParameterTypes() {
        if (this.myParameterTypes == null) {
            MethodSignatureBase.$$$reportNull$$$0(4);
        }
        return this.myParameterTypes;
    }

    @Override
    public PsiTypeParameter @NotNull [] getTypeParameters() {
        if (this.myTypeParameters == null) {
            MethodSignatureBase.$$$reportNull$$$0(5);
        }
        return this.myTypeParameters;
    }

    public PsiType @NotNull [] getErasedParameterTypes() {
        PsiType[] result = this.myErasedParameterTypes;
        if (result == null) {
            result = MethodSignatureUtil.calcErasedParameterTypes(this);
            this.myErasedParameterTypes = result;
        }
        if (result == null) {
            MethodSignatureBase.$$$reportNull$$$0(6);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)o;
        return MethodSignatureUtil.areSignaturesEqual(methodSignature, this);
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        PsiType[] parameterTypes = this.getErasedParameterTypes();
        result = 31 * result + parameterTypes.length;
        int length = Math.min(3, parameterTypes.length);
        for (int i = 0; i < length; ++i) {
            PsiType type2 = parameterTypes[i];
            if (type2 == null) continue;
            result = 31 * result + type2.hashCode();
        }
        return result;
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + ": ";
        PsiTypeParameter[] typeParameters = this.getTypeParameters();
        if (typeParameters.length != 0) {
            s = s + Arrays.stream(typeParameters).map(PsiQualifiedNamedElement::getName).collect(Collectors.joining(", ", "<", ">"));
        }
        s = s + this.getName() + "(" + Arrays.asList(this.getParameterTypes()) + ")";
        return s;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            MethodSignatureBase.$$$reportNull$$$0(7);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/util/MethodSignatureBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/util/MethodSignatureBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErasedParameterTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

