/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ui;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import sqldelight.com.intellij.openapi.util.SystemInfo;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.ui.scale.JBUIScale;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.TestOnly;

public final class JreHiDpiUtil {
    private static final AtomicReference<Boolean> jreHiDPI = new AtomicReference();

    public static boolean isJreHiDPI(@Nullable GraphicsConfiguration gc) {
        return JreHiDpiUtil.isJreHiDPIEnabled() && JBUIScale.isHiDPI(JBUIScale.sysScale(gc));
    }

    public static boolean isJreHiDPI(@Nullable Graphics2D g) {
        return JreHiDpiUtil.isJreHiDPIEnabled() && JBUIScale.isHiDPI(JBUIScale.sysScale(g));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJreHiDPIEnabled() {
        if (SystemInfoRt.isMac) {
            return true;
        }
        Boolean value = jreHiDPI.get();
        if (value != null) {
            return value;
        }
        AtomicReference<Boolean> atomicReference = jreHiDPI;
        synchronized (atomicReference) {
            value = jreHiDPI.get();
            if (value != null) {
                return value;
            }
            value = false;
            if (Boolean.parseBoolean(System.getProperty("hidpi", "true")) && SystemInfo.isJetBrainsJvm) {
                try {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    Class<?> sunGraphicsEnvironmentClass = Class.forName("sun.java2d.SunGraphicsEnvironment");
                    if (sunGraphicsEnvironmentClass.isInstance(ge)) {
                        try {
                            Method method = sunGraphicsEnvironmentClass.getDeclaredMethod("isUIScaleEnabled", new Class[0]);
                            method.setAccessible(true);
                            value = (Boolean)method.invoke((Object)ge, new Object[0]);
                        }
                        catch (NoSuchMethodException e) {
                            value = false;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            jreHiDPI.set(value);
        }
        return value;
    }

    @TestOnly
    @NotNull
    public static AtomicReference<Boolean> test_jreHiDPI() {
        JreHiDpiUtil.isJreHiDPIEnabled();
        AtomicReference<Boolean> atomicReference = jreHiDPI;
        if (atomicReference == null) {
            JreHiDpiUtil.$$$reportNull$$$0(0);
        }
        return atomicReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/ui/JreHiDpiUtil", "test_jreHiDPI"));
    }
}

