/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import sqldelight.com.intellij.ui.JBColor;
import sqldelight.com.intellij.util.ui.JBUI;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class CustomLineBorder
implements Border {
    private final Color myColor;
    private final Insets myInsets;

    public CustomLineBorder(@Nullable Color color, @NotNull Insets insets) {
        if (insets == null) {
            CustomLineBorder.$$$reportNull$$$0(0);
        }
        this.myColor = color;
        this.myInsets = insets;
    }

    public CustomLineBorder(@Nullable Color color, int top, int left, int bottom, int right) {
        this(color, JBUI.insets(top, left, bottom, right));
    }

    public CustomLineBorder(@NotNull Insets insets) {
        if (insets == null) {
            CustomLineBorder.$$$reportNull$$$0(1);
        }
        this(null, insets);
    }

    public CustomLineBorder(int top, int left, int bottom, int right) {
        this(JBUI.insets(top, left, bottom, right));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Color oldColor = g.getColor();
        g.setColor(this.getColor());
        if (this.myInsets.left > 0) {
            g.fillRect(x, y, this.myInsets.left, h);
        }
        if (this.myInsets.bottom > 0) {
            g.fillRect(x, y + h - this.myInsets.bottom, w, this.myInsets.bottom);
        }
        if (this.myInsets.right > 0) {
            g.fillRect(x + w - this.myInsets.right, y, this.myInsets.right, h);
        }
        if (this.myInsets.top > 0) {
            g.fillRect(x, y, w, this.myInsets.top);
        }
        g.setColor(oldColor);
    }

    protected Color getColor() {
        return this.myColor == null ? JBColor.border() : this.myColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return (Insets)this.myInsets.clone();
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insets", "sqldelight/com/intellij/ui/border/CustomLineBorder", "<init>"));
    }
}

