/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ui.svg;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import sqldelight.com.intellij.diagnostic.StartUpMeasurer;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.ui.icons.IconLoadMeasurer;
import sqldelight.com.intellij.ui.svg.ImageValue;
import sqldelight.com.intellij.ui.svg.SvgCacheManagerKt;
import sqldelight.com.intellij.util.ImageLoader;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.mvstore.MVMap;
import sqldelight.org.jetbrains.mvstore.MVStore;
import sqldelight.org.jetbrains.mvstore.type.DataType;
import sqldelight.org.jetbrains.mvstore.type.FixedByteArrayDataType;
import sqldelight.org.jetbrains.mvstore.type.KeyableDataType;
import sun.awt.image.SunWritableRaster;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0010J&\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lsqldelight/com/intellij/ui/svg/SvgCacheManager;", "", "dbFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "mapBuilder", "Lsqldelight/org/jetbrains/mvstore/MVMap$Builder;", "", "Lsqldelight/com/intellij/ui/svg/ImageValue;", "scaleToMap", "", "", "Lsqldelight/org/jetbrains/mvstore/MVMap;", "store", "Lsqldelight/org/jetbrains/mvstore/MVStore;", "close", "", "loadFromCache", "Ljava/awt/Image;", "themeDigest", "imageBytes", "scale", "isDark", "", "docSize", "Lsqldelight/com/intellij/util/ImageLoader$Dimension2DDouble;", "save", "storeLoadedImage", "image", "Ljava/awt/image/BufferedImage;", "Companion", "StoreErrorHandler", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class SvgCacheManager {
    private final MVStore store;
    private final Map<Float, MVMap<byte[], ImageValue>> scaleToMap;
    private final MVMap.Builder<byte[], ImageValue> mapBuilder;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void close() {
        this.store.close();
    }

    public final void save() {
        this.store.triggerAutoSave();
    }

    @Nullable
    public final Image loadFromCache(@NotNull byte[] themeDigest, @NotNull byte[] imageBytes, float scale, boolean isDark, @NotNull ImageLoader.Dimension2DDouble docSize) {
        Intrinsics.checkNotNullParameter((Object)themeDigest, (String)"themeDigest");
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)docSize, (String)"docSize");
        byte[] key = SvgCacheManagerKt.access$getCacheKey(themeDigest, imageBytes);
        MVMap map = Companion.getMap(scale, isDark, this.scaleToMap, this.store, this.mapBuilder);
        try {
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            ImageValue imageValue = (ImageValue)map.get(key);
            if (imageValue == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)imageValue, (String)"map.get(key) ?: return null");
            ImageValue data = imageValue;
            Image image = Companion.readImage(data);
            docSize.setSize((float)data.w / scale, (float)data.h / scale);
            IconLoadMeasurer.svgCacheRead.end(start);
            return image;
        }
        catch (Throwable e) {
            SvgCacheManagerKt.access$getLogger().error(e);
            try {
                map.remove(key);
            }
            catch (Exception e1) {
                SvgCacheManagerKt.access$getLogger().error("Cannot remove invalid entry", e1);
            }
            return null;
        }
    }

    public final void storeLoadedImage(@NotNull byte[] themeDigest, @NotNull byte[] imageBytes, float scale, @NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)themeDigest, (String)"themeDigest");
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        byte[] key = SvgCacheManagerKt.access$getCacheKey(themeDigest, imageBytes);
        Companion.getMap(scale, false, this.scaleToMap, this.store, this.mapBuilder).put(key, SvgCacheManagerKt.access$writeImage(image));
    }

    public SvgCacheManager(@NotNull Path dbFile) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        this.scaleToMap = new ConcurrentHashMap(2, 0.75f, 2);
        StoreErrorHandler storeErrorHandler = new StoreErrorHandler();
        MVStore.Builder storeBuilder = new MVStore.Builder().backgroundExceptionHandler(storeErrorHandler).autoCommitDelay(60000).compressionLevel(1);
        MVStore mVStore = storeBuilder.openOrNewOnIoError(dbFile, true, 1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)mVStore, (String)"storeBuilder.openOrNewOn\u2026on cache database\", it) }");
        this.store = mVStore;
        storeErrorHandler.setStoreOpened(true);
        MVMap.Builder mapBuilder = new MVMap.Builder();
        mapBuilder.keyType((KeyableDataType)new FixedByteArrayDataType(11));
        mapBuilder.valueType((DataType)new ImageValue.ImageValueSerializer());
        this.mapBuilder = mapBuilder;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsqldelight/com/intellij/ui/svg/SvgCacheManager$StoreErrorHandler;", "Ljava/util/function/BiConsumer;", "", "Lsqldelight/org/jetbrains/mvstore/MVStore;", "()V", "isStoreOpened", "", "()Z", "setStoreOpened", "(Z)V", "accept", "", "e", "store", "intellij.platform.util.ui"})
    private static final class StoreErrorHandler
    implements BiConsumer<Throwable, MVStore> {
        private boolean isStoreOpened;

        public final boolean isStoreOpened() {
            return this.isStoreOpened;
        }

        public final void setStoreOpened(boolean bl) {
            this.isStoreOpened = bl;
        }

        @Override
        public void accept(@NotNull Throwable e, @NotNull MVStore store) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)store, (String)"store");
            Logger logger2 = SvgCacheManagerKt.access$getLogger();
            if (this.isStoreOpened) {
                logger2.error("Icon cache error (db=" + store + ")");
            } else {
                logger2.warn("Icon cache will be recreated or previous version of data reused, (db=" + store + ")");
            }
            logger2.debug(e);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J|\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u00040\f2\u0006\u0010\r\u001a\u00020\u000e2$\u0010\u000f\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018\u00a8\u0006\u001a"}, d2={"Lsqldelight/com/intellij/ui/svg/SvgCacheManager$Companion;", "", "()V", "getMap", "Lsqldelight/org/jetbrains/mvstore/MVMap;", "K", "V", "scale", "", "isDark", "", "scaleToMap", "", "store", "Lsqldelight/org/jetbrains/mvstore/MVStore;", "mapBuilder", "Lsqldelight/org/jetbrains/mvstore/MVMap$MapBuilder;", "readImage", "Ljava/awt/Image;", "value", "Lsqldelight/com/intellij/ui/svg/ImageValue;", "buffer", "Ljava/nio/ByteBuffer;", "w", "", "h", "intellij.platform.util.ui"})
    public static final class Companion {
        @NotNull
        public final <K, V> MVMap<K, V> getMap(float scale, boolean isDark, @NotNull Map<Float, MVMap<K, V>> scaleToMap, @NotNull MVStore store, @NotNull MVMap.MapBuilder<MVMap<K, V>, K, V> mapBuilder) {
            Intrinsics.checkNotNullParameter(scaleToMap, (String)"scaleToMap");
            Intrinsics.checkNotNullParameter((Object)store, (String)"store");
            Intrinsics.checkNotNullParameter(mapBuilder, (String)"mapBuilder");
            MVMap<K, V> mVMap = scaleToMap.computeIfAbsent(Float.valueOf(scale + (float)(isDark ? 10000 : 0)), new Function(store, scale, isDark, mapBuilder){
                final /* synthetic */ MVStore $store;
                final /* synthetic */ float $scale;
                final /* synthetic */ boolean $isDark;
                final /* synthetic */ MVMap.MapBuilder $mapBuilder;

                @NotNull
                public final MVMap<K, V> apply(@NotNull Float it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$store.openMap("sqldelight.icons@" + this.$scale + (this.$isDark ? "_d" : ""), this.$mapBuilder);
                }
                {
                    this.$store = mVStore;
                    this.$scale = f;
                    this.$isDark = bl;
                    this.$mapBuilder = mapBuilder;
                }
            });
            Intrinsics.checkNotNullExpressionValue(mVMap, (String)"scaleToMap.computeIfAbse\u2026e \"\", mapBuilder)\n      }");
            return mVMap;
        }

        @NotNull
        public final Image readImage(@NotNull ImageValue value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            DataBufferInt dataBuffer = new DataBufferInt(value.data, value.data.length);
            SunWritableRaster.makeTrackable(dataBuffer);
            return SvgCacheManagerKt.access$createImage(value.w, value.h, dataBuffer);
        }

        @NotNull
        public final Image readImage(@NotNull ByteBuffer buffer, int w, int h) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            DataBufferInt dataBuffer = new DataBufferInt(w * h);
            buffer.asIntBuffer().get(SunWritableRaster.stealData(dataBuffer, 0));
            SunWritableRaster.makeTrackable(dataBuffer);
            return SvgCacheManagerKt.access$createImage(w, h, dataBuffer);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

