/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ui.svg;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.w3c.dom.Element;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.ui.svg.SvgTranscoder;
import sqldelight.org.apache.batik.anim.dom.SVGOMDocument;
import sqldelight.org.apache.batik.bridge.BridgeContext;
import sqldelight.org.apache.batik.bridge.ViewBox;
import sqldelight.org.apache.batik.ext.awt.RenderingHintsKeyExt;
import sqldelight.org.apache.batik.gvt.CanvasGraphicsNode;
import sqldelight.org.apache.batik.gvt.CompositeGraphicsNode;
import sqldelight.org.apache.batik.gvt.GraphicsNode;
import sqldelight.org.w3c.dom.svg.SVGSVGElement;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a@\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u001a\r\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0002\u001a(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"identityTransform", "Ljava/awt/geom/AffineTransform;", "supportedFeatures", "Ljava/util/HashSet;", "", "computeTransform", "document", "Lsqldelight/org/apache/batik/anim/dom/SVGOMDocument;", "gvtRoot", "Lsqldelight/org/apache/batik/gvt/GraphicsNode;", "context", "Lsqldelight/org/apache/batik/bridge/BridgeContext;", "docWidth", "", "docHeight", "width", "height", "getStandardBolderFontWeight", "f", "getStandardLighterFontWeight", "logger", "Lsqldelight/com/intellij/openapi/diagnostic/Logger;", "Lsqldelight/org/jetbrains/annotations/NotNull;", "render", "Ljava/awt/image/BufferedImage;", "offScreenWidth", "", "offScreenHeight", "usr2dev", "intellij.platform.util.ui"})
public final class SvgTranscoderKt {
    private static final AffineTransform identityTransform = new AffineTransform();
    private static final HashSet<String> supportedFeatures = new HashSet();

    private static final Logger logger() {
        Logger logger2 = Logger.getInstance(SvgTranscoder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(SvgTranscoder::class.java)");
        return logger2;
    }

    private static final AffineTransform computeTransform(SVGOMDocument document, GraphicsNode gvtRoot, BridgeContext context2, float docWidth, float docHeight, float width, float height) {
        CanvasGraphicsNode cgn;
        Object object;
        List list;
        GraphicsNode graphicsNode;
        String viewBox;
        AffineTransform preserveAspectRatioMatrix = null;
        SVGSVGElement root = document.getRootElement();
        String string = viewBox = root.getAttributeNS(null, "viewBox");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"viewBox");
        CharSequence charSequence = string;
        if (charSequence.length() > 0) {
            String aspectRatio = root.getAttributeNS(null, "preserveAspectRatio");
            AffineTransform affineTransform = ViewBox.getPreserveAspectRatioTransform((Element)root, viewBox, aspectRatio, width, height, context2);
            Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"ViewBox.getPreserveAspec\u2026, width, height, context)");
            preserveAspectRatioMatrix = affineTransform;
        } else {
            float f = width / docWidth;
            float f2 = height / docHeight;
            float scale = Math.min(f, f2);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(scale, scale);
            Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"AffineTransform.getScale\u2026uble(), scale.toDouble())");
            preserveAspectRatioMatrix = affineTransform;
        }
        if (!((graphicsNode = gvtRoot) instanceof CompositeGraphicsNode)) {
            graphicsNode = null;
        }
        if (!(((list = (CompositeGraphicsNode)graphicsNode) != null && (list = list.getChildren()) != null ? CollectionsKt.firstOrNull((List)list) : (object = null)) instanceof CanvasGraphicsNode)) {
            object = null;
        }
        if ((cgn = (CanvasGraphicsNode)object) == null) {
            return preserveAspectRatioMatrix;
        }
        cgn.setViewingTransform(preserveAspectRatioMatrix);
        return new AffineTransform();
    }

    private static final BufferedImage render(int offScreenWidth, int offScreenHeight, AffineTransform usr2dev, GraphicsNode gvtRoot) {
        BufferedImage image = new BufferedImage(offScreenWidth, offScreenHeight, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(image));
        Graphics2D graphics2D = g;
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"g");
        graphics2D.setTransform(identityTransform);
        g.setClip(0, 0, offScreenWidth, offScreenHeight);
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, offScreenWidth, offScreenHeight);
        g.setComposite(AlphaComposite.SrcOver);
        g.transform(usr2dev);
        gvtRoot.paint(g);
        g.dispose();
        return image;
    }

    private static final float getStandardLighterFontWeight(float f) {
        float f2;
        switch ((int)((f + (float)50) / (float)100) * 100) {
            case 100: 
            case 200: {
                f2 = 100.0f;
                break;
            }
            case 300: {
                f2 = 200.0f;
                break;
            }
            case 400: {
                f2 = 300.0f;
                break;
            }
            case 500: 
            case 600: 
            case 700: 
            case 800: 
            case 900: {
                f2 = 400.0f;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Bad Font Weight: " + f);
            }
        }
        return f2;
    }

    private static final float getStandardBolderFontWeight(float f) {
        float f2;
        switch ((int)((f + (float)50) / (float)100) * 100) {
            case 100: 
            case 200: 
            case 300: 
            case 400: 
            case 500: {
                f2 = 600.0f;
                break;
            }
            case 600: {
                f2 = 700.0f;
                break;
            }
            case 700: {
                f2 = 800.0f;
                break;
            }
            case 800: {
                f2 = 900.0f;
                break;
            }
            case 900: {
                f2 = 900.0f;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Bad Font Weight: " + f);
            }
        }
        return f2;
    }

    public static final /* synthetic */ Logger access$logger() {
        return SvgTranscoderKt.logger();
    }

    public static final /* synthetic */ float access$getStandardLighterFontWeight(float f) {
        return SvgTranscoderKt.getStandardLighterFontWeight(f);
    }

    public static final /* synthetic */ float access$getStandardBolderFontWeight(float f) {
        return SvgTranscoderKt.getStandardBolderFontWeight(f);
    }

    public static final /* synthetic */ HashSet access$getSupportedFeatures$p() {
        return supportedFeatures;
    }

    public static final /* synthetic */ AffineTransform access$computeTransform(SVGOMDocument document, GraphicsNode gvtRoot, BridgeContext context2, float docWidth, float docHeight, float width, float height) {
        return SvgTranscoderKt.computeTransform(document, gvtRoot, context2, docWidth, docHeight, width, height);
    }

    public static final /* synthetic */ BufferedImage access$render(int offScreenWidth, int offScreenHeight, AffineTransform usr2dev, GraphicsNode gvtRoot) {
        return SvgTranscoderKt.render(offScreenWidth, offScreenHeight, usr2dev, gvtRoot);
    }
}

