/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class BitUtil {
    @Contract(pure=true)
    public static boolean isSet(byte value, byte mask) {
        BitUtil.assertOneBitMask(mask);
        return (value & mask) == mask;
    }

    @Contract(pure=true)
    public static boolean isSet(int value, int mask) {
        BitUtil.assertOneBitMask(mask);
        return (value & mask) == mask;
    }

    @Contract(pure=true)
    public static boolean isSet(long flags, long mask) {
        BitUtil.assertOneBitMask(mask);
        return (flags & mask) == mask;
    }

    @Contract(pure=true)
    public static byte set(byte value, byte mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return (byte)(setBit ? value | mask : value & ~mask);
    }

    @Contract(pure=true)
    public static int set(int value, int mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return setBit ? value | mask : value & ~mask;
    }

    @Contract(pure=true)
    public static long set(long value, long mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return setBit ? value | mask : value & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Contract(pure=true)
    public static byte clear(byte value, byte mask) {
        return BitUtil.set(value, mask, false);
    }

    @Contract(pure=true)
    public static int clear(int value, int mask) {
        return BitUtil.set(value, mask, false);
    }

    @Contract(pure=true)
    public static long clear(long value, long mask) {
        return BitUtil.set(value, mask, false);
    }

    private static void assertOneBitMask(byte mask) {
        BitUtil.assertOneBitMask((long)mask & 0xFFL);
    }

    public static void assertOneBitMask(int mask) {
        assert ((mask & mask - 1) == 0) : BitUtil.invalidMaskError(mask);
    }

    private static void assertOneBitMask(long mask) {
        assert ((mask & mask - 1L) == 0L) : BitUtil.invalidMaskError(mask);
    }

    @NotNull
    private static String invalidMaskError(long mask) {
        String string = "Mask must have only one bit set, but got: " + Long.toBinaryString(mask);
        if (string == null) {
            BitUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static boolean isPowerOfTwo(int i) {
        return (i & i - 1) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/util/BitUtil", "invalidMaskError"));
    }
}

