/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Getter;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.UserDataHolder;
import sqldelight.com.intellij.openapi.util.UserDataHolderEx;
import sqldelight.com.intellij.psi.FileViewProvider;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.util.CachedValue;
import sqldelight.com.intellij.psi.util.CachedValueProvider;
import sqldelight.com.intellij.psi.util.CachedValuesManager;
import sqldelight.com.intellij.psi.util.ParameterizedCachedValue;
import sqldelight.com.intellij.psi.util.ParameterizedCachedValueProvider;
import sqldelight.com.intellij.serviceContainer.NonInjectable;
import sqldelight.com.intellij.util.CachedValueBase;
import sqldelight.com.intellij.util.CachedValueLeakChecker;
import sqldelight.com.intellij.util.CachedValueStabilityChecker;
import sqldelight.com.intellij.util.CachedValuesFactory;
import sqldelight.com.intellij.util.DefaultCachedValuesFactory;
import sqldelight.com.intellij.util.containers.CollectionFactory;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class CachedValuesManagerImpl
extends CachedValuesManager {
    private static final Object NULL = new Object();
    private ConcurrentMap<UserDataHolder, Object> myCacheHolders = CollectionFactory.createConcurrentWeakIdentityMap();
    private Set<Key<?>> myKeys = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project) {
        this(project, project.getService(CachedValuesFactory.class));
    }

    @NonInjectable
    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory) {
        this.myProject = project;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project) : factory;
    }

    @Override
    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(0);
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(1);
        }
        return cachedValue;
    }

    @Override
    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(2);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(3);
        }
        return parameterizedCachedValue;
    }

    @Override
    @Nullable
    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value;
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(4);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(6);
        }
        if ((value = dataHolder.getUserData(key)) instanceof CachedValueBase && ((CachedValueBase)((Object)value)).isFromMyProject(this.myProject)) {
            Getter<T> data = value.getUpToDateOrNull();
            if (data != null) {
                return data.get();
            }
            CachedValueStabilityChecker.checkProvidersEquivalent(provider, value.getValueProvider(), key);
        }
        if (value == null) {
            value = this.saveInUserData(dataHolder, key, this.freshCachedValue(dataHolder, key, provider, trackValue));
        }
        return value.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CachedValue<T> saveInUserData(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, CachedValue<T> value) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(7);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(8);
        }
        this.trackKeyHolder(dataHolder, key);
        if (dataHolder instanceof UserDataHolderEx) {
            return ((UserDataHolderEx)dataHolder).putUserDataIfAbsent(key, value);
        }
        UserDataHolder userDataHolder = dataHolder;
        synchronized (userDataHolder) {
            CachedValue<T> existing = dataHolder.getUserData(key);
            if (existing != null) {
                return existing;
            }
            dataHolder.putUserData(key, value);
            return value;
        }
    }

    @Override
    protected void trackKeyHolder(@NotNull UserDataHolder dataHolder, @NotNull Key<?> key) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(9);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(10);
        }
        if (!CachedValuesManagerImpl.isClearedOnPluginUnload(dataHolder)) {
            this.myCacheHolders.put(dataHolder, NULL);
            this.myKeys.add(key);
        }
    }

    private static boolean isClearedOnPluginUnload(@NotNull UserDataHolder dataHolder) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(11);
        }
        return dataHolder instanceof PsiElement || dataHolder instanceof ASTNode || dataHolder instanceof FileViewProvider;
    }

    private <T> CachedValue<T> freshCachedValue(UserDataHolder dh, Key<CachedValue<T>> key, CachedValueProvider<T> provider, boolean trackValue) {
        CachedValueLeakChecker.checkProviderDoesNotLeakPSI(provider, key, dh);
        CachedValue<T> value = this.createCachedValue(provider, trackValue);
        assert (((CachedValueBase)((Object)value)).isFromMyProject(this.myProject));
        return value;
    }

    @ApiStatus.Internal
    public void clearCachedValues() {
        for (UserDataHolder holder : this.myCacheHolders.keySet()) {
            for (Key<?> key : this.myKeys) {
                holder.putUserData(key, null);
            }
        }
        CachedValueStabilityChecker.cleanupFieldCache();
        this.myCacheHolders = CollectionFactory.createConcurrentWeakIdentityMap();
        this.myKeys = ContainerUtil.newConcurrentSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterizedCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createParameterizedCachedValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveInUserData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "trackKeyHolder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isClearedOnPluginUnload";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

