/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import sqldelight.com.intellij.openapi.diagnostic.ControlFlowException;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.Comparing;
import sqldelight.com.intellij.openapi.util.DifferenceFilter;
import sqldelight.com.intellij.util.ArrayUtil;
import sqldelight.com.intellij.util.ArrayUtilRt;
import sqldelight.com.intellij.util.BitUtil;
import sqldelight.com.intellij.util.ExceptionUtil;
import sqldelight.com.intellij.util.ExceptionUtilRt;
import sqldelight.com.intellij.util.JBIterableClassTraverser;
import sqldelight.com.intellij.util.ReflectionUtilRt;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class ReflectionUtil {
    private static final Logger LOG;
    private static final Object unsafe;

    private ReflectionUtil() {
    }

    @Nullable
    public static Type resolveVariable(@NotNull TypeVariable<?> variable, @NotNull Class<?> classType) {
        if (variable == null) {
            ReflectionUtil.$$$reportNull$$$0(0);
        }
        if (classType == null) {
            ReflectionUtil.$$$reportNull$$$0(1);
        }
        return ReflectionUtil.resolveVariable(variable, classType, true);
    }

    @Nullable
    public static Type resolveVariable(@NotNull TypeVariable<?> variable, @NotNull Class<?> classType, boolean resolveInInterfacesOnly) {
        Class<?> aClass;
        int index;
        if (variable == null) {
            ReflectionUtil.$$$reportNull$$$0(2);
        }
        if (classType == null) {
            ReflectionUtil.$$$reportNull$$$0(3);
        }
        if ((index = ArrayUtilRt.find((aClass = ReflectionUtil.getRawType(classType)).getTypeParameters(), variable)) >= 0) {
            return variable;
        }
        Class<?>[] classes = aClass.getInterfaces();
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        for (int i = 0; i <= classes.length; ++i) {
            Type type2;
            Class<?> anInterface;
            if (i < classes.length) {
                anInterface = classes[i];
            } else {
                anInterface = aClass.getSuperclass();
                if (resolveInInterfacesOnly || anInterface == null) continue;
            }
            Type resolved2 = ReflectionUtil.resolveVariable(variable, anInterface);
            if (resolved2 instanceof Class || resolved2 instanceof ParameterizedType) {
                return resolved2;
            }
            if (!(resolved2 instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved2;
            index = ArrayUtilRt.find(anInterface.getTypeParameters(), typeVariable);
            if (index < 0) {
                LOG.error("Cannot resolve type variable:\ntypeVariable = " + typeVariable + "\ngenericDeclaration = " + ReflectionUtil.declarationToString(typeVariable.getGenericDeclaration()) + "\nsearching in " + ReflectionUtil.declarationToString(anInterface));
            }
            Type type3 = type2 = i < genericInterfaces.length ? genericInterfaces[i] : aClass.getGenericSuperclass();
            if (type2 instanceof Class) {
                return Object.class;
            }
            if (type2 instanceof ParameterizedType) {
                return ReflectionUtil.getActualTypeArguments((ParameterizedType)type2)[index];
            }
            throw new AssertionError((Object)("Invalid type: " + type2));
        }
        return null;
    }

    @NotNull
    private static String declarationToString(@NotNull GenericDeclaration anInterface) {
        if (anInterface == null) {
            ReflectionUtil.$$$reportNull$$$0(4);
        }
        String string = anInterface.toString() + Arrays.asList(anInterface.getTypeParameters()) + " loaded by " + ((Class)anInterface).getClassLoader();
        if (string == null) {
            ReflectionUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static Class<?> getRawType(@NotNull Type type2) {
        if (type2 == null) {
            ReflectionUtil.$$$reportNull$$$0(6);
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz == null) {
                ReflectionUtil.$$$reportNull$$$0(7);
            }
            return clazz;
        }
        if (type2 instanceof ParameterizedType) {
            return ReflectionUtil.getRawType(((ParameterizedType)type2).getRawType());
        }
        if (type2 instanceof GenericArrayType) {
            Class<?> clazz = Array.newInstance(ReflectionUtil.getRawType(((GenericArrayType)type2).getGenericComponentType()), 0).getClass();
            if (clazz == null) {
                ReflectionUtil.$$$reportNull$$$0(8);
            }
            return clazz;
        }
        assert (false) : type2;
        if (null == null) {
            ReflectionUtil.$$$reportNull$$$0(9);
        }
        return null;
    }

    public static Type @NotNull [] getActualTypeArguments(@NotNull ParameterizedType parameterizedType) {
        if (parameterizedType == null) {
            ReflectionUtil.$$$reportNull$$$0(10);
        }
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (typeArray == null) {
            ReflectionUtil.$$$reportNull$$$0(11);
        }
        return typeArray;
    }

    @Nullable
    public static Class<?> substituteGenericType(@NotNull Type genericType, @NotNull Type classType) {
        if (genericType == null) {
            ReflectionUtil.$$$reportNull$$$0(12);
        }
        if (classType == null) {
            ReflectionUtil.$$$reportNull$$$0(13);
        }
        if (genericType instanceof TypeVariable) {
            int index;
            Class<?> aClass = ReflectionUtil.getRawType(classType);
            Type type2 = ReflectionUtil.resolveVariable((TypeVariable)genericType, aClass);
            if (type2 instanceof Class) {
                return (Class)type2;
            }
            if (type2 instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type2).getRawType();
            }
            if (type2 instanceof TypeVariable && classType instanceof ParameterizedType && (index = ArrayUtilRt.find(aClass.getTypeParameters(), type2)) >= 0) {
                return ReflectionUtil.getRawType(ReflectionUtil.getActualTypeArguments((ParameterizedType)classType)[index]);
            }
        } else {
            return ReflectionUtil.getRawType(genericType);
        }
        return null;
    }

    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(14);
        }
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class clazz2 : JBIterableClassTraverser.classTraverser(clazz)) {
            Collections.addAll(result, clazz2.getDeclaredFields());
        }
        ArrayList<Field> arrayList = result;
        if (arrayList == null) {
            ReflectionUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Field findField(@NotNull Class<?> clazz, @Nullable Class<?> type2, @NotNull @NonNls String name) throws NoSuchFieldException {
        Field result;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(17);
        }
        if ((result = ReflectionUtil.findFieldInHierarchy(clazz, field -> name.equals(field.getName()) && (type2 == null || field.getType().equals(type2)))) != null) {
            Field field2 = result;
            if (field2 == null) {
                ReflectionUtil.$$$reportNull$$$0(18);
            }
            return field2;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type2);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<?> fieldType, @NotNull @NonNls String fieldName) throws NoSuchFieldException {
        Field result;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(19);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(20);
        }
        if ((result = ReflectionUtil.findFieldInHierarchy(clazz, field -> fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType())))) != null) {
            Field field2 = result;
            if (field2 == null) {
                ReflectionUtil.$$$reportNull$$$0(21);
            }
            return field2;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    @Nullable
    public static Field findFieldInHierarchy(@NotNull Class<?> rootClass, @NotNull Predicate<? super Field> checker) {
        if (rootClass == null) {
            ReflectionUtil.$$$reportNull$$$0(22);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(23);
        }
        for (Class<?> aClass = rootClass; aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return ReflectionUtil.processInterfaces(rootClass.getInterfaces(), new HashSet(), checker);
    }

    @Nullable
    private static Field processInterfaces(Class<?> @NotNull [] interfaces, @NotNull Set<? super Class<?>> visited, @NotNull Predicate<? super Field> checker) {
        if (visited == null) {
            ReflectionUtil.$$$reportNull$$$0(24);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(25);
        }
        if (interfaces == null) {
            ReflectionUtil.$$$reportNull$$$0(26);
        }
        for (Class<?> anInterface : interfaces) {
            if (!visited.add(anInterface)) continue;
            for (Field field : anInterface.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
            Field field = ReflectionUtil.processInterfaces(anInterface.getInterfaces(), visited, checker);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static void resetField(@NotNull Class<?> clazz, @Nullable(value="null means of any type") @Nullable(value="null means of any type") Class<?> type2, @NotNull @NonNls String name) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(27);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(28);
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type2, name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetField(@NotNull Object object, @NotNull @NonNls String name) {
        if (object == null) {
            ReflectionUtil.$$$reportNull$$$0(29);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(30);
        }
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), null, name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(31);
        }
        field.setAccessible(true);
        Class<?> type2 = field.getType();
        try {
            if (type2.isPrimitive()) {
                if (Boolean.TYPE.equals(type2)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type2)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type2)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type2)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Method findMethod(@NotNull Collection<Method> methods, @NonNls @NotNull String name, Class<?> ... parameters2) {
        if (methods == null) {
            ReflectionUtil.$$$reportNull$$$0(32);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(33);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(34);
        }
        for (Method method : methods) {
            if (parameters2.length != method.getParameterCount() || !name.equals(method.getName()) || !Arrays.equals(parameters2, method.getParameterTypes())) continue;
            return ReflectionUtil.makeAccessible(method);
        }
        return null;
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters2) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(35);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(36);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(37);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getMethod(name, parameters2));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters2) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(38);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(39);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(40);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getDeclaredMethod(name, parameters2));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class<?> aClass, @NonNls @NotNull String name) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(41);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(42);
        }
        return ReflectionUtil.findFieldInHierarchy(aClass, field -> name.equals(field.getName()));
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(43);
        }
        return ReflectionUtil.getClassPublicMethods(aClass, false);
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class<?> aClass, boolean includeSynthetic) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(44);
        }
        Method[] methods = aClass.getMethods();
        return includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(45);
        }
        return ReflectionUtil.getClassDeclaredMethods(aClass, false);
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class<?> aClass, boolean includeSynthetic) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(46);
        }
        Method[] methods = aClass.getDeclaredMethods();
        return includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
    }

    @NotNull
    public static List<Field> getClassDeclaredFields(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(47);
        }
        Field[] fields = aClass.getDeclaredFields();
        List<Field> list = Arrays.asList(fields);
        if (list == null) {
            ReflectionUtil.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    private static List<Method> filterRealMethods(Method @NotNull [] methods) {
        if (methods == null) {
            ReflectionUtil.$$$reportNull$$$0(49);
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.isSynthetic()) continue;
            result.add(method);
        }
        ArrayList<Method> arrayList = result;
        if (arrayList == null) {
            ReflectionUtil.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @Nullable
    public static Class<?> getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class<?> ... parameters2) {
        Method method;
        if (instanceClass == null) {
            ReflectionUtil.$$$reportNull$$$0(51);
        }
        if (methodName == null) {
            ReflectionUtil.$$$reportNull$$$0(52);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(53);
        }
        if ((method = ReflectionUtil.getMethod(instanceClass, methodName, parameters2)) != null) {
            return method.getDeclaringClass();
        }
        while (instanceClass != null) {
            method = ReflectionUtil.getDeclaredMethod(instanceClass, methodName, parameters2);
            if (method != null) {
                return method.getDeclaringClass();
            }
            instanceClass = instanceClass.getSuperclass();
        }
        return null;
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(54);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(55);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return ReflectionUtil.getFieldValue(field, object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class<?> objectClass, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(56);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(57);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (ReflectionUtil.isInstanceField(field)) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            return ReflectionUtil.getFieldValue(field, null);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    @Nullable
    public static <T> T getFieldValue(@NotNull Field field, @Nullable Object object) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(58);
        }
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static boolean isInstanceField(@NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(59);
        }
        return !Modifier.isStatic(field.getModifiers());
    }

    public static <T> boolean setField(@NotNull Class<?> objectClass, Object object, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName, T value) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(60);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(61);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            field.set(object, value);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.debug(e);
            return false;
        }
    }

    public static Type resolveVariableInHierarchy(@NotNull TypeVariable<?> variable, @NotNull Class<?> aClass) {
        Type type2;
        if (variable == null) {
            ReflectionUtil.$$$reportNull$$$0(62);
        }
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(63);
        }
        Class<?> current = aClass;
        while ((type2 = ReflectionUtil.resolveVariable(variable, current, false)) == null) {
            if ((current = current.getSuperclass()) != null) continue;
            return null;
        }
        if (type2 instanceof TypeVariable) {
            return ReflectionUtil.resolveVariableInHierarchy((TypeVariable)type2, aClass);
        }
        return type2;
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(@NotNull Class<T> aClass) {
        Constructor<T> constructor;
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(64);
        }
        try {
            Constructor<T> constructor2 = aClass.getConstructor(new Class[0]);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass, e);
        }
        if (constructor == null) {
            ReflectionUtil.$$$reportNull$$$0(65);
        }
        return constructor;
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(66);
        }
        return ReflectionUtil.newInstance(aClass, true);
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass, boolean isKotlinDataClassesSupported) {
        T t;
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(67);
        }
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            t = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            T t2;
            Throwable targetException;
            if (e instanceof InvocationTargetException && (targetException = ((InvocationTargetException)e).getTargetException()) instanceof ControlFlowException && targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (isKotlinDataClassesSupported && (t2 = ReflectionUtil.createAsDataClass(aClass)) != null) {
                T t3 = t2;
                if (t3 == null) {
                    ReflectionUtil.$$$reportNull$$$0(69);
                }
                return t3;
            }
            ExceptionUtilRt.rethrowUnchecked(e);
            throw new RuntimeException(e);
        }
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(68);
        }
        return t;
    }

    @Nullable
    private static <T> T createAsDataClass(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(70);
        }
        for (Annotation annotation : aClass.getAnnotations()) {
            String name = annotation.annotationType().getName();
            if (!name.equals("kotlin.Metadata") && !name.equals("kotlin.jvm.internal.KotlinClass")) continue;
            Constructor<?>[] constructors = aClass.getDeclaredConstructors();
            Exception exception = null;
            SmartList defaultCtors = new SmartList();
            for (Constructor<?> constructor : constructors) {
                try {
                    block15: {
                        Class<?>[] parameterTypes;
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (constructor.getParameterCount() == 0) {
                            return (T)constructor.newInstance(new Object[0]);
                        }
                        for (Class<?> type2 : parameterTypes = constructor.getParameterTypes()) {
                            if (!type2.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) {
                                continue;
                            }
                            break block15;
                        }
                        return (T)constructor.newInstance(new Object[parameterTypes.length]);
                    }
                    defaultCtors.add(constructor);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            for (Constructor constructor : defaultCtors) {
                try {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception == null) continue;
            ExceptionUtil.rethrow(exception);
        }
        return null;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args) {
        T t;
        if (constructor == null) {
            ReflectionUtil.$$$reportNull$$$0(71);
        }
        if (args == null) {
            ReflectionUtil.$$$reportNull$$$0(72);
        }
        try {
            t = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(73);
        }
        return t;
    }

    @Nullable
    public static Class<?> getGrandCallerClass() {
        int stackFrameCount = 3;
        return ReflectionUtil.getCallerClass(stackFrameCount + 1);
    }

    public static Class<?> getCallerClass(int stackFrameCount) {
        Class<?> callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        int depth = stackFrameCount + 1;
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(depth);
            ++depth;
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(stackFrameCount - 1);
        }
        return callerClass;
    }

    public static void copyFields(Field @NotNull [] fields, @NotNull Object from, @NotNull Object to) {
        if (from == null) {
            ReflectionUtil.$$$reportNull$$$0(74);
        }
        if (to == null) {
            ReflectionUtil.$$$reportNull$$$0(75);
        }
        if (fields == null) {
            ReflectionUtil.$$$reportNull$$$0(76);
        }
        ReflectionUtil.copyFields(fields, from, to, null);
    }

    public static boolean copyFields(Field @NotNull [] fields, @NotNull Object from, @NotNull Object to, @Nullable DifferenceFilter<?> diffFilter) {
        if (from == null) {
            ReflectionUtil.$$$reportNull$$$0(77);
        }
        if (to == null) {
            ReflectionUtil.$$$reportNull$$$0(78);
        }
        if (fields == null) {
            ReflectionUtil.$$$reportNull$$$0(79);
        }
        HashSet<Field> sourceFields = new HashSet<Field>(Arrays.asList(from.getClass().getFields()));
        boolean valuesChanged = false;
        for (Field field : fields) {
            if (!sourceFields.contains(field) || !ReflectionUtil.isPublic(field) || ReflectionUtil.isFinal(field)) continue;
            try {
                if (diffFilter != null && !diffFilter.test(field)) continue;
                ReflectionUtil.copyFieldValue(from, to, field);
                valuesChanged = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return valuesChanged;
    }

    public static <T> boolean comparePublicNonFinalFields(@NotNull T first, @NotNull T second) {
        if (first == null) {
            ReflectionUtil.$$$reportNull$$$0(80);
        }
        if (second == null) {
            ReflectionUtil.$$$reportNull$$$0(81);
        }
        Class<?> defaultClass = first.getClass();
        Field[] fields = defaultClass.getDeclaredFields();
        if (defaultClass != second.getClass()) {
            fields = ArrayUtil.mergeArrays(fields, second.getClass().getDeclaredFields());
        }
        for (Field field : fields) {
            if (!ReflectionUtil.isPublic(field) || ReflectionUtil.isFinal(field)) continue;
            field.setAccessible(true);
            try {
                if (Comparing.equal(field.get(second), field.get(first))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public static void copyFieldValue(@NotNull Object from, @NotNull Object to, @NotNull Field field) throws IllegalAccessException {
        Class<?> fieldType;
        if (from == null) {
            ReflectionUtil.$$$reportNull$$$0(82);
        }
        if (to == null) {
            ReflectionUtil.$$$reportNull$$$0(83);
        }
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(84);
        }
        if (!((fieldType = field.getType()).isPrimitive() || fieldType.equals(String.class) || fieldType.isEnum())) {
            throw new RuntimeException("Field '" + field.getName() + "' not copied: unsupported type: " + field.getType());
        }
        field.set(to, field.get(from));
    }

    private static boolean isPublic(@NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(85);
        }
        return (field.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(@NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(86);
        }
        return (field.getModifiers() & 0x10) != 0;
    }

    @NotNull
    public static Class<?> forName(@NotNull String fqn) {
        Class<?> clazz;
        if (fqn == null) {
            ReflectionUtil.$$$reportNull$$$0(87);
        }
        try {
            clazz = Class.forName(fqn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(88);
        }
        return clazz;
    }

    @NotNull
    public static Class<?> boxType(@NotNull Class<?> type2) {
        if (type2 == null) {
            ReflectionUtil.$$$reportNull$$$0(89);
        }
        if (!type2.isPrimitive()) {
            Class<?> clazz = type2;
            if (clazz == null) {
                ReflectionUtil.$$$reportNull$$$0(90);
            }
            return clazz;
        }
        if (type2 == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type2 == Byte.TYPE) {
            return Byte.class;
        }
        if (type2 == Short.TYPE) {
            return Short.class;
        }
        if (type2 == Integer.TYPE) {
            return Integer.class;
        }
        if (type2 == Long.TYPE) {
            return Long.class;
        }
        if (type2 == Float.TYPE) {
            return Float.class;
        }
        if (type2 == Double.TYPE) {
            return Double.class;
        }
        if (type2 == Character.TYPE) {
            return Character.class;
        }
        Class<?> clazz = type2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(91);
        }
        return clazz;
    }

    @NotNull
    public static <T, V> Field getTheOnlyVolatileInstanceFieldOfClass(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            ReflectionUtil.$$$reportNull$$$0(92);
        }
        if (fieldType == null) {
            ReflectionUtil.$$$reportNull$$$0(93);
        }
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field : declaredFields) {
            int modifiers = field.getModifiers();
            if (BitUtil.isSet(modifiers, 8) || !BitUtil.isSet(modifiers, 64) || !fieldType.isAssignableFrom(field.getType())) continue;
            if (found == null) {
                found = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found + " and " + field);
        }
        if (found == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        Field field = found;
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(94);
        }
        return field;
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static Object getUnsafe() {
        Object object = unsafe;
        if (object == null) {
            ReflectionUtil.$$$reportNull$$$0(95);
        }
        return object;
    }

    public static Class<?> findCallerClass(int framesToSkip) {
        return ReflectionUtilRt.findCallerClass(framesToSkip + 1);
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            ReflectionUtil.$$$reportNull$$$0(96);
        }
        if (descendant == null) {
            ReflectionUtil.$$$reportNull$$$0(97);
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    public static String dumpFields(@NotNull Class<?> objectClass, @Nullable Object object, String ... fieldNames) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(98);
        }
        SmartList<String> chunks = new SmartList<String>();
        for (String fieldName : fieldNames) {
            chunks.add(fieldName + "=" + ReflectionUtil.getField(objectClass, object, null, fieldName));
        }
        return String.join((CharSequence)"; ", chunks);
    }

    static {
        Class<?> unsafeClass;
        LOG = Logger.getInstance(ReflectionUtil.class);
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        unsafe = ReflectionUtil.getStaticFieldValue(unsafeClass, unsafeClass, "theUnsafe");
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the Unsafe class");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/ReflectionUtil";
                break;
            }
            case 6: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterizedType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: 
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 55: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 31: 
            case 58: 
            case 59: 
            case 84: 
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 32: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 34: 
            case 37: 
            case 40: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceClass";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 54: 
            case 56: 
            case 60: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 74: 
            case 77: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 75: 
            case 78: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/ReflectionUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationToString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualTypeArguments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findField";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findAssignableField";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclaredFields";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRealMethods";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructor";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "forName";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsafe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "declarationToString";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRawType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActualTypeArguments";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "substituteGenericType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAssignableField";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFieldInHierarchy";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processInterfaces";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resetField";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredMethod";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredField";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getClassPublicMethods";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredMethods";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredFields";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "filterRealMethods";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclaringClass";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFieldValue";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFieldValue";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceField";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setField";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariableInHierarchy";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructor";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createAsDataClass";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "copyFields";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "comparePublicNonFinalFields";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldValue";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isPublic";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "forName";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "dumpFields";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 48: 
            case 50: 
            case 65: 
            case 68: 
            case 69: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 95: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

