/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sqldelight.com.intellij.diagnostic.StartUpMeasurer;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.IconLoader;
import sqldelight.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.util.text.Strings;
import sqldelight.com.intellij.ui.ColorUtil;
import sqldelight.com.intellij.ui.icons.IconLoadMeasurer;
import sqldelight.com.intellij.ui.scale.DerivedScaleType;
import sqldelight.com.intellij.ui.scale.ScaleContext;
import sqldelight.com.intellij.ui.svg.SvgCacheManager;
import sqldelight.com.intellij.ui.svg.SvgDocumentFactoryKt;
import sqldelight.com.intellij.ui.svg.SvgPrebuiltCacheManager;
import sqldelight.com.intellij.ui.svg.SvgTranscoder;
import sqldelight.com.intellij.util.ArrayUtilRt;
import sqldelight.com.intellij.util.ImageLoader;
import sqldelight.com.intellij.util.ui.EDT;
import sqldelight.com.intellij.util.ui.ImageUtil;
import sqldelight.org.apache.batik.transcoder.TranscoderException;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SVGLoader {
    private static final byte[] DEFAULT_THEME = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    private static final boolean USE_CACHE = Boolean.parseBoolean(System.getProperty("idea.ui.icons.svg.disk.cache", "true"));
    private static SvgElementColorPatcherProvider ourColorPatcher;
    private static SvgElementColorPatcherProvider selectionColorPatcher;
    private static SvgElementColorPatcherProvider contextColorPatcher;
    private static volatile boolean isColorRedefinitionContext;
    public static final int ICON_DEFAULT_SIZE = 16;

    @Nullable
    public static SvgCacheManager getCache() {
        return SvgCache.persistentCache;
    }

    private SVGLoader() {
    }

    public static Image load(@NotNull URL url, float scale) throws IOException {
        if (url == null) {
            SVGLoader.$$$reportNull$$$0(0);
        }
        return SVGLoader.load(url.getPath(), url.openStream(), scale, false, null);
    }

    public static Image load(@NotNull InputStream stream, float scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(1);
        }
        return SVGLoader.load(null, stream, scale, false, null);
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, float scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(2);
        }
        return SVGLoader.load(url == null ? null : url.getPath(), stream, scale, false, null);
    }

    @ApiStatus.Internal
    @Nullable
    public static Image loadFromClassResource(@Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, @NotNull String path, int rasterizedCacheKey, float scale, boolean isDark, @NotNull ImageLoader.Dimension2DDouble docSize) throws IOException {
        byte[] themeDigest;
        if (path == null) {
            SVGLoader.$$$reportNull$$$0(3);
        }
        if (docSize == null) {
            SVGLoader.$$$reportNull$$$0(4);
        }
        byte[] data = null;
        if (USE_CACHE && !SVGLoader.isColorRedefinitionContext()) {
            SvgElementColorPatcher subPatcher;
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            themeDigest = DEFAULT_THEME;
            SvgElementColorPatcherProvider colorPatcher = ourColorPatcher;
            if (colorPatcher != null && (subPatcher = colorPatcher.forPath(path)) != null) {
                themeDigest = subPatcher.digest();
            }
            if (themeDigest != null) {
                Image image;
                SvgPrebuiltCacheManager cache;
                if (themeDigest == DEFAULT_THEME && rasterizedCacheKey != 0 && (cache = SvgCache.prebuiltPersistentCache) != null) {
                    try {
                        image = cache.loadFromCache(rasterizedCacheKey, scale, isDark, docSize);
                    }
                    catch (Throwable e) {
                        Logger.getInstance(SVGLoader.class).error("cannot load from prebuilt icon cache", e);
                        image = null;
                    }
                    if (image != null) {
                        return image;
                    }
                }
                if ((data = ImageLoader.getResourceData(path, resourceClass, classLoader)) == null) {
                    return null;
                }
                image = SvgCache.persistentCache.loadFromCache(themeDigest, data, scale, isDark, docSize);
                if (image != null) {
                    return image;
                }
            }
            if (start != -1L) {
                IconLoadMeasurer.svgCacheRead.end(start);
            }
        } else {
            themeDigest = null;
        }
        if (data == null && (data = ImageLoader.getResourceData(path, resourceClass, classLoader)) == null) {
            return null;
        }
        return SVGLoader.loadAndCache(path, data, scale, docSize, themeDigest);
    }

    @ApiStatus.Internal
    @NotNull
    public static Image load(@Nullable String path, @NotNull InputStream stream, float scale, boolean isDark, @Nullable ImageLoader.Dimension2DDouble docSize) throws IOException {
        byte[] data;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(5);
        }
        if (docSize == null) {
            docSize = new ImageLoader.Dimension2DDouble(0.0, 0.0);
        }
        byte[] themeDigest = null;
        if (USE_CACHE && !SVGLoader.isColorRedefinitionContext()) {
            SvgElementColorPatcher subPatcher;
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            themeDigest = DEFAULT_THEME;
            SvgElementColorPatcherProvider colorPatcher = ourColorPatcher;
            if (colorPatcher != null && (subPatcher = colorPatcher.forPath(path)) != null) {
                themeDigest = subPatcher.digest();
            }
            if (themeDigest == null) {
                data = null;
            } else {
                data = stream.readAllBytes();
                Image image = SvgCache.persistentCache.loadFromCache(themeDigest, data, scale, isDark, docSize);
                if (image != null) {
                    Image image2 = image;
                    if (image2 == null) {
                        SVGLoader.$$$reportNull$$$0(6);
                    }
                    return image2;
                }
            }
            if (start != -1L) {
                IconLoadMeasurer.svgCacheRead.end(start);
            }
        } else {
            data = stream.readAllBytes();
        }
        return SVGLoader.loadAndCache(path, data, scale, docSize, themeDigest);
    }

    @NotNull
    private static BufferedImage loadAndCache(@Nullable String path, byte[] data, float scale, @NotNull ImageLoader.Dimension2DDouble docSize, byte[] themeDigest) throws IOException {
        BufferedImage bufferedImage;
        if (docSize == null) {
            SVGLoader.$$$reportNull$$$0(7);
        }
        long decodingStart = StartUpMeasurer.getCurrentTimeIfEnabled();
        try {
            bufferedImage = SvgTranscoder.createImage(scale, SVGLoader.createDocument(path, data), docSize);
        }
        catch (TranscoderException e) {
            docSize.setSize(0.0, 0.0);
            throw new IOException(e);
        }
        if (decodingStart != -1L) {
            IconLoadMeasurer.svgDecoding.end(decodingStart);
        }
        if (themeDigest != null) {
            try {
                long cacheWriteStart = StartUpMeasurer.getCurrentTimeIfEnabled();
                SvgCache.persistentCache.storeLoadedImage(themeDigest, data, scale, bufferedImage);
                IconLoadMeasurer.svgCacheWrite.end(cacheWriteStart);
            }
            catch (Exception e) {
                Logger.getInstance(SVGLoader.class).error("Failed to write SVG cache for: " + path, e);
            }
        }
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            SVGLoader.$$$reportNull$$$0(8);
        }
        return bufferedImage2;
    }

    @NotNull
    public static BufferedImage loadWithoutCache(byte @NotNull [] content, float scale) throws IOException {
        BufferedImage bufferedImage;
        if (content == null) {
            SVGLoader.$$$reportNull$$$0(9);
        }
        try {
            bufferedImage = SvgTranscoder.createImage(scale, SVGLoader.createDocument(null, new ByteArrayInputStream(content)), null);
        }
        catch (TranscoderException e) {
            throw new IOException(e);
        }
        if (bufferedImage == null) {
            SVGLoader.$$$reportNull$$$0(10);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    public static Image load(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext scaleContext, double width, double d) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(11);
        }
        if (scaleContext == null) {
            SVGLoader.$$$reportNull$$$0(12);
        }
        try {
            void height;
            double scale = scaleContext.getScale(DerivedScaleType.PIX_SCALE);
            return SvgTranscoder.createImage(1.0f, SVGLoader.createDocument(url != null ? url.getPath() : null, stream), null, (float)(width * scale), (float)(height * scale));
        }
        catch (TranscoderException e) {
            throw new IOException(e);
        }
    }

    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, ScaleContext context2) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(13);
        }
        BufferedImage image = (BufferedImage)SVGLoader.load(url == null ? null : url.getPath(), stream, (float)context2.getScale(DerivedScaleType.PIX_SCALE), false, null);
        BufferedImage t = (BufferedImage)ImageUtil.ensureHiDPI(image, context2);
        return (T)t;
    }

    public static ImageLoader.Dimension2DDouble getDocumentSize(@NotNull InputStream stream, float scale) throws IOException {
        int ch;
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(14);
        }
        BufferExposingByteArrayOutputStream buffer = new BufferExposingByteArrayOutputStream(100);
        byte[] bytes = new byte[3];
        boolean checkClosingBracket = false;
        while ((ch = stream.read()) != -1) {
            buffer.write(ch);
            if (ch == 60) {
                int n = stream.read(bytes, 0, 3);
                if (n == -1) break;
                buffer.write(bytes, 0, n);
                checkClosingBracket = n == 3 && bytes[0] == 115 && bytes[1] == 118 && bytes[2] == 103;
                continue;
            }
            if (!checkClosingBracket || ch != 62) continue;
            buffer.write(new byte[]{60, 47, 115, 118, 103, 62});
            ByteArrayInputStream input = new ByteArrayInputStream(buffer.getInternalBuffer(), 0, buffer.size());
            return SvgTranscoder.getDocumentSize(scale, SvgDocumentFactoryKt.createSvgDocument(null, input));
        }
        return new ImageLoader.Dimension2DDouble(16.0f * scale, 16.0f * scale);
    }

    public static double getMaxZoomFactor(@Nullable String path, @NotNull InputStream stream, @NotNull ScaleContext scaleContext) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(15);
        }
        if (scaleContext == null) {
            SVGLoader.$$$reportNull$$$0(16);
        }
        ImageLoader.Dimension2DDouble size = SvgTranscoder.getDocumentSize((float)scaleContext.getScale(DerivedScaleType.PIX_SCALE), SVGLoader.createDocument(path, stream));
        float iconMaxSize2 = SvgTranscoder.getIconMaxSize();
        return Math.min((double)iconMaxSize2 / size.getWidth(), (double)iconMaxSize2 / size.getHeight());
    }

    @NotNull
    private static Document createDocument(@Nullable String url, @NotNull InputStream inputStream) {
        if (inputStream == null) {
            SVGLoader.$$$reportNull$$$0(17);
        }
        Document document = SvgDocumentFactoryKt.createSvgDocument(url, inputStream);
        SVGLoader.patchColors(url, document);
        Document document2 = document;
        if (document2 == null) {
            SVGLoader.$$$reportNull$$$0(18);
        }
        return document2;
    }

    @NotNull
    private static Document createDocument(@Nullable String url, byte[] data) {
        Document document = SvgDocumentFactoryKt.createSvgDocument(url, data);
        SVGLoader.patchColors(url, document);
        Document document2 = document;
        if (document2 == null) {
            SVGLoader.$$$reportNull$$$0(19);
        }
        return document2;
    }

    private static void patchColors(@Nullable String url, @NotNull Document document) {
        SvgElementColorPatcher selectionPatcher;
        SvgElementColorPatcherProvider selectionPatcherProvider;
        SvgElementColorPatcher patcher;
        SvgElementColorPatcherProvider colorPatcher;
        if (document == null) {
            SVGLoader.$$$reportNull$$$0(20);
        }
        if ((colorPatcher = ourColorPatcher) != null && (patcher = colorPatcher.forPath(url)) != null) {
            patcher.patchColors(document.getDocumentElement());
        }
        if (SVGLoader.isColorRedefinitionContext() && (selectionPatcherProvider = SVGLoader.getColorPatcherProvider()) != null && (selectionPatcher = selectionPatcherProvider.forPath(url)) != null) {
            selectionPatcher.patchColors(document.getDocumentElement());
        }
    }

    public static void setContextColorPatcher(@Nullable SvgElementColorPatcherProvider provider) {
        contextColorPatcher = provider;
    }

    private static SvgElementColorPatcherProvider getColorPatcherProvider() {
        return contextColorPatcher;
    }

    @Nullable
    public static SvgElementColorPatcher newPatcher(final byte @Nullable [] digest, final @NotNull Map<String, String> newPalette, final @NotNull Map<String, Integer> alphas) {
        if (newPalette == null) {
            SVGLoader.$$$reportNull$$$0(21);
        }
        if (alphas == null) {
            SVGLoader.$$$reportNull$$$0(22);
        }
        if (newPalette.isEmpty()) {
            return null;
        }
        return new SvgElementColorPatcher(){

            @Override
            public byte[] digest() {
                return digest;
            }

            @Override
            public void patchColors(@NotNull Element svg) {
                if (svg == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.patchColorAttribute(svg, "fill");
                this.patchColorAttribute(svg, "stroke");
                NodeList nodes = svg.getChildNodes();
                int length = nodes.getLength();
                for (int i = 0; i < length; ++i) {
                    Node item = nodes.item(i);
                    if (!(item instanceof Element)) continue;
                    this.patchColors((Element)item);
                }
            }

            private void patchColorAttribute(@NotNull Element svg, String attrName) {
                if (svg == null) {
                    1.$$$reportNull$$$0(1);
                }
                String color = svg.getAttribute(attrName);
                String opacity = svg.getAttribute(attrName + "-opacity");
                if (!Strings.isEmpty(color)) {
                    int alpha = 255;
                    try {
                        alpha = (int)Math.ceil(255.0f * Float.parseFloat(opacity));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String newColor = null;
                    String key = SVGLoader.toCanonicalColor(color);
                    if (alpha != 255) {
                        newColor = (String)newPalette.get(key + Integer.toHexString(alpha));
                    }
                    if (newColor == null) {
                        newColor = (String)newPalette.get(key);
                    }
                    if (newColor != null) {
                        svg.setAttribute(attrName, newColor);
                        if (alphas.get(newColor) != null) {
                            svg.setAttribute(attrName + "-opacity", String.valueOf(Float.valueOf(((Integer)alphas.get(newColor)).intValue()).floatValue() / 255.0f));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "svg";
                objectArray2[1] = "sqldelight/com/intellij/util/SVGLoader$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "patchColors";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "patchColorAttribute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static String toCanonicalColor(String color) {
        Object s = Strings.toLowerCase(color);
        if (((String)s).startsWith("#") && ((String)s).length() < 7) {
            s = "#" + ColorUtil.toHex(ColorUtil.fromHex((String)s));
        }
        return s;
    }

    public static void setColorPatcherProvider(@Nullable SvgElementColorPatcherProvider colorPatcher) {
        ourColorPatcher = colorPatcher;
        IconLoader.clearCache();
    }

    public static void setSelectionColorPatcherProvider(@Nullable SvgElementColorPatcherProvider colorPatcher) {
        selectionColorPatcher = colorPatcher;
        IconLoader.clearCache();
    }

    public static void setColorRedefinitionContext(boolean isColorRedefinitionContext) {
        SVGLoader.isColorRedefinitionContext = isColorRedefinitionContext;
    }

    public static boolean isColorRedefinitionContext() {
        return contextColorPatcher != null && isColorRedefinitionContext && EDT.isCurrentThreadEdt() && Registry.is("ide.patch.icons.on.selection", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintIconWithSelection(Icon icon2, Component c, Graphics g, int x, int y) {
        if (selectionColorPatcher == null) {
            icon2.paintIcon(c, g, x, y);
        } else {
            try {
                SVGLoader.setContextColorPatcher(selectionColorPatcher);
                SVGLoader.setColorRedefinitionContext(true);
                icon2.paintIcon(c, g, x, y);
            }
            finally {
                SVGLoader.setContextColorPatcher(null);
                SVGLoader.setColorRedefinitionContext(false);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docSize";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/SVGLoader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPalette";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alphas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/SVGLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndCache";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadWithoutCache";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFromClassResource";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadAndCache";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadWithoutCache";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadHiDPI";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentSize";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMaxZoomFactor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "patchColors";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newPatcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SvgElementColorPatcherProvider {
        @Deprecated
        @Nullable
        default public SvgElementColorPatcher forURL(@Nullable URL url) {
            return null;
        }

        @Nullable
        default public SvgElementColorPatcher forPath(@Nullable String path) {
            return this.forURL(null);
        }
    }

    public static interface SvgElementColorPatcher {
        public void patchColors(@NotNull Element var1);

        public byte @Nullable [] digest();
    }

    private static final class SvgCache {
        private static final SvgCacheManager persistentCache;
        private static final SvgPrebuiltCacheManager prebuiltPersistentCache;

        private SvgCache() {
        }

        static {
            SvgCacheManager cache;
            SvgPrebuiltCacheManager prebuiltCache;
            try {
                String dbPath;
                Path dbDir = null;
                if (USE_CACHE && !"false".equals(dbPath = System.getProperty("idea.ui.icons.prebuilt.db"))) {
                    dbDir = dbPath == null || dbPath.isEmpty() ? Path.of(PathManager.getBinPath() + "/icons", new String[0]) : Path.of(dbPath, new String[0]);
                }
                prebuiltCache = dbDir != null && Files.isDirectory(dbDir, new LinkOption[0]) ? new SvgPrebuiltCacheManager(dbDir) : null;
            }
            catch (Exception e) {
                Logger.getInstance(SVGLoader.class).error("Cannot use prebuilt svg cache", e);
                prebuiltCache = null;
            }
            prebuiltPersistentCache = prebuiltCache;
            try {
                cache = USE_CACHE ? new SvgCacheManager(Path.of(PathManager.getSystemPath(), "sqldelight.icons-v6.db")) : null;
            }
            catch (Exception e) {
                Logger.getInstance(SVGLoader.class).error(e);
                cache = null;
            }
            persistentCache = cache;
        }
    }
}

