/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.containers;

import java.io.File;
import java.io.Serializable;
import sqldelight.com.intellij.openapi.util.io.FileUtilRt;
import sqldelight.com.intellij.util.containers.CanonicalObjectStrategy;
import sqldelight.com.intellij.util.containers.FastUtilCaseInsensitiveStringHashingStrategy;
import sqldelight.com.intellij.util.containers.FastUtilCharSequenceHashingStrategy;
import sqldelight.com.intellij.util.containers.HashingStrategy;
import sqldelight.it.unimi.dsi.fastutil.Hash;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FastUtilHashingStrategies {
    private static final Hash.Strategy<CharSequence> CASE_SENSITIVE = new FastUtilCharSequenceHashingStrategy(true);
    private static final Hash.Strategy<CharSequence> CASE_INSENSITIVE = new FastUtilCharSequenceHashingStrategy(false);
    public static final Hash.Strategy<File> FILE_HASH_STRATEGY = new SerializableHashStrategy<File>(){

        @Override
        public int hashCode(@Nullable File o) {
            return FileUtilRt.pathHashCode(o == null ? null : o.getPath());
        }

        @Override
        public boolean equals(@Nullable File a, @Nullable File b) {
            return FileUtilRt.pathsEqual(a == null ? null : a.getPath(), b == null ? null : b.getPath());
        }
    };

    private FastUtilHashingStrategies() {
    }

    @NotNull
    public static Hash.Strategy<CharSequence> getCharSequenceStrategy(boolean isCaseSensitive) {
        Hash.Strategy<CharSequence> strategy = isCaseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(0);
        }
        return strategy;
    }

    @NotNull
    public static Hash.Strategy<String> getStringStrategy(boolean isCaseSensitive) {
        Hash.Strategy<Object> strategy = isCaseSensitive ? FastUtilHashingStrategies.getCanonicalStrategy() : FastUtilCaseInsensitiveStringHashingStrategy.INSTANCE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(1);
        }
        return strategy;
    }

    @NotNull
    public static Hash.Strategy<String> getCaseInsensitiveStringStrategy() {
        Hash.Strategy<String> strategy = FastUtilCaseInsensitiveStringHashingStrategy.INSTANCE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(2);
        }
        return strategy;
    }

    @NotNull
    public static <T> Hash.Strategy<T> getCanonicalStrategy() {
        Hash.Strategy<Object> strategy = CanonicalObjectStrategy.INSTANCE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(3);
        }
        return strategy;
    }

    @NotNull
    public static <T> Hash.Strategy<T> adaptAsNotNull(final @NotNull HashingStrategy<? super T> hashingStrategy) {
        if (hashingStrategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(4);
        }
        return new Hash.Strategy<T>(){

            @Override
            public int hashCode(@Nullable T o) {
                return o == null ? 0 : hashingStrategy.hashCode(o);
            }

            @Override
            public boolean equals(@Nullable T a, @Nullable T b) {
                return a == b || a != null && b != null && hashingStrategy.equals(a, b);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/containers/FastUtilHashingStrategies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharSequenceStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseInsensitiveStringStrategy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalStrategy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/containers/FastUtilHashingStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adaptAsNotNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface SerializableHashStrategy<T>
    extends Hash.Strategy<T>,
    Serializable {
    }
}

