/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.indexing;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sqldelight.com.intellij.diagnostic.PluginException;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.ReadAction;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.progress.ProgressIndicator;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.roots.ContentIterator;
import sqldelight.com.intellij.openapi.roots.ProjectFileIndex;
import sqldelight.com.intellij.openapi.util.Condition;
import sqldelight.com.intellij.openapi.util.ThrowableComputable;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.vfs.VFileProperty;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileFilter;
import sqldelight.com.intellij.openapi.vfs.VirtualFileWithId;
import sqldelight.com.intellij.psi.search.GlobalSearchScope;
import sqldelight.com.intellij.util.Consumer;
import sqldelight.com.intellij.util.IncorrectOperationException;
import sqldelight.com.intellij.util.Processor;
import sqldelight.com.intellij.util.SystemProperties;
import sqldelight.com.intellij.util.indexing.DumbModeAccessType;
import sqldelight.com.intellij.util.indexing.ID;
import sqldelight.com.intellij.util.indexing.IdFilter;
import sqldelight.com.intellij.util.indexing.IndexedFile;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class FileBasedIndex {
    @Deprecated(forRemoval=true)
    public static final boolean ourEnableTracingOfKeyHashToVirtualFileMapping = true;
    @ApiStatus.Internal
    public static final boolean ourSnapshotMappingsEnabled = SystemProperties.getBooleanProperty("idea.index.snapshot.mappings.enabled", true);
    private static final boolean ourDisableIndexAccessDuringDumbMode = Boolean.getBoolean("idea.disable.index.access.during.dumb.mode");
    @ApiStatus.Internal
    public static final boolean USE_IN_MEMORY_INDEX = Boolean.getBoolean("idea.use.in.memory.file.based.index");
    @ApiStatus.Internal
    public static final boolean IGNORE_PLAIN_TEXT_FILES = Boolean.getBoolean("idea.ignore.plain.text.indexing");

    public abstract void iterateIndexableFiles(@NotNull ContentIterator var1, @NotNull Project var2, @Nullable ProgressIndicator var3);

    @Nullable
    public abstract VirtualFile getFileBeingCurrentlyIndexed();

    @Nullable
    public abstract IndexWritingFile getFileWritingCurrentlyIndexes();

    @ApiStatus.Internal
    public void registerProjectFileSets(@NotNull Project project) {
        if (project == null) {
            FileBasedIndex.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    public void removeProjectFileSets(@NotNull Project project) {
        if (project == null) {
            FileBasedIndex.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    @Nullable
    public DumbModeAccessType getCurrentDumbModeAccessType() {
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    @NotNull
    public <T> Processor<? super T> inheritCurrentDumbAccessType(@NotNull Processor<? super T> processor) {
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(2);
        }
        Processor<? super T> processor2 = processor;
        if (processor2 == null) {
            FileBasedIndex.$$$reportNull$$$0(3);
        }
        return processor2;
    }

    public static FileBasedIndex getInstance() {
        return ApplicationManager.getApplication().getService(FileBasedIndex.class);
    }

    public static int getFileId(@NotNull VirtualFile file) {
        if (file == null) {
            FileBasedIndex.$$$reportNull$$$0(4);
        }
        if (file instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)((Object)file)).getId();
        }
        throw new IllegalArgumentException("Virtual file doesn't support id: " + file + ", implementation class: " + file.getClass().getName());
    }

    @Deprecated(forRemoval=true)
    public abstract VirtualFile findFileById(Project var1, int var2);

    public void requestRebuild(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(5);
        }
        this.requestRebuild(indexId, new Throwable());
    }

    @NotNull
    public abstract <K, V> List<V> getValues(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    @NotNull
    public abstract <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    @ApiStatus.Experimental
    @NotNull
    public abstract <K, V> Iterator<VirtualFile> getContainingFilesIterator(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    public abstract <K, V> boolean processValues(@NotNull ID<K, V> var1, @NotNull K var2, @Nullable VirtualFile var3, @NotNull ValueProcessor<? super V> var4, @NotNull GlobalSearchScope var5);

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull ValueProcessor<? super V> processor, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(6);
        }
        if (dataKey == null) {
            FileBasedIndex.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            FileBasedIndex.$$$reportNull$$$0(9);
        }
        return this.processValues(indexId, dataKey, inFile, processor, filter);
    }

    public abstract <K, V> long getIndexModificationStamp(@NotNull ID<K, V> var1, @NotNull Project var2);

    public abstract <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> var1, @NotNull Collection<? extends K> var2, @NotNull GlobalSearchScope var3, @Nullable Condition<? super V> var4, @NotNull Processor<? super VirtualFile> var5);

    public abstract <K, V> boolean processFilesContainingAnyKey(@NotNull ID<K, V> var1, @NotNull Collection<? extends K> var2, @NotNull GlobalSearchScope var3, @Nullable IdFilter var4, @Nullable Condition<? super V> var5, @NotNull Processor<? super VirtualFile> var6);

    @NotNull
    public abstract <K> Collection<K> getAllKeys(@NotNull ID<K, ?> var1, @NotNull Project var2);

    @ApiStatus.Internal
    public abstract <K> void ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3);

    public abstract void requestRebuild(@NotNull ID<?, ?> var1, @NotNull Throwable var2);

    public abstract <K> void scheduleRebuild(@NotNull ID<K, ?> var1, @NotNull Throwable var2);

    public abstract void requestReindex(@NotNull VirtualFile var1);

    public abstract <K, V> boolean getFilesWithKey(@NotNull ID<K, V> var1, @NotNull Set<? extends K> var2, @NotNull Processor<? super VirtualFile> var3, @NotNull GlobalSearchScope var4);

    @ApiStatus.Experimental
    public void ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull Runnable command) {
        if (dumbModeAccessType == null) {
            FileBasedIndex.$$$reportNull$$$0(10);
        }
        if (command == null) {
            FileBasedIndex.$$$reportNull$$$0(11);
        }
        this.ignoreDumbMode(dumbModeAccessType, () -> {
            command.run();
            return null;
        });
    }

    @ApiStatus.Experimental
    public <T, E extends Throwable> T ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (dumbModeAccessType == null) {
            FileBasedIndex.$$$reportNull$$$0(12);
        }
        if (computable == null) {
            FileBasedIndex.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    public abstract <K> boolean processAllKeys(@NotNull ID<K, ?> var1, @NotNull Processor<? super K> var2, @Nullable Project var3);

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            FileBasedIndex.$$$reportNull$$$0(16);
        }
        return this.processAllKeys(indexId, processor, scope.getProject());
    }

    @NotNull
    public abstract <K, V> Map<K, V> getFileData(@NotNull ID<K, V> var1, @NotNull VirtualFile var2, @NotNull Project var3);

    @Nullable
    public abstract <V> V getSingleEntryIndexData(@NotNull ID<Integer, V> var1, @NotNull VirtualFile var2, @NotNull Project var3);

    public static void iterateRecursively(@NotNull VirtualFile root, @NotNull ContentIterator processor, @Nullable ProgressIndicator indicator, @Nullable Set<? super VirtualFile> visitedRoots, @Nullable ProjectFileIndex projectFileIndex) {
        if (root == null) {
            FileBasedIndex.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(18);
        }
        VirtualFileFilter acceptFilter = file -> {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (visitedRoots != null && !root.equals(file) && file.isDirectory() && !visitedRoots.add(file)) {
                return false;
            }
            return projectFileIndex == null || ReadAction.compute(() -> projectFileIndex.isExcluded(file)) == false;
        };
        VirtualFileFilter symlinkFilter = file -> {
            if (acceptFilter.accept(file)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    if (!Registry.is("indexer.follows.symlinks")) {
                        return false;
                    }
                    VirtualFile canonicalFile = file.getCanonicalFile();
                    if (canonicalFile != null) {
                        return acceptFilter.accept(canonicalFile);
                    }
                }
                return true;
            }
            return false;
        };
        VfsUtilCore.iterateChildrenRecursively(root, symlinkFilter, processor);
    }

    public void invalidateCaches() {
        throw new IncorrectOperationException();
    }

    @ApiStatus.Experimental
    public boolean isFileIndexedInCurrentSession(@NotNull VirtualFile file, @NotNull ID<?, ?> indexId) {
        if (file == null) {
            FileBasedIndex.$$$reportNull$$$0(19);
        }
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(20);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Experimental
    public boolean processFilesContainingAllKeys(@NotNull Collection<? extends AllKeysQuery<?, ?>> queries, @NotNull GlobalSearchScope filter, @NotNull Processor<? super VirtualFile> processor) {
        if (queries == null) {
            FileBasedIndex.$$$reportNull$$$0(21);
        }
        if (filter == null) {
            FileBasedIndex.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    public static boolean isIndexAccessDuringDumbModeEnabled() {
        return !ourDisableIndexAccessDuringDumbMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/indexing/FileBasedIndex";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbModeAccessType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/indexing/FileBasedIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "inheritCurrentDumbAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectFileSets";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectFileSets";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inheritCurrentDumbAccessType";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processValues";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDumbMode";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "iterateRecursively";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isFileIndexedInCurrentSession";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface FileTypeSpecificInputFilter
    extends InputFilter {
        public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> var1);
    }

    @ApiStatus.Experimental
    public static interface ProjectSpecificInputFilter
    extends InputFilter {
        @Override
        default public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                ProjectSpecificInputFilter.$$$reportNull$$$0(0);
            }
            PluginException.reportDeprecatedDefault(this.getClass(), "acceptInput", "`acceptInput(IndexedFile)` should be called");
            return false;
        }

        public boolean acceptInput(@NotNull IndexedFile var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "sqldelight/com/intellij/util/indexing/FileBasedIndex$ProjectSpecificInputFilter", "acceptInput"));
        }
    }

    @FunctionalInterface
    public static interface InputFilter {
        public boolean acceptInput(@NotNull VirtualFile var1);
    }

    @FunctionalInterface
    public static interface ValueProcessor<V> {
        public boolean process(@NotNull VirtualFile var1, V var2);
    }

    @ApiStatus.Experimental
    public static class AllKeysQuery<K, V> {
        @NotNull
        private final ID<K, V> indexId;
        @NotNull
        private final Collection<? extends K> dataKeys;
        @Nullable
        private final Condition<? super V> valueChecker;

        public AllKeysQuery(@NotNull ID<K, V> id, @NotNull Collection<? extends K> keys, @Nullable Condition<? super V> checker) {
            if (id == null) {
                AllKeysQuery.$$$reportNull$$$0(0);
            }
            if (keys == null) {
                AllKeysQuery.$$$reportNull$$$0(1);
            }
            this.indexId = id;
            this.dataKeys = keys;
            this.valueChecker = checker;
        }

        @NotNull
        public ID<K, V> getIndexId() {
            ID<K, V> iD = this.indexId;
            if (iD == null) {
                AllKeysQuery.$$$reportNull$$$0(2);
            }
            return iD;
        }

        @NotNull
        public Collection<? extends K> getDataKeys() {
            Collection<? extends K> collection = this.dataKeys;
            if (collection == null) {
                AllKeysQuery.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Nullable
        public Condition<? super V> getValueChecker() {
            return this.valueChecker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/util/indexing/FileBasedIndex$AllKeysQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/util/indexing/FileBasedIndex$AllKeysQuery";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class IndexWritingFile {
        public final int fileId;
        @Nullable
        public final String filePath;

        public IndexWritingFile(int id, @Nullable String path) {
            this.fileId = id;
            this.filePath = path;
        }
    }
}

