/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.indexing;

import java.io.IOException;
import java.nio.charset.Charset;
import sqldelight.com.intellij.lang.FileASTNode;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.lang.LighterAST;
import sqldelight.com.intellij.lang.TreeBackedLighterAST;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.fileEditor.FileDocumentManager;
import sqldelight.com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.fileTypes.FileTypeRegistry;
import sqldelight.com.intellij.openapi.fileTypes.LanguageFileType;
import sqldelight.com.intellij.openapi.project.DefaultProjectFactory;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.NotNullComputable;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.LanguageSubstitutors;
import sqldelight.com.intellij.psi.PsiDocumentManager;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiFileFactory;
import sqldelight.com.intellij.util.indexing.FileContent;
import sqldelight.com.intellij.util.indexing.IndexedFile;
import sqldelight.com.intellij.util.indexing.IndexedFileImpl;
import sqldelight.com.intellij.util.indexing.IndexingDataKeys;
import sqldelight.com.intellij.util.indexing.PsiDependentFileContent;
import sqldelight.com.intellij.util.indexing.SubstitutedFileType;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class FileContentImpl
extends IndexedFileImpl
implements PsiDependentFileContent {
    @NotNull
    private final NotNullComputable<byte[]> myContentComputable;
    private Charset myCharset;
    private byte[] myContent;
    private CharSequence myContentAsText;
    private byte[] myIndexedFileHash;
    private boolean myLighterASTShouldBeThreadSafe;
    private final boolean myPhysicalContent;
    private static final Key<PsiFile> CACHED_PSI = Key.create("cached psi from content");
    private static final Key<LighterAST> LIGHTER_AST_NODE_KEY = Key.create("lighter.ast.node");

    private FileContentImpl(@NotNull VirtualFile file, @NotNull FileType fileType, @Nullable CharSequence contentAsText, @NotNull NotNullComputable<byte[]> contentComputable, boolean physicalContent) {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(1);
        }
        if (contentComputable == null) {
            FileContentImpl.$$$reportNull$$$0(2);
        }
        super(file, fileType, null);
        this.myContentAsText = contentAsText;
        this.myContentComputable = contentComputable;
        this.myPhysicalContent = physicalContent;
    }

    @Override
    @NotNull
    public LighterAST getLighterAST() {
        LighterAST lighterAST = this.getUserData(LIGHTER_AST_NODE_KEY);
        if (lighterAST == null) {
            FileASTNode node = this.getPsiFile().getNode();
            lighterAST = this.myLighterASTShouldBeThreadSafe ? new TreeBackedLighterAST(node) : node.getLighterAST();
            this.putUserData(LIGHTER_AST_NODE_KEY, lighterAST);
        }
        LighterAST lighterAST2 = lighterAST;
        if (lighterAST2 == null) {
            FileContentImpl.$$$reportNull$$$0(3);
        }
        return lighterAST2;
    }

    void ensureThreadSafeLighterAST() {
        this.myLighterASTShouldBeThreadSafe = true;
    }

    private PsiFile createFileFromText(@NotNull CharSequence text) {
        FileType fileType;
        Project project;
        if (text == null) {
            FileContentImpl.$$$reportNull$$$0(4);
        }
        if ((project = this.getProject()) == null) {
            project = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        if (!((fileType = FileContentImpl.getFileTypeWithoutSubstitution(this)) instanceof LanguageFileType)) {
            throw new AssertionError((Object)("PSI can be created only for a file with LanguageFileType but actual is " + fileType.getClass() + ".\nPlease use a proper FileBasedIndexExtension#getInputFilter() implementation for the caller index"));
        }
        return FileContentImpl.createFileFromText(project, text, (LanguageFileType)fileType, this.myFile, this.getFileName());
    }

    @NotNull
    public static PsiFile createFileFromText(@NotNull Project project, @NotNull CharSequence text, @NotNull LanguageFileType fileType, @NotNull VirtualFile file, @NotNull String fileName) {
        if (project == null) {
            FileContentImpl.$$$reportNull$$$0(5);
        }
        if (text == null) {
            FileContentImpl.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            FileContentImpl.$$$reportNull$$$0(9);
        }
        Language language = fileType.getLanguage();
        Language substitutedLanguage = LanguageSubstitutors.getInstance().substituteLanguage(language, file, project);
        PsiFile psiFile = PsiFileFactory.getInstance(project).createFileFromText(fileName, substitutedLanguage, text, false, false, false, file);
        if (psiFile == null) {
            throw new IllegalStateException("psiFile is null. language = " + language.getID() + ", substitutedLanguage = " + substitutedLanguage.getID());
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            FileContentImpl.$$$reportNull$$$0(10);
        }
        return psiFile2;
    }

    @NotNull
    public static FileContent createByContent(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(11);
        }
        if (content == null) {
            FileContentImpl.$$$reportNull$$$0(12);
        }
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFile(file, content);
        return new FileContentImpl(file, fileType, null, () -> content, true);
    }

    @NotNull
    public static FileContentImpl createByContent(@NotNull VirtualFile file, @NotNull NotNullComputable<byte[]> contentComputable) {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(13);
        }
        if (contentComputable == null) {
            FileContentImpl.$$$reportNull$$$0(14);
        }
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFile(file);
        return new FileContentImpl(file, fileType, null, contentComputable, true);
    }

    @NotNull
    public static FileContent createByContent(@NotNull VirtualFile file, @NotNull NotNullComputable<byte[]> contentComputable, @Nullable Project project) {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(15);
        }
        if (contentComputable == null) {
            FileContentImpl.$$$reportNull$$$0(16);
        }
        FileContentImpl fileContent = FileContentImpl.createByContent(file, contentComputable);
        if (project != null) {
            fileContent.setProject(project);
        }
        FileContentImpl fileContentImpl = fileContent;
        if (fileContentImpl == null) {
            FileContentImpl.$$$reportNull$$$0(17);
        }
        return fileContentImpl;
    }

    @NotNull
    public static FileContent createByFile(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(18);
        }
        return FileContentImpl.createByFile(file, null);
    }

    @NotNull
    public static FileContent createByFile(@NotNull VirtualFile file, @Nullable Project project) throws IOException {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(19);
        }
        FileContentImpl content = (FileContentImpl)FileContentImpl.createByContent(file, file.contentsToByteArray(false));
        if (project != null) {
            content.setProject(project);
        }
        FileContentImpl fileContentImpl = content;
        if (fileContentImpl == null) {
            FileContentImpl.$$$reportNull$$$0(20);
        }
        return fileContentImpl;
    }

    @NotNull
    public static FileContent createByText(@NotNull VirtualFile file, @NotNull CharSequence contentAsText, @Nullable Project project) {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(21);
        }
        if (contentAsText == null) {
            FileContentImpl.$$$reportNull$$$0(22);
        }
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFile(file);
        FileContentImpl content = new FileContentImpl(file, fileType, contentAsText, () -> {
            throw new IllegalStateException("Content must be converted from 'contentAsText'");
        }, false);
        if (project != null) {
            content.setProject(project);
        }
        FileContentImpl fileContentImpl = content;
        if (fileContentImpl == null) {
            FileContentImpl.$$$reportNull$$$0(23);
        }
        return fileContentImpl;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            this.myCharset = charset = this.myFile.getCharset();
        }
        Charset charset2 = charset;
        if (charset2 == null) {
            FileContentImpl.$$$reportNull$$$0(24);
        }
        return charset2;
    }

    public boolean isPhysicalContent() {
        return this.myPhysicalContent;
    }

    @Override
    public byte @NotNull [] getContent() {
        if (this.myContent == null) {
            if (this.myContentAsText != null) {
                this.myContent = this.myContentAsText.toString().getBytes(this.getCharset());
            } else {
                this.myContent = this.myContentComputable.compute();
                FileType unsubstitutedFileType = FileContentImpl.getFileTypeWithoutSubstitution(this);
                if (!unsubstitutedFileType.isBinary()) {
                    this.myContent = this.getContentAsText().toString().getBytes(this.getCharset());
                }
            }
        }
        if (this.myContent == null) {
            FileContentImpl.$$$reportNull$$$0(25);
        }
        return this.myContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public CharSequence getContentAsText() {
        FileType unsubstitutedFileType = FileContentImpl.getFileTypeWithoutSubstitution(this);
        if (unsubstitutedFileType.isBinary()) {
            throw new UnsupportedOperationException("Cannot obtain text for binary file type : " + unsubstitutedFileType.getDescription());
        }
        CharSequence content = this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content != null) {
            CharSequence charSequence = content;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                FileContentImpl.$$$reportNull$$$0(26);
            }
            return charSequence2;
        }
        if (this.myContentAsText == null) {
            this.myContentAsText = LoadTextUtil.getTextByBinaryPresentation(this.getContent(), this.myFile);
        }
        CharSequence charSequence = this.myContentAsText;
        CharSequence charSequence3 = charSequence;
        if (charSequence3 == null) {
            FileContentImpl.$$$reportNull$$$0(27);
        }
        return charSequence3;
        finally {
            this.myContent = null;
        }
    }

    @Override
    public String toString() {
        return "FileContentImpl(" + this.getFileName() + ")";
    }

    public byte @Nullable [] getIndexedFileHash() {
        if (!this.myPhysicalContent) {
            throw new IllegalStateException("Hashes are allowed only while physical changes indexing");
        }
        return this.myIndexedFileHash;
    }

    public void setIndexedFileHash(byte @NotNull [] fileContentHash) {
        if (fileContentHash == null) {
            FileContentImpl.$$$reportNull$$$0(28);
        }
        this.myIndexedFileHash = fileContentHash;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile existingPsi;
        PsiDocumentManager psiDocumentManager;
        Document document;
        if (!this.myPhysicalContent && (document = FileDocumentManager.getInstance().getCachedDocument(this.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance(this.getProject())).isUncommited(document) && (existingPsi = psiDocumentManager.getPsiFile(document)) != null) {
            PsiFile psiFile = existingPsi;
            if (psiFile == null) {
                FileContentImpl.$$$reportNull$$$0(29);
            }
            return psiFile;
        }
        PsiFile explicitPsi = this.getUserData(IndexingDataKeys.PSI_FILE);
        if (explicitPsi != null) {
            PsiFile psiFile = explicitPsi;
            if (psiFile == null) {
                FileContentImpl.$$$reportNull$$$0(30);
            }
            return psiFile;
        }
        PsiFile cachedPsi = this.getUserData(CACHED_PSI);
        if (cachedPsi != null) {
            PsiFile psiFile = cachedPsi;
            if (psiFile == null) {
                FileContentImpl.$$$reportNull$$$0(31);
            }
            return psiFile;
        }
        PsiFile createdPsi = this.createFileFromText(this.getContentAsText());
        createdPsi.putUserData(IndexingDataKeys.VIRTUAL_FILE, this.getFile());
        this.putUserData(CACHED_PSI, createdPsi);
        PsiFile psiFile = createdPsi;
        if (psiFile == null) {
            FileContentImpl.$$$reportNull$$$0(32);
        }
        return psiFile;
    }

    @ApiStatus.Internal
    @NotNull
    public static FileType getFileTypeWithoutSubstitution(@NotNull IndexedFile indexedFile) {
        FileType fileType;
        if (indexedFile == null) {
            FileContentImpl.$$$reportNull$$$0(33);
        }
        FileType fileType2 = (fileType = indexedFile.getFileType()) instanceof SubstitutedFileType ? ((SubstitutedFileType)fileType).getOriginalFileType() : fileType;
        if (fileType2 == null) {
            FileContentImpl.$$$reportNull$$$0(34);
        }
        return fileType2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComputable";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/indexing/FileContentImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentAsText";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentHash";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/indexing/FileContentImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLighterAST";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createByContent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createByFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createByText";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentAsText";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeWithoutSubstitution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createByContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createByFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createByText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedFileHash";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeWithoutSubstitution";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

