/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.lang;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import sqldelight.com.intellij.util.UrlUtilRt;
import sqldelight.com.intellij.util.lang.CachePoolImpl;
import sqldelight.com.intellij.util.lang.ClassLoadingLocks;
import sqldelight.com.intellij.util.lang.ClassPath;
import sqldelight.com.intellij.util.lang.ClasspathCache;
import sqldelight.com.intellij.util.lang.Loader;
import sqldelight.com.intellij.util.lang.Resource;
import sqldelight.com.intellij.util.lang.ResourceFile;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader
implements ClassPath.ClassDataConsumer {
    private static final boolean mimicJarUrlConnection = Boolean.parseBoolean(System.getProperty("idea.mimic.jar.url.connection", "false"));
    private static final boolean isParallelCapable = UrlClassLoader.registerAsParallelCapable();
    private static final ClassLoader appClassLoader = UrlClassLoader.class.getClassLoader();
    private static final ThreadLocal<Boolean> skipFindingResource = new ThreadLocal();
    private final List<Path> files;
    protected final ClassPath classPath;
    private final ClassLoadingLocks<String> classLoadingLocks;
    private final boolean isBootstrapResourcesAllowed;
    private final boolean isSystemClassLoader;
    @NotNull
    protected final ClassPath.ClassDataConsumer classDataConsumer;
    @ApiStatus.Internal
    @Nullable
    public BiFunction<String, Boolean, String> resolveScopeManager;

    final void appendToClassPathForInstrumentation(@NotNull String jar) {
        if (jar == null) {
            UrlClassLoader.$$$reportNull$$$0(0);
        }
        this.addFiles(Collections.singletonList(Paths.get(jar, new String[0])));
    }

    @ApiStatus.Internal
    @NotNull
    public final ClassPath getClassPath() {
        ClassPath classPath = this.classPath;
        if (classPath == null) {
            UrlClassLoader.$$$reportNull$$$0(1);
        }
        return classPath;
    }

    @ApiStatus.Internal
    @NotNull
    public static Collection<Map.Entry<String, Path>> getLoadedClasses() {
        Collection<Map.Entry<String, Path>> collection = ClassPath.getLoadedClasses();
        if (collection == null) {
            UrlClassLoader.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public final List<Path> getBaseUrls() {
        List<Path> list = this.classPath.getBaseUrls();
        if (list == null) {
            UrlClassLoader.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public final Map<String, Long> getLoadingStats() {
        Map<String, Long> map = ClassPath.getLoadingStats();
        if (map == null) {
            UrlClassLoader.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public static Builder build() {
        return new Builder();
    }

    @Deprecated
    public UrlClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            UrlClassLoader.$$$reportNull$$$0(5);
        }
        this(UrlClassLoader.createDefaultBuilderForJdk(parent), null, isParallelCapable);
        UrlClassLoader.registerInClassLoaderValueMap(parent, this);
    }

    protected static void registerInClassLoaderValueMap(@NotNull ClassLoader parent, @NotNull ClassLoader classLoader) {
        if (parent == null) {
            UrlClassLoader.$$$reportNull$$$0(6);
        }
        if (classLoader == null) {
            UrlClassLoader.$$$reportNull$$$0(7);
        }
        try {
            Field f = ClassLoader.class.getDeclaredField("classLoaderValueMap");
            f.setAccessible(true);
            f.set(classLoader, f.get(parent));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    protected static Builder createDefaultBuilderForJdk(@NotNull ClassLoader parent) {
        if (parent == null) {
            UrlClassLoader.$$$reportNull$$$0(8);
        }
        Builder configuration = new Builder();
        if (parent instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)parent).getURLs();
            configuration.files = new ArrayList<Path>(urls.length);
            for (URL url : urls) {
                configuration.files.add(Paths.get(url.getPath(), new String[0]));
            }
        } else {
            String[] parts = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
            configuration.files = new ArrayList<Path>(parts.length);
            for (String s : parts) {
                configuration.files.add(Paths.get(s, new String[0]));
            }
        }
        configuration.isSystemClassLoader = true;
        configuration.parent = parent.getParent();
        configuration.useCache = true;
        configuration.isClassPathIndexEnabled = true;
        configuration.isBootstrapResourcesAllowed = Boolean.parseBoolean(System.getProperty("idea.allow.bootstrap.resources", "true"));
        Builder builder = configuration;
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(9);
        }
        return builder;
    }

    protected UrlClassLoader(@NotNull Builder builder, boolean isParallelCapable) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(10);
        }
        this(builder, null, isParallelCapable);
    }

    protected UrlClassLoader(@NotNull Builder builder, @Nullable Function<Path, ResourceFile> resourceFileFactory, boolean isParallelCapable) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(11);
        }
        super(builder.parent);
        this.classDataConsumer = ClassPath.recordLoadingTime ? new ClassPath.MeasuringClassDataConsumer(this) : this;
        this.isSystemClassLoader = builder.isSystemClassLoader;
        this.files = builder.files;
        this.classPath = new ClassPath(this.files, builder, resourceFileFactory, mimicJarUrlConnection);
        this.isBootstrapResourcesAllowed = builder.isBootstrapResourcesAllowed;
        this.classLoadingLocks = isParallelCapable ? new ClassLoadingLocks() : null;
    }

    protected UrlClassLoader(@NotNull List<Path> files, @NotNull ClassPath classPath) {
        if (files == null) {
            UrlClassLoader.$$$reportNull$$$0(12);
        }
        if (classPath == null) {
            UrlClassLoader.$$$reportNull$$$0(13);
        }
        super(null);
        this.classDataConsumer = ClassPath.recordLoadingTime ? new ClassPath.MeasuringClassDataConsumer(this) : this;
        this.files = files;
        this.classPath = classPath;
        this.isBootstrapResourcesAllowed = false;
        this.isSystemClassLoader = false;
        this.classLoadingLocks = new ClassLoadingLocks();
    }

    @Deprecated
    public final void addURL(@NotNull URL url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(14);
        }
        this.addFiles(Collections.singletonList(Paths.get(url.getPath(), new String[0])));
    }

    @ApiStatus.Internal
    public final void addFiles(@NotNull List<Path> files) {
        if (files == null) {
            UrlClassLoader.$$$reportNull$$$0(15);
        }
        this.classPath.addFiles(files);
        this.files.addAll(files);
    }

    @NotNull
    public final List<URL> getUrls() {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Path file : this.files) {
            try {
                result.add(file.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        ArrayList<URL> arrayList = result;
        if (arrayList == null) {
            UrlClassLoader.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public final List<Path> getFiles() {
        List<Path> list = Collections.unmodifiableList(this.files);
        if (list == null) {
            UrlClassLoader.$$$reportNull$$$0(17);
        }
        return list;
    }

    public boolean hasLoadedClass(String name) {
        Class<?> aClass = this.findLoadedClass(name);
        return aClass != null && aClass.getClassLoader() == this;
    }

    @Override
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(18);
        }
        String fileNameWithoutExtension = name.replace('.', '/');
        String fileName = fileNameWithoutExtension + ".class";
        long packageNameHash = ClasspathCache.getPackageNameHash(fileNameWithoutExtension, fileNameWithoutExtension.lastIndexOf(47));
        if (this.isSystemClassLoader && (packageNameHash == -9217824570049207139L || packageNameHash == -1976620678582843062L || packageNameHash == 4571982292824530778L)) {
            return appClassLoader.loadClass(name);
        }
        try {
            clazz = this.classPath.findClass(name, fileName, packageNameHash, this.classDataConsumer);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    private void definePackageIfNeeded(String name) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return;
        }
        String packageName2 = name.substring(0, lastDotIndex);
        if (this.isPackageDefined(packageName2)) {
            return;
        }
        try {
            this.definePackage(packageName2, null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean isPackageDefined(String packageName2) {
        return this.getPackage(packageName2) != null;
    }

    protected ProtectionDomain getProtectionDomain() {
        return null;
    }

    @Override
    public boolean isByteBufferSupported(@NotNull String name) {
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(19);
        }
        return true;
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name, byte[] data, Loader loader) throws IOException {
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(20);
        }
        this.definePackageIfNeeded(name);
        return super.defineClass(name, data, 0, data.length, null);
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name, ByteBuffer data, Loader loader) throws IOException {
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(21);
        }
        this.definePackageIfNeeded(name);
        return super.defineClass(name, data, null);
    }

    @Override
    @Nullable
    public URL findResource(@NotNull String name) {
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(22);
        }
        if (skipFindingResource.get() != null) {
            return null;
        }
        Resource resource = this.doFindResource(name);
        return resource != null ? resource.getURL() : null;
    }

    public byte @Nullable [] getResourceAsBytes(@NotNull String name, boolean checkParents) throws IOException {
        Resource resource;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(23);
        }
        return (resource = this.classPath.findResource(name)) == null ? null : resource.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name) {
        Resource resource;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(24);
        }
        if ((resource = this.doFindResource(name)) != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                this.logError("Cannot load resource " + name, e);
                return null;
            }
        }
        if (this.isBootstrapResourcesAllowed) {
            skipFindingResource.set(Boolean.TRUE);
            try {
                URL url = super.getResource(name);
                if (url != null) {
                    try {
                        InputStream inputStream = url.openStream();
                        return inputStream;
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                skipFindingResource.set(null);
            }
        }
        return null;
    }

    @Nullable
    private Resource doFindResource(String name) {
        String canonicalPath = UrlClassLoader.toCanonicalPath(name);
        Resource resource = this.classPath.findResource(canonicalPath);
        if (resource == null && canonicalPath.startsWith("/") && this.classPath.findResource(canonicalPath.substring(1)) != null) {
            this.logError("Calling `ClassLoader#getResource` with leading slash doesn't work; strip", new IllegalArgumentException(name));
        }
        return resource;
    }

    public final void processResources(@NotNull String dir, @NotNull Predicate<String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        if (dir == null) {
            UrlClassLoader.$$$reportNull$$$0(25);
        }
        if (fileNameFilter == null) {
            UrlClassLoader.$$$reportNull$$$0(26);
        }
        if (consumer == null) {
            UrlClassLoader.$$$reportNull$$$0(27);
        }
        this.classPath.processResources(dir, fileNameFilter, consumer);
    }

    @Override
    @NotNull
    protected Enumeration<URL> findResources(@NotNull String name) throws IOException {
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(28);
        }
        Enumeration<URL> enumeration = this.classPath.getResources(name);
        if (enumeration == null) {
            UrlClassLoader.$$$reportNull$$$0(29);
        }
        return enumeration;
    }

    @Override
    @NotNull
    protected final Object getClassLoadingLock(String className) {
        Object object = this.classLoadingLocks == null ? this : this.classLoadingLocks.getOrCreateLock(className);
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(30);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> loadClassInsideSelf(String name, String fileName, long packageNameHash, boolean forceLoadFromSubPluginClassloader) throws IOException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            if (!forceLoadFromSubPluginClassloader) {
                ClassLoader parent = this.getParent();
                if (parent != null) {
                    try {
                        c = parent.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (c != null) {
                    return c;
                }
            }
            return this.classPath.findClass(name, fileName, packageNameHash, this.classDataConsumer);
        }
    }

    @NotNull
    public static CachePool createCachePool() {
        return new CachePoolImpl();
    }

    protected static String toCanonicalPath(@NotNull String path) {
        char next;
        if (path == null) {
            UrlClassLoader.$$$reportNull$$$0(31);
        }
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == '.') {
            if (path.length() == 1) {
                return "";
            }
            char c = path.charAt(1);
            if (c == '/') {
                path = path.substring(2);
            }
        }
        int index = -1;
        do {
            char c = next = (index = path.indexOf(47, index + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index + 1);
        } while (next != '.' && next != '/' && index != -1);
        if (index == -1) {
            return path;
        }
        StringBuilder result = new StringBuilder(path.length());
        int start = UrlClassLoader.processRoot(path, result);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    UrlClassLoader.processDots(result, dots, start);
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result.append('.');
                --dots;
            }
            result.append(c);
            separator = false;
        }
        if (dots > 0) {
            UrlClassLoader.processDots(result, dots, start);
        }
        return result.toString();
    }

    private static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text == null) {
            UrlClassLoader.$$$reportNull$$$0(32);
        }
        if (suffix == null) {
            UrlClassLoader.$$$reportNull$$$0(33);
        }
        if ((l1 = text.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    private static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            UrlClassLoader.$$$reportNull$$$0(34);
        }
        start = Math.max(start, 0);
        for (int i = Math.min(end, s.length()) - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private static void processDots(StringBuilder result, int dots, int start) {
        if (dots == 2) {
            int pos = -1;
            if (!UrlClassLoader.endsWith(result, "/../") && !"../".contentEquals(result)) {
                pos = UrlClassLoader.lastIndexOf(result, '/', start, result.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                result.delete(pos, result.length());
            } else {
                result.append("../");
            }
        } else if (dots != 1) {
            for (int i = 0; i < dots; ++i) {
                result.append('.');
            }
            result.append('/');
        }
    }

    private static int processRoot(String path, StringBuilder result) {
        if (!path.isEmpty() && path.charAt(0) == '/') {
            result.append('/');
            return 1;
        }
        if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
            result.append(path, 0, 3);
            return 3;
        }
        return 0;
    }

    private void logError(String message2, Throwable t) {
        try {
            Class<?> logger2 = this.loadClass("sqldelight.com.intellij.openapi.diagnostic.Logger");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Object instance = lookup.findStatic(logger2, "getInstance", MethodType.methodType(logger2, Class.class)).invoke(this.getClass());
            lookup.findVirtual(logger2, "error", MethodType.methodType(Void.TYPE, String.class, Throwable.class)).bindTo(instance).invokeExact(message2, t);
        }
        catch (Throwable tt) {
            t.addSuppressed(tt);
            System.err.println(this.getClass().getName() + ": " + message2);
            t.printStackTrace(System.err);
        }
    }

    @NotNull
    public static String urlToFilePath(@NotNull String url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(35);
        }
        int start = url.startsWith("file:") ? "file:".length() : 0;
        int end = url.indexOf("!/");
        if (url.charAt(start) == '/' && url.length() > start + 2 && url.charAt(start + 2) == ':') {
            ++start;
        }
        String string = UrlUtilRt.unescapePercentSequences(url, start, end < 0 ? url.length() : end).toString();
        if (string == null) {
            UrlClassLoader.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 16: 
            case 17: 
            case 29: 
            case 30: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 16: 
            case 17: 
            case 29: 
            case 30: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 16: 
            case 17: 
            case 29: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 14: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingStats";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultBuilderForJdk";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findResources";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendToClassPathForInstrumentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 16: 
            case 17: 
            case 29: 
            case 30: 
            case 36: {
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerInClassLoaderValueMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBuilderForJdk";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isByteBufferSupported";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "consumeClassData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsBytes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findResources";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "urlToFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 16: 
            case 17: 
            case 29: 
            case 30: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        private static final boolean isClassPathIndexEnabledGlobalValue = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
        List<Path> files = Collections.emptyList();
        ClassLoader parent;
        boolean lockJars = true;
        boolean useCache;
        boolean isSystemClassLoader;
        boolean isClassPathIndexEnabled;
        boolean isBootstrapResourcesAllowed;
        @Nullable
        CachePoolImpl cachePool;
        Predicate<? super Path> cachingCondition;

        Builder() {
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public Builder urls(@NotNull List<URL> urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(0);
            }
            ArrayList<Path> files = new ArrayList<Path>(urls.size());
            for (URL url : urls) {
                files.add(Paths.get(UrlClassLoader.urlToFilePath(url.getPath()), new String[0]));
            }
            this.files = files;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder files(@NotNull List<Path> paths) {
            if (paths == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.files = paths;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder parent(ClassLoader parent) {
            this.parent = parent;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder allowLock(boolean lockJars) {
            this.lockJars = lockJars;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder useCache() {
            this.useCache = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder useCache(boolean useCache) {
            this.useCache = useCache;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.isClassPathIndexEnabled = isClassPathIndexEnabledGlobalValue;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder useCache(@NotNull CachePool pool, @NotNull Predicate<? super Path> condition) {
            if (pool == null) {
                Builder.$$$reportNull$$$0(9);
            }
            if (condition == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.useCache = true;
            this.cachePool = (CachePoolImpl)pool;
            this.cachingCondition = condition;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder noPreload() {
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder allowBootstrapResources() {
            Builder builder = this.allowBootstrapResources(true);
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder allowBootstrapResources(boolean allowBootstrapResources) {
            this.isBootstrapResourcesAllowed = allowBootstrapResources;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @NotNull
        public UrlClassLoader get() {
            return new UrlClassLoader(this, null, isParallelCapable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pool";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "urls";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "files";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowLock";
                    break;
                }
                case 6: 
                case 7: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useCache";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "usePersistentClasspathIndexForLocalClassDirectories";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "noPreload";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowBootstrapResources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "files";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "useCache";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface CachePool {
    }
}

