/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.ui;

import java.awt.Dimension;
import javax.swing.plaf.UIResource;
import sqldelight.com.intellij.ui.scale.JBUIScale;
import sqldelight.com.intellij.util.ui.MyScaler;
import sqldelight.org.jetbrains.annotations.NotNull;

public class JBDimension
extends Dimension {
    Size2D size2D;
    private final MyScaler scaler = new MyScaler();

    public JBDimension(int width, int height) {
        this(width, height, false);
    }

    @NotNull
    public static JBDimension size(Dimension size) {
        if (size instanceof JBDimension) {
            JBDimension newSize = ((JBDimension)size).newSize();
            JBDimension jBDimension = size instanceof UIResource ? newSize.asUIResource() : newSize;
            if (jBDimension == null) {
                JBDimension.$$$reportNull$$$0(0);
            }
            return jBDimension;
        }
        return new JBDimension(size.width, size.height);
    }

    public JBDimension(int width, int height, boolean preScaled) {
        this((double)width, (double)height, preScaled);
    }

    private JBDimension(double width, double height, boolean preScaled) {
        this.size2D = new Size2D(preScaled ? width : JBDimension.scale(width), preScaled ? height : JBDimension.scale(height));
        this.set(this.size2D);
    }

    private static double scale(double size) {
        return Math.max(-1.0f, JBUIScale.scale((float)size));
    }

    @NotNull
    public static JBDimension create(Dimension from, boolean preScaled) {
        if (from instanceof JBDimension) {
            JBDimension jBDimension = (JBDimension)from;
            if (jBDimension == null) {
                JBDimension.$$$reportNull$$$0(1);
            }
            return jBDimension;
        }
        return new JBDimension(from.width, from.height, preScaled);
    }

    @NotNull
    public static JBDimension create(Dimension from) {
        return JBDimension.create(from, false);
    }

    @NotNull
    public JBDimensionUIResource asUIResource() {
        return new JBDimensionUIResource(this);
    }

    @NotNull
    public JBDimension withWidth(int width) {
        JBDimension size = new JBDimension(0, 0);
        size.size2D.set(JBDimension.scale(width), this.size2D.height);
        size.set(size.size2D.intWidth(), this.height);
        JBDimension jBDimension = size;
        if (jBDimension == null) {
            JBDimension.$$$reportNull$$$0(2);
        }
        return jBDimension;
    }

    @NotNull
    public JBDimension withHeight(int height) {
        JBDimension size = new JBDimension(0, 0);
        size.size2D.set(this.size2D.width, JBDimension.scale(height));
        size.set(this.width, size.size2D.intHeight());
        JBDimension jBDimension = size;
        if (jBDimension == null) {
            JBDimension.$$$reportNull$$$0(3);
        }
        return jBDimension;
    }

    protected void set(int width, int height) {
        this.width = width;
        this.height = height;
    }

    protected void set(Size2D size2d) {
        this.set(size2d.intWidth(), size2d.intHeight());
    }

    public boolean update() {
        if (!this.scaler.needUpdate()) {
            return false;
        }
        this.size2D.set(this.scaler.scaleVal(this.size2D.width), this.scaler.scaleVal(this.size2D.height));
        this.set(this.size2D);
        this.scaler.update();
        return true;
    }

    @NotNull
    public JBDimension size() {
        this.update();
        JBDimension jBDimension = this;
        if (jBDimension == null) {
            JBDimension.$$$reportNull$$$0(4);
        }
        return jBDimension;
    }

    @NotNull
    public JBDimension newSize() {
        this.update();
        return new JBDimension(this.size2D.width, this.size2D.height, true);
    }

    public int width() {
        this.update();
        return this.width;
    }

    public int height() {
        this.update();
        return this.height;
    }

    public double width2d() {
        this.update();
        return this.size2D.width;
    }

    public double height2d() {
        this.update();
        return this.size2D.height;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JBDimension)) {
            return false;
        }
        JBDimension that = (JBDimension)obj;
        return this.size2D.equals(that.size2D);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "sqldelight/com/intellij/util/ui/JBDimension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "size";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withWidth";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withHeight";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class JBDimensionUIResource
    extends JBDimension
    implements UIResource {
        public JBDimensionUIResource(JBDimension size) {
            super(0, 0);
            this.set(size.width, size.height);
            this.size2D = size.size2D.copy();
        }
    }

    private static final class Size2D {
        double width;
        double height;

        Size2D(double width, double height) {
            this.width = width;
            this.height = height;
        }

        int intWidth() {
            return (int)Math.ceil(this.width);
        }

        int intHeight() {
            return (int)Math.ceil(this.height);
        }

        Size2D copy() {
            return new Size2D(this.width, this.height);
        }

        void set(double width, double height) {
            this.width = width;
            this.height = height;
        }
    }
}

