/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import sqldelight.com.intellij.diagnostic.LoadingState;
import sqldelight.com.intellij.icons.AllIcons;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.ui.ColorUtil;
import sqldelight.com.intellij.ui.Gray;
import sqldelight.com.intellij.ui.JBColor;
import sqldelight.com.intellij.ui.JreHiDpiUtil;
import sqldelight.com.intellij.ui.border.CustomLineBorder;
import sqldelight.com.intellij.ui.scale.JBUIScale;
import sqldelight.com.intellij.util.ui.JBDimension;
import sqldelight.com.intellij.util.ui.JBEmptyBorder;
import sqldelight.com.intellij.util.ui.JBFont;
import sqldelight.com.intellij.util.ui.JBInsets;
import sqldelight.com.intellij.util.ui.JBScalableIcon;
import sqldelight.com.intellij.util.ui.JBValue;
import sqldelight.com.intellij.util.ui.StartupUiUtil;
import sqldelight.com.intellij.util.ui.UIUtil;
import sqldelight.com.intellij.util.ui.components.BorderLayoutPanel;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class JBUI {
    public static float pixScale() {
        return JreHiDpiUtil.isJreHiDPIEnabled() ? JBUIScale.sysScale() * JBUIScale.scale(1.0f) : JBUIScale.scale(1.0f);
    }

    public static float pixScale(float f) {
        return JBUI.pixScale() * f;
    }

    public static float pixScale(@Nullable GraphicsConfiguration gc) {
        return JreHiDpiUtil.isJreHiDPIEnabled() ? JBUIScale.sysScale(gc) * JBUIScale.scale(1.0f) : JBUIScale.scale(1.0f);
    }

    public static float pixScale(@Nullable Component comp) {
        return JBUI.pixScale(comp != null ? comp.getGraphicsConfiguration() : null);
    }

    @Deprecated
    public static float scale(float f) {
        return JBUIScale.scale(f);
    }

    public static int scale(int i) {
        return JBUIScale.scale(i);
    }

    public static int scaleFontSize(float fontSize) {
        return JBUIScale.scaleFontSize(fontSize);
    }

    @NotNull
    public static JBValue value(float value) {
        return new JBValue.Float(value);
    }

    @NotNull
    public static JBValue uiIntValue(@NotNull String key, int defValue) {
        if (key == null) {
            JBUI.$$$reportNull$$$0(0);
        }
        return new JBValue.UIInteger(key, defValue);
    }

    @NotNull
    public static JBDimension size(int width, int height) {
        return new JBDimension(width, height);
    }

    @NotNull
    public static JBDimension size(int widthAndHeight) {
        return new JBDimension(widthAndHeight, widthAndHeight);
    }

    @NotNull
    public static JBDimension size(Dimension size) {
        JBDimension jBDimension = JBDimension.size(size);
        if (jBDimension == null) {
            JBUI.$$$reportNull$$$0(1);
        }
        return jBDimension;
    }

    @NotNull
    public static JBInsets insets(int top, int left, int bottom, int right) {
        return new JBInsets(top, left, bottom, right);
    }

    @NotNull
    public static JBInsets insets(int all) {
        return new JBInsets(all);
    }

    @NotNull
    public static JBInsets insets(@NonNls @NotNull String propName, @NotNull JBInsets defaultValue) {
        Insets i;
        if (propName == null) {
            JBUI.$$$reportNull$$$0(2);
        }
        if (defaultValue == null) {
            JBUI.$$$reportNull$$$0(3);
        }
        JBInsets jBInsets = (i = UIManager.getInsets(propName)) != null ? JBInsets.create(i) : defaultValue;
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(4);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insets(int topBottom, int leftRight) {
        JBInsets jBInsets = JBInsets.create(topBottom, leftRight);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(5);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets emptyInsets() {
        JBInsets jBInsets = JBInsets.emptyInsets();
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(6);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insetsTop(int t) {
        return new JBInsets(t, 0, 0, 0);
    }

    @NotNull
    public static JBInsets insetsLeft(int l) {
        return new JBInsets(0, l, 0, 0);
    }

    @NotNull
    public static JBInsets insetsBottom(int b) {
        return new JBInsets(0, 0, b, 0);
    }

    @NotNull
    public static JBInsets insetsRight(int r) {
        return new JBInsets(0, 0, 0, r);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static <T extends JBScalableIcon> T scale(@NotNull T icon2) {
        if (icon2 == null) {
            JBUI.$$$reportNull$$$0(7);
        }
        T t = JBUIScale.scaleIcon(icon2);
        if (t == null) {
            JBUI.$$$reportNull$$$0(8);
        }
        return t;
    }

    @NotNull
    public static JBDimension emptySize() {
        return new JBDimension(0, 0);
    }

    @NotNull
    public static JBInsets insets(@NotNull Insets insets) {
        if (insets == null) {
            JBUI.$$$reportNull$$$0(9);
        }
        JBInsets jBInsets = JBInsets.create(insets);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(10);
        }
        return jBInsets;
    }

    @Deprecated(forRemoval=true)
    public static boolean isUsrHiDPI() {
        return JBUIScale.isUsrHiDPI();
    }

    public static boolean isPixHiDPI(@Nullable GraphicsConfiguration gc) {
        return JBUIScale.isHiDPI(JBUI.pixScale(gc));
    }

    public static boolean isPixHiDPI(@Nullable Component comp) {
        return JBUIScale.isHiDPI(JBUI.pixScale(comp));
    }

    public static Border asUIResource(@NotNull Border border) {
        if (border == null) {
            JBUI.$$$reportNull$$$0(11);
        }
        if (border instanceof UIResource) {
            return border;
        }
        return new BorderUIResource(border);
    }

    public static int getInt(@NonNls @NotNull String propertyName, int defaultValue) {
        Object value;
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(12);
        }
        return (value = UIManager.get(propertyName)) instanceof Integer ? (Integer)value : defaultValue;
    }

    public static float getFloat(@NonNls @NotNull String propertyName, float defaultValue) {
        Object value;
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(13);
        }
        if ((value = UIManager.get(propertyName)) instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        if (value instanceof String) {
            try {
                return Float.parseFloat((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @NotNull
    private static Icon getIcon(@NonNls @NotNull String propertyName, @NotNull Icon defaultIcon) {
        Icon icon2;
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(14);
        }
        if (defaultIcon == null) {
            JBUI.$$$reportNull$$$0(15);
        }
        Icon icon3 = (icon2 = UIManager.getIcon(propertyName)) == null ? defaultIcon : icon2;
        if (icon3 == null) {
            JBUI.$$$reportNull$$$0(16);
        }
        return icon3;
    }

    static {
        LoadingState.BASE_LAF_INITIALIZED.checkOccurred();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/ui/JBUI";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/ui/JBUI";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "size";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "insets";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyInsets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uiIntValue";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "insets";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "asUIResource";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFloat";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CurrentTheme {
        private static final Color DEFAULT_RENDERER_BACKGROUND = new JBColor(0xFFFFFF, 3948353);
        private static final Color DEFAULT_RENDERER_SELECTION_BACKGROUND = new JBColor(3700182, 3106250);
        private static final Color DEFAULT_RENDERER_SELECTION_INACTIVE_BACKGROUND = new JBColor(0xD4D4D4, 862526);
        private static final Color DEFAULT_RENDERER_HOVER_BACKGROUND = new JBColor(15595004, 4606541);
        private static final Color DEFAULT_RENDERER_HOVER_INACTIVE_BACKGROUND = new JBColor(0xF5F5F5, 4606541);

        public static interface Tree {
            public static final Color BACKGROUND = JBColor.namedColor("Tree.background", DEFAULT_RENDERER_BACKGROUND);
            public static final Color FOREGROUND = JBColor.namedColor("Tree.foreground", Label.foreground(false));

            @NotNull
            public static Color background(boolean selected, boolean focused) {
                Color color = selected ? Selection.background(focused) : BACKGROUND;
                if (color == null) {
                    Tree.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color foreground(boolean selected, boolean focused) {
                Color color = selected ? Selection.foreground(focused) : FOREGROUND;
                if (color == null) {
                    Tree.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Tree";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static final class Hover {
                private static final Color BACKGROUND = JBColor.namedColor("Tree.hoverBackground", DEFAULT_RENDERER_HOVER_BACKGROUND);

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Hover.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Tree$Hover", "background"));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("Tree.hoverInactiveBackground", DEFAULT_RENDERER_HOVER_INACTIVE_BACKGROUND);
                }
            }

            public static final class Selection {
                private static final Color BACKGROUND = JBColor.namedColor("Tree.selectionBackground", DEFAULT_RENDERER_SELECTION_BACKGROUND);
                private static final Color FOREGROUND = JBColor.namedColor("Tree.selectionForeground", Label.foreground(true));

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                @NotNull
                public static Color foreground(boolean focused) {
                    Color color = focused ? FOREGROUND : Inactive.FOREGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(1);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Tree$Selection";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "background";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "foreground";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("Tree.selectionInactiveBackground", DEFAULT_RENDERER_SELECTION_INACTIVE_BACKGROUND);
                    public static final Color FOREGROUND = JBColor.namedColor("Tree.selectionInactiveForeground", Tree.FOREGROUND);
                }
            }
        }

        public static interface Table {
            public static final Color BACKGROUND = JBColor.namedColor("Table.background", DEFAULT_RENDERER_BACKGROUND);
            public static final Color FOREGROUND = JBColor.namedColor("Table.foreground", Label.foreground(false));

            @NotNull
            public static Color background(boolean selected, boolean focused) {
                Color color = selected ? Selection.background(focused) : BACKGROUND;
                if (color == null) {
                    Table.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color foreground(boolean selected, boolean focused) {
                Color color = selected ? Selection.foreground(focused) : FOREGROUND;
                if (color == null) {
                    Table.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Table";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static final class Hover {
                private static final Color BACKGROUND = JBColor.namedColor("Table.hoverBackground", DEFAULT_RENDERER_HOVER_BACKGROUND);

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Hover.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Table$Hover", "background"));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("Table.hoverInactiveBackground", DEFAULT_RENDERER_HOVER_INACTIVE_BACKGROUND);
                }
            }

            public static final class Selection {
                private static final Color BACKGROUND = JBColor.namedColor("Table.selectionBackground", DEFAULT_RENDERER_SELECTION_BACKGROUND);
                private static final Color FOREGROUND = JBColor.namedColor("Table.selectionForeground", Label.foreground(true));

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                @NotNull
                public static Color foreground(boolean focused) {
                    Color color = focused ? FOREGROUND : Inactive.FOREGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(1);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Table$Selection";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "background";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "foreground";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("Table.selectionInactiveBackground", DEFAULT_RENDERER_SELECTION_INACTIVE_BACKGROUND);
                    public static final Color FOREGROUND = JBColor.namedColor("Table.selectionInactiveForeground", Table.FOREGROUND);
                }
            }
        }

        public static interface List {
            public static final Color BACKGROUND = JBColor.namedColor("List.background", DEFAULT_RENDERER_BACKGROUND);
            public static final Color FOREGROUND = JBColor.namedColor("List.foreground", Label.foreground(false));

            @NotNull
            public static Color background(boolean selected, boolean focused) {
                Color color = selected ? Selection.background(focused) : BACKGROUND;
                if (color == null) {
                    List.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color foreground(boolean selected, boolean focused) {
                Color color = selected ? Selection.foreground(focused) : FOREGROUND;
                if (color == null) {
                    List.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$List";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static final class Hover {
                private static final Color BACKGROUND = JBColor.namedColor("List.hoverBackground", DEFAULT_RENDERER_HOVER_BACKGROUND);

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Hover.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$List$Hover", "background"));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("List.hoverInactiveBackground", DEFAULT_RENDERER_HOVER_INACTIVE_BACKGROUND);
                }
            }

            public static final class Selection {
                private static final Color BACKGROUND = JBColor.namedColor("List.selectionBackground", DEFAULT_RENDERER_SELECTION_BACKGROUND);
                private static final Color FOREGROUND = JBColor.namedColor("List.selectionForeground", Label.foreground(true));

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                @NotNull
                public static Color foreground(boolean focused) {
                    Color color = focused ? FOREGROUND : Inactive.FOREGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(1);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$List$Selection";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "background";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "foreground";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("List.selectionInactiveBackground", DEFAULT_RENDERER_SELECTION_INACTIVE_BACKGROUND);
                    public static final Color FOREGROUND = JBColor.namedColor("List.selectionInactiveForeground", List.FOREGROUND);
                }
            }
        }

        public static final class NotificationWarning {
            @NotNull
            public static Color backgroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.warningBackground", new JBColor(16381838, 5919265));
                if (jBColor == null) {
                    NotificationWarning.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color foregroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.warningForeground", UIUtil.getToolTipForeground());
                if (jBColor == null) {
                    NotificationWarning.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.warningBorderColor", new JBColor(12236836, 10919779));
                if (jBColor == null) {
                    NotificationWarning.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$NotificationWarning";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "backgroundColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foregroundColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class NotificationInfo {
            @NotNull
            public static Color backgroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.informativeBackground", new JBColor(0xBAEEBA, 3359022));
                if (jBColor == null) {
                    NotificationInfo.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color foregroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.informativeForeground", UIUtil.getToolTipForeground());
                if (jBColor == null) {
                    NotificationInfo.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.informativeBorderColor", new JBColor(10534813, 8755578));
                if (jBColor == null) {
                    NotificationInfo.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$NotificationInfo";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "backgroundColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foregroundColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class NotificationError {
            @NotNull
            public static Color backgroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.errorBackground", new JBColor(0xFFCCCC, 7358277));
                if (jBColor == null) {
                    NotificationError.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color foregroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.errorForeground", UIUtil.getToolTipForeground());
                if (jBColor == null) {
                    NotificationError.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.errorBorderColor", new JBColor(0xD69696, 0x998A8A));
                if (jBColor == null) {
                    NotificationError.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$NotificationError";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "backgroundColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foregroundColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class NewClassDialog {
            @NotNull
            public static Color searchFieldBackground() {
                JBColor jBColor = JBColor.namedColor("NewClass.SearchField.background", 0xFFFFFF);
                if (jBColor == null) {
                    NewClassDialog.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color panelBackground() {
                JBColor jBColor = JBColor.namedColor("NewClass.Panel.background", 0xF2F2F2);
                if (jBColor == null) {
                    NewClassDialog.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color bordersColor() {
                JBColor jBColor = JBColor.namedColor("TextField.borderColor", JBColor.namedColor("Component.borderColor", new JBColor(0xBDBDBD, 0x646464)));
                if (jBColor == null) {
                    NewClassDialog.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            public static int fieldsSeparatorWidth() {
                return JBUI.getInt("NewClass.separatorWidth", JBUIScale.scale(10));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$NewClassDialog";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "panelBackground";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "bordersColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Arrow {
            @NotNull
            public static Color foregroundColor(boolean enabled) {
                JBColor jBColor = enabled ? JBColor.namedColor("ComboBox.ArrowButton.iconColor", JBColor.namedColor("ComboBox.darcula.arrowButtonForeground", Gray.x66)) : JBColor.namedColor("ComboBox.ArrowButton.disabledIconColor", JBColor.namedColor("ComboBox.darcula.arrowButtonDisabledForeground", Gray.xAB));
                if (jBColor == null) {
                    Arrow.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color backgroundColor(boolean enabled, boolean editable) {
                Color color = enabled ? (editable ? JBColor.namedColor("ComboBox.ArrowButton.background", JBColor.namedColor("ComboBox.darcula.editable.arrowButtonBackground", Gray.xFC)) : JBColor.namedColor("ComboBox.ArrowButton.nonEditableBackground", JBColor.namedColor("ComboBox.darcula.arrowButtonBackground", Gray.xFC))) : UIUtil.getPanelBackground();
                if (color == null) {
                    Arrow.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Arrow";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foregroundColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "backgroundColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static interface ContextHelp {
            @NotNull
            public static final Color FOREGROUND = JBColor.namedColor("Label.infoForeground", new JBColor(Gray.x78, (Color)Gray.x8C));
        }

        public static final class GotItTooltip {
            @NotNull
            public static Color foreground(boolean useContrastColors) {
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.foreground", 0xF5F5F5);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(0);
                    }
                    return jBColor;
                }
                JBColor jBColor = JBColor.namedColor("GotItTooltip.foreground", UIUtil.getToolTipForeground());
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color background(boolean useContrastColors) {
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.background");
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(2);
                    }
                    return jBColor;
                }
                JBColor jBColor = JBColor.namedColor("GotItTooltip.background", UIUtil.getToolTipBackground());
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color shortcutForeground(boolean useContrastColors) {
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.spanForeground", 0xF5F5F5);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(4);
                    }
                    return jBColor;
                }
                JBColor jBColor = JBColor.namedColor("GotItTooltip.shortcutForeground", Tooltip.shortcutForeground());
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color linkForeground() {
                JBColor jBColor = JBColor.namedColor("GotItTooltip.linkForeground", Link.Foreground.ENABLED);
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor(boolean useContrastColors) {
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.background", 1077736, 942799);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(7);
                    }
                    return jBColor;
                }
                JBColor jBColor = JBColor.namedColor("GotItTooltip.borderColor", Tooltip.borderColor());
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(8);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonBackgroundContrast() {
                JBColor jBColor = JBColor.namedColor("Tooltip.Learning.spanBackground", 875709, 151728);
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(9);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonForegroundContrast() {
                JBColor jBColor = JBColor.namedColor("Tooltip.Learning.spanForeground", 0xF5F5F5);
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(10);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$GotItTooltip";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "shortcutForeground";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkForeground";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonBackgroundContrast";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonForegroundContrast";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Tooltip {
            @NotNull
            public static Color shortcutForeground() {
                JBColor jBColor = JBColor.namedColor("ToolTip.shortcutForeground", new JBColor(0x787878, 0x999999));
                if (jBColor == null) {
                    Tooltip.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("ToolTip.borderColor", new JBColor(0xADADAD, 6514025));
                if (jBColor == null) {
                    Tooltip.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Tooltip";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "shortcutForeground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Link {
            @NotNull
            public static final Color FOCUSED_BORDER_COLOR = JBColor.namedColor("Link.focusedBorderColor", Component.FOCUSED_BORDER_COLOR);

            @Deprecated(forRemoval=true)
            @NotNull
            public static Color linkColor() {
                Color color = Foreground.ENABLED;
                if (color == null) {
                    Link.$$$reportNull$$$0(0);
                }
                return color;
            }

            @Deprecated(forRemoval=true)
            @NotNull
            public static Color linkHoverColor() {
                Color color = Foreground.HOVERED;
                if (color == null) {
                    Link.$$$reportNull$$$0(1);
                }
                return color;
            }

            @Deprecated(forRemoval=true)
            @NotNull
            public static Color linkPressedColor() {
                Color color = Foreground.PRESSED;
                if (color == null) {
                    Link.$$$reportNull$$$0(2);
                }
                return color;
            }

            @Deprecated(forRemoval=true)
            @NotNull
            public static Color linkVisitedColor() {
                Color color = Foreground.VISITED;
                if (color == null) {
                    Link.$$$reportNull$$$0(3);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Link";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkHoverColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkPressedColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkVisitedColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static interface Foreground {
                @NotNull
                public static final Color DISABLED = JBColor.namedColor("Link.disabledForeground", Label.disabledForeground());
                @NotNull
                public static final Color ENABLED = JBColor.namedColor("Link.activeForeground", JBColor.namedColor("link.foreground", 5807606));
                @NotNull
                public static final Color HOVERED = JBColor.namedColor("Link.hoverForeground", JBColor.namedColor("link.hover.foreground", ENABLED));
                @NotNull
                public static final Color PRESSED = JBColor.namedColor("Link.pressedForeground", JBColor.namedColor("link.pressed.foreground", 0xF00000, 12218149));
                @NotNull
                public static final Color VISITED = JBColor.namedColor("Link.visitedForeground", JBColor.namedColor("link.visited.foreground", 0x800080, 9926313));
                @NotNull
                public static final Color SECONDARY = JBColor.namedColor("Link.secondaryForeground", 7839165, 5666464);
            }
        }

        public static final class Validator {
            @NotNull
            public static Color errorBorderColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.errorBorderColor", 14723241);
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color errorBackgroundColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.errorBackground", JBColor.namedColor("ValidationTooltip.errorBackgroundColor", 16115431));
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color warningBorderColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.warningBorderColor", 14732968);
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color warningBackgroundColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.warningBackground", JBColor.namedColor("ValidationTooltip.warningBackgroundColor", 16117990));
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Validator";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorBorderColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorBackgroundColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningBorderColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningBackgroundColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Advertiser {
            @NotNull
            public static Color foreground() {
                Color foreground = BigPopup.advertiserForeground();
                JBColor jBColor = JBColor.namedColor("Popup.Advertiser.foreground", foreground);
                if (jBColor == null) {
                    Advertiser.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color background() {
                Color background = BigPopup.advertiserBackground();
                JBColor jBColor = JBColor.namedColor("Popup.Advertiser.background", background);
                if (jBColor == null) {
                    Advertiser.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Border border() {
                return new JBEmptyBorder(JBUI.insets("Popup.Advertiser.borderInsets", JBUI.insets(5, 10, 5, 15)));
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("Popup.Advertiser.borderColor", Gray._135);
                if (jBColor == null) {
                    Advertiser.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Advertiser";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class BigPopup {
            @NotNull
            public static Color headerBackground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Header.background", 0xF2F2F2);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Insets tabInsets() {
                JBInsets jBInsets = JBInsets.create(0, 12);
                if (jBInsets == null) {
                    BigPopup.$$$reportNull$$$0(1);
                }
                return jBInsets;
            }

            @NotNull
            public static Color selectedTabColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Tab.selectedBackground", 0xDEDEDE);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color selectedTabTextColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Tab.selectedForeground", 0);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color searchFieldBackground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.SearchField.background", 0xFFFFFF);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color searchFieldBorderColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.SearchField.borderColor", 0xBDBDBD);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Insets searchFieldInsets() {
                JBInsets jBInsets = JBUI.insets(0, 6, 0, 5);
                if (jBInsets == null) {
                    BigPopup.$$$reportNull$$$0(6);
                }
                return jBInsets;
            }

            public static int maxListHeight() {
                return JBUIScale.scale(600);
            }

            @NotNull
            public static Color listSeparatorColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.List.separatorColor", Gray.xDC);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            @NotNull
            public static Color listTitleLabelForeground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.List.separatorForeground", UIUtil.getLabelDisabledForeground());
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(8);
                }
                return jBColor;
            }

            @NotNull
            public static Color searchFieldGrayForeground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.SearchField.infoForeground", JBColor.GRAY);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(9);
                }
                return jBColor;
            }

            @NotNull
            public static Color advertiserForeground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Advertiser.foreground", JBColor.GRAY);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(10);
                }
                return jBColor;
            }

            @NotNull
            public static Border advertiserBorder() {
                return new JBEmptyBorder(JBUI.insets("SearchEverywhere.Advertiser.borderInsets", JBUI.insets(5, 10, 5, 15)));
            }

            @NotNull
            public static Color advertiserBackground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Advertiser.background", 0xF2F2F2);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(11);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$BigPopup";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tabInsets";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectedTabColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectedTabTextColor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldBackground";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldBorderColor";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldInsets";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listSeparatorColor";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listTitleLabelForeground";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldGrayForeground";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "advertiserForeground";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "advertiserBackground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class TabbedPane {
            public static final Color ENABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.underlineColor", JBColor.namedColor("TabbedPane.selectedColor", 4228041));
            public static final Color DISABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.disabledUnderlineColor", JBColor.namedColor("TabbedPane.selectedDisabledColor", Gray.xAB));
            public static final Color DISABLED_TEXT_COLOR = JBColor.namedColor("TabbedPane.disabledForeground", JBColor.namedColor("TabbedPane.disabledText", Gray.x99));
            public static final Color HOVER_COLOR = JBColor.namedColor("TabbedPane.hoverColor", Gray.xD9);
            public static final Color FOCUS_COLOR = JBColor.namedColor("TabbedPane.focusColor", 14345453);
            public static final JBValue TAB_HEIGHT = new JBValue.UIInteger("TabbedPane.tabHeight", 32);
            public static final JBValue SELECTION_HEIGHT = new JBValue.UIInteger("TabbedPane.tabSelectionHeight", 3);
            public static final JBValue SELECTION_ARC = new JBValue.UIInteger("TabbedPane.tabSelectionArc", 0);
        }

        public static final class Focus {
            private static final Color GRAPHITE_COLOR = new JBColor(new Color(-2137417827, true), new Color(6776937));

            @NotNull
            public static Color focusColor() {
                Color color = UIUtil.isGraphite() ? GRAPHITE_COLOR : JBColor.namedColor("Component.focusColor", JBColor.namedColor("Focus.borderColor", 9089771));
                if (color == null) {
                    Focus.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color defaultButtonColor() {
                return StartupUiUtil.isUnderDarcula() ? JBColor.namedColor("Button.default.focusColor", JBColor.namedColor("Focus.defaultButtonBorderColor", 9946099)) : Focus.focusColor();
            }

            @NotNull
            public static Color errorColor(boolean active) {
                JBColor jBColor = active ? JBColor.namedColor("Component.errorFocusColor", JBColor.namedColor("Focus.activeErrorBorderColor", 15023693)) : JBColor.namedColor("Component.inactiveErrorFocusColor", JBColor.namedColor("Focus.inactiveErrorBorderColor", 0xEBBCBC));
                if (jBColor == null) {
                    Focus.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color warningColor(boolean active) {
                JBColor jBColor = active ? JBColor.namedColor("Component.warningFocusColor", JBColor.namedColor("Focus.activeWarningBorderColor", 14853434)) : JBColor.namedColor("Component.inactiveWarningFocusColor", JBColor.namedColor("Focus.inactiveWarningBorderColor", 16765829));
                if (jBColor == null) {
                    Focus.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Focus";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "focusColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Popup {
            public static final Color BACKGROUND = JBColor.namedColor("Popup.background", List.BACKGROUND);

            public static int bodyBottomInsetNoAd() {
                return JBUI.getInt("Popup.Body.bottomInsetNoAd", 8);
            }

            public static int bodyBottomInsetBeforeAd() {
                return JBUI.getInt("Popup.Body.bottomInsetBeforeAd", 8);
            }

            public static int bodyTopInsetNoHeader() {
                return JBUI.getInt("Popup.Body.topInsetNoHeader", 8);
            }

            public static Color headerBackground(boolean active) {
                return active ? JBColor.namedColor("Popup.Header.activeBackground", 0xE6E6E6) : JBColor.namedColor("Popup.Header.inactiveBackground", 0xEDEDED);
            }

            public static Color headerForeground(boolean active) {
                return active ? JBColor.namedColor("Popup.Header.activeForeground", UIUtil.getLabelForeground()) : JBColor.namedColor("Popup.Header.inactiveForeground", UIUtil.getLabelDisabledForeground());
            }

            @NotNull
            public static JBInsets headerInsets() {
                JBInsets jBInsets = JBUI.insets("Popup.Header.insets", JBUI.insets(12, 10, 10, 10));
                if (jBInsets == null) {
                    Popup.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            public static int headerHeight(boolean hasControls) {
                return hasControls ? JBUIScale.scale(28) : JBUIScale.scale(24);
            }

            public static Color borderColor(boolean active) {
                return active ? JBColor.namedColor("Popup.borderColor", JBColor.namedColor("Popup.Border.color", 0x808080)) : JBColor.namedColor("Popup.inactiveBorderColor", JBColor.namedColor("Popup.inactiveBorderColor", 0xAAAAAA));
            }

            public static float borderWidth() {
                return JBUI.getFloat("Popup.borderWidth", 1.0f);
            }

            public static Insets searchFieldBorderInsets() {
                return JBUI.insets("Popup.SearchField.borderInsets", JBUI.insets(4, 12, 4, 12));
            }

            public static Insets searchFieldInputInsets() {
                return JBUI.insets("Popup.SearchField.inputInsets", JBUI.insets(4, 8, 8, 2));
            }

            public static Color toolbarPanelColor() {
                return JBColor.namedColor("Popup.Toolbar.background", 0xF7F7F7);
            }

            public static Color toolbarBorderColor() {
                return JBColor.namedColor("Popup.Toolbar.borderColor", JBColor.namedColor("Popup.Toolbar.Border.color", 0xF7F7F7));
            }

            public static int toolbarHeight() {
                return JBUIScale.scale(28);
            }

            public static Color separatorColor() {
                return JBColor.namedColor("Popup.separatorColor", new JBColor(Color.gray.brighter(), (Color)Gray.x51));
            }

            public static JBInsets separatorInsets() {
                return JBUI.insets("Popup.separatorInsets", JBUI.insets(4, 12, 4, 12));
            }

            public static Insets separatorLabelInsets() {
                return JBUI.insets("Popup.separatorLabelInsets", JBUI.insets(2, 20, 2, 20));
            }

            public static Color separatorTextColor() {
                return JBColor.namedColor("Popup.separatorForeground", Color.gray);
            }

            public static int minimumHintWidth() {
                return JBUIScale.scale(170);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Popup", "headerInsets"));
            }
        }

        public static final class ComplexPopup {
            public static final Color HEADER_BACKGROUND = JBColor.namedColor("ComplexPopup.Header.background", Popup.BACKGROUND);
            public static final int TEXT_FIELD_SEPARATOR_HEIGHT = 1;

            public static JBInsets headerInsets() {
                return JBUI.insets("ComplexPopup.Header.insets", JBUI.insets(12, 10, 10, 10));
            }

            public static JBInsets textFieldBorderInsets() {
                return JBUI.insets("ComplexPopup.TextField.borderInsets", JBUI.insets(0, 12));
            }

            public static JBInsets textFieldInputInsets() {
                return JBUI.insets("ComplexPopup.TextField.inputInsets", JBUI.insets(6, 2));
            }
        }

        public static final class Label {
            @NotNull
            public static Color foreground(boolean selected) {
                JBColor jBColor = selected ? JBColor.namedColor("Label.selectedForeground", 0xFFFFFF) : JBColor.namedColor("Label.foreground", 0);
                if (jBColor == null) {
                    Label.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color foreground() {
                return Label.foreground(false);
            }

            @NotNull
            public static Color disabledForeground(boolean selected) {
                JBColor jBColor = selected ? JBColor.namedColor("Label.selectedDisabledForeground", 0x999999) : JBColor.namedColor("Label.disabledForeground", JBColor.namedColor("Label.disabledText", 0x999999));
                if (jBColor == null) {
                    Label.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color disabledForeground() {
                return Label.disabledForeground(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Label";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "disabledForeground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class ToolWindow {
            @NotNull
            public static Color background() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.background");
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.borderColor", DefaultTabs.borderColor());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color underlinedTabForeground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.underlinedTabForeground", DefaultTabs.underlinedTabForeground());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.hoverBackground", DefaultTabs.hoverBackground());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color inactiveUnderlineColor() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.inactiveUnderlineColor", DefaultTabs.inactiveUnderlineColor());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color underlineColor() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.underlineColor", DefaultTabs.underlineColor());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("ToolWindow.HeaderTab.underlinedTabBackground");
            }

            public static Color hoverInactiveBackground() {
                return JBColor.namedColor("ToolWindow.HeaderTab.hoverInactiveBackground", ToolWindow.hoverBackground());
            }

            public static Color underlinedTabInactiveBackground() {
                return UIManager.getColor("ToolWindow.HeaderTab.underlinedTabInactiveBackground");
            }

            @NotNull
            public static Color underlinedTabInactiveForeground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.underlinedTabInactiveForeground", ToolWindow.underlinedTabForeground());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Insets headerTabInsets() {
                JBInsets jBInsets = JBUI.insets("ToolWindow.HeaderTab.insets", JBUI.insets(0, 12, 0, 12));
                if (jBInsets == null) {
                    ToolWindow.$$$reportNull$$$0(7);
                }
                return jBInsets;
            }

            public static int headerTabUnderlineArc() {
                return JBUI.getInt("ToolWindow.HeaderTab.underlineArc", 4);
            }

            public static JBInsets headerTabLeftRightInsets() {
                return JBUI.insets("ToolWindow.HeaderTab.leftRightInsets", JBUI.insets(0, 8, 0, 8));
            }

            @NotNull
            public static Color headerBackground(boolean active) {
                return active ? ToolWindow.headerActiveBackground() : ToolWindow.headerBackground();
            }

            @NotNull
            public static Color headerBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Header.inactiveBackground", JBColor.namedColor("ToolWindow.header.background", 0xECECEC));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(8);
                }
                return jBColor;
            }

            @NotNull
            public static Color headerBorderBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Header.borderColor", DefaultTabs.borderColor());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(9);
                }
                return jBColor;
            }

            @NotNull
            public static Color headerActiveBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Header.background", JBColor.namedColor("ToolWindow.header.active.background", 14870252));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(10);
                }
                return jBColor;
            }

            @NotNull
            public static Insets headerInsets() {
                JBInsets jBInsets = JBUI.insets("ToolWindow.Header.insets", JBUI.insets(4, 8, 4, 8));
                if (jBInsets == null) {
                    ToolWindow.$$$reportNull$$$0(11);
                }
                return jBInsets;
            }

            public static int headerHeight() {
                return JBUI.getInt("ToolWindow.Header.height", 42);
            }

            public static JBInsets headerLabelLeftRightInsets() {
                return JBUI.insets("ToolWindow.Header.labelLeftRightInsets", JBUI.insets(0, 12, 0, 16));
            }

            public static JBInsets headerToolbarLeftRightInsets() {
                return JBUI.insets("ToolWindow.Header.toolbarLeftRightInsets", JBUI.insets(0, 12, 0, 8));
            }

            @Deprecated(forRemoval=true)
            public static int tabVerticalPadding() {
                return JBUI.getInt("ToolWindow.HeaderTab.verticalPadding", JBUIScale.scale(6));
            }

            public static int underlineHeight() {
                return JBUI.getInt("ToolWindow.HeaderTab.underlineHeight", DefaultTabs.underlineHeight());
            }

            @NotNull
            public static Font headerFont() {
                JBFont jBFont = JBFont.label();
                if (jBFont == null) {
                    ToolWindow.$$$reportNull$$$0(12);
                }
                return jBFont;
            }

            public static float overrideHeaderFontSizeOffset() {
                Object offset = UIManager.get("ToolWindow.Header.font.size.offset");
                if (offset instanceof Integer) {
                    return ((Integer)offset).floatValue();
                }
                return 0.0f;
            }

            @NotNull
            public static Color hoveredIconBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderCloseButton.background", JBColor.namedColor("ToolWindow.header.closeButton.background", 0xB9B9B9));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(13);
                }
                return jBColor;
            }

            @NotNull
            public static Icon closeTabIcon(boolean hovered) {
                Icon icon2 = hovered ? JBUI.getIcon("ToolWindow.header.closeButton.hovered.icon", AllIcons.Actions.CloseHovered) : JBUI.getIcon("ToolWindow.header.closeButton.icon", AllIcons.Actions.Close);
                if (icon2 == null) {
                    ToolWindow.$$$reportNull$$$0(14);
                }
                return icon2;
            }

            @NotNull
            public static Icon comboTabIcon(boolean hovered) {
                Icon icon2 = hovered ? JBUI.getIcon("ToolWindow.header.comboButton.hovered.icon", AllIcons.General.ArrowDown) : JBUI.getIcon("ToolWindow.header.comboButton.icon", AllIcons.General.ArrowDown);
                if (icon2 == null) {
                    ToolWindow.$$$reportNull$$$0(15);
                }
                return icon2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$ToolWindow";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlinedTabForeground";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBackground";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveUnderlineColor";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlineColor";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlinedTabInactiveForeground";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerTabInsets";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerBackground";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerBorderBackground";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerActiveBackground";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerInsets";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerFont";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoveredIconBackground";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "closeTabIcon";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[1] = "comboTabIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static interface DragAndDrop {
                public static final Color STRIPE_BACKGROUND = JBColor.namedColor("ToolWindow.Button.DragAndDrop.stripeBackground", DragAndDrop.Area.BACKGROUND);
                public static final Color BUTTON_DROP_BACKGROUND = JBColor.namedColor("ToolWindow.Button.DragAndDrop.buttonDropBackground", DragAndDrop.Area.BACKGROUND);
                public static final Color BUTTON_FLOATING_BACKGROUND = JBColor.namedColor("ToolWindow.Button.DragAndDrop.buttonFloatingBackground", ActionButton.pressedBackground());
            }
        }

        public static final class StatusBar {
            public static final Color BACKGROUND = JBColor.namedColor("StatusBar.background", JBColor.PanelBackground);
            public static final Color BORDER_COLOR = JBColor.namedColor("StatusBar.borderColor", Gray.x91);

            @Deprecated
            public static Color hoverBackground() {
                return Widget.HOVER_BACKGROUND;
            }

            public static interface Breadcrumbs {
                public static final Color FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.foreground", Widget.FOREGROUND);
                public static final Color HOVER_FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.hoverForeground", UIUtil.getLabelForeground());
                public static final Color HOVER_BACKGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.hoverBackground", ActionButton.hoverBackground());
                public static final Color SELECTION_FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.selectionForeground", List.Selection.foreground(true));
                public static final Color SELECTION_BACKGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.selectionBackground", List.Selection.background(true));
                public static final Color SELECTION_INACTIVE_FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.selectionInactiveForeground", List.Selection.foreground(false));
                public static final Color SELECTION_INACTIVE_BACKGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.selectionInactiveBackground", List.Selection.background(false));
                public static final Color FLOATING_BACKGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.floatingBackground", List.BACKGROUND);
                public static final Color FLOATING_FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.floatingForeground", UIUtil.getLabelForeground());
                public static final JBValue CHEVRON_INSET = new JBValue.UIInteger("StatusBar.Breadcrumbs.chevronInset", 0);

                public static Insets floatingBorderInsets() {
                    return JBUI.insets("StatusBar.Breadcrumbs.floatingToolbarInsets", JBInsets.emptyInsets());
                }
            }

            public static interface Widget {
                public static final Color FOREGROUND = JBColor.namedColor("StatusBar.Widget.foreground", UIUtil.getLabelForeground());
                public static final Color HOVER_FOREGROUND = JBColor.namedColor("StatusBar.Widget.hoverForeground", UIUtil.getLabelForeground());
                public static final Color HOVER_BACKGROUND = JBColor.namedColor("StatusBar.Widget.hoverBackground", ActionButton.hoverBackground());
                public static final Color PRESSED_FOREGROUND = JBColor.namedColor("StatusBar.Widget.pressedForeground", UIUtil.getLabelForeground());
                public static final Color PRESSED_BACKGROUND = JBColor.namedColor("StatusBar.Widget.pressedBackground", ActionButton.pressedBackground());

                public static Border iconBorder() {
                    return new JBEmptyBorder(JBUI.insets("StatusBar.Widget.widgetInsets", JBUI.insets(0, 4)));
                }

                public static Border border() {
                    return new JBEmptyBorder(JBUI.insets("StatusBar.Widget.widgetInsets", JBUI.insets(0, 6)));
                }
            }
        }

        public static interface Notification {
            public static final Color FOREGROUND = JBColor.namedColor("Notification.foreground", Label.foreground());
            public static final Color BACKGROUND = JBColor.namedColor("Notification.background", 16775377, 1914967);

            public static interface Error {
                public static final Color FOREGROUND = JBColor.namedColor("Notification.errorForeground", FOREGROUND);
                public static final Color BACKGROUND = JBColor.namedColor("Notification.errorBackground", 16115431, 5848385);
                public static final Color BORDER_COLOR = JBColor.namedColor("Notification.errorBorderColor", 14723241, 7554379);
            }
        }

        public static interface IconBadge {
            public static final Color ERROR = JBColor.namedColor("IconBadge.errorBackground", 14897746, 14376028);
            public static final Color WARNING = JBColor.namedColor("IconBadge.warningBackground", 16566107, 15910236);
            public static final Color INFORMATION = JBColor.namedColor("IconBadge.infoBackground", 5803251, 5540599);
            public static final Color SUCCESS = JBColor.namedColor("IconBadge.successBackground", 6273125, 6270309);
        }

        public static interface DragAndDrop {
            public static final Color BORDER_COLOR = JBColor.namedColor("DragAndDrop.borderColor", 2520511, 3106250);
            public static final Color ROW_BACKGROUND = JBColor.namedColor("DragAndDrop.rowBackground", 645250854, 795200051);

            public static interface Area {
                public static final Color FOREGROUND = JBColor.namedColor("DragAndDrop.areaForeground", 0x787878, 0xBABABA);
                public static final Color BACKGROUND = JBColor.namedColor("DragAndDrop.areaBackground", 4029900, 4213335);
            }
        }

        public static interface Editor {
            public static final Color BORDER_COLOR = JBColor.namedColor("Editor.Toolbar.borderColor", JBColor.border());

            public static interface Tooltip {
                public static final Color BACKGROUND = JBColor.namedColor("Editor.ToolTip.background", UIUtil.getToolTipBackground());
                public static final Color FOREGROUND = JBColor.namedColor("Editor.ToolTip.foreground", UIUtil.getToolTipForeground());
            }
        }

        public static final class EditorTabs {
            @NotNull
            public static Color underlineColor() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.underlineColor", DefaultTabs.underlineColor());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            public static int underlineHeight() {
                return JBUI.getInt("EditorTabs.underlineHeight", DefaultTabs.underlineHeight());
            }

            public static int underlineArc() {
                return JBUI.getInt("EditorTabs.underlineArc", 0);
            }

            @NotNull
            public static Color inactiveUnderlineColor() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.inactiveUnderlineColor", DefaultTabs.inactiveUnderlineColor());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("EditorTabs.underlinedTabBackground");
            }

            public static Insets tabInsets() {
                return JBUI.insets("EditorTabs.tabInsets", JBUI.insets(0, 8));
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.borderColor", DefaultTabs.borderColor());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color background() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.background", DefaultTabs.background());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.hoverBackground", DefaultTabs.hoverBackground());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground(boolean selected, boolean active) {
                String key = selected ? (active ? "EditorTabs.hoverSelectedBackground" : "EditorTabs.hoverSelectedInactiveBackground") : (active ? "EditorTabs.hoverBackground" : "EditorTabs.hoverInactiveBackground");
                JBColor jBColor = JBColor.namedColor(key, selected ? Gray.TRANSPARENT : DefaultTabs.hoverBackground());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color inactiveColoredFileBackground() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.inactiveColoredFileBackground", DefaultTabs.inactiveColoredTabBackground());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Color underlinedTabForeground() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.underlinedTabForeground", DefaultTabs.underlinedTabForeground());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$EditorTabs";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlineColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveUnderlineColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBackground";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveColoredFileBackground";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlinedTabForeground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class DebuggerTabs {
            public static int underlineHeight() {
                return JBUI.getInt("DebuggerTabs.underlineHeight", JBUIScale.scale(2));
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("DebuggerTabs.underlinedTabBackground");
            }
        }

        public static final class DefaultTabs {
            @NotNull
            public static Color underlineColor() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.underlineColor", new JBColor(4228041, 4884679));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            public static int underlineHeight() {
                return JBUI.getInt("DefaultTabs.underlineHeight", JBUIScale.scale(3));
            }

            @NotNull
            public static Color inactiveUnderlineColor() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.inactiveUnderlineColor", new JBColor(10266552, 7633536));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.borderColor", UIUtil.CONTRAST_BORDER_COLOR);
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color background() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.background", new JBColor(0xECECEC, 3948353));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.hoverBackground", new JBColor(ColorUtil.withAlpha(Color.BLACK, 0.1), ColorUtil.withAlpha(Color.BLACK, 0.35)));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("DefaultTabs.underlinedTabBackground");
            }

            @NotNull
            public static Color underlinedTabForeground() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.underlinedTabForeground", UIUtil.getLabelForeground());
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color inactiveColoredTabBackground() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.inactiveColoredTabBackground", new JBColor(ColorUtil.withAlpha(Color.BLACK, 0.07), ColorUtil.withAlpha(new Color(3948353), 0.6)));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$DefaultTabs";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlineColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveUnderlineColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBackground";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlinedTabForeground";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveColoredTabBackground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class CustomFrameDecorations {
            @NotNull
            public static Color separatorForeground() {
                JBColor jBColor = JBColor.namedColor("Separator.separatorColor", new JBColor(0xCDCDCD, 0x515151));
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneButtonHoverBackground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.Button.hoverBackground", new JBColor(ColorUtil.withAlpha(Color.BLACK, 0.1), ColorUtil.withAlpha(Color.WHITE, 0.1)));
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneButtonPressBackground() {
                return CustomFrameDecorations.titlePaneButtonHoverBackground();
            }

            @NotNull
            public static Color titlePaneInactiveBackground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.inactiveBackground", CustomFrameDecorations.titlePaneBackground());
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneBackground(boolean active) {
                return active ? CustomFrameDecorations.titlePaneBackground() : CustomFrameDecorations.titlePaneInactiveBackground();
            }

            @NotNull
            public static Color titlePaneBackground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.background", CustomFrameDecorations.paneBackground());
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color mainToolbarBackground(boolean active) {
                JBColor activeBG = JBColor.namedColor("MainToolbar.background", CustomFrameDecorations.titlePaneBackground());
                JBColor inactiveBG = JBColor.namedColor("MainToolbar.inactiveBackground", activeBG);
                JBColor jBColor = active ? activeBG : inactiveBG;
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneInfoForeground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.infoForeground", new JBColor(0x616161, 0x919191));
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneInactiveInfoForeground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.inactiveInfoForeground", new JBColor(0xA6A6A6, 0x737373));
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Color paneBackground() {
                JBColor jBColor = JBColor.namedColor("Panel.background", Gray.xCD);
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$CustomFrameDecorations";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "separatorForeground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneButtonHoverBackground";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneInactiveBackground";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneBackground";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "mainToolbarBackground";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneInfoForeground";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneInactiveInfoForeground";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "paneBackground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static interface SegmentedButton {
            public static final Color SELECTED_START_BORDER_COLOR = JBColor.namedColor("SegmentedButton.selectedStartBorderColor", Gray.xBF);
            public static final Color SELECTED_END_BORDER_COLOR = JBColor.namedColor("SegmentedButton.selectedEndBorderColor", Gray.xB8);
            public static final Color SELECTED_BUTTON_COLOR = JBColor.namedColor("SegmentedButton.selectedButtonColor", 0x555A5C);
            public static final Color FOCUSED_SELECTED_BUTTON_COLOR = JBColor.namedColor("SegmentedButton.focusedSelectedButtonColor", 14345453);
        }

        public static final class Button {
            @NotNull
            public static Color buttonColorStart() {
                JBColor jBColor = JBColor.namedColor("Button.startBackground", JBColor.namedColor("Button.darcula.startColor", 0x555A5C));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonColorEnd() {
                JBColor jBColor = JBColor.namedColor("Button.endBackground", JBColor.namedColor("Button.darcula.endColor", 4277832));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color defaultButtonColorStart() {
                JBColor jBColor = JBColor.namedColor("Button.default.startBackground", JBColor.namedColor("Button.darcula.defaultStartColor", 3690347));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color defaultButtonColorEnd() {
                JBColor jBColor = JBColor.namedColor("Button.default.endBackground", JBColor.namedColor("Button.darcula.defaultEndColor", 2306371));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color focusBorderColor(boolean isDefaultButton) {
                JBColor jBColor = isDefaultButton ? JBColor.namedColor("Button.default.focusedBorderColor", JBColor.namedColor("Button.darcula.defaultFocusedOutlineColor", 8892378)) : JBColor.namedColor("Button.focusedBorderColor", JBColor.namedColor("Button.darcula.focusedOutlineColor", 8892378));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonOutlineColorStart(boolean isDefaultButton) {
                JBColor jBColor = isDefaultButton ? JBColor.namedColor("Button.default.startBorderColor", JBColor.namedColor("Button.darcula.outlineDefaultStartColor", Gray.xBF)) : JBColor.namedColor("Button.startBorderColor", JBColor.namedColor("Button.darcula.outlineStartColor", Gray.xBF));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonOutlineColorEnd(boolean isDefaultButton) {
                JBColor jBColor = isDefaultButton ? JBColor.namedColor("Button.default.endBorderColor", JBColor.namedColor("Button.darcula.outlineDefaultEndColor", Gray.xB8)) : JBColor.namedColor("Button.endBorderColor", JBColor.namedColor("Button.darcula.outlineEndColor", Gray.xB8));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Color disabledOutlineColor() {
                JBColor jBColor = JBColor.namedColor("Button.disabledBorderColor", JBColor.namedColor("Button.darcula.disabledOutlineColor", Gray.xCF));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$Button";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonColorStart";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonColorEnd";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultButtonColorStart";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultButtonColorEnd";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "focusBorderColor";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonOutlineColorStart";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonOutlineColorEnd";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "disabledOutlineColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class ActionsList {
            public static final Color MNEMONIC_FOREGROUND = JBColor.namedColor("Component.infoForeground", new JBColor(Gray.x99, (Color)Gray.x78));

            @NotNull
            public static Insets numberMnemonicInsets() {
                JBInsets jBInsets = JBUI.insets("ActionsList.mnemonicsBorderInsets", JBUI.insets(0, 8, 1, 6));
                if (jBInsets == null) {
                    ActionsList.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            @NotNull
            public static Insets cellPadding() {
                JBInsets jBInsets = JBUI.insets("ActionsList.cellBorderInsets", JBUI.insets(1, 12, 1, 12));
                if (jBInsets == null) {
                    ActionsList.$$$reportNull$$$0(1);
                }
                return jBInsets;
            }

            public static int elementIconGap() {
                return new JBValue.UIInteger("ActionsList.icon.gap", JBUI.scale(6)).get();
            }

            public static int mnemonicIconGap() {
                return new JBValue.UIInteger("ActionsList.mnemonic.icon.gap", JBUI.scale(6)).get();
            }

            @NotNull
            public static Font applyStylesForNumberMnemonic(Font font) {
                if (SystemInfoRt.isWindows) {
                    HashMap attributes = new HashMap(font.getAttributes());
                    attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    Font font2 = font.deriveFont(attributes);
                    if (font2 == null) {
                        ActionsList.$$$reportNull$$$0(2);
                    }
                    return font2;
                }
                Font font3 = font;
                if (font3 == null) {
                    ActionsList.$$$reportNull$$$0(3);
                }
                return font3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$ActionsList";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "numberMnemonicInsets";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cellPadding";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "applyStylesForNumberMnemonic";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class ActionButton {
            @NotNull
            public static Color pressedBackground() {
                JBColor jBColor = JBColor.namedColor("ActionButton.pressedBackground", Gray.xCF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color pressedBorder() {
                JBColor jBColor = JBColor.namedColor("ActionButton.pressedBorderColor", Gray.xCF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color focusedBorder() {
                JBColor jBColor = JBColor.namedColor("ActionButton.focusedBorderColor", new JBColor(6469854, 6204624));
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground() {
                JBColor jBColor = JBColor.namedColor("ActionButton.hoverBackground", Gray.xDF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBorder() {
                JBColor jBColor = JBColor.namedColor("ActionButton.hoverBorderColor", Gray.xDF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverSeparatorColor() {
                JBColor jBColor = JBColor.namedColor("ActionButton.hoverSeparatorColor", new JBColor(Gray.xB3, (Color)Gray.x6B));
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$CurrentTheme$ActionButton";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "pressedBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "pressedBorder";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "focusedBorder";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBackground";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBorder";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverSeparatorColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Component {
            public static final Color FOCUSED_BORDER_COLOR = JBColor.namedColor("Component.focusedBorderColor", 8892378, 4615572);
        }
    }

    public static final class Panels {
        @NotNull
        public static BorderLayoutPanel simplePanel() {
            return new BorderLayoutPanel();
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(Component comp) {
            BorderLayoutPanel borderLayoutPanel = Panels.simplePanel().addToCenter(comp);
            if (borderLayoutPanel == null) {
                Panels.$$$reportNull$$$0(0);
            }
            return borderLayoutPanel;
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(int hgap, int vgap) {
            return new BorderLayoutPanel(hgap, vgap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/util/ui/JBUI$Panels", "simplePanel"));
        }
    }

    public static final class Borders {
        @NotNull
        public static JBEmptyBorder empty(int top, int left, int bottom, int right) {
            if (top == 0 && left == 0 && bottom == 0 && right == 0) {
                JBEmptyBorder jBEmptyBorder = JBEmptyBorder.SHARED_EMPTY_INSTANCE;
                if (jBEmptyBorder == null) {
                    Borders.$$$reportNull$$$0(0);
                }
                return jBEmptyBorder;
            }
            return new JBEmptyBorder(top, left, bottom, right);
        }

        @NotNull
        public static JBEmptyBorder empty(int topAndBottom, int leftAndRight) {
            return Borders.empty(topAndBottom, leftAndRight, topAndBottom, leftAndRight);
        }

        @NotNull
        public static JBEmptyBorder emptyTop(int offset) {
            return Borders.empty(offset, 0, 0, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyLeft(int offset) {
            return Borders.empty(0, offset, 0, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyBottom(int offset) {
            return Borders.empty(0, 0, offset, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyRight(int offset) {
            return Borders.empty(0, 0, 0, offset);
        }

        @NotNull
        public static JBEmptyBorder empty() {
            return Borders.empty(0, 0, 0, 0);
        }

        @NotNull
        public static Border empty(int offsets) {
            return Borders.empty(offsets, offsets, offsets, offsets);
        }

        @NotNull
        public static Border empty(@NotNull Insets insets) {
            if (insets == null) {
                Borders.$$$reportNull$$$0(1);
            }
            return Borders.empty(insets.top, insets.left, insets.bottom, insets.right);
        }

        @NotNull
        public static Border customLine(Color color, int top, int left, int bottom, int right) {
            return new CustomLineBorder(color, new JBInsets(top, left, bottom, right));
        }

        @NotNull
        public static Border customLine(Color color, int thickness) {
            return Borders.customLine(color, thickness, thickness, thickness, thickness);
        }

        @NotNull
        public static Border customLine(Color color) {
            return Borders.customLine(color, 1);
        }

        @NotNull
        public static Border customLineTop(Color color) {
            return Borders.customLine(color, 1, 0, 0, 0);
        }

        @NotNull
        public static Border customLineLeft(Color color) {
            return Borders.customLine(color, 0, 1, 0, 0);
        }

        @NotNull
        public static Border customLineRight(Color color) {
            return Borders.customLine(color, 0, 0, 0, 1);
        }

        @NotNull
        public static Border customLineBottom(Color color) {
            return Borders.customLine(color, 0, 0, 1, 0);
        }

        @Nullable
        public static Border compound(@Nullable Border outside, @Nullable Border inside) {
            return inside == null ? outside : (outside == null ? inside : new CompoundBorder(outside, inside));
        }

        @Nullable
        public static Border compound(Border ... borders) {
            if (borders == null) {
                Borders.$$$reportNull$$$0(2);
            }
            Border result = null;
            for (Border border : borders) {
                if (border == null) continue;
                result = result == null ? border : new CompoundBorder(result, border);
            }
            return result;
        }

        @NotNull
        public static Border merge(@Nullable Border source, @NotNull Border extra, boolean extraIsOutside) {
            if (extra == null) {
                Borders.$$$reportNull$$$0(3);
            }
            if (source == null) {
                Border border = extra;
                if (border == null) {
                    Borders.$$$reportNull$$$0(4);
                }
                return border;
            }
            return new CompoundBorder(extraIsOutside ? extra : source, extraIsOutside ? source : extra);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/util/ui/JBUI$Borders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "borders";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extra";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/util/ui/JBUI$Borders";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "empty";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compound";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Fonts {
        @NotNull
        public static JBFont label() {
            JBFont jBFont = JBFont.label();
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(0);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont label(float size) {
            JBFont jBFont = JBFont.label().deriveFont(JBUIScale.scale(size));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(1);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont smallFont() {
            JBFont jBFont = JBFont.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(2);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont miniFont() {
            JBFont jBFont = JBFont.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.MINI));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(3);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont create(@NonNls String fontFamily, int size) {
            JBFont jBFont = JBFont.create(new Font(fontFamily, 0, size));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(4);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont toolbarFont() {
            JBFont jBFont = SystemInfoRt.isMac ? Fonts.smallFont() : JBFont.label();
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(5);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont toolbarSmallComboBoxFont() {
            return Fonts.label(11.0f);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "sqldelight/com/intellij/util/ui/JBUI$Fonts";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "label";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "smallFont";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "miniFont";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toolbarFont";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

