/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import sqldelight.com.intellij.ui.paint.PaintUtil;
import sqldelight.com.intellij.ui.scale.JBUIScale;
import sqldelight.com.intellij.util.ui.JBUI;
import sqldelight.org.jetbrains.annotations.NotNull;

public abstract class JBValue {
    protected JBValue() {
    }

    public int get() {
        return PaintUtil.RoundingMode.ROUND.round(JBUIScale.scale(this.getUnscaled()));
    }

    public float getFloat() {
        return JBUIScale.scale(this.getUnscaled());
    }

    public int get(@NotNull PaintUtil.RoundingMode rm) {
        if (rm == null) {
            JBValue.$$$reportNull$$$0(0);
        }
        return rm.round(JBUIScale.scale(this.getUnscaled()));
    }

    public abstract float getUnscaled();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rm", "sqldelight/com/intellij/util/ui/JBValue", "get"));
    }

    public static class JBValueGroup {
        private final List<CachedFloat> group = new LinkedList<CachedFloat>();
        private final PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                for (CachedFloat value : group) {
                    value.scaleAndCache();
                }
            }
        };

        public JBValueGroup() {
            JBUIScale.addUserScaleChangeListener(this.listener);
        }

        public JBValue value(float value) {
            CachedFloat v = new CachedFloat(value);
            this.group.add(v);
            return v;
        }

        public void dispose() {
            JBUIScale.removeUserScaleChangeListener(this.listener);
            this.group.clear();
        }
    }

    private static class CachedFloat
    extends Float {
        private float cachedScaledValue;

        protected CachedFloat(float value) {
            super(value);
            this.scaleAndCache();
        }

        @Override
        public int get() {
            return PaintUtil.RoundingMode.ROUND.round(this.cachedScaledValue);
        }

        @Override
        public float getFloat() {
            return this.cachedScaledValue;
        }

        @Override
        public int get(@NotNull PaintUtil.RoundingMode rm) {
            if (rm == null) {
                CachedFloat.$$$reportNull$$$0(0);
            }
            return rm.round(this.cachedScaledValue);
        }

        public void scaleAndCache() {
            this.cachedScaledValue = JBUIScale.scale(this.getUnscaled());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rm", "sqldelight/com/intellij/util/ui/JBValue$CachedFloat", "get"));
        }
    }

    public static class Float
    extends JBValue {
        private final float value;

        public Float(float value) {
            this(value, false);
        }

        public Float(float value, boolean preScaled) {
            this.value = preScaled ? value / JBUIScale.scale(1.0f) : value;
        }

        @Override
        public float getUnscaled() {
            return this.value;
        }
    }

    public static final class UIInteger
    extends JBValue {
        @NotNull
        private final String key;
        private final int defValue;

        public UIInteger(@NotNull String key, int defValue) {
            if (key == null) {
                UIInteger.$$$reportNull$$$0(0);
            }
            this.key = key;
            this.defValue = defValue;
        }

        @Override
        public float getUnscaled() {
            return JBUI.getInt(this.key, this.defValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "sqldelight/com/intellij/util/ui/JBValue$UIInteger", "<init>"));
        }
    }
}

