/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.ui;

import java.awt.AWTError;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellRendererPane;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import sqldelight.com.intellij.BundleBase;
import sqldelight.com.intellij.diagnostic.LoadingState;
import sqldelight.com.intellij.icons.AllIcons;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.ui.GraphicsConfig;
import sqldelight.com.intellij.openapi.util.Computable;
import sqldelight.com.intellij.openapi.util.Condition;
import sqldelight.com.intellij.openapi.util.Conditions;
import sqldelight.com.intellij.openapi.util.Couple;
import sqldelight.com.intellij.openapi.util.Disposer;
import sqldelight.com.intellij.openapi.util.Factory;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.NlsSafe;
import sqldelight.com.intellij.openapi.util.NotNullLazyValue;
import sqldelight.com.intellij.openapi.util.Ref;
import sqldelight.com.intellij.openapi.util.SystemInfo;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.openapi.util.UserDataHolder;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.openapi.util.text.TextWithMnemonic;
import sqldelight.com.intellij.ui.ClientProperty;
import sqldelight.com.intellij.ui.ColorUtil;
import sqldelight.com.intellij.ui.ComponentUtil;
import sqldelight.com.intellij.ui.DocumentAdapter;
import sqldelight.com.intellij.ui.Gray;
import sqldelight.com.intellij.ui.JBColor;
import sqldelight.com.intellij.ui.JreHiDpiUtil;
import sqldelight.com.intellij.ui.PanelWithAnchor;
import sqldelight.com.intellij.ui.SideBorder;
import sqldelight.com.intellij.ui.TableUtil;
import sqldelight.com.intellij.ui.mac.foundation.Foundation;
import sqldelight.com.intellij.ui.paint.LinePainter2D;
import sqldelight.com.intellij.ui.paint.PaintUtil;
import sqldelight.com.intellij.ui.scale.JBUIScale;
import sqldelight.com.intellij.util.ArrayUtilRt;
import sqldelight.com.intellij.util.BitUtil;
import sqldelight.com.intellij.util.Consumer;
import sqldelight.com.intellij.util.FontUtil;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.com.intellij.util.PairFunction;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.com.intellij.util.RetinaImage;
import sqldelight.com.intellij.util.ThrowableRunnable;
import sqldelight.com.intellij.util.concurrency.Semaphore;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.containers.JBIterable;
import sqldelight.com.intellij.util.containers.JBTreeTraverser;
import sqldelight.com.intellij.util.ui.AppleBoldDottedPainter;
import sqldelight.com.intellij.util.ui.CenteredIcon;
import sqldelight.com.intellij.util.ui.DetectRetinaKit;
import sqldelight.com.intellij.util.ui.EdtInvocationManager;
import sqldelight.com.intellij.util.ui.ExtendableHTMLViewFactory;
import sqldelight.com.intellij.util.ui.GraphicsUtil;
import sqldelight.com.intellij.util.ui.HTMLEditorKitBuilder;
import sqldelight.com.intellij.util.ui.Html;
import sqldelight.com.intellij.util.ui.ImageUtil;
import sqldelight.com.intellij.util.ui.JBHtmlEditorKit;
import sqldelight.com.intellij.util.ui.JBInsets;
import sqldelight.com.intellij.util.ui.JBUI;
import sqldelight.com.intellij.util.ui.MacUIUtil;
import sqldelight.com.intellij.util.ui.StartupUiUtil;
import sqldelight.com.intellij.util.ui.StyleSheetUtil;
import sqldelight.com.intellij.util.ui.WavePainter;
import sqldelight.org.intellij.lang.annotations.JdkConstants;
import sqldelight.org.intellij.lang.annotations.Language;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.Nls;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.TestOnly;
import sun.font.FontUtilities;

public final class UIUtil {
    @NlsSafe
    public static final String BORDER_LINE = "<hr size=1 noshade>";
    @NlsSafe
    public static final String BR = "<br/>";
    @NlsSafe
    public static final String HR = "<hr/>";
    @NlsSafe
    public static final String LINE_SEPARATOR = "\n";
    public static final Key<Boolean> LAF_WITH_THEME_KEY;
    public static final Key<String> PLUGGABLE_LAF_KEY;
    private static final Key<Boolean> IS_SHOWING;
    private static final Key<Boolean> HAS_FOCUS;
    @ApiStatus.Internal
    public static final String NO_BORDER_UNDER_WINDOW_TITLE_KEY = "";
    private static final NotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    public static final char MNEMONIC = '\u001b';
    @NlsSafe
    public static final String HTML_MIME = "text/html";
    @NonNls
    public static final String JSLIDER_ISFILLED = "JSlider.isFilled";
    @NonNls
    public static final String TABLE_FOCUS_CELL_BACKGROUND_PROPERTY = "Table.focusCellBackground";
    @NonNls
    public static final String HIDE_EDITOR_FROM_DATA_CONTEXT_PROPERTY = "AuxEditorComponent";
    @NonNls
    public static final String CENTER_TOOLTIP_DEFAULT = "ToCenterTooltip";
    @NonNls
    public static final String CENTER_TOOLTIP_STRICT = "ToCenterTooltip.default";
    private static final Pattern CLOSE_TAG_PATTERN;
    @NonNls
    private static final String FOCUS_PROXY_KEY = "isFocusProxy";
    public static final Key<Integer> KEEP_BORDER_SIDES;
    private static final Key<UndoManager> UNDO_MANAGER;
    public static final Key<Boolean> TEXT_COPY_ROOT;
    private static final Action REDO_ACTION;
    private static final Action UNDO_ACTION;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final int DEFAULT_HGAP = 10;
    public static final int DEFAULT_VGAP = 4;
    public static final int LARGE_VGAP = 12;
    private static final int REGULAR_PANEL_TOP_BOTTOM_INSET = 8;
    private static final int REGULAR_PANEL_LEFT_RIGHT_INSET = 12;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    @NonNls
    private static final String ROOT_PANE = "JRootPane.future";
    private static final Ref<Boolean> ourRetina;
    public static final int LIST_FIXED_CELL_HEIGHT = 20;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS;
    private static final JBTreeTraverser<Component> UI_TRAVERSER;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final DocumentListener SET_TEXT_CHECKER;
    public static final String CHECKBOX_ROLLOVER_PROPERTY = "JCheckBox.rollOver.rectangle";
    public static final String CHECKBOX_PRESSED_PROPERTY = "JCheckBox.pressed.rectangle";

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(UIUtil.class);
        if (logger2 == null) {
            UIUtil.$$$reportNull$$$0(0);
        }
        return logger2;
    }

    public static void decorateWindowHeader(JRootPane pane) {
        if (pane != null && SystemInfo.isMacOSMojave) {
            if (Runtime.version().feature() < 17) {
                pane.putClientProperty("jetbrains.awt.windowDarkAppearance", UIUtil.isUnderDarcula());
            } else if (UIUtil.isUnderDarcula()) {
                pane.putClientProperty("apple.awt.windowAppearance", "NSAppearanceNameVibrantDark");
            } else {
                pane.putClientProperty("apple.awt.windowAppearance", "NSAppearanceNameVibrantLight");
            }
        }
    }

    public static int getTransparentTitleBarHeight(JRootPane rootPane) {
        Object property = rootPane.getClientProperty("Window.transparentTitleBarHeight");
        if (property instanceof Integer) {
            return (Integer)property;
        }
        if ("small".equals(rootPane.getClientProperty("Window.style"))) {
            return JBUI.getInt("macOSWindow.Title.heightSmall", 19);
        }
        return JBUI.getInt("macOSWindow.Title.height", SystemInfo.isMacOSBigSur ? 29 : 23);
    }

    public static void markAsPossibleOwner(Dialog dialog) {
        ClientProperty.put((Window)dialog, "PossibleOwner", Boolean.TRUE);
    }

    public static boolean isPossibleOwner(@NotNull Dialog dialog) {
        if (dialog == null) {
            UIUtil.$$$reportNull$$$0(1);
        }
        return ClientProperty.isTrue(dialog, "PossibleOwner");
    }

    public static int getMultiClickInterval() {
        Object property = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (property instanceof Integer) {
            return (Integer)property;
        }
        return 500;
    }

    public static void applyStyle(@NotNull ComponentStyle componentStyle, @NotNull Component comp) {
        if (componentStyle == null) {
            UIUtil.$$$reportNull$$$0(2);
        }
        if (comp == null) {
            UIUtil.$$$reportNull$$$0(3);
        }
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)comp;
        if (UIUtil.isUnderAquaBasedLookAndFeel()) {
            c.putClientProperty("JComponent.sizeVariant", StringUtil.toLowerCase(componentStyle.name()));
        }
        FontSize fontSize = componentStyle == ComponentStyle.MINI ? FontSize.MINI : (componentStyle == ComponentStyle.SMALL ? FontSize.SMALL : FontSize.NORMAL);
        c.setFont(UIUtil.getFont(fontSize, c.getFont()));
        Container p = c.getParent();
        if (p != null) {
            SwingUtilities.updateComponentTreeUI(p);
        }
    }

    @NotNull
    public static Cursor getTextCursor(@NotNull Color backgroundColor) {
        if (backgroundColor == null) {
            UIUtil.$$$reportNull$$$0(4);
        }
        Cursor cursor = SystemInfoRt.isMac && ColorUtil.isDark(backgroundColor) ? MacUIUtil.getInvertedTextCursor() : Cursor.getPredefinedCursor(2);
        if (cursor == null) {
            UIUtil.$$$reportNull$$$0(5);
        }
        return cursor;
    }

    @Nullable
    public static Cursor cursorIfNotDefault(@Nullable Cursor cursorToSet) {
        return cursorToSet != null && cursorToSet.getType() != 0 ? cursorToSet : null;
    }

    @NotNull
    public static RGBImageFilter getGrayFilter() {
        GrayFilter grayFilter = GrayFilter.namedFilter("grayFilter", new GrayFilter(33, -35, 100));
        if (grayFilter == null) {
            UIUtil.$$$reportNull$$$0(6);
        }
        return grayFilter;
    }

    @NotNull
    public static RGBImageFilter getTextGrayFilter() {
        GrayFilter grayFilter = GrayFilter.namedFilter("text.grayFilter", new GrayFilter(20, 0, 100));
        if (grayFilter == null) {
            UIUtil.$$$reportNull$$$0(7);
        }
        return grayFilter;
    }

    @NotNull
    public static Couple<Color> getCellColors(@NotNull JTable table, boolean isSel, int row, int column) {
        if (table == null) {
            UIUtil.$$$reportNull$$$0(8);
        }
        Couple<Color> couple = Couple.of(isSel ? table.getSelectionForeground() : table.getForeground(), isSel ? table.getSelectionBackground() : table.getBackground());
        if (couple == null) {
            UIUtil.$$$reportNull$$$0(9);
        }
        return couple;
    }

    public static void fixOSXEditorBackground(@NotNull JTable table) {
        if (table == null) {
            UIUtil.$$$reportNull$$$0(10);
        }
        if (!SystemInfoRt.isMac) {
            return;
        }
        if (table.isEditing()) {
            int column = table.getEditingColumn();
            int row = table.getEditingRow();
            Component renderer = column >= 0 && row >= 0 ? table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), true, table.hasFocus(), row, column) : null;
            Component component = table.getEditorComponent();
            if (component != null && renderer != null) {
                UIUtil.changeBackGround(component, renderer.getBackground());
            }
        }
    }

    private UIUtil() {
    }

    public static boolean isRetina(@NotNull Graphics2D graphics) {
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(11);
        }
        return SystemInfoRt.isMac ? DetectRetinaKit.isMacRetina(graphics) : UIUtil.isRetina();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("is.hidpi"))) {
            return true;
        }
        if (Registry.is("new.retina.detection", false)) {
            return DetectRetinaKit.isRetina();
        }
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set(false);
                try {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    Integer scale = ReflectionUtil.getField(device.getClass(), device, Integer.TYPE, "scale");
                    if (scale != null && scale == 2) {
                        ourRetina.set(true);
                        return true;
                    }
                }
                catch (AWTError | Exception throwable) {
                    // empty catch block
                }
                ourRetina.set(false);
            }
            return ourRetina.get();
        }
    }

    @Deprecated
    public static boolean isWindowClientPropertyTrue(Window window, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(12);
        }
        return ClientProperty.isTrue(window, key);
    }

    @Deprecated
    public static Object getWindowClientProperty(Window window, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(13);
        }
        return ClientProperty.get((Component)window, key);
    }

    @Deprecated
    public static void putWindowClientProperty(Window window, @NotNull Object key, Object value) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(14);
        }
        ClientProperty.put(window, key, value);
    }

    @Deprecated
    public static boolean isClientPropertyTrue(Object component, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(15);
        }
        return component instanceof Component && ClientProperty.isTrue((Component)component, key);
    }

    @Deprecated
    public static Object getClientProperty(Object component, @NotNull @NonNls Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(16);
        }
        return component instanceof Component ? ClientProperty.get((Component)component, key) : null;
    }

    @NotNull
    public static Map<Object, Object> getAllClientProperties(Object component) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        if (component instanceof RootPaneContainer) {
            component = ((RootPaneContainer)component).getRootPane();
        }
        if (component instanceof JComponent) {
            Map<Object, Object> map2;
            Object table;
            Method method;
            block13: {
                block12: {
                    method = ReflectionUtil.getDeclaredMethod(JComponent.class, "getClientProperties", new Class[0]);
                    if (method != null) break block12;
                    Map<Object, Object> map3 = Collections.emptyMap();
                    if (map3 == null) {
                        UIUtil.$$$reportNull$$$0(17);
                    }
                    return map3;
                }
                method.setAccessible(true);
                table = method.invoke(component, new Object[0]);
                method = ReflectionUtil.getDeclaredMethod(table.getClass(), "getKeys", Object[].class);
                if (method != null) break block13;
                Map<Object, Object> map4 = Collections.emptyMap();
                if (map4 == null) {
                    UIUtil.$$$reportNull$$$0(18);
                }
                return map4;
            }
            try {
                method.setAccessible(true);
                Object arr = method.invoke(table, new Object[1]);
                if (arr instanceof Object[]) {
                    for (Object key : (Object[])arr) {
                        map.put(key, ((JComponent)component).getClientProperty(key));
                    }
                }
                map2 = Collections.unmodifiableMap(map);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (map2 == null) {
                UIUtil.$$$reportNull$$$0(19);
            }
            return map2;
        }
        Map<Object, Object> map5 = Collections.emptyMap();
        if (map5 == null) {
            UIUtil.$$$reportNull$$$0(20);
        }
        return map5;
    }

    public static <T> T getClientProperty(Object component, @NotNull Class<T> type2) {
        if (type2 == null) {
            UIUtil.$$$reportNull$$$0(21);
        }
        return ObjectUtils.tryCast(ClientProperty.get(ObjectUtils.tryCast(component, Component.class), type2), type2);
    }

    @Deprecated
    public static <T> T getClientProperty(Object component, @NotNull Key<T> key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(22);
        }
        return component instanceof Component ? (T)ClientProperty.get((Component)component, key) : null;
    }

    @Deprecated
    public static <T> void putClientProperty(@NotNull JComponent component, @NotNull Key<T> key, T value) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(23);
        }
        if (key == null) {
            UIUtil.$$$reportNull$$$0(24);
        }
        component.putClientProperty(key, value);
    }

    @Contract(pure=true)
    @NotNull
    public static String getHtmlBody(@NotNull String text) {
        int bodyIndex;
        int htmlIndex;
        if (text == null) {
            UIUtil.$$$reportNull$$$0(25);
        }
        if ((htmlIndex = 6 + text.indexOf("<html>")) < 6) {
            String string = text.replaceAll(LINE_SEPARATOR, "<br>");
            if (string == null) {
                UIUtil.$$$reportNull$$$0(26);
            }
            return string;
        }
        int htmlCloseIndex = text.indexOf("</html>", htmlIndex);
        if (htmlCloseIndex < 0) {
            htmlCloseIndex = text.length();
        }
        if ((bodyIndex = 6 + text.indexOf("<body>", htmlIndex)) < 6) {
            String string = text.substring(htmlIndex, htmlCloseIndex);
            if (string == null) {
                UIUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        int bodyCloseIndex = text.indexOf("</body>", bodyIndex);
        if (bodyCloseIndex < 0) {
            bodyCloseIndex = text.length();
        }
        String string = text.substring(bodyIndex, Math.min(bodyCloseIndex, htmlCloseIndex));
        if (string == null) {
            UIUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String getHtmlBody(@NotNull Html html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(29);
        }
        String result = UIUtil.getHtmlBody(html.getText());
        String string = html.isKeepFont() ? result : result.replaceAll("<font(.*?)>", NO_BORDER_UNDER_WINDOW_TITLE_KEY).replaceAll("</font>", NO_BORDER_UNDER_WINDOW_TITLE_KEY);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    public static void drawLinePickedOut(@NotNull Graphics graphics, int x, int y, int x1, int y1) {
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(31);
        }
        if (x == x1) {
            int minY = Math.min(y, y1);
            int maxY = Math.max(y, y1);
            LinePainter2D.paint((Graphics2D)graphics, x, minY + 1, (double)x1, maxY - 1);
        } else if (y == y1) {
            int minX = Math.min(x, x1);
            int maxX = Math.max(x, x1);
            LinePainter2D.paint((Graphics2D)graphics, minX + 1, y, (double)(maxX - 1), y1);
        } else {
            LinePainter2D.paint((Graphics2D)graphics, x, y, (double)x1, y1);
        }
    }

    public static boolean isReallyTypedEvent(@NotNull KeyEvent e) {
        char c;
        if (e == null) {
            UIUtil.$$$reportNull$$$0(32);
        }
        if ((c = e.getKeyChar()) == '\uffff') {
            return false;
        }
        if (c < ' ' || c == '\u007f') {
            return false;
        }
        if (SystemInfoRt.isWindows && c >= '\u200c' && c <= '\u200f') {
            return true;
        }
        if (SystemInfoRt.isMac) {
            return !e.isMetaDown() && !e.isControlDown();
        }
        return !e.isAltDown() && !e.isControlDown();
    }

    public static int getStringY(@NotNull String string, @NotNull Rectangle bounds, @NotNull Graphics2D g) {
        if (string == null) {
            UIUtil.$$$reportNull$$$0(33);
        }
        if (bounds == null) {
            UIUtil.$$$reportNull$$$0(34);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(35);
        }
        int centerY = bounds.height / 2;
        Font font = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle stringBounds = font.getStringBounds(string.isEmpty() ? " " : string, frc).getBounds();
        return (int)((double)centerY - (double)stringBounds.height / 2.0 - (double)stringBounds.y);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label, @NotNull Graphics g) {
        if (label == null) {
            UIUtil.$$$reportNull$$$0(36);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(37);
        }
        UIUtil.drawLabelDottedRectangle(label, g, null);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label, @NotNull Graphics g, @Nullable Rectangle bounds) {
        if (label == null) {
            UIUtil.$$$reportNull$$$0(38);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(39);
        }
        if (bounds == null) {
            bounds = UIUtil.getLabelTextBounds(label);
        }
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int baseLine = label.getUI().getBaseline(label, label.getWidth(), label.getHeight());
        int textY = baseLine - fm.getLeading() - fm.getAscent();
        int textHeight = fm.getHeight();
        UIUtil.drawDottedRectangle(g, bounds.x, textY, bounds.x + bounds.width - 1, textY + textHeight - 1);
    }

    @NotNull
    public static Rectangle getLabelTextBounds(@NotNull JLabel label) {
        if (label == null) {
            UIUtil.$$$reportNull$$$0(40);
        }
        Dimension size = label.getPreferredSize();
        Icon icon2 = label.getIcon();
        Point point = new Point(0, 0);
        Insets insets = label.getInsets();
        if (icon2 != null) {
            if (label.getHorizontalTextPosition() == 11) {
                point.x += label.getIconTextGap();
                point.x += icon2.getIconWidth();
            } else if (label.getHorizontalTextPosition() == 10) {
                size.width -= icon2.getIconWidth();
            }
        }
        point.x += insets.left;
        point.y += insets.top;
        size.width -= point.x;
        size.width -= insets.right;
        size.height -= insets.bottom;
        return new Rectangle(point, size);
    }

    public static int getHighestGlyphHeight(@NotNull String string, @NotNull Font font, @NotNull Graphics graphics) {
        if (string == null) {
            UIUtil.$$$reportNull$$$0(41);
        }
        if (font == null) {
            UIUtil.$$$reportNull$$$0(42);
        }
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(43);
        }
        FontRenderContext frc = ((Graphics2D)graphics).getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, string);
        int maxHeight = 0;
        for (int i = 0; i < string.length(); ++i) {
            maxHeight = Math.max(maxHeight, (int)gv.getGlyphMetrics(i).getBounds2D().getHeight());
        }
        return maxHeight;
    }

    public static void setEnabled(@NotNull Component component, boolean enabled, boolean recursively) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(44);
        }
        UIUtil.setEnabled(component, enabled, recursively, false);
    }

    public static void setEnabled(@NotNull Component component, boolean enabled, boolean recursively, boolean visibleOnly) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(45);
        }
        JBIterable<Component> all = recursively ? ((JBTreeTraverser)UIUtil.uiTraverser(component).expandAndFilter(visibleOnly ? Component::isVisible : Conditions.alwaysTrue())).traverse() : JBIterable.of(component);
        Color fg = enabled ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        for (Component c : all) {
            c.setEnabled(enabled);
            if (!(c instanceof JLabel)) continue;
            c.setForeground(fg);
        }
    }

    @Deprecated(forRemoval=true)
    public static void drawLine(@NotNull Graphics g, int x1, int y1, int x2, int y2) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(46);
        }
        LinePainter2D.paint((Graphics2D)g, x1, y1, (double)x2, y2);
    }

    public static void drawLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, @Nullable Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(47);
        }
        Color oldFg = g.getColor();
        Color oldBg = g.getBackground();
        if (fgColor != null) {
            g.setColor(fgColor);
        }
        if (bgColor != null) {
            g.setBackground(bgColor);
        }
        LinePainter2D.paint(g, x1, y1, (double)x2, y2);
        if (fgColor != null) {
            g.setColor(oldFg);
        }
        if (bgColor != null) {
            g.setBackground(oldBg);
        }
    }

    public static void drawWave(@NotNull Graphics2D g, @NotNull Rectangle rectangle) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(48);
        }
        if (rectangle == null) {
            UIUtil.$$$reportNull$$$0(49);
        }
        WavePainter.forColor(g.getColor()).paint(g, (int)rectangle.getMinX(), (int)rectangle.getMaxX(), (int)rectangle.getMaxY());
    }

    public static String @NotNull [] splitText(@NotNull String text, @NotNull FontMetrics fontMetrics, int widthLimit, char separator) {
        if (text == null) {
            UIUtil.$$$reportNull$$$0(50);
        }
        if (fontMetrics == null) {
            UIUtil.$$$reportNull$$$0(51);
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        StringBuilder currentAtom = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String s;
            int width;
            char ch = text.charAt(i);
            currentAtom.append(ch);
            if (ch == separator) {
                currentLine.append((CharSequence)currentAtom);
                currentAtom.setLength(0);
            }
            if ((width = fontMetrics.stringWidth(s = currentLine.toString() + currentAtom)) < widthLimit - fontMetrics.charWidth('w')) continue;
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
                continue;
            }
            lines.add(currentAtom.toString());
            currentAtom.setLength(0);
        }
        String s = currentLine.toString() + currentAtom;
        if (!s.isEmpty()) {
            lines.add(s);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(lines);
        if (stringArray == null) {
            UIUtil.$$$reportNull$$$0(52);
        }
        return stringArray;
    }

    public static void setActionNameAndMnemonic(@NotNull @Nls String text, @NotNull Action action) {
        if (text == null) {
            UIUtil.$$$reportNull$$$0(53);
        }
        if (action == null) {
            UIUtil.$$$reportNull$$$0(54);
        }
        UIUtil.assignMnemonic(text, action);
        text = text.replaceAll("&", NO_BORDER_UNDER_WINDOW_TITLE_KEY);
        action.putValue("Name", text);
    }

    public static void assignMnemonic(@NotNull @Nls String text, @NotNull Action action) {
        String mnemoChar;
        int mnemoPos;
        if (text == null) {
            UIUtil.$$$reportNull$$$0(55);
        }
        if (action == null) {
            UIUtil.$$$reportNull$$$0(56);
        }
        if ((mnemoPos = text.indexOf(38)) >= 0 && mnemoPos < text.length() - 2 && (mnemoChar = text.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action.putValue("MnemonicKey", mnemoChar.charAt(0));
        }
    }

    @NotNull
    public static Font getLabelFont(@NotNull FontSize size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(57);
        }
        return UIUtil.getFont(size, null);
    }

    @NotNull
    public static Font getFont(@NotNull FontSize size, @Nullable Font base) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(58);
        }
        if (base == null) {
            base = StartupUiUtil.getLabelFont();
        }
        Font font = base.deriveFont(UIUtil.getFontSize(size));
        if (font == null) {
            UIUtil.$$$reportNull$$$0(59);
        }
        return font;
    }

    public static float getFontSize(@NotNull FontSize size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(60);
        }
        int defSize = StartupUiUtil.getLabelFont().getSize();
        switch (size) {
            case SMALL: {
                return Math.max((float)defSize - JBUIScale.scale(2.0f), JBUIScale.scale(11.0f));
            }
            case MINI: {
                return Math.max((float)defSize - JBUIScale.scale(4.0f), JBUIScale.scale(9.0f));
            }
        }
        return defSize;
    }

    @NotNull
    public static Color getLabelFontColor(@NotNull FontColor fontColor) {
        if (fontColor == null) {
            UIUtil.$$$reportNull$$$0(61);
        }
        Color defColor = UIUtil.getLabelForeground();
        if (fontColor == FontColor.BRIGHTER) {
            return new JBColor(new Color(Math.min(defColor.getRed() + 50, 255), Math.min(defColor.getGreen() + 50, 255), Math.min(defColor.getBlue() + 50, 255)), defColor.darker());
        }
        Color color = defColor;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(62);
        }
        return color;
    }

    public static int getCheckBoxTextHorizontalOffset(@NotNull JCheckBox cb) {
        if (cb == null) {
            UIUtil.$$$reportNull$$$0(63);
        }
        ButtonUI ui = cb.getUI();
        Icon buttonIcon = cb.getIcon();
        if (buttonIcon == null && ui != null && ui instanceof BasicRadioButtonUI) {
            buttonIcon = ((BasicRadioButtonUI)ui).getDefaultIcon();
        }
        return UIUtil.getButtonTextHorizontalOffset(cb, cb.getSize(new Dimension()), buttonIcon);
    }

    public static int getButtonTextHorizontalOffset(@NotNull AbstractButton button, @NotNull Dimension size, @Nullable Icon buttonIcon) {
        if (button == null) {
            UIUtil.$$$reportNull$$$0(64);
        }
        if (size == null) {
            UIUtil.$$$reportNull$$$0(65);
        }
        String text = button.getText();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = button.getInsets();
        viewRect.y = i.top;
        viewRect.width = size.width - (i.right + viewRect.x);
        viewRect.height = size.height - (i.bottom + viewRect.y);
        SwingUtilities.layoutCompoundLabel(button, button.getFontMetrics(button.getFont()), text, buttonIcon, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), viewRect, iconRect, textRect, text == null ? 0 : button.getIconTextGap());
        return textRect.x;
    }

    public static int getScrollBarWidth() {
        return UIManager.getInt("ScrollBar.width");
    }

    public static Color getLabelBackground() {
        return UIManager.getColor("Label.background");
    }

    @NotNull
    public static Color getLabelForeground() {
        JBColor jBColor = JBColor.namedColor("Label.foreground", new JBColor(Gray._0, (Color)Gray.xBB));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(66);
        }
        return jBColor;
    }

    @NotNull
    public static Color getErrorForeground() {
        JBColor jBColor = JBColor.namedColor("Label.errorForeground", new JBColor(new Color(13050413), (Color)JBColor.RED));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(67);
        }
        return jBColor;
    }

    @NotNull
    public static Color getLabelDisabledForeground() {
        JBColor jBColor = JBColor.namedColor("Label.disabledForeground", JBColor.GRAY);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(68);
        }
        return jBColor;
    }

    @NotNull
    public static Color getLabelInfoForeground() {
        JBColor jBColor = JBColor.namedColor("Label.infoForeground", new JBColor(Gray._120, (Color)Gray._135));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(69);
        }
        return jBColor;
    }

    @NotNull
    public static Color getContextHelpForeground() {
        Color color = JBUI.CurrentTheme.ContextHelp.FOREGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(70);
        }
        return color;
    }

    @Nls
    @NotNull
    public static String removeMnemonic(@Nls @NotNull String s) {
        if (s == null) {
            UIUtil.$$$reportNull$$$0(71);
        }
        String string = TextWithMnemonic.parse(s).getText();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(72);
        }
        return string;
    }

    public static int getDisplayMnemonicIndex(@NotNull String s) {
        int idx;
        if (s == null) {
            UIUtil.$$$reportNull$$$0(73);
        }
        if ((idx = s.indexOf(38)) >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(38)) {
            return idx;
        }
        idx = s.indexOf(27);
        if (idx >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(27)) {
            return idx;
        }
        return -1;
    }

    @Nls
    public static String replaceMnemonicAmpersand(@Nls String value) {
        return BundleBase.replaceMnemonicAmpersand(value);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color getTreeTextForeground() {
        return UIUtil.getTreeForeground();
    }

    @Deprecated
    @NotNull
    public static Color getTreeTextBackground() {
        return UIUtil.getTreeBackground();
    }

    public static Color getFieldForegroundColor() {
        return UIManager.getColor("field.foreground");
    }

    public static Color getActiveTextColor() {
        return UIManager.getColor("textActiveText");
    }

    @NotNull
    public static Color getInactiveTextColor() {
        JBColor jBColor = JBColor.namedColor("Component.infoForeground", new JBColor(Gray.x99, (Color)Gray.x78));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(74);
        }
        return jBColor;
    }

    public static Color getInactiveTextFieldBackgroundColor() {
        return UIManager.getColor("TextField.inactiveBackground");
    }

    public static Color getTreeSelectionBorderColor() {
        return UIManager.getColor("Tree.selectionBorderColor");
    }

    public static int getTreeRightChildIndent() {
        return UIManager.getInt("Tree.rightChildIndent");
    }

    public static int getTreeLeftChildIndent() {
        return UIManager.getInt("Tree.leftChildIndent");
    }

    @NotNull
    public static Color getToolTipBackground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.background", new JBColor(Gray.xF2, new Color(3948353)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(75);
        }
        return jBColor;
    }

    @NotNull
    public static Color getToolTipActionBackground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.Actions.background", new JBColor(Gray.xEB, new Color(4409162)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(76);
        }
        return jBColor;
    }

    @NotNull
    public static Color getToolTipForeground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.foreground", new JBColor(Gray.x00, (Color)Gray.xBF));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(77);
        }
        return jBColor;
    }

    public static Color getComboBoxDisabledForeground() {
        return UIManager.getColor("ComboBox.disabledForeground");
    }

    public static Color getComboBoxDisabledBackground() {
        return UIManager.getColor("ComboBox.disabledBackground");
    }

    public static Color getButtonSelectColor() {
        return UIManager.getColor("Button.select");
    }

    public static Integer getPropertyMaxGutterIconWidth(@NotNull String propertyPrefix) {
        if (propertyPrefix == null) {
            UIUtil.$$$reportNull$$$0(78);
        }
        return (Integer)UIManager.get(propertyPrefix + ".maxGutterIconWidth");
    }

    public static Color getMenuItemDisabledForeground() {
        return UIManager.getColor("MenuItem.disabledForeground");
    }

    public static Object getMenuItemDisabledForegroundObject() {
        return UIManager.get("MenuItem.disabledForeground");
    }

    public static Object getTabbedPanePaintContentBorder(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(79);
        }
        return c.getClientProperty("TabbedPane.paintContentBorder");
    }

    public static Color getTableGridColor() {
        return UIManager.getColor("Table.gridColor");
    }

    @NotNull
    public static Color getPanelBackground() {
        Color color = JBColor.PanelBackground;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(80);
        }
        return color;
    }

    public static Color getEditorPaneBackground() {
        return UIManager.getColor("EditorPane.background");
    }

    public static Color getTableFocusCellBackground() {
        return UIManager.getColor(TABLE_FOCUS_CELL_BACKGROUND_PROPERTY);
    }

    public static Color getTextFieldForeground() {
        return UIManager.getColor("TextField.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor("TextField.background");
    }

    public static Color getTextFieldDisabledBackground() {
        return UIManager.getColor("TextField.disabledBackground");
    }

    public static Font getButtonFont() {
        return UIManager.getFont("Button.font");
    }

    public static Font getToolTipFont() {
        return UIManager.getFont("ToolTip.font");
    }

    public static void setSliderIsFilled(@NotNull JSlider slider, boolean value) {
        if (slider == null) {
            UIUtil.$$$reportNull$$$0(81);
        }
        slider.putClientProperty(JSLIDER_ISFILLED, value);
    }

    public static Color getLabelTextForeground() {
        return UIManager.getColor("Label.textForeground");
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Font getOptionPaneMessageFont() {
        return UIManager.getFont("OptionPane.messageFont");
    }

    public static Font getMenuFont() {
        return UIManager.getFont("Menu.font");
    }

    public static Color getSeparatorShadow() {
        return UIManager.getColor("Separator.shadow");
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color getSeparatorColor() {
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(82);
        }
        return color;
    }

    public static Border getTableFocusCellHighlightBorder() {
        return UIManager.getBorder("Table.focusCellHighlightBorder");
    }

    @Deprecated
    public static void setLineStyleAngled(@NotNull JTree component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(83);
        }
    }

    public static Color getTableFocusCellForeground() {
        return UIManager.getColor("Table.focusCellForeground");
    }

    public static Border getTextFieldBorder() {
        return UIManager.getBorder("TextField.border");
    }

    @NotNull
    public static Icon getErrorIcon() {
        Icon icon2 = ObjectUtils.notNull(UIManager.getIcon("OptionPane.errorIcon"), AllIcons.General.ErrorDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(84);
        }
        return icon2;
    }

    @NotNull
    public static Icon getInformationIcon() {
        Icon icon2 = ObjectUtils.notNull(UIManager.getIcon("OptionPane.informationIcon"), AllIcons.General.InformationDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(85);
        }
        return icon2;
    }

    @NotNull
    public static Icon getQuestionIcon() {
        Icon icon2 = ObjectUtils.notNull(UIManager.getIcon("OptionPane.questionIcon"), AllIcons.General.QuestionDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(86);
        }
        return icon2;
    }

    @NotNull
    public static Icon getWarningIcon() {
        Icon icon2 = ObjectUtils.notNull(UIManager.getIcon("OptionPane.warningIcon"), AllIcons.General.WarningDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(87);
        }
        return icon2;
    }

    @NotNull
    public static Icon getBalloonInformationIcon() {
        Icon icon2 = AllIcons.General.BalloonInformation;
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(88);
        }
        return icon2;
    }

    @NotNull
    public static Icon getBalloonWarningIcon() {
        Icon icon2 = AllIcons.General.BalloonWarning;
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(89);
        }
        return icon2;
    }

    @NotNull
    public static Icon getBalloonErrorIcon() {
        Icon icon2 = AllIcons.General.BalloonError;
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(90);
        }
        return icon2;
    }

    @NotNull
    public static Icon getTreeNodeIcon(boolean expanded, boolean selected, boolean focused) {
        boolean white = selected && focused || StartupUiUtil.isUnderDarcula();
        Icon expandedDefault = UIUtil.getTreeExpandedIcon();
        Icon collapsedDefault = UIUtil.getTreeCollapsedIcon();
        Icon expandedSelected = UIUtil.getTreeSelectedExpandedIcon();
        Icon collapsedSelected = UIUtil.getTreeSelectedCollapsedIcon();
        int width = Math.max(Math.max(expandedDefault.getIconWidth(), collapsedDefault.getIconWidth()), Math.max(expandedSelected.getIconWidth(), collapsedSelected.getIconWidth()));
        int height = Math.max(Math.max(expandedDefault.getIconHeight(), collapsedDefault.getIconHeight()), Math.max(expandedSelected.getIconHeight(), collapsedSelected.getIconHeight()));
        return new CenteredIcon(!white ? (expanded ? expandedDefault : collapsedDefault) : (expanded ? expandedSelected : collapsedSelected), width, height, false);
    }

    @NotNull
    public static Icon getTreeCollapsedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.collapsedIcon");
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(91);
        }
        return icon2;
    }

    @NotNull
    public static Icon getTreeExpandedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.expandedIcon");
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(92);
        }
        return icon2;
    }

    @NotNull
    public static Icon getTreeSelectedCollapsedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.collapsedSelectedIcon");
        return icon2 != null ? icon2 : UIUtil.getTreeCollapsedIcon();
    }

    @NotNull
    public static Icon getTreeSelectedExpandedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.expandedSelectedIcon");
        return icon2 != null ? icon2 : UIUtil.getTreeExpandedIcon();
    }

    public static Color getWindowColor() {
        return UIManager.getColor("window");
    }

    public static Color getTextAreaForeground() {
        return UIManager.getColor("TextArea.foreground");
    }

    public static Color getOptionPaneBackground() {
        return UIManager.getColor("OptionPane.background");
    }

    @Deprecated(forRemoval=true)
    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfoRt.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    @Deprecated(forRemoval=true)
    public static boolean isUnderNimbusLookAndFeel() {
        return false;
    }

    public static boolean isUnderAquaBasedLookAndFeel() {
        return SystemInfoRt.isMac && (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
    }

    public static boolean isUnderDefaultMacTheme() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (SystemInfoRt.isMac && lookAndFeel instanceof UserDataHolder) {
            UserDataHolder dh = (UserDataHolder)((Object)lookAndFeel);
            return Boolean.TRUE != dh.getUserData(LAF_WITH_THEME_KEY) && Objects.equals(dh.getUserData(PLUGGABLE_LAF_KEY), "macOS Light");
        }
        return false;
    }

    public static boolean isUnderWin10LookAndFeel() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (SystemInfoRt.isWindows && lookAndFeel instanceof UserDataHolder) {
            UserDataHolder dh = (UserDataHolder)((Object)lookAndFeel);
            return Boolean.TRUE != dh.getUserData(LAF_WITH_THEME_KEY) && Objects.equals(dh.getUserData(PLUGGABLE_LAF_KEY), "Windows 10 Light");
        }
        return false;
    }

    public static boolean isUnderDarcula() {
        return StartupUiUtil.isUnderDarcula();
    }

    public static boolean isUnderIntelliJLaF() {
        return UIManager.getLookAndFeel().getName().contains("IntelliJ") || UIUtil.isUnderDefaultMacTheme() || UIUtil.isUnderWin10LookAndFeel();
    }

    @Deprecated(forRemoval=true)
    public static boolean isUnderGTKLookAndFeel() {
        return SystemInfoRt.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static boolean isGraphite() {
        if (!SystemInfoRt.isMac) {
            return false;
        }
        try {
            return Foundation.invoke("NSColor", "currentControlTint", new Object[0]).intValue() == 6;
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static Font getToolbarFont() {
        Font font = SystemInfoRt.isMac ? UIUtil.getLabelFont(FontSize.SMALL) : StartupUiUtil.getLabelFont();
        if (font == null) {
            UIUtil.$$$reportNull$$$0(93);
        }
        return font;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Color shade(@NotNull Color c, double factor, double d) {
        void alphaFactor;
        if (c == null) {
            UIUtil.$$$reportNull$$$0(94);
        }
        assert (factor >= 0.0) : factor;
        return new Color(Math.min((int)Math.round((double)c.getRed() * factor), 255), Math.min((int)Math.round((double)c.getGreen() * factor), 255), Math.min((int)Math.round((double)c.getBlue() * factor), 255), Math.min((int)Math.round((double)c.getAlpha() * alphaFactor), 255));
    }

    @NotNull
    public static Color mix(@NotNull Color c1, Color c2, double factor) {
        if (c1 == null) {
            UIUtil.$$$reportNull$$$0(95);
        }
        assert (0.0 <= factor && factor <= 1.0) : factor;
        double backFactor = 1.0 - factor;
        return new Color(Math.min((int)Math.round((double)c1.getRed() * backFactor + (double)c2.getRed() * factor), 255), Math.min((int)Math.round((double)c1.getGreen() * backFactor + (double)c2.getGreen() * factor), 255), Math.min((int)Math.round((double)c1.getBlue() * backFactor + (double)c2.getBlue() * factor), 255));
    }

    public static boolean isFullRowSelectionLAF() {
        return false;
    }

    public static boolean isUnderNativeMacLookAndFeel() {
        return StartupUiUtil.isUnderDarcula();
    }

    public static int getListCellHPadding() {
        return UIUtil.isUnderDefaultMacTheme() ? 8 : (UIUtil.isUnderWin10LookAndFeel() ? 2 : 7);
    }

    public static int getListCellVPadding() {
        return 1;
    }

    @NotNull
    public static JBInsets getRegularPanelInsets() {
        JBInsets jBInsets = JBInsets.create(8, 12);
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(96);
        }
        return jBInsets;
    }

    @NotNull
    public static Insets getListCellPadding() {
        JBInsets jBInsets = JBInsets.create(UIUtil.getListCellVPadding(), UIUtil.getListCellHPadding());
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(97);
        }
        return jBInsets;
    }

    @NotNull
    public static Insets getListViewportPadding() {
        return UIUtil.getListViewportPadding(false);
    }

    @NotNull
    public static Insets getListViewportPadding(boolean listWithAdvertiser) {
        JBInsets jBInsets = listWithAdvertiser ? new JBInsets(4, 0, 8, 0) : JBInsets.create(4, 0);
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(98);
        }
        return jBInsets;
    }

    public static boolean isToUseDottedCellBorder() {
        return !UIUtil.isUnderNativeMacLookAndFeel();
    }

    public static boolean isControlKeyDown(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            UIUtil.$$$reportNull$$$0(99);
        }
        return SystemInfoRt.isMac ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
    }

    public static String @NotNull [] getValidFontNames(boolean familyName) {
        TreeSet<String> result = new TreeSet<String>();
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            try {
                if (!FontUtil.isValidFont(font)) continue;
                result.add(familyName ? font.getFamily() : font.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Font labelFont = StartupUiUtil.getLabelFont();
        if (labelFont != null && FontUtil.isValidFont(labelFont)) {
            result.add(familyName ? labelFont.getFamily() : labelFont.getName());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            UIUtil.$$$reportNull$$$0(100);
        }
        return stringArray;
    }

    public static String @NotNull [] getStandardFontSizes() {
        if (STANDARD_FONT_SIZES == null) {
            UIUtil.$$$reportNull$$$0(101);
        }
        return STANDARD_FONT_SIZES;
    }

    public static void setupEnclosingDialogBounds(@NotNull JComponent component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(102);
        }
        component.revalidate();
        component.repaint();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != null && (window.getSize().height < window.getMinimumSize().height || window.getSize().width < window.getMinimumSize().width)) {
            window.pack();
        }
    }

    @NotNull
    public static String displayPropertiesToCSS(Font font, Color fg) {
        @NonNls StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            UIUtil.appendColor(fg, rule);
            rule.append(" ; ");
        }
        rule.append(" }");
        String string = rule.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(103);
        }
        return string;
    }

    public static void appendColor(@NotNull Color color, @NotNull StringBuilder sb) {
        if (color == null) {
            UIUtil.$$$reportNull$$$0(104);
        }
        if (sb == null) {
            UIUtil.$$$reportNull$$$0(105);
        }
        if (color.getRed() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getBlue()));
    }

    public static void drawDottedRectangle(@NotNull Graphics g, @NotNull Rectangle r) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(106);
        }
        if (r == null) {
            UIUtil.$$$reportNull$$$0(107);
        }
        UIUtil.drawDottedRectangle(g, r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public static void drawDottedRectangle(@NotNull Graphics g, int x, int y, int x1, int y1) {
        int i1;
        if (g == null) {
            UIUtil.$$$reportNull$$$0(108);
        }
        for (i1 = x; i1 <= x1; i1 += 2) {
            LinePainter2D.paint((Graphics2D)g, i1, y, (double)i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            LinePainter2D.paint((Graphics2D)g, x1, i1, (double)x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            LinePainter2D.paint((Graphics2D)g, i1, y1, (double)i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            LinePainter2D.paint((Graphics2D)g, x, i1, (double)x, i1);
        }
    }

    public static void drawBoldDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(109);
        }
        if (SystemInfoRt.isMac && !UIUtil.isRetina() || SystemInfoRt.isLinux) {
            UIUtil.drawAppleDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        } else {
            UIUtil.drawBoringDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        }
    }

    public static void drawSearchMatch(@NotNull Graphics2D g, float startX, float endX, int height) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(110);
        }
        UIUtil.drawSearchMatch(g, startX, endX, height, UIUtil.getSearchMatchGradientStartColor(), UIUtil.getSearchMatchGradientEndColor());
    }

    @NotNull
    public static JBColor getSearchMatchGradientStartColor() {
        JBColor jBColor = JBColor.namedColor("SearchMatch.startBackground", JBColor.namedColor("SearchMatch.startColor", new Color(-1275073886, true)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(111);
        }
        return jBColor;
    }

    @NotNull
    public static JBColor getSearchMatchGradientEndColor() {
        JBColor jBColor = JBColor.namedColor("SearchMatch.endBackground", JBColor.namedColor("SearchMatch.endColor", new Color(-1275080638, true)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(112);
        }
        return jBColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawSearchMatch(@NotNull Graphics2D g, float startXf, float endXf, int height, Color c1, Color c2) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(113);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setPaint(UIUtil.getGradientPaint(startXf, 2.0f, c1, startXf, height - 5, c2));
            if (JreHiDpiUtil.isJreHiDPI(g2)) {
                GraphicsUtil.setupRoundedBorderAntialiasing(g2);
                g2.fill(new RoundRectangle2D.Float(startXf, 2.0f, endXf - startXf, height - 4, 5.0f, 5.0f));
            } else {
                boolean drawRound;
                int startX = (int)startXf;
                int endX = (int)endXf;
                g2.fillRect(startX, 3, endX - startX, height - 5);
                boolean bl = drawRound = endXf - startXf > 4.0f;
                if (drawRound) {
                    LinePainter2D.paint(g2, startX - 1, 4.0, (double)(startX - 1), height - 4);
                    LinePainter2D.paint(g2, endX, 4.0, (double)endX, height - 4);
                    g2.setColor(new Color(100, 100, 100, 50));
                    LinePainter2D.paint(g2, startX - 1, 4.0, (double)(startX - 1), height - 4);
                    LinePainter2D.paint(g2, endX, 4.0, (double)endX, height - 4);
                    LinePainter2D.paint(g2, startX, 3.0, (double)(endX - 1), 3.0);
                    LinePainter2D.paint(g2, startX, height - 3, (double)(endX - 1), height - 3);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    private static void drawBoringDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(114);
        }
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
            LinePainter2D.paint(g, startX, lineY + 1, (double)endX, lineY + 1);
        }
        int step = 4;
        int startPosCorrection = startX % 4 < 3 ? 0 : 1;
        g.setColor(fgColor != null ? fgColor : oldColor);
        for (int dotXi = (startX / 4 + startPosCorrection) * 4; dotXi < endX; dotXi += 4) {
            LinePainter2D.paint(g, dotXi, lineY, (double)(dotXi + 1), lineY);
            LinePainter2D.paint(g, dotXi, lineY + 1, (double)(dotXi + 1), lineY + 1);
        }
        g.setColor(oldColor);
    }

    public static void drawGradientHToolbarBackground(@NotNull Graphics g, int width, int height) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(115);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._215, 0.0f, height, Gray._200));
        g2d.fillRect(0, 0, width, height);
    }

    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean drawTopLine) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(116);
        }
        UIUtil.drawHeader(g, x, width, height, active, false, drawTopLine, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean toolWindow, boolean drawTopLine, boolean drawBottomLine) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(117);
        }
        GraphicsConfig config = GraphicsUtil.disableAAPainting(g);
        try {
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBackground(active));
            g.fillRect(x, 0, width, height);
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBorderBackground());
            if (drawTopLine) {
                LinePainter2D.paint((Graphics2D)g, x, 0.0, (double)width, 0.0);
            }
            if (drawBottomLine) {
                LinePainter2D.paint((Graphics2D)g, x, height - 1, (double)width, height - 1);
            }
        }
        finally {
            config.restore();
        }
    }

    public static void drawDoubleSpaceDottedLine(@NotNull Graphics2D g, int start, int end, int xOrY, Color fgColor, boolean horizontal) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(118);
        }
        g.setColor(fgColor);
        for (int dot = start; dot < end; dot += 3) {
            if (horizontal) {
                LinePainter2D.paint(g, dot, xOrY, (double)dot, xOrY);
                continue;
            }
            LinePainter2D.paint(g, xOrY, dot, (double)xOrY, dot);
        }
    }

    private static void drawAppleDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(119);
        }
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
            LinePainter2D.paint(g, startX, lineY + 1, (double)endX, lineY + 1);
            LinePainter2D.paint(g, startX, lineY + 2, (double)endX, lineY + 2);
        }
        AppleBoldDottedPainter painter = AppleBoldDottedPainter.forColor(ObjectUtils.notNull(fgColor, oldColor));
        painter.paint(g, startX, endX, lineY);
    }

    @Deprecated(forRemoval=true)
    public static void applyRenderingHints(@NotNull Graphics g) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(120);
        }
        GraphicsUtil.applyRenderingHints((Graphics2D)g);
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImage(int width, int height, int type2) {
        BufferedImage bufferedImage = ImageUtil.createImage(width, height, type2);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(121);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(GraphicsConfiguration gc, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type2;
        if (roundingMode == null) {
            UIUtil.$$$reportNull$$$0(122);
        }
        if (JreHiDpiUtil.isJreHiDPI(gc)) {
            BufferedImage bufferedImage = RetinaImage.create(gc, width, height, (int)type2, (PaintUtil.RoundingMode)rm);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(123);
            }
            return bufferedImage;
        }
        return new BufferedImage(rm.round(width), rm.round(height), (int)type2);
    }

    @NotNull
    public static BufferedImage createImage(@Nullable Component component, int width, int height, int type2) {
        BufferedImage bufferedImage = ImageUtil.createImage(component == null ? null : component.getGraphicsConfiguration(), width, height, type2);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(124);
        }
        return bufferedImage;
    }

    public static void setupComposite(@NotNull Graphics2D g) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(125);
        }
        g.setComposite(X_RENDER_ACTIVE.getValue() != false ? AlphaComposite.SrcOver : AlphaComposite.Src);
    }

    @TestOnly
    public static void dispatchAllInvocationEvents() {
        EdtInvocationManager.dispatchAllInvocationEvents();
    }

    /*
     * WARNING - void declaration
     */
    public static void addAwtListener(@NotNull AWTEventListener listener, long mask, @NotNull Disposable disposable) {
        void parent;
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(126);
        }
        if (disposable == null) {
            UIUtil.$$$reportNull$$$0(127);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, mask);
        Disposer.register((Disposable)parent, () -> Toolkit.getDefaultToolkit().removeAWTEventListener(listener));
    }

    public static void addParentChangeListener(@NotNull Component component, @NotNull PropertyChangeListener listener) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(128);
        }
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(129);
        }
        component.addPropertyChangeListener("ancestor", listener);
    }

    public static void removeParentChangeListener(@NotNull Component component, @NotNull PropertyChangeListener listener) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(130);
        }
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(131);
        }
        component.removePropertyChangeListener("ancestor", listener);
    }

    public static void drawVDottedLine(@NotNull Graphics2D g, int lineX, int startY, int endY, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(132);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, lineX, startY, (double)lineX, endY);
        }
        g.setColor(fgColor);
        for (int i = startY / 2 * 2; i < endY; i += 2) {
            g.drawRect(lineX, i, 0, 0);
        }
    }

    public static void drawHDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(133);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
        }
        g.setColor(fgColor);
        for (int i = startX / 2 * 2; i < endX; i += 2) {
            g.drawRect(i, lineY, 0, 0);
        }
    }

    public static void drawDottedLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(134);
        }
        if (x1 == x2) {
            UIUtil.drawVDottedLine(g, x1, y1, y2, bgColor, fgColor);
        } else if (y1 == y2) {
            UIUtil.drawHDottedLine(g, x1, x2, y1, bgColor, fgColor);
        } else {
            throw new IllegalArgumentException("Only vertical or horizontal lines are supported");
        }
    }

    public static void drawStringWithHighlighting(@NotNull Graphics g, @NotNull String s, int x, int y, Color foreground, Color highlighting) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(135);
        }
        if (s == null) {
            UIUtil.$$$reportNull$$$0(136);
        }
        g.setColor(highlighting);
        boolean isRetina = JreHiDpiUtil.isJreHiDPI((Graphics2D)g);
        float scale = 1.0f / JBUIScale.sysScale((Graphics2D)g);
        for (float i = (float)(x - 1); i <= (float)(x + 1); i += isRetina ? scale : 1.0f) {
            for (float j = (float)(y - 1); j <= (float)(y + 1); j += isRetina ? scale : 1.0f) {
                ((Graphics2D)g).drawString(s, i, j);
            }
        }
        g.setColor(foreground);
        g.drawString(s, x, y);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect, @NotNull String str, boolean horzCentered, boolean vertCentered) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(137);
        }
        if (rect == null) {
            UIUtil.$$$reportNull$$$0(138);
        }
        if (str == null) {
            UIUtil.$$$reportNull$$$0(139);
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int textWidth = fm.stringWidth(str) - 1;
        int x = horzCentered ? Math.max(rect.x, rect.x + (rect.width - textWidth) / 2) : rect.x;
        int y = vertCentered ? Math.max(rect.y, rect.y + rect.height / 2 + fm.getAscent() * 2 / 5) : rect.y;
        Shape oldClip = g.getClip();
        g.clip(rect);
        g.drawString(str, x, y);
        g.setClip(oldClip);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect, @NotNull String str) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(140);
        }
        if (rect == null) {
            UIUtil.$$$reportNull$$$0(141);
        }
        if (str == null) {
            UIUtil.$$$reportNull$$$0(142);
        }
        UIUtil.drawCenteredString(g, rect, str, true, true);
    }

    public static boolean isFocusAncestor(@NotNull Component component) {
        Component owner;
        if (component == null) {
            UIUtil.$$$reportNull$$$0(143);
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            return false;
        }
        if (SwingUtilities.isDescendingFrom(owner, component)) {
            return true;
        }
        while (component != null) {
            if (UIUtil.hasFocus(component)) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    @ApiStatus.Experimental
    public static boolean hasFocus(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(144);
        }
        if (GraphicsEnvironment.isHeadless() || component.hasFocus()) {
            return true;
        }
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        return jComponent != null && Boolean.TRUE.equals(jComponent.getClientProperty(HAS_FOCUS));
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void markAsFocused(@NotNull JComponent component, boolean value) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(145);
        }
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        component.putClientProperty(HAS_FOCUS, value ? Boolean.TRUE : null);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(146);
        }
        return UIUtil.isCloseClick(e, 501);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e, int effectiveType) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(147);
        }
        if (e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 2 || e.getButton() == 1 && e.isShiftDown();
    }

    public static boolean isActionClick(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(148);
        }
        return UIUtil.isActionClick(e, 501);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(149);
        }
        return UIUtil.isActionClick(e, effectiveType, false);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType, boolean allowShift) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(150);
        }
        if (!allowShift && UIUtil.isCloseClick(e) || e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 1;
    }

    @NotNull
    public static Color getBgFillColor(@NotNull Component c) {
        Component parent;
        if (c == null) {
            UIUtil.$$$reportNull$$$0(151);
        }
        Color color = (parent = UIUtil.findNearestOpaque(c)) == null ? c.getBackground() : parent.getBackground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(152);
        }
        return color;
    }

    @Nullable
    public static Component findNearestOpaque(Component c) {
        return ComponentUtil.findParentByCondition(c, Component::isOpaque);
    }

    @Deprecated(forRemoval=true)
    public static Component findParentByCondition(@Nullable Component c, @NotNull Condition<? super Component> condition) {
        if (condition == null) {
            UIUtil.$$$reportNull$$$0(153);
        }
        return ComponentUtil.findParentByCondition(c, (? super Component it) -> condition.value((Component)it));
    }

    @Nullable
    public static Component getDeepestComponentAt(@NotNull Component parent, int x, int y) {
        Component[] components;
        JRootPane rootPane;
        Component component;
        if (parent == null) {
            UIUtil.$$$reportNull$$$0(154);
        }
        if ((component = SwingUtilities.getDeepestComponentAt(parent, x, y)) != null && component.getParent() instanceof JRootPane && (component = UIUtil.getDeepestComponentAtForComponent(parent, x, y, (rootPane = (JRootPane)component.getParent()).getLayeredPane())) == null) {
            component = UIUtil.getDeepestComponentAtForComponent(parent, x, y, rootPane.getContentPane());
        }
        if (component != null && component.getParent() instanceof JLayeredPane && (components = ((JLayeredPane)component.getParent()).getComponentsInLayer(JLayeredPane.DEFAULT_LAYER)).length == 1 && ArrayUtilRt.indexOf(components, component, 0, components.length) == -1) {
            component = UIUtil.getDeepestComponentAtForComponent(parent, x, y, components[0]);
        }
        return component;
    }

    private static Component getDeepestComponentAtForComponent(@NotNull Component parent, int x, int y, @NotNull Component component) {
        if (parent == null) {
            UIUtil.$$$reportNull$$$0(155);
        }
        if (component == null) {
            UIUtil.$$$reportNull$$$0(156);
        }
        Point point = SwingUtilities.convertPoint(parent, new Point(x, y), component);
        return SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
    }

    public static void layoutRecursively(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(157);
        }
        if (!(component instanceof JComponent)) {
            return;
        }
        UIUtil.forEachComponentInHierarchy(component, Component::doLayout);
    }

    @Language(value="HTML")
    @NlsSafe
    @NotNull
    public static String getCssFontDeclaration(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(158);
        }
        return UIUtil.getCssFontDeclaration(font, UIUtil.getLabelForeground(), JBUI.CurrentTheme.Link.Foreground.ENABLED, null);
    }

    @Language(value="HTML")
    @NlsSafe
    @NotNull
    public static String getCssFontDeclaration(@NotNull Font font, @Nullable Color fgColor, @Nullable Color linkColor, @Nullable String liImg) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(159);
        }
        String familyAndSize = "font-family:'" + font.getFamily() + "'; font-size:" + font.getSize() + "pt;";
        String string = "<style>\nbody, div, td, p {" + familyAndSize + (String)(fgColor != null ? " color:#" + ColorUtil.toHex(fgColor) + ";" : NO_BORDER_UNDER_WINDOW_TITLE_KEY) + "}\na {" + familyAndSize + (String)(linkColor != null ? " color:#" + ColorUtil.toHex(linkColor) + ";" : NO_BORDER_UNDER_WINDOW_TITLE_KEY) + "}\ncode {font-size:" + font.getSize() + "pt;}\nul {list-style:disc; margin-left:15px;}\n</style>";
        if (string == null) {
            UIUtil.$$$reportNull$$$0(160);
        }
        return string;
    }

    @NotNull
    public static Color getFocusedFillColor() {
        return UIUtil.toAlpha(UIUtil.getListSelectionBackground(true), 100);
    }

    @NotNull
    public static Color getFocusedBoundsColor() {
        return UIUtil.getBoundsColor();
    }

    @NotNull
    public static Color getBoundsColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(161);
        }
        return color;
    }

    @NotNull
    public static Color getBoundsColor(boolean focused) {
        return focused ? UIUtil.getFocusedBoundsColor() : UIUtil.getBoundsColor();
    }

    @NotNull
    public static Color toAlpha(Color color, int alpha) {
        Color actual = color != null ? color : Color.black;
        return new Color(actual.getRed(), actual.getGreen(), actual.getBlue(), alpha);
    }

    public static boolean isFocusable(@Nullable Component component) {
        return component != null && component.isFocusable() && component.isEnabled() && component.isShowing();
    }

    @Deprecated
    public static void requestFocus(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(162);
        }
        if (c.isShowing()) {
            c.requestFocus();
        } else {
            SwingUtilities.invokeLater(c::requestFocus);
        }
    }

    public static boolean canDisplayFocusedState(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(163);
        }
        return component instanceof JTextComponent || component instanceof AbstractButton || component instanceof JComboBox;
    }

    public static void dispose(Component c) {
        MouseWheelListener[] mouseWheelListeners;
        MouseMotionListener[] motionListeners;
        MouseListener[] mouseListeners;
        if (c == null) {
            return;
        }
        for (MouseListener each : mouseListeners = c.getMouseListeners()) {
            c.removeMouseListener(each);
        }
        for (MouseMotionListener each : motionListeners = c.getMouseMotionListeners()) {
            c.removeMouseMotionListener(each);
        }
        for (MouseWheelListener each : mouseWheelListeners = c.getMouseWheelListeners()) {
            c.removeMouseWheelListener(each);
        }
        if (c instanceof AbstractButton) {
            ActionListener[] listeners;
            for (ActionListener listener : listeners = ((AbstractButton)c).getActionListeners()) {
                ((AbstractButton)c).removeActionListener(listener);
            }
        }
    }

    public static void disposeProgress(@NotNull JProgressBar progress) {
        if (progress == null) {
            UIUtil.$$$reportNull$$$0(164);
        }
        if (!UIUtil.isUnderNativeMacLookAndFeel()) {
            return;
        }
        SwingUtilities.invokeLater(() -> progress.setUI(null));
    }

    @Nullable
    public static Component findUltimateParent(@Nullable Component c) {
        return c == null ? null : ComponentUtil.findUltimateParent(c);
    }

    @NotNull
    public static Color getHeaderActiveColor() {
        Color color = ACTIVE_HEADER_COLOR;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(165);
        }
        return color;
    }

    @NotNull
    public static Color getFocusedBorderColor() {
        Color color = JBUI.CurrentTheme.Focus.focusColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(166);
        }
        return color;
    }

    @NotNull
    public static Color getHeaderInactiveColor() {
        Color color = INACTIVE_HEADER_COLOR;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(167);
        }
        return color;
    }

    @NotNull
    public static Font getTitledBorderFont() {
        Font font = StartupUiUtil.getLabelFont();
        if (font == null) {
            UIUtil.$$$reportNull$$$0(168);
        }
        return font;
    }

    @Deprecated
    @Nullable
    public static StyleSheet loadStyleSheet(@Nullable URL url) {
        return url == null ? null : StyleSheetUtil.INSTANCE.loadStyleSheet(url);
    }

    @Deprecated
    @NotNull
    public static HTMLEditorKit getHTMLEditorKit() {
        HTMLEditorKit hTMLEditorKit = HTMLEditorKitBuilder.simple();
        if (hTMLEditorKit == null) {
            UIUtil.$$$reportNull$$$0(169);
        }
        return hTMLEditorKit;
    }

    @Deprecated
    @NotNull
    public static HTMLEditorKit getHTMLEditorKit(boolean noGapsBetweenParagraphs) {
        HTMLEditorKitBuilder builder = new HTMLEditorKitBuilder();
        if (!noGapsBetweenParagraphs) {
            builder.withGapsBetweenParagraphs();
        }
        HTMLEditorKit hTMLEditorKit = builder.build();
        if (hTMLEditorKit == null) {
            UIUtil.$$$reportNull$$$0(170);
        }
        return hTMLEditorKit;
    }

    @NotNull
    public static Font getFontWithFallbackIfNeeded(@NotNull Font font, @NotNull String text) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(171);
        }
        if (text == null) {
            UIUtil.$$$reportNull$$$0(172);
        }
        if (!SystemInfoRt.isMac && font.canDisplayUpTo(text) != -1) {
            return UIUtil.getFontWithFallback(font);
        }
        Font font2 = font;
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(173);
        }
        return font2;
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(174);
        }
        if (!SystemInfoRt.isMac) {
            try {
                if (!FontUtilities.fontSupportsDefaultEncoding(font)) {
                    font = FontUtilities.getCompositeFontUIResource(font);
                }
            }
            catch (Throwable e) {
                UIUtil.getLogger().warn(e);
                FontUIResource fontUIResource = StartupUiUtil.getFontWithFallback(font.getFamily(), font.getStyle(), font.getSize());
                if (fontUIResource == null) {
                    UIUtil.$$$reportNull$$$0(175);
                }
                return fontUIResource;
            }
        }
        return font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, int size) {
        FontUIResource fontUIResource = StartupUiUtil.getFontWithFallback(familyName, style, size);
        if (fontUIResource == null) {
            UIUtil.$$$reportNull$$$0(176);
        }
        return fontUIResource;
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, float size) {
        FontUIResource fontUIResource = StartupUiUtil.getFontWithFallback(familyName, style, size);
        if (fontUIResource == null) {
            UIUtil.$$$reportNull$$$0(177);
        }
        return fontUIResource;
    }

    public static <T> T htmlInjectionGuard(T toRender) {
        if (toRender instanceof String && StringUtil.toLowerCase((String)toRender).startsWith("<html>")) {
            return (T)("<html>" + StringUtil.escapeXmlEntities((String)toRender));
        }
        return toRender;
    }

    @Deprecated
    public static void removeScrollBorder(Component c) {
        JBIterable<JScrollPane> scrollPanes = ((JBTreeTraverser)UIUtil.uiTraverser(c).expand(o -> o == c || o instanceof JPanel || o instanceof JLayeredPane)).filter(JScrollPane.class);
        for (JScrollPane scrollPane : scrollPanes) {
            Integer keepBorderSides = ClientProperty.get((Component)scrollPane, KEEP_BORDER_SIDES);
            if (keepBorderSides != null) {
                if (scrollPane.getBorder() instanceof LineBorder) {
                    Color color = ((LineBorder)scrollPane.getBorder()).getLineColor();
                    scrollPane.setBorder(new SideBorder(color, keepBorderSides));
                    continue;
                }
                scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), keepBorderSides));
                continue;
            }
            scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), 0));
        }
    }

    @NotNull
    @NlsSafe
    public static String toHtml(@NotNull @Nls String html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(178);
        }
        return UIUtil.toHtml(html, 0);
    }

    @NotNull
    @NlsSafe
    public static String toHtml(@NotNull @Nls String html, int hPadding) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(179);
        }
        @NlsSafe String withClosedTag = CLOSE_TAG_PATTERN.matcher(html).replaceAll("<$1$2></$1>");
        Font font = StartupUiUtil.getLabelFont();
        @NonNls String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : JBUIScale.scale(11);
        String string = "<html><style>body { font-family: " + family + "; font-size: " + size + ";} ul li {list-style-type:circle;}</style>" + UIUtil.addPadding(withClosedTag, hPadding) + "</html>";
        if (string == null) {
            UIUtil.$$$reportNull$$$0(180);
        }
        return string;
    }

    @NotNull
    public static String addPadding(@NotNull String html, int hPadding) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(181);
        }
        String string = String.format("<p style=\"margin: 0 %dpx 0 %dpx;\">%s</p>", hPadding, hPadding, html);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(182);
        }
        return string;
    }

    @NotNull
    public static String convertSpace2Nbsp(@NotNull String html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(183);
        }
        @NonNls StringBuilder result = new StringBuilder();
        int braces = 0;
        for (int currentPos = 0; currentPos < html.length(); ++currentPos) {
            String each = html.substring(currentPos, currentPos + 1);
            if ("<".equals(each)) {
                ++braces;
            } else if (">".equals(each)) {
                --braces;
            }
            if (" ".equals(each) && braces == 0) {
                result.append("&nbsp;");
                continue;
            }
            result.append(each);
        }
        String string = result.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(184);
        }
        return string;
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(185);
        }
        EdtInvocationManager.invokeLaterIfNeeded(runnable);
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(186);
        }
        EdtInvocationManager.invokeAndWaitIfNeeded(runnable);
    }

    public static <T> T invokeAndWaitIfNeeded(@NotNull Computable<T> computable) {
        if (computable == null) {
            UIUtil.$$$reportNull$$$0(187);
        }
        Ref result = Ref.create();
        UIUtil.invokeAndWaitIfNeeded(() -> result.set(computable.compute()));
        return result.get();
    }

    public static void invokeAndWaitIfNeeded(@NotNull ThrowableRunnable<?> runnable) throws Throwable {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(188);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            Ref ref = Ref.create();
            EdtInvocationManager.getInstance().invokeAndWait(() -> {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    ref.set(throwable);
                }
            });
            if (!ref.isNull()) {
                throw (Throwable)ref.get();
            }
        }
    }

    public static boolean isFocusProxy(@Nullable Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(FOCUS_PROXY_KEY));
    }

    public static void maybeInstall(@NotNull InputMap map, String action, KeyStroke stroke) {
        if (map == null) {
            UIUtil.$$$reportNull$$$0(189);
        }
        if (map.get(stroke) == null) {
            map.put(stroke, action);
        }
    }

    public static void changeBackGround(@NotNull Component component, Color background) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(190);
        }
        Color oldBackGround = component.getBackground();
        if (background == null || !background.equals(oldBackGround)) {
            component.setBackground(background);
        }
    }

    @Nullable
    public static ComboPopup getComboBoxPopup(@NotNull JComboBox<?> comboBox) {
        ComboBoxUI ui;
        if (comboBox == null) {
            UIUtil.$$$reportNull$$$0(191);
        }
        if ((ui = comboBox.getUI()) instanceof BasicComboBoxUI) {
            return ReflectionUtil.getField(BasicComboBoxUI.class, ui, ComboPopup.class, "popup");
        }
        return null;
    }

    public static void fixFormattedField(@NotNull JFormattedTextField field) {
        if (field == null) {
            UIUtil.$$$reportNull$$$0(192);
        }
        if (SystemInfoRt.isMac) {
            int commandKeyMask;
            try {
                commandKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
            catch (HeadlessException e) {
                return;
            }
            InputMap inputMap = field.getInputMap();
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, commandKeyMask);
            inputMap.put(copyKeyStroke, "copy-to-clipboard");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, commandKeyMask);
            inputMap.put(pasteKeyStroke, "paste-from-clipboard");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, commandKeyMask);
            inputMap.put(cutKeyStroke, "cut-to-clipboard");
        }
    }

    public static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    public static int getSelectedButton(@NotNull ButtonGroup group) {
        if (group == null) {
            UIUtil.$$$reportNull$$$0(193);
        }
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (group.isSelected(button.getModel())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setSelectedButton(@NotNull ButtonGroup group, int index) {
        if (group == null) {
            UIUtil.$$$reportNull$$$0(194);
        }
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            group.setSelected(button.getModel(), index == i);
            ++i;
        }
    }

    public static boolean isSelectionButtonDown(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(195);
        }
        return e.isShiftDown() || e.isControlDown() || e.isMetaDown();
    }

    public static boolean isToggleListSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(196);
        }
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfoRt.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    public static void setComboBoxEditorBounds(int x, int y, int width, int height, @NotNull JComponent editor) {
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(197);
        }
        editor.reshape(x, y, width, height);
    }

    public static boolean isDescendingFrom(@Nullable Component child, @NotNull Component parent) {
        if (parent == null) {
            UIUtil.$$$reportNull$$$0(198);
        }
        while (child != null && child != parent) {
            child = child instanceof JPopupMenu ? ((JPopupMenu)child).getInvoker() : child.getParent();
        }
        return child == parent;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T getParentOfType(@NotNull Class<? extends T> type2, Component component) {
        if (type2 == null) {
            UIUtil.$$$reportNull$$$0(199);
        }
        return ComponentUtil.getParentOfType(type2, component);
    }

    @NotNull
    public static JBIterable<Component> uiParents(@Nullable Component c, boolean strict) {
        JBIterable<Component> jBIterable = strict ? JBIterable.generate(c, c1 -> c1.getParent()).skip(1) : JBIterable.generate(c, c1 -> c1.getParent());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(200);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component) {
        if (!(component instanceof Container)) {
            JBIterable<Component> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                UIUtil.$$$reportNull$$$0(201);
            }
            return jBIterable;
        }
        Container container = (Container)component;
        JBIterable<Component> jBIterable = JBIterable.of(container.getComponents());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(202);
        }
        return jBIterable;
    }

    @NotNull
    public static JBTreeTraverser<Component> uiTraverser(@Nullable Component component) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)UI_TRAVERSER.withRoot(component)).expandAndFilter(o -> !(o instanceof CellRendererPane));
        if (jBTreeTraverser == null) {
            UIUtil.$$$reportNull$$$0(203);
        }
        return jBTreeTraverser;
    }

    public static void scrollListToVisibleIfNeeded(@NotNull JList<?> list) {
        if (list == null) {
            UIUtil.$$$reportNull$$$0(204);
        }
        SwingUtilities.invokeLater(() -> {
            Rectangle cellBounds;
            Rectangle visibleRect;
            int selectedIndex = list.getSelectedIndex();
            if (selectedIndex >= 0 && !(visibleRect = list.getVisibleRect()).contains(cellBounds = list.getCellBounds(selectedIndex, selectedIndex))) {
                list.scrollRectToVisible(cellBounds);
            }
        });
    }

    @Nullable
    public static <T extends JComponent> T findComponentOfType(JComponent parent, Class<T> cls) {
        if (parent == null || cls.isInstance(parent)) {
            return (T)((JComponent)cls.cast(parent));
        }
        for (Component component : parent.getComponents()) {
            T comp;
            if (!(component instanceof JComponent) || (comp = UIUtil.findComponentOfType((JComponent)component, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    @NotNull
    public static <T extends JComponent> List<T> findComponentsOfType(JComponent parent, @NotNull Class<? extends T> cls) {
        if (cls == null) {
            UIUtil.$$$reportNull$$$0(205);
        }
        List<? extends T> list = ComponentUtil.findComponentsOfType(parent, cls);
        if (list == null) {
            UIUtil.$$$reportNull$$$0(206);
        }
        return list;
    }

    @Nullable
    public static JRootPane getRootPane(Component c) {
        JRootPane root = ComponentUtil.getParentOfType(JRootPane.class, c);
        if (root != null) {
            return root;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            WeakReference pane;
            if (!(eachParent instanceof JComponent) || (pane = (WeakReference)((JComponent)eachParent).getClientProperty(ROOT_PANE)) == null) continue;
            return (JRootPane)pane.get();
        }
        return null;
    }

    public static void setFutureRootPane(@NotNull JComponent c, @NotNull JRootPane pane) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(207);
        }
        if (pane == null) {
            UIUtil.$$$reportNull$$$0(208);
        }
        c.putClientProperty(ROOT_PANE, new WeakReference<JRootPane>(pane));
    }

    public static boolean isMeaninglessFocusOwner(@Nullable Component c) {
        if (c == null || !c.isShowing()) {
            return true;
        }
        return c instanceof JFrame || c instanceof JDialog || c instanceof JWindow || c instanceof JRootPane || UIUtil.isFocusProxy(c);
    }

    public static boolean isDialogRootPane(JRootPane rootPane) {
        if (rootPane != null) {
            Object isDialog = rootPane.getClientProperty("DIALOG_ROOT_PANE");
            return isDialog instanceof Boolean && (Boolean)isDialog != false;
        }
        return false;
    }

    public static void runWhenVisibilityChanged(@NotNull Component component, final Runnable runnable) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(209);
        }
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                runnable.run();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                runnable.run();
            }
        });
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(PanelWithAnchor ... panels) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(210);
        }
        return UIUtil.mergeComponentsWithAnchor(Arrays.asList(panels));
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(@NotNull Collection<? extends PanelWithAnchor> panels) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(211);
        }
        return UIUtil.mergeComponentsWithAnchor(panels, false);
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(@NotNull Collection<? extends PanelWithAnchor> panels, boolean visibleOnly) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(212);
        }
        JComponent maxWidthAnchor = null;
        int maxWidth = 0;
        for (PanelWithAnchor panelWithAnchor : panels) {
            JComponent anchor;
            if (visibleOnly && panelWithAnchor instanceof JComponent && !((JComponent)((Object)panelWithAnchor)).isVisible() || (anchor = panelWithAnchor != null ? panelWithAnchor.getOwnAnchor() : null) == null) continue;
            panelWithAnchor.setAnchor(null);
            int anchorWidth = anchor.getPreferredSize().width;
            if (maxWidth >= anchorWidth) continue;
            maxWidth = anchorWidth;
            maxWidthAnchor = anchor;
        }
        for (PanelWithAnchor panelWithAnchor : panels) {
            if (panelWithAnchor == null) continue;
            panelWithAnchor.setAnchor(maxWidthAnchor);
            if (!(panelWithAnchor instanceof JComponent)) continue;
            ((JComponent)((Object)panelWithAnchor)).revalidate();
            ((JComponent)((Object)panelWithAnchor)).repaint();
        }
        return maxWidthAnchor;
    }

    public static void setNotOpaqueRecursively(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(213);
        }
        UIUtil.setOpaqueRecursively(component, false);
    }

    public static void setOpaqueRecursively(@NotNull Component component, boolean opaque) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(214);
        }
        if (!(component instanceof JComponent)) {
            return;
        }
        UIUtil.forEachComponentInHierarchy(component, c -> {
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(opaque);
            }
        });
    }

    public static void setEnabledRecursively(@NotNull Component component, boolean enabled) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(215);
        }
        UIUtil.forEachComponentInHierarchy(component, c -> c.setEnabled(enabled));
    }

    public static void setBackgroundRecursively(@NotNull Component component, @NotNull Color bg) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(216);
        }
        if (bg == null) {
            UIUtil.$$$reportNull$$$0(217);
        }
        UIUtil.forEachComponentInHierarchy(component, c -> c.setBackground(bg));
    }

    public static void setForegroundRecursively(@NotNull Component component, @NotNull Color bg) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(218);
        }
        if (bg == null) {
            UIUtil.$$$reportNull$$$0(219);
        }
        UIUtil.forEachComponentInHierarchy(component, c -> c.setForeground(bg));
    }

    public static void forEachComponentInHierarchy(@NotNull Component component, @NotNull Consumer<? super Component> action) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(220);
        }
        if (action == null) {
            UIUtil.$$$reportNull$$$0(221);
        }
        action.consume(component);
        if (component instanceof Container) {
            for (Component c : ((Container)component).getComponents()) {
                UIUtil.forEachComponentInHierarchy(c, action);
            }
        }
    }

    public static void addInsets(@NotNull JComponent component, int top, int left, int bottom, int right) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(222);
        }
        UIUtil.addBorder(component, BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    public static void addInsets(@NotNull JComponent component, @NotNull Insets insets) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(223);
        }
        if (insets == null) {
            UIUtil.$$$reportNull$$$0(224);
        }
        UIUtil.addInsets(component, insets.top, insets.left, insets.bottom, insets.right);
    }

    public static void adjustWindowToMinimumSize(Window window) {
        if (window == null) {
            return;
        }
        Dimension minSize = window.getMinimumSize();
        Dimension size = window.getSize();
        Dimension newSize = new Dimension(Math.max(size.width, minSize.width), Math.max(size.height, minSize.height));
        if (!newSize.equals(size)) {
            SwingUtilities.invokeLater(() -> {
                if (window.isShowing()) {
                    window.setSize(newSize);
                }
            });
        }
    }

    public static int getLcdContrastValue() {
        int lcdContrastValue;
        int n = lcdContrastValue = LoadingState.APP_STARTED.isOccurred() ? Registry.intValue("lcd.contrast.value", 0) : 0;
        if (lcdContrastValue == 0) {
            return StartupUiUtil.doGetLcdContrastValueForSplash(StartupUiUtil.isUnderDarcula());
        }
        return StartupUiUtil.normalizeLcdContrastValue(lcdContrastValue);
    }

    public static void addBorder(JComponent component, Border border) {
        if (component != null && border != null) {
            Border old = component.getBorder();
            if (old != null) {
                border = BorderFactory.createCompoundBorder(border, old);
            }
            component.setBorder(border);
        }
    }

    @NotNull
    public static Color getDecoratedRowColor() {
        JBColor jBColor = JBColor.namedColor("Table.stripeColor", DECORATED_ROW_BG_COLOR);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(225);
        }
        return jBColor;
    }

    @NotNull
    public static Paint getGradientPaint(float x1, float y1, @NotNull Color c1, float x2, float y2, @NotNull Color c2) {
        if (c1 == null) {
            UIUtil.$$$reportNull$$$0(226);
        }
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(227);
        }
        return Registry.is("ui.no.bangs.and.whistles", false) ? ColorUtil.mix(c1, c2, 0.5) : new GradientPaint(x1, y1, c1, x2, y2, c2);
    }

    @Nullable
    public static Point getLocationOnScreen(@NotNull JComponent component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(228);
        }
        int dx = 0;
        int dy = 0;
        for (Container c = component; c != null; c = c.getParent()) {
            if (c.isShowing()) {
                Point locationOnScreen = c.getLocationOnScreen();
                locationOnScreen.translate(dx, dy);
                return locationOnScreen;
            }
            Point location = c.getLocation();
            dx += location.x;
            dy += location.y;
        }
        return null;
    }

    public static void setAutoRequestFocus(@NotNull Window window, boolean value) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(229);
        }
        if (!SystemInfoRt.isMac) {
            window.setAutoRequestFocus(value);
        }
    }

    public static void runWhenWindowOpened(@NotNull Window window, final @NotNull Runnable runnable) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(230);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(231);
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable.run();
            }
        });
    }

    public static void runWhenWindowClosed(@NotNull Window window, final @NotNull Runnable runnable) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(232);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(233);
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable.run();
            }
        });
    }

    @NotNull
    public static String getDebugText(@NotNull Component c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(234);
        }
        StringBuilder builder = new StringBuilder();
        UIUtil.getAllTextsRecursively(c, builder);
        String string = builder.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(235);
        }
        return string;
    }

    private static void getAllTextsRecursively(@NotNull Component component, @NotNull StringBuilder builder) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(236);
        }
        if (builder == null) {
            UIUtil.$$$reportNull$$$0(237);
        }
        String candidate = NO_BORDER_UNDER_WINDOW_TITLE_KEY;
        if (component instanceof JLabel) {
            candidate = ((JLabel)component).getText();
        }
        if (component instanceof JTextComponent) {
            candidate = ((JTextComponent)component).getText();
        }
        if (component instanceof AbstractButton) {
            candidate = ((AbstractButton)component).getText();
        }
        if (StringUtil.isNotEmpty(candidate)) {
            candidate = candidate.replaceAll("<a href=\"#inspection/[^)]+\\)", NO_BORDER_UNDER_WINDOW_TITLE_KEY);
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(StringUtil.removeHtmlTags(candidate).trim());
        }
        if (component instanceof Container) {
            Component[] components;
            for (Component child : components = ((Container)component).getComponents()) {
                UIUtil.getAllTextsRecursively(child, builder);
            }
        }
    }

    public static boolean isAncestor(@NotNull Component ancestor, @Nullable Component descendant) {
        if (ancestor == null) {
            UIUtil.$$$reportNull$$$0(238);
        }
        while (descendant != null) {
            if (descendant == ancestor) {
                return true;
            }
            descendant = descendant.getParent();
        }
        return false;
    }

    public static void resetUndoRedoActions(@NotNull JTextComponent textComponent) {
        UndoManager undoManager;
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(239);
        }
        if ((undoManager = ClientProperty.get((Component)textComponent, UNDO_MANAGER)) != null) {
            undoManager.discardAllEdits();
        }
    }

    public static void addUndoRedoActions(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(240);
        }
        if (textComponent.getClientProperty(UNDO_MANAGER) instanceof UndoManager) {
            return;
        }
        UndoManager undoManager = new UndoManager();
        textComponent.putClientProperty(UNDO_MANAGER, undoManager);
        textComponent.getDocument().addUndoableEditListener(undoManager);
        textComponent.getDocument().addDocumentListener(SET_TEXT_CHECKER);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, SystemInfoRt.isMac ? 4 : 2), "undoKeystroke");
        textComponent.getActionMap().put("undoKeystroke", UNDO_ACTION);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, (SystemInfoRt.isMac ? 4 : 2) | 1), "redoKeystroke");
        textComponent.getActionMap().put("redoKeystroke", REDO_ACTION);
    }

    @Nullable
    public static UndoManager getUndoManager(Component component) {
        Object o;
        if (component instanceof JTextComponent && (o = ((JTextComponent)component).getClientProperty(UNDO_MANAGER)) instanceof UndoManager) {
            return (UndoManager)o;
        }
        return null;
    }

    public static void playSoundFromResource(@NotNull String resourceName) {
        Class<?> callerClass;
        if (resourceName == null) {
            UIUtil.$$$reportNull$$$0(241);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return;
        }
        UIUtil.playSoundFromStream(() -> callerClass.getResourceAsStream(resourceName));
    }

    public static void playSoundFromStream(@NotNull Factory<? extends InputStream> streamProducer) {
        if (streamProducer == null) {
            UIUtil.$$$reportNull$$$0(242);
        }
        new Thread(() -> {
            try {
                Clip clip = AudioSystem.getClip();
                InputStream stream = (InputStream)streamProducer.create();
                if (!stream.markSupported()) {
                    stream = new BufferedInputStream(stream);
                }
                AudioInputStream inputStream = AudioSystem.getAudioInputStream(stream);
                clip.open(inputStream);
                clip.start();
            }
            catch (Exception e) {
                UIUtil.getLogger().info(e);
            }
        }, "play sound").start();
    }

    @NlsSafe
    @NotNull
    public static String leftArrow() {
        String string = FontUtil.leftArrow(StartupUiUtil.getLabelFont());
        if (string == null) {
            UIUtil.$$$reportNull$$$0(243);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String rightArrow() {
        String string = FontUtil.rightArrow(StartupUiUtil.getLabelFont());
        if (string == null) {
            UIUtil.$$$reportNull$$$0(244);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String upArrow(@NotNull String defaultValue) {
        if (defaultValue == null) {
            UIUtil.$$$reportNull$$$0(245);
        }
        String string = FontUtil.upArrow(StartupUiUtil.getLabelFont(), defaultValue);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(246);
        }
        return string;
    }

    public static void configureNumericFormattedTextField(@NotNull JFormattedTextField textField) {
        if (textField == null) {
            UIUtil.$$$reportNull$$$0(247);
        }
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setParseIntegerOnly(true);
        format.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(format);
        numberFormatter.setMinimum(Integer.valueOf(0));
        textField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        textField.setHorizontalAlignment(11);
        textField.setColumns(4);
    }

    @Nullable
    public static Window getWindow(@Nullable Component component) {
        return ComponentUtil.getWindow(component);
    }

    public static void toFront(@Nullable Window window) {
        if (window instanceof Frame) {
            ((Frame)window).setState(0);
        }
        if (window != null) {
            window.toFront();
        }
    }

    public static boolean hasScrollPane(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(248);
        }
        return UIUtil.hasComponentOfType(component, JScrollPane.class);
    }

    public static boolean hasComponentOfType(@NotNull Component component, Class<?> ... types) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(249);
        }
        if (types == null) {
            UIUtil.$$$reportNull$$$0(250);
        }
        for (Class<?> type2 : types) {
            if (!type2.isAssignableFrom(component.getClass())) continue;
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (!UIUtil.hasComponentOfType(container.getComponent(i), types)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setColumns(JTextComponent textComponent, int columns) {
        if (textComponent instanceof JTextField) {
            ((JTextField)textComponent).setColumns(columns);
        }
        if (textComponent instanceof JTextArea) {
            ((JTextArea)textComponent).setColumns(columns);
        }
    }

    public static int getLineHeight(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(251);
        }
        return textComponent.getFontMetrics(textComponent.getFont()).getHeight();
    }

    public static JComponent getPreferredFocusedComponent(Container container) {
        Container parent = container;
        if (parent == null) {
            return null;
        }
        FocusTraversalPolicy policy = parent.getFocusTraversalPolicy();
        while (policy == null) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
            policy = parent.getFocusTraversalPolicy();
        }
        Component component = policy.getFirstComponent(container);
        return component instanceof JComponent ? (JComponent)component : null;
    }

    @NotNull
    public static ComponentStyle getComponentStyle(Component component) {
        if (component instanceof JComponent) {
            Object property = ((JComponent)component).getClientProperty("JComponent.sizeVariant");
            if ("large".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.LARGE;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(252);
                }
                return componentStyle;
            }
            if ("small".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.SMALL;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(253);
                }
                return componentStyle;
            }
            if ("mini".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.MINI;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(254);
                }
                return componentStyle;
            }
        }
        ComponentStyle componentStyle = ComponentStyle.REGULAR;
        if (componentStyle == null) {
            UIUtil.$$$reportNull$$$0(255);
        }
        return componentStyle;
    }

    public static void repaintViewport(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(256);
        }
        if (!c.isDisplayable() || !c.isVisible()) {
            return;
        }
        Container p = c.getParent();
        if (p instanceof JViewport) {
            p.repaint();
        }
    }

    public static void setCursor(@NotNull Component component, Cursor cursor) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(257);
        }
        if (!component.isCursorSet() || component.getCursor() != cursor) {
            component.setCursor(cursor);
        }
    }

    public static boolean haveCommonOwner(Component c1, Component c2) {
        Window owner;
        if (c1 == null || c2 == null) {
            return false;
        }
        Window c1Ancestor = UIUtil.findWindowAncestor(c1);
        Window c2Ancestor = UIUtil.findWindowAncestor(c2);
        HashSet<Window> ownerSet = new HashSet<Window>();
        for (owner = c1Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            ownerSet.add(owner);
        }
        for (owner = c2Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            if (!ownerSet.contains(owner)) continue;
            return true;
        }
        return false;
    }

    private static Window findWindowAncestor(@NotNull Component c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(258);
        }
        return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
    }

    public static boolean isHelpButton(Component button) {
        return button instanceof JButton && "help".equals(((JComponent)button).getClientProperty("JButton.buttonType"));
    }

    public static boolean isRetina(@NotNull GraphicsDevice device) {
        if (device == null) {
            UIUtil.$$$reportNull$$$0(259);
        }
        return DetectRetinaKit.isOracleMacRetinaDevice(device);
    }

    public static void useSafely(@NotNull Graphics originGraphics, @NotNull Consumer<? super Graphics2D> drawingConsumer) {
        if (originGraphics == null) {
            UIUtil.$$$reportNull$$$0(260);
        }
        if (drawingConsumer == null) {
            UIUtil.$$$reportNull$$$0(261);
        }
        Graphics2D graphics = (Graphics2D)originGraphics.create();
        try {
            drawingConsumer.consume(graphics);
        }
        finally {
            graphics.dispose();
        }
    }

    @NotNull
    public static Font getListFont() {
        Font font = UIManager.getFont("List.font");
        Font font2 = font != null ? font : StartupUiUtil.getLabelFont();
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(262);
        }
        return font2;
    }

    @NotNull
    public static Color getListBackground() {
        Color color = JBUI.CurrentTheme.List.BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(263);
        }
        return color;
    }

    @NotNull
    public static Color getListSelectionBackground(boolean focused) {
        Color color = JBUI.CurrentTheme.List.Selection.background(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(264);
        }
        return color;
    }

    @NotNull
    public static Dimension updateListRowHeight(@NotNull Dimension size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(265);
        }
        size.height = Math.max(size.height, UIManager.getInt("List.rowHeight"));
        Dimension dimension = size;
        if (dimension == null) {
            UIUtil.$$$reportNull$$$0(266);
        }
        return dimension;
    }

    @NotNull
    public static Color getListBackground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getListBackground() : UIUtil.getListSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getListBackground(boolean selected) {
        return UIUtil.getListBackground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionBackground() {
        return UIUtil.getListSelectionBackground(true);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color getListUnfocusedSelectionBackground() {
        return UIUtil.getListSelectionBackground(false);
    }

    @NotNull
    public static Color getListForeground() {
        Color color = JBUI.CurrentTheme.List.FOREGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(267);
        }
        return color;
    }

    @NotNull
    public static Color getListSelectionForeground(boolean focused) {
        Color color = JBUI.CurrentTheme.List.Selection.foreground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(268);
        }
        return color;
    }

    @NotNull
    public static Color getListForeground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getListForeground() : UIUtil.getListSelectionForeground(focused);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color getListForeground(boolean selected) {
        return UIUtil.getListForeground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionForeground() {
        return UIUtil.getListSelectionForeground(true);
    }

    @NotNull
    public static Font getTreeFont() {
        Font font = UIManager.getFont("Tree.font");
        Font font2 = font != null ? font : StartupUiUtil.getLabelFont();
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(269);
        }
        return font2;
    }

    @NotNull
    public static Color getTreeBackground() {
        Color color = JBUI.CurrentTheme.Tree.BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(270);
        }
        return color;
    }

    @NotNull
    public static Color getTreeSelectionBackground(boolean focused) {
        Color color = JBUI.CurrentTheme.Tree.Selection.background(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(271);
        }
        return color;
    }

    @NotNull
    public static Color getTreeBackground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTreeBackground() : UIUtil.getTreeSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionBackground() {
        return UIUtil.getTreeSelectionBackground(true);
    }

    @Deprecated
    @NotNull
    public static Color getTreeUnfocusedSelectionBackground() {
        return UIUtil.getTreeSelectionBackground(false);
    }

    @NotNull
    public static Color getTreeForeground() {
        Color color = JBUI.CurrentTheme.Tree.FOREGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(272);
        }
        return color;
    }

    @NotNull
    public static Color getTreeSelectionForeground(boolean focused) {
        Color color = JBUI.CurrentTheme.Tree.Selection.foreground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(273);
        }
        return color;
    }

    @NotNull
    public static Color getTreeForeground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTreeForeground() : UIUtil.getTreeSelectionForeground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionForeground() {
        return UIUtil.getTreeSelectionForeground(true);
    }

    @NotNull
    public static Color getTableBackground() {
        Color color = JBUI.CurrentTheme.Table.BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(274);
        }
        return color;
    }

    @NotNull
    public static Color getTableSelectionBackground(boolean focused) {
        Color color = JBUI.CurrentTheme.Table.Selection.background(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(275);
        }
        return color;
    }

    @NotNull
    public static Color getTableBackground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTableBackground() : UIUtil.getTableSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTableBackground(boolean selected) {
        return UIUtil.getTableBackground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionBackground() {
        return UIUtil.getTableSelectionBackground(true);
    }

    @NotNull
    public static Color getTableForeground() {
        Color color = JBUI.CurrentTheme.Table.FOREGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(276);
        }
        return color;
    }

    @NotNull
    public static Color getTableSelectionForeground(boolean focused) {
        Color color = JBUI.CurrentTheme.Table.Selection.foreground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(277);
        }
        return color;
    }

    @NotNull
    public static Color getTableForeground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTableForeground() : UIUtil.getTableSelectionForeground(focused);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color getTableForeground(boolean selected) {
        return UIUtil.getTableForeground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionForeground() {
        return UIUtil.getTableSelectionForeground(true);
    }

    public static void doNotScrollToCaret(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(278);
        }
        textComponent.setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle nloc) {
            }
        });
    }

    public static void convertToLabel(@NotNull JEditorPane editorPane) {
        if (editorPane == null) {
            UIUtil.$$$reportNull$$$0(279);
        }
        editorPane.setEditable(false);
        editorPane.setFocusable(false);
        editorPane.setOpaque(false);
        editorPane.setBorder(null);
        editorPane.setContentType(HTML_MIME);
        editorPane.setEditorKit(HTMLEditorKitBuilder.simple());
    }

    public static void enableEagerSoftWrapping(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(280);
        }
        textComponent.getDocument().putProperty("multiByte", Boolean.TRUE);
    }

    @NotNull
    public static Color getTooltipSeparatorColor() {
        JBColor jBColor = JBColor.namedColor("Tooltip.separatorColor", 0xD1D1D1, 5527128);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(281);
        }
        return jBColor;
    }

    public static void scrollToReference(@NotNull JEditorPane editor, @NotNull @NonNls String reference) {
        Element elementById;
        Document document;
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(282);
        }
        if (reference == null) {
            UIUtil.$$$reportNull$$$0(283);
        }
        if ((document = editor.getDocument()) instanceof HTMLDocument && (elementById = ((HTMLDocument)document).getElement(reference)) != null) {
            try {
                int pos = elementById.getStartOffset();
                Rectangle r = editor.modelToView(pos);
                if (r != null) {
                    r.height = editor.getVisibleRect().height;
                    editor.scrollRectToVisible(r);
                    editor.setCaretPosition(pos);
                }
            }
            catch (BadLocationException e) {
                UIUtil.getLogger().error(e);
            }
            return;
        }
        editor.scrollToReference(reference);
    }

    @ApiStatus.Experimental
    public static boolean isShowing(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(284);
        }
        if (Boolean.getBoolean("java.awt.headless") || component.isShowing()) {
            return true;
        }
        while (component != null) {
            JComponent jComponent;
            JComponent jComponent2 = jComponent = component instanceof JComponent ? (JComponent)component : null;
            if (jComponent != null && Boolean.TRUE.equals(jComponent.getClientProperty(IS_SHOWING))) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void markAsShowing(@NotNull JComponent component, boolean value) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(285);
        }
        if (Boolean.getBoolean("java.awt.headless")) {
            return;
        }
        component.putClientProperty(IS_SHOWING, value ? Boolean.TRUE : null);
    }

    public static void runWhenFocused(@NotNull Component component, final @NotNull Runnable runnable) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(286);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(287);
        }
        assert (component.isShowing());
        if (component.isFocusOwner()) {
            runnable.run();
        } else {
            final Disposable disposable = Disposer.newDisposable();
            FocusAdapter focusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Disposer.dispose(disposable);
                    runnable.run();
                }
            };
            HierarchyListener hierarchyListener = e -> {
                if ((e.getChangeFlags() & 4L) != 0L && !component.isShowing()) {
                    Disposer.dispose(disposable);
                }
            };
            component.addFocusListener(focusListener);
            component.addHierarchyListener(hierarchyListener);
            Disposer.register(disposable, () -> {
                component.removeFocusListener(focusListener);
                component.removeHierarchyListener(hierarchyListener);
            });
        }
    }

    public static void runWhenHidden(@NotNull Component component, @NotNull Runnable runnable) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(288);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(289);
        }
        component.addHierarchyListener(UIUtil.runWhenHidden(runnable));
    }

    @NotNull
    private static HierarchyListener runWhenHidden(final @NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(290);
        }
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!BitUtil.isSet(e.getChangeFlags(), 2L)) {
                    return;
                }
                Component component = e.getComponent();
                if (component.isDisplayable()) {
                    return;
                }
                component.removeHierarchyListener(this);
                runnable.run();
            }
        };
    }

    public static void runWhenChanged(final @NotNull Component component, final @NotNull String property, final @NotNull Runnable runnable) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(291);
        }
        if (property == null) {
            UIUtil.$$$reportNull$$$0(292);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(293);
        }
        component.addPropertyChangeListener(property, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.removePropertyChangeListener(property, this);
                runnable.run();
            }
        });
    }

    public static Font getLabelFont() {
        return StartupUiUtil.getLabelFont();
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(294);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(295);
        }
        StartupUiUtil.drawImage(g, image, x, y, observer);
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Dimension container, @NotNull Dimension child) {
        if (container == null) {
            UIUtil.$$$reportNull$$$0(296);
        }
        if (child == null) {
            UIUtil.$$$reportNull$$$0(297);
        }
        Point point = StartupUiUtil.getCenterPoint(container, child);
        if (point == null) {
            UIUtil.$$$reportNull$$$0(298);
        }
        return point;
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Rectangle container, @NotNull Dimension child) {
        if (container == null) {
            UIUtil.$$$reportNull$$$0(299);
        }
        if (child == null) {
            UIUtil.$$$reportNull$$$0(300);
        }
        Point point = StartupUiUtil.getCenterPoint(container, child);
        if (point == null) {
            UIUtil.$$$reportNull$$$0(301);
        }
        return point;
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(302);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(303);
        }
        StartupUiUtil.drawImage(g, image, dstBounds, srcBounds, null, observer);
    }

    @TestOnly
    public static void pump() {
        assert (!SwingUtilities.isEventDispatchThread());
        Semaphore lock = new Semaphore(1);
        SwingUtilities.invokeLater(() -> lock.up());
        lock.waitFor();
    }

    public static boolean isJreHiDPI() {
        return StartupUiUtil.isJreHiDPI();
    }

    public static Color makeTransparent(@NotNull Color color, @NotNull Color backgroundColor, double transparency) {
        if (color == null) {
            UIUtil.$$$reportNull$$$0(304);
        }
        if (backgroundColor == null) {
            UIUtil.$$$reportNull$$$0(305);
        }
        int r = UIUtil.makeTransparent(transparency, color.getRed(), backgroundColor.getRed());
        int g = UIUtil.makeTransparent(transparency, color.getGreen(), backgroundColor.getGreen());
        int b = UIUtil.makeTransparent(transparency, color.getBlue(), backgroundColor.getBlue());
        return new Color(r, g, b);
    }

    private static int makeTransparent(double transparency, int channel, int backgroundChannel) {
        int result = (int)((double)backgroundChannel * (1.0 - transparency) + (double)channel * transparency);
        if (result < 0) {
            return 0;
        }
        return Math.min(result, 255);
    }

    public static void stopFocusedEditing(@NotNull Window window) {
        Component focusOwner;
        if (window == null) {
            UIUtil.$$$reportNull$$$0(306);
        }
        if ((focusOwner = FocusManager.getCurrentManager().getFocusOwner()) == null || !SwingUtilities.isDescendingFrom(focusOwner, window)) {
            return;
        }
        ObjectUtils.consumeIfCast(focusOwner, JFormattedTextField.class, field -> {
            try {
                ((JFormattedTextField)focusOwner).commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        });
        ObjectUtils.consumeIfCast(focusOwner.getParent(), JTable.class, table -> TableUtil.stopEditing(table));
        ObjectUtils.consumeIfCast(focusOwner.getParent(), JTree.class, tree -> tree.stopEditing());
    }

    public static String colorToHex(Color color) {
        return UIUtil.to2DigitsHex(color.getRed()) + UIUtil.to2DigitsHex(color.getGreen()) + UIUtil.to2DigitsHex(color.getBlue());
    }

    private static String to2DigitsHex(int i) {
        Object s = Integer.toHexString(i);
        if (((String)s).length() < 2) {
            s = "0" + (String)s;
        }
        return s;
    }

    static {
        LoadingState.BASE_LAF_INITIALIZED.checkOccurred();
        LAF_WITH_THEME_KEY = Key.create("Laf.with.ui.theme");
        PLUGGABLE_LAF_KEY = Key.create("Pluggable.laf.name");
        IS_SHOWING = Key.create("Component.isShowing");
        HAS_FOCUS = Key.create("Component.hasFocus");
        X_RENDER_ACTIVE = NotNullLazyValue.atomicLazy(() -> {
            if (!SystemInfoRt.isXWindow) {
                return false;
            }
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                return (Boolean)method.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                return false;
            }
        });
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create("keepBorderSides");
        UNDO_MANAGER = Key.create("undoManager");
        TEXT_COPY_ROOT = Key.create("TEXT_COPY_ROOT");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                UndoManager manager;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((manager = ClientProperty.get(ObjectUtils.tryCast(e.getSource(), Component.class), UNDO_MANAGER)) != null && manager.canRedo()) {
                    manager.redo();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "sqldelight/com/intellij/util/ui/UIUtil$1", "actionPerformed"));
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                UndoManager manager;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((manager = ClientProperty.get(ObjectUtils.tryCast(e.getSource(), Component.class), UNDO_MANAGER)) != null && manager.canUndo()) {
                    manager.undo();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "sqldelight/com/intellij/util/ui/UIUtil$2", "actionPerformed"));
            }
        };
        ACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.active", 10533589);
        INACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.inactive", Gray._128);
        CONTRAST_BORDER_COLOR = JBColor.namedColor("Borders.ContrastBorderColor", new JBColor(0xC9C9C9, 0x323232));
        SIDE_PANEL_BACKGROUND = JBColor.namedColor("SidePanel.background", new JBColor(15133680, 4080460));
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, (Color)Gray.x51);
        TRANSPARENT_COLOR = Gray.TRANSPARENT;
        PANEL_REGULAR_INSETS = UIUtil.getRegularPanelInsets();
        PANEL_SMALL_INSETS = JBInsets.create(5, 8);
        ourRetina = Ref.create(SystemInfoRt.isMac ? null : Boolean.valueOf(false));
        NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
        UI_TRAVERSER = JBTreeTraverser.from(c -> {
            JBIterable<Object> result = c instanceof JMenu ? JBIterable.of(((JMenu)c).getMenuComponents()) : UIUtil.uiChildren(c);
            if (c instanceof JComponent) {
                JPopupMenu jpm;
                JComponent jc = (JComponent)c;
                Iterable<? extends Component> orphans = ClientProperty.get((Component)jc, NOT_IN_HIERARCHY_COMPONENTS);
                if (orphans != null) {
                    result = result.append(orphans);
                }
                if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                    result = result.append(Collections.singletonList(jpm));
                }
            }
            return result;
        });
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        SET_TEXT_CHECKER = new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                Document document;
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if ((document = e.getDocument()) instanceof AbstractDocument) {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                        UndoableEditListener[] undoableEditListeners;
                        if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                        for (UndoableEditListener listener : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                            if (!(listener instanceof UndoManager)) continue;
                            Runnable runnable = ((UndoManager)listener)::discardAllEdits;
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "sqldelight/com/intellij/util/ui/UIUtil$6", "textChanged"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 71: 
            case 73: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 94: 
            case 95: 
            case 99: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 163: 
            case 164: 
            case 171: 
            case 172: 
            case 174: 
            case 178: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 265: 
            case 278: 
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 299: 
            case 300: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 71: 
            case 73: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 94: 
            case 95: 
            case 99: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 163: 
            case 164: 
            case 171: 
            case 172: 
            case 174: 
            case 178: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 265: 
            case 278: 
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 299: 
            case 300: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/ui/UIUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 4: 
            case 305: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundColor";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 11: 
            case 31: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 21: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: 
            case 44: 
            case 45: 
            case 83: 
            case 102: 
            case 128: 
            case 130: 
            case 143: 
            case 144: 
            case 145: 
            case 156: 
            case 157: 
            case 163: 
            case 190: 
            case 209: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 218: 
            case 220: 
            case 222: 
            case 223: 
            case 228: 
            case 236: 
            case 248: 
            case 249: 
            case 257: 
            case 284: 
            case 285: 
            case 286: 
            case 288: 
            case 291: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 25: 
            case 50: 
            case 53: 
            case 55: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: 
            case 178: 
            case 179: 
            case 181: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 32: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 195: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 35: 
            case 37: 
            case 39: 
            case 46: 
            case 47: 
            case 48: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 125: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 140: 
            case 294: 
            case 302: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 42: 
            case 158: 
            case 159: 
            case 171: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 54: 
            case 56: 
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 57: 
            case 58: 
            case 60: 
            case 65: 
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontColor";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 71: 
            case 73: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyPrefix";
                break;
            }
            case 79: 
            case 94: 
            case 151: 
            case 162: 
            case 207: 
            case 234: 
            case 256: 
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slider";
                break;
            }
            case 95: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
            case 104: 
            case 304: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 126: 
            case 129: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 127: 
            case 154: 
            case 155: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 138: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 139: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 185: 
            case 186: 
            case 188: 
            case 231: 
            case 233: 
            case 287: 
            case 289: 
            case 290: 
            case 293: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 193: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 197: 
            case 282: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 210: 
            case 211: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
            case 217: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 229: 
            case 230: 
            case 232: 
            case 306: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 239: 
            case 240: 
            case 251: 
            case 278: 
            case 280: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 242: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamProducer";
                break;
            }
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 250: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 259: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 260: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originGraphics";
                break;
            }
            case 261: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingConsumer";
                break;
            }
            case 279: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
            case 283: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 292: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 295: 
            case 303: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 296: 
            case 299: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 297: 
            case 300: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 71: 
            case 73: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 94: 
            case 95: 
            case 99: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 163: 
            case 164: 
            case 171: 
            case 172: 
            case 174: 
            case 178: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 265: 
            case 278: 
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 299: 
            case 300: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/ui/UIUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextCursor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrayFilter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextGrayFilter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellColors";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClientProperties";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlBody";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "splitText";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelFontColor";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelForeground";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorForeground";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelDisabledForeground";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelInfoForeground";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextHelpForeground";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMnemonic";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveTextColor";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipBackground";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipActionBackground";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipForeground";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelBackground";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorColor";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonInformationIcon";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonWarningIcon";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonErrorIcon";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeCollapsedIcon";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeExpandedIcon";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarFont";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularPanelInsets";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCellPadding";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getListViewportPadding";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidFontNames";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardFontSizes";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "displayPropertiesToCSS";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchMatchGradientStartColor";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchMatchGradientEndColor";
                break;
            }
            case 121: 
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgFillColor";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssFontDeclaration";
                break;
            }
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundsColor";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderActiveColor";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedBorderColor";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderInactiveColor";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitledBorderFont";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "getHTMLEditorKit";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontWithFallbackIfNeeded";
                break;
            }
            case 175: 
            case 176: 
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontWithFallback";
                break;
            }
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "addPadding";
                break;
            }
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSpace2Nbsp";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "uiParents";
                break;
            }
            case 201: 
            case 202: {
                objectArray = objectArray2;
                objectArray2[1] = "uiChildren";
                break;
            }
            case 203: {
                objectArray = objectArray2;
                objectArray2[1] = "uiTraverser";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentsOfType";
                break;
            }
            case 225: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecoratedRowColor";
                break;
            }
            case 235: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugText";
                break;
            }
            case 243: {
                objectArray = objectArray2;
                objectArray2[1] = "leftArrow";
                break;
            }
            case 244: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
            case 246: {
                objectArray = objectArray2;
                objectArray2[1] = "upArrow";
                break;
            }
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentStyle";
                break;
            }
            case 262: {
                objectArray = objectArray2;
                objectArray2[1] = "getListFont";
                break;
            }
            case 263: {
                objectArray = objectArray2;
                objectArray2[1] = "getListBackground";
                break;
            }
            case 264: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionBackground";
                break;
            }
            case 266: {
                objectArray = objectArray2;
                objectArray2[1] = "updateListRowHeight";
                break;
            }
            case 267: {
                objectArray = objectArray2;
                objectArray2[1] = "getListForeground";
                break;
            }
            case 268: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionForeground";
                break;
            }
            case 269: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeFont";
                break;
            }
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeBackground";
                break;
            }
            case 271: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionBackground";
                break;
            }
            case 272: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeForeground";
                break;
            }
            case 273: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionForeground";
                break;
            }
            case 274: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableBackground";
                break;
            }
            case 275: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionBackground";
                break;
            }
            case 276: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableForeground";
                break;
            }
            case 277: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionForeground";
                break;
            }
            case 281: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipSeparatorColor";
                break;
            }
            case 298: 
            case 301: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterPoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleOwner";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyStyle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextCursor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCellColors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fixOSXEditorBackground";
                break;
            }
            case 11: 
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "isRetina";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isWindowClientPropertyTrue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getWindowClientProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putWindowClientProperty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isClientPropertyTrue";
                break;
            }
            case 16: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 25: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlBody";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "drawLinePickedOut";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isReallyTypedEvent";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getStringY";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "drawLabelDottedRectangle";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getLabelTextBounds";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getHighestGlyphHeight";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "drawLine";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "drawWave";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "splitText";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setActionNameAndMnemonic";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "assignMnemonic";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFont";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getFontSize";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFontColor";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxTextHorizontalOffset";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getButtonTextHorizontalOffset";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "removeMnemonic";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMnemonicIndex";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyMaxGutterIconWidth";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getTabbedPanePaintContentBorder";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "setSliderIsFilled";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "setLineStyleAngled";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "shade";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isControlKeyDown";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "setupEnclosingDialogBounds";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "appendColor";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedRectangle";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "drawBoldDottedLine";
                break;
            }
            case 110: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "drawSearchMatch";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "drawBoringDottedLine";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "drawGradientHToolbarBackground";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "drawHeader";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "drawDoubleSpaceDottedLine";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "drawAppleDottedLine";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "applyRenderingHints";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "setupComposite";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "addAwtListener";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "addParentChangeListener";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "removeParentChangeListener";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "drawVDottedLine";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "drawHDottedLine";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedLine";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "drawStringWithHighlighting";
                break;
            }
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "drawCenteredString";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "isFocusAncestor";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "hasFocus";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "markAsFocused";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "isCloseClick";
                break;
            }
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "isActionClick";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "getBgFillColor";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAt";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAtForComponent";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "layoutRecursively";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "getCssFontDeclaration";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "canDisplayFocusedState";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "disposeProgress";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallbackIfNeeded";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "addPadding";
                break;
            }
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "convertSpace2Nbsp";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "maybeInstall";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "changeBackGround";
                break;
            }
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "getComboBoxPopup";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "fixFormattedField";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedButton";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedButton";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionButtonDown";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "isToggleListSelectionEvent";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "setComboBoxEditorBounds";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "isDescendingFrom";
                break;
            }
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "scrollListToVisibleIfNeeded";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "findComponentsOfType";
                break;
            }
            case 207: 
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "setFutureRootPane";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "runWhenVisibilityChanged";
                break;
            }
            case 210: 
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "mergeComponentsWithAnchor";
                break;
            }
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "setOpaqueRecursively";
                break;
            }
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "setEnabledRecursively";
                break;
            }
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundRecursively";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "setForegroundRecursively";
                break;
            }
            case 220: 
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "forEachComponentInHierarchy";
                break;
            }
            case 222: 
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "getGradientPaint";
                break;
            }
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "getLocationOnScreen";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "setAutoRequestFocus";
                break;
            }
            case 230: 
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "runWhenWindowOpened";
                break;
            }
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "runWhenWindowClosed";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "getDebugText";
                break;
            }
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "getAllTextsRecursively";
                break;
            }
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "resetUndoRedoActions";
                break;
            }
            case 240: {
                objectArray = objectArray;
                objectArray[2] = "addUndoRedoActions";
                break;
            }
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromResource";
                break;
            }
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromStream";
                break;
            }
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericFormattedTextField";
                break;
            }
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "hasScrollPane";
                break;
            }
            case 249: 
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "hasComponentOfType";
                break;
            }
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "getLineHeight";
                break;
            }
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "repaintViewport";
                break;
            }
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "findWindowAncestor";
                break;
            }
            case 260: 
            case 261: {
                objectArray = objectArray;
                objectArray[2] = "useSafely";
                break;
            }
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "updateListRowHeight";
                break;
            }
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "doNotScrollToCaret";
                break;
            }
            case 279: {
                objectArray = objectArray;
                objectArray[2] = "convertToLabel";
                break;
            }
            case 280: {
                objectArray = objectArray;
                objectArray[2] = "enableEagerSoftWrapping";
                break;
            }
            case 282: 
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "scrollToReference";
                break;
            }
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "isShowing";
                break;
            }
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "markAsShowing";
                break;
            }
            case 286: 
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "runWhenFocused";
                break;
            }
            case 288: 
            case 289: 
            case 290: {
                objectArray = objectArray;
                objectArray[2] = "runWhenHidden";
                break;
            }
            case 291: 
            case 292: 
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "runWhenChanged";
                break;
            }
            case 294: 
            case 295: 
            case 302: 
            case 303: {
                objectArray = objectArray;
                objectArray[2] = "drawImage";
                break;
            }
            case 296: 
            case 297: 
            case 299: 
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "getCenterPoint";
                break;
            }
            case 304: 
            case 305: {
                objectArray = objectArray;
                objectArray[2] = "makeTransparent";
                break;
            }
            case 306: {
                objectArray = objectArray;
                objectArray[2] = "stopFocusedEditing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 71: 
            case 73: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 94: 
            case 95: 
            case 99: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 163: 
            case 164: 
            case 171: 
            case 172: 
            case 174: 
            case 178: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 265: 
            case 278: 
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 299: 
            case 300: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextPainter {
        private final List<String> myLines = new ArrayList<String>();
        private boolean myDrawShadow = StartupUiUtil.isUnderDarcula();
        private Color myShadowColor = StartupUiUtil.isUnderDarcula() ? Gray._0.withAlpha(100) : Gray._220;
        private float myLineSpacing = 1.0f;
        private Font myFont;
        private Color myColor;

        @NotNull
        public TextPainter withShadow(boolean drawShadow, Color shadowColor) {
            this.myDrawShadow = drawShadow;
            this.myShadowColor = shadowColor;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(0);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withLineSpacing(float lineSpacing) {
            this.myLineSpacing = lineSpacing;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(1);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withColor(Color color) {
            this.myColor = color;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(2);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withFont(Font font) {
            this.myFont = font;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(3);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter appendLine(String text) {
            if (text == null || text.isEmpty()) {
                TextPainter textPainter = this;
                if (textPainter == null) {
                    TextPainter.$$$reportNull$$$0(4);
                }
                return textPainter;
            }
            this.myLines.add(text);
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(5);
            }
            return textPainter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(@NotNull Graphics g, @NotNull PairFunction<? super Integer, ? super Integer, ? extends Couple<Integer>> _position) {
            if (g == null) {
                TextPainter.$$$reportNull$$$0(6);
            }
            if (_position == null) {
                TextPainter.$$$reportNull$$$0(7);
            }
            Font oldFont = null;
            if (this.myFont != null) {
                oldFont = g.getFont();
                g.setFont(this.myFont);
            }
            Color oldColor = null;
            if (this.myColor != null) {
                oldColor = g.getColor();
                g.setColor(this.myColor);
            }
            try {
                int[] maxWidth = new int[]{0};
                int[] height = new int[]{0};
                ContainerUtil.process(this.myLines, text -> {
                    FontMetrics fm = g.getFontMetrics();
                    maxWidth[0] = Math.max(fm.stringWidth(text.replace("<shortcut>", UIUtil.NO_BORDER_UNDER_WINDOW_TITLE_KEY).replace("</shortcut>", UIUtil.NO_BORDER_UNDER_WINDOW_TITLE_KEY)), maxWidth[0]);
                    height[0] = (int)((float)height[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    return true;
                });
                Couple<Integer> position = _position.fun((Integer)(maxWidth[0] + 20), (Integer)height[0]);
                assert (position != null);
                int[] yOffset = new int[]{(Integer)position.getSecond()};
                ContainerUtil.process(this.myLines, text -> {
                    String shortcut = UIUtil.NO_BORDER_UNDER_WINDOW_TITLE_KEY;
                    if (text.contains("<shortcut>")) {
                        shortcut = text.substring(text.indexOf("<shortcut>") + "<shortcut>".length(), text.indexOf("</shortcut>"));
                        text = text.substring(0, text.indexOf("<shortcut>"));
                    }
                    int x = (Integer)position.getFirst() + 10;
                    FontMetrics fm = g.getFontMetrics();
                    if (this.myDrawShadow) {
                        int xOff = StartupUiUtil.isUnderDarcula() ? 1 : 0;
                        Color oldColor1 = g.getColor();
                        g.setColor(this.myShadowColor);
                        int yOff = 1;
                        g.drawString((String)text, x + xOff, yOffset[0] + yOff);
                        g.setColor(oldColor1);
                    }
                    g.drawString((String)text, x, yOffset[0]);
                    if (!StringUtil.isEmpty(shortcut)) {
                        Color oldColor1 = g.getColor();
                        g.setColor(JBColor.namedColor("Editor.shortcutForeground", new JBColor(new Color(82, 99, 155), new Color(88, 157, 246))));
                        g.drawString(shortcut, x + fm.stringWidth(text + (StartupUiUtil.isUnderDarcula() ? " " : UIUtil.NO_BORDER_UNDER_WINDOW_TITLE_KEY)), yOffset[0]);
                        g.setColor(oldColor1);
                    }
                    yOffset[0] = (int)((float)yOffset[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    return true;
                });
            }
            finally {
                if (oldFont != null) {
                    g.setFont(oldFont);
                }
                if (oldColor != null) {
                    g.setColor(oldColor);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/util/ui/UIUtil$TextPainter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_position";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withShadow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withLineSpacing";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withColor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withFont";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendLine";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/util/ui/UIUtil$TextPainter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "draw";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Deprecated
    public static final class JBWordWrapHtmlEditorKit
    extends JBHtmlEditorKit {
        @Override
        public ViewFactory getViewFactory() {
            return ExtendableHTMLViewFactory.DEFAULT_WORD_WRAP;
        }
    }

    public static enum FontColor {
        NORMAL,
        BRIGHTER;

    }

    public static enum ComponentStyle {
        LARGE,
        REGULAR,
        SMALL,
        MINI;

    }

    public static enum FontSize {
        NORMAL,
        SMALL,
        MINI;

    }

    public static class GrayFilter
    extends RGBImageFilter {
        private float brightness;
        private float contrast;
        private int alpha;
        private int origContrast;
        private int origBrightness;

        public GrayFilter(int brightness, int contrast, int alpha) {
            this.setBrightness(brightness);
            this.setContrast(contrast);
            this.setAlpha(alpha);
        }

        public GrayFilter() {
            this(0, 0, 100);
        }

        private void setBrightness(int brightness) {
            this.origBrightness = Math.max(-100, Math.min(100, brightness));
            this.brightness = (float)(Math.pow(this.origBrightness, 3.0) / 10000.0);
        }

        public int getBrightness() {
            return this.origBrightness;
        }

        private void setContrast(int contrast) {
            this.origContrast = Math.max(-100, Math.min(100, contrast));
            this.contrast = (float)this.origContrast / 100.0f;
        }

        public int getContrast() {
            return this.origContrast;
        }

        private void setAlpha(int alpha) {
            this.alpha = Math.max(0, Math.min(100, alpha));
        }

        public int getAlpha() {
            return this.alpha;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = (int)(0.3 * (double)(rgb >> 16 & 0xFF) + 0.59 * (double)(rgb >> 8 & 0xFF) + 0.11 * (double)(rgb & 0xFF));
            gray = this.brightness >= 0.0f ? (int)(((float)gray + this.brightness * 255.0f) / (1.0f + this.brightness)) : (int)((float)gray / (1.0f - this.brightness));
            gray = this.contrast >= 0.0f ? (gray >= 127 ? (int)((float)gray + (float)(255 - gray) * this.contrast) : (int)((float)gray - (float)gray * this.contrast)) : (int)(127.0f + (float)(gray - 127) * (this.contrast + 1.0f));
            int a = (rgb >> 24 & 0xFF) * this.alpha / 100;
            return a << 24 | gray << 16 | gray << 8 | gray;
        }

        @NotNull
        public GrayFilterUIResource asUIResource() {
            return new GrayFilterUIResource(this);
        }

        @NotNull
        public static GrayFilter namedFilter(@NotNull String resourceName, @NotNull GrayFilter defaultFilter) {
            if (resourceName == null) {
                GrayFilter.$$$reportNull$$$0(0);
            }
            if (defaultFilter == null) {
                GrayFilter.$$$reportNull$$$0(1);
            }
            GrayFilter grayFilter = ObjectUtils.notNull((GrayFilter)UIManager.get(resourceName), defaultFilter);
            if (grayFilter == null) {
                GrayFilter.$$$reportNull$$$0(2);
            }
            return grayFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/util/ui/UIUtil$GrayFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/util/ui/UIUtil$GrayFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "namedFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "namedFilter";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class GrayFilterUIResource
        extends GrayFilter
        implements UIResource {
            public GrayFilterUIResource(@NotNull GrayFilter filter) {
                if (filter == null) {
                    GrayFilterUIResource.$$$reportNull$$$0(0);
                }
                super(filter.origBrightness, filter.origContrast, filter.alpha);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "sqldelight/com/intellij/util/ui/UIUtil$GrayFilter$GrayFilterUIResource", "<init>"));
            }
        }
    }
}

