/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.xmlb;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.openapi.util.JDOMExternalizable;
import sqldelight.com.intellij.openapi.util.text.StringUtilRt;
import sqldelight.com.intellij.serialization.MutableAccessor;
import sqldelight.com.intellij.serialization.PropertyCollector;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.com.intellij.util.ThreeState;
import sqldelight.com.intellij.util.xml.dom.XmlElement;
import sqldelight.com.intellij.util.xmlb.AccessorBindingWrapper;
import sqldelight.com.intellij.util.xmlb.AttributeBinding;
import sqldelight.com.intellij.util.xmlb.Binding;
import sqldelight.com.intellij.util.xmlb.CompactCollectionBinding;
import sqldelight.com.intellij.util.xmlb.Converter;
import sqldelight.com.intellij.util.xmlb.JDOMElementBinding;
import sqldelight.com.intellij.util.xmlb.MultiNodeBinding;
import sqldelight.com.intellij.util.xmlb.NestedBinding;
import sqldelight.com.intellij.util.xmlb.NotNullDeserializeBinding;
import sqldelight.com.intellij.util.xmlb.OptionTagBinding;
import sqldelight.com.intellij.util.xmlb.SerializationFilter;
import sqldelight.com.intellij.util.xmlb.Serializer;
import sqldelight.com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import sqldelight.com.intellij.util.xmlb.TagBinding;
import sqldelight.com.intellij.util.xmlb.TextBinding;
import sqldelight.com.intellij.util.xmlb.XmlSerializationException;
import sqldelight.com.intellij.util.xmlb.annotations.AbstractCollection;
import sqldelight.com.intellij.util.xmlb.annotations.Attribute;
import sqldelight.com.intellij.util.xmlb.annotations.CollectionBean;
import sqldelight.com.intellij.util.xmlb.annotations.MapAnnotation;
import sqldelight.com.intellij.util.xmlb.annotations.OptionTag;
import sqldelight.com.intellij.util.xmlb.annotations.Property;
import sqldelight.com.intellij.util.xmlb.annotations.Tag;
import sqldelight.com.intellij.util.xmlb.annotations.Text;
import sqldelight.com.intellij.util.xmlb.annotations.Transient;
import sqldelight.com.intellij.util.xmlb.annotations.XCollection;
import sqldelight.com.intellij.util.xmlb.annotations.XMap;
import sqldelight.it.unimi.dsi.fastutil.objects.Object2FloatMap;
import sqldelight.it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import sqldelight.org.jdom.Comment;
import sqldelight.org.jdom.Content;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BeanBinding
extends NotNullDeserializeBinding {
    private static final XmlSerializerPropertyCollector PROPERTY_COLLECTOR = new XmlSerializerPropertyCollector(new MyPropertyCollectorConfiguration());
    private final String myTagName;
    protected NestedBinding[] bindings;
    protected final Class<?> myBeanClass;
    ThreeState compareByFields;

    public BeanBinding(@NotNull Class<?> beanClass) {
        if (beanClass == null) {
            BeanBinding.$$$reportNull$$$0(0);
        }
        this.compareByFields = ThreeState.UNSURE;
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtilRt.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public final synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        if (originalType == null) {
            BeanBinding.$$$reportNull$$$0(1);
        }
        if (serializer == null) {
            BeanBinding.$$$reportNull$$$0(2);
        }
        assert (this.bindings == null);
        Property classAnnotation = this.myBeanClass.getAnnotation(Property.class);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.bindings = new NestedBinding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            NestedBinding binding = BeanBinding.createBinding(accessors.get(i), serializer, classAnnotation == null ? Property.Style.OPTION_TAG : classAnnotation.style());
            binding.init(originalType, serializer);
            this.bindings[i] = binding;
        }
    }

    @Override
    @Nullable
    public final Object serialize(@NotNull Object o, @Nullable Object context2, @Nullable SerializationFilter filter) {
        if (o == null) {
            BeanBinding.$$$reportNull$$$0(3);
        }
        return this.serializeInto(o, context2 == null ? null : new Element(this.myTagName), filter);
    }

    public final Element serialize(@NotNull Object object, boolean createElementIfEmpty, @Nullable SerializationFilter filter) {
        if (object == null) {
            BeanBinding.$$$reportNull$$$0(4);
        }
        return this.serializeInto(object, createElementIfEmpty ? new Element(this.myTagName) : null, filter);
    }

    @Nullable
    public Element serializeInto(@NotNull Object o, @Nullable Element element, @Nullable SerializationFilter filter) {
        if (o == null) {
            BeanBinding.$$$reportNull$$$0(5);
        }
        for (NestedBinding binding : this.bindings) {
            if (o instanceof SerializationFilter && !((SerializationFilter)o).accepts(binding.getAccessor(), o)) continue;
            element = this.serializePropertyInto(binding, o, element, filter, true);
        }
        return element;
    }

    @Nullable
    protected final Element serializePropertyInto(@NotNull NestedBinding binding, @NotNull Object o, @Nullable Element element, @Nullable SerializationFilter filter, boolean isFilterPropertyItself) {
        Object node;
        MutableAccessor accessor;
        Property property;
        if (binding == null) {
            BeanBinding.$$$reportNull$$$0(6);
        }
        if (o == null) {
            BeanBinding.$$$reportNull$$$0(7);
        }
        if ((property = (accessor = binding.getAccessor()).getAnnotation(Property.class)) == null || !property.alwaysWrite()) {
            if (filter != null && isFilterPropertyItself && (filter instanceof SkipDefaultsSerializationFilter ? ((SkipDefaultsSerializationFilter)filter).equal(binding, o) : !filter.accepts(accessor, o))) {
                return element;
            }
            if (property != null && property.filter() != SerializationFilter.class && !ReflectionUtil.newInstance(property.filter()).accepts(accessor, o)) {
                return element;
            }
        }
        if (element == null) {
            element = new Element(this.myTagName);
        }
        if ((node = binding.serialize(o, element, filter)) != null) {
            if (node instanceof sqldelight.org.jdom.Attribute) {
                element.setAttribute((sqldelight.org.jdom.Attribute)node);
            } else {
                Binding.addContent(element, node);
            }
        }
        return element;
    }

    @Override
    @NotNull
    public final Object deserialize(@Nullable Object context2, @NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(8);
        }
        Object instance = this.newInstance();
        this.deserializeInto(instance, element);
        Object object = instance;
        if (object == null) {
            BeanBinding.$$$reportNull$$$0(9);
        }
        return object;
    }

    @Override
    @NotNull
    public final Object deserialize(@Nullable Object context2, @NotNull XmlElement element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(10);
        }
        Object instance = this.newInstance();
        this.deserializeInto(instance, element);
        Object object = instance;
        if (object == null) {
            BeanBinding.$$$reportNull$$$0(11);
        }
        return object;
    }

    @NotNull
    protected Object newInstance() {
        Object obj = ReflectionUtil.newInstance(this.myBeanClass, false);
        if (obj == null) {
            BeanBinding.$$$reportNull$$$0(12);
        }
        return obj;
    }

    final boolean equalByFields(@NotNull Object currentValue, @NotNull Object defaultValue, @NotNull SkipDefaultsSerializationFilter filter) {
        if (currentValue == null) {
            BeanBinding.$$$reportNull$$$0(13);
        }
        if (defaultValue == null) {
            BeanBinding.$$$reportNull$$$0(14);
        }
        if (filter == null) {
            BeanBinding.$$$reportNull$$$0(15);
        }
        for (NestedBinding binding : this.bindings) {
            MutableAccessor accessor = binding.getAccessor();
            if (filter.equal(binding, accessor.read(currentValue), accessor.read(defaultValue))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Object2FloatMap<String> computeBindingWeights(@NotNull Set<String> accessorNameTracker) {
        if (accessorNameTracker == null) {
            BeanBinding.$$$reportNull$$$0(16);
        }
        Object2FloatOpenHashMap<String> weights = new Object2FloatOpenHashMap<String>(accessorNameTracker.size());
        float weight = 0.0f;
        float step = (float)this.bindings.length / (float)accessorNameTracker.size();
        for (String name : accessorNameTracker) {
            weights.put(name, weight);
            weight += step;
        }
        weight = 0.0f;
        for (NestedBinding binding : this.bindings) {
            String name = binding.getAccessor().getName();
            if (!weights.containsKey(name)) {
                weights.put(name, weight);
            }
            weight += 1.0f;
        }
        Object2FloatOpenHashMap<String> object2FloatOpenHashMap = weights;
        if (object2FloatOpenHashMap == null) {
            BeanBinding.$$$reportNull$$$0(17);
        }
        return object2FloatOpenHashMap;
    }

    public final void sortBindings(@NotNull Object2FloatMap<? super String> weights) {
        if (weights == null) {
            BeanBinding.$$$reportNull$$$0(18);
        }
        Arrays.sort(this.bindings, (o1, o2) -> {
            String n1 = o1.getAccessor().getName();
            String n2 = o2.getAccessor().getName();
            float w1 = weights.getFloat(n1);
            float w2 = weights.getFloat(n2);
            return (int)(w1 - w2);
        });
    }

    public final void deserializeInto(@NotNull Object result, @NotNull Element element) {
        if (result == null) {
            BeanBinding.$$$reportNull$$$0(19);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(20);
        }
        this.deserializeInto(result, element, null);
    }

    public final void deserializeInto(@NotNull Object result, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (result == null) {
            BeanBinding.$$$reportNull$$$0(21);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(22);
        }
        block0: for (sqldelight.org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtilRt.isEmpty(attribute.getNamespaceURI())) continue;
            for (NestedBinding binding : this.bindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).name.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result, attribute.getValue());
                continue block0;
            }
        }
        LinkedHashMap<NestedBinding, List> data = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (NestedBinding binding : this.bindings) {
                if (content instanceof sqldelight.org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = new LinkedHashMap<NestedBinding, List>();
                    }
                    data.computeIfAbsent(binding, it -> new ArrayList()).add(child);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserializeUnsafe(result, child);
                continue block2;
            }
        }
        for (NestedBinding binding : this.bindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat) continue;
            binding.deserializeUnsafe(result, element);
        }
        if (data != null) {
            for (NestedBinding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result, (List)data.get(binding));
            }
        }
    }

    public final void deserializeInto(@NotNull Object result, @NotNull XmlElement element) {
        if (result == null) {
            BeanBinding.$$$reportNull$$$0(23);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(24);
        }
        int attributeBindingCount = 0;
        for (NestedBinding binding : this.bindings) {
            if (binding instanceof AttributeBinding) {
                ++attributeBindingCount;
                AttributeBinding attributeBinding = (AttributeBinding)binding;
                String value = element.attributes.get(attributeBinding.name);
                if (value == null) continue;
                attributeBinding.set(result, value);
                continue;
            }
            if (element.content == null || !(binding instanceof TextBinding)) continue;
            ((TextBinding)binding).set(result, element.content);
        }
        if (attributeBindingCount == this.bindings.length) {
            return;
        }
        LinkedHashMap<NestedBinding, List> data = null;
        block1: for (XmlElement child : element.children) {
            for (NestedBinding binding : this.bindings) {
                if (binding instanceof AttributeBinding || binding instanceof TextBinding || !binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = new LinkedHashMap<NestedBinding, List>();
                    }
                    data.computeIfAbsent(binding, it -> new ArrayList()).add(child);
                    continue block1;
                }
                binding.deserializeUnsafe(result, child);
                continue block1;
            }
        }
        for (NestedBinding binding : this.bindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat) continue;
            binding.deserializeUnsafe(result, element);
        }
        if (data != null) {
            for (NestedBinding binding : data.keySet()) {
                ((MultiNodeBinding)((Object)binding)).deserializeList2(result, (List)data.get(binding));
            }
        }
    }

    @Override
    public final boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(25);
        }
        return element.getName().equals(this.myTagName);
    }

    @Override
    public final boolean isBoundTo(@NotNull XmlElement element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(26);
        }
        return element.name.equals(this.myTagName);
    }

    @NotNull
    private static String getTagName(@NotNull Class<?> aClass) {
        int lastIndexOf;
        if (aClass == null) {
            BeanBinding.$$$reportNull$$$0(27);
        }
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            String string = name;
            if (string == null) {
                BeanBinding.$$$reportNull$$$0(28);
            }
            return string;
        }
        String name = aClass.getSimpleName();
        if (name.isEmpty()) {
            name = aClass.getSuperclass().getSimpleName();
        }
        if ((lastIndexOf = name.lastIndexOf(36)) > 0 && name.length() > lastIndexOf + 1) {
            String string = name.substring(lastIndexOf + 1);
            if (string == null) {
                BeanBinding.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            BeanBinding.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    private static String getTagNameFromAnnotation(@NotNull Class<?> aClass) {
        Tag tag;
        if (aClass == null) {
            BeanBinding.$$$reportNull$$$0(31);
        }
        return (tag = aClass.getAnnotation(Tag.class)) != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    public static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass) {
        if (aClass == null) {
            BeanBinding.$$$reportNull$$$0(32);
        }
        List<MutableAccessor> list = PROPERTY_COLLECTOR.collect(aClass);
        if (list == null) {
            BeanBinding.$$$reportNull$$$0(33);
        }
        return list;
    }

    private static boolean isAssertBindings(@NotNull Class<?> aClass) {
        if (aClass == null) {
            BeanBinding.$$$reportNull$$$0(34);
        }
        do {
            Property property;
            if ((property = aClass.getAnnotation(Property.class)) == null || property.assertIfNoBindings()) continue;
            return true;
        } while ((aClass = aClass.getSuperclass()) != null);
        return false;
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static NestedBinding createBinding(@NotNull MutableAccessor accessor, @NotNull Serializer serializer, @NotNull Property.Style propertyStyle) {
        XMap xMap;
        Attribute attribute;
        if (accessor == null) {
            BeanBinding.$$$reportNull$$$0(35);
        }
        if (serializer == null) {
            BeanBinding.$$$reportNull$$$0(36);
        }
        if (propertyStyle == null) {
            BeanBinding.$$$reportNull$$$0(37);
        }
        if ((attribute = accessor.getAnnotation(Attribute.class)) != null) {
            return new AttributeBinding(accessor, attribute);
        }
        Text text = accessor.getAnnotation(Text.class);
        if (text != null) {
            return new TextBinding(accessor);
        }
        OptionTag optionTag = accessor.getAnnotation(OptionTag.class);
        if (optionTag != null && optionTag.converter() != Converter.class) {
            return new OptionTagBinding(accessor, optionTag);
        }
        Binding binding = serializer.getBinding(accessor);
        if (binding instanceof JDOMElementBinding) {
            JDOMElementBinding jDOMElementBinding = (JDOMElementBinding)binding;
            if (jDOMElementBinding == null) {
                BeanBinding.$$$reportNull$$$0(38);
            }
            return jDOMElementBinding;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            return new TagBinding(accessor, tag);
        }
        if (binding instanceof CompactCollectionBinding) {
            return new AccessorBindingWrapper(accessor, binding, false, Property.Style.OPTION_TAG);
        }
        boolean surroundWithTag = true;
        boolean inline = false;
        Property property = accessor.getAnnotation(Property.class);
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
            inline = property.flat();
        }
        if (!surroundWithTag || inline) {
            if (inline && !(binding instanceof BeanBinding)) {
                throw new XmlSerializationException("inline supported only for BeanBinding: " + accessor);
            }
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            return new AccessorBindingWrapper(accessor, binding, inline, property.style());
        }
        XCollection xCollection = accessor.getAnnotation(XCollection.class);
        if (!(xCollection == null || xCollection.propertyElementName().isEmpty() && xCollection.style() != XCollection.Style.v2)) {
            return new TagBinding(accessor, xCollection.propertyElementName());
        }
        if (optionTag == null && (xMap = accessor.getAnnotation(XMap.class)) != null) {
            return new TagBinding(accessor, xMap.propertyElementName());
        }
        if (propertyStyle == Property.Style.ATTRIBUTE) {
            return new AttributeBinding(accessor, null);
        }
        return new OptionTagBinding(accessor, optionTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 8: 
            case 10: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorNameTracker";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weights";
                break;
            }
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeBindingWeights";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeInto";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serializePropertyInto";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 38: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "equalByFields";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeBindingWeights";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sortBindings";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deserializeInto";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTagNameFromAnnotation";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAccessors";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAssertBindings";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createBinding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyPropertyCollectorConfiguration
    extends PropertyCollector.Configuration {
        private MyPropertyCollectorConfiguration() {
            super(true, false, false);
        }

        @Override
        public boolean isAnnotatedAsTransient(@NotNull AnnotatedElement element) {
            if (element == null) {
                MyPropertyCollectorConfiguration.$$$reportNull$$$0(0);
            }
            return element.isAnnotationPresent(Transient.class);
        }

        @Override
        public boolean hasStoreAnnotations(@NotNull AccessibleObject element) {
            if (element == null) {
                MyPropertyCollectorConfiguration.$$$reportNull$$$0(1);
            }
            return element.isAnnotationPresent(OptionTag.class) || element.isAnnotationPresent(Tag.class) || element.isAnnotationPresent(Attribute.class) || element.isAnnotationPresent(Property.class) || element.isAnnotationPresent(Text.class) || element.isAnnotationPresent(CollectionBean.class) || element.isAnnotationPresent(MapAnnotation.class) || element.isAnnotationPresent(XMap.class) || element.isAnnotationPresent(XCollection.class) || element.isAnnotationPresent(AbstractCollection.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "sqldelight/com/intellij/util/xmlb/BeanBinding$MyPropertyCollectorConfiguration";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAnnotatedAsTransient";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasStoreAnnotations";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class XmlSerializerPropertyCollectorListClassValue
    extends ClassValue<List<MutableAccessor>> {
        @NotNull
        private final PropertyCollector.Configuration configuration;

        private XmlSerializerPropertyCollectorListClassValue(@NotNull PropertyCollector.Configuration configuration) {
            if (configuration == null) {
                XmlSerializerPropertyCollectorListClassValue.$$$reportNull$$$0(0);
            }
            this.configuration = configuration;
        }

        @Override
        protected List<MutableAccessor> computeValue(Class<?> aClass) {
            List<MutableAccessor> result = PropertyCollector.doCollect(aClass, this.configuration, null);
            if (result.isEmpty() && !BeanBinding.isAssertBindings(aClass)) {
                if (JDOMExternalizable.class.isAssignableFrom(aClass)) {
                    NotNullDeserializeBinding.LOG.error("Do not compute bindings for JDOMExternalizable: " + aClass.getName());
                } else if (aClass.isEnum()) {
                    NotNullDeserializeBinding.LOG.error("Do not compute bindings for enum: " + aClass.getName());
                } else if (aClass == String.class) {
                    NotNullDeserializeBinding.LOG.error("Do not compute bindings for String");
                }
                NotNullDeserializeBinding.LOG.warn("no accessors for " + aClass.getName());
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "sqldelight/com/intellij/util/xmlb/BeanBinding$XmlSerializerPropertyCollectorListClassValue", "<init>"));
        }
    }

    private static final class XmlSerializerPropertyCollector
    extends PropertyCollector {
        private final ClassValue<List<MutableAccessor>> accessorCache;

        XmlSerializerPropertyCollector(@NotNull PropertyCollector.Configuration configuration) {
            if (configuration == null) {
                XmlSerializerPropertyCollector.$$$reportNull$$$0(0);
            }
            super(configuration);
            this.accessorCache = new XmlSerializerPropertyCollectorListClassValue(configuration);
        }

        @Override
        @NotNull
        public List<MutableAccessor> collect(@NotNull Class<?> aClass) {
            if (aClass == null) {
                XmlSerializerPropertyCollector.$$$reportNull$$$0(1);
            }
            List<MutableAccessor> list = this.accessorCache.get(aClass);
            if (list == null) {
                XmlSerializerPropertyCollector.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/util/xmlb/BeanBinding$XmlSerializerPropertyCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/util/xmlb/BeanBinding$XmlSerializerPropertyCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "collect";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

