/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.anim.dom;

import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import sqldelight.org.apache.batik.anim.dom.SVGOMDocument;
import sqldelight.org.apache.batik.css.engine.CSSEngine;
import sqldelight.org.apache.batik.css.engine.CSSStyleSheetNode;
import sqldelight.org.apache.batik.css.engine.StyleSheet;
import sqldelight.org.apache.batik.dom.AbstractDocument;
import sqldelight.org.apache.batik.dom.StyleSheetFactory;
import sqldelight.org.apache.batik.dom.StyleSheetProcessingInstruction;
import sqldelight.org.apache.batik.util.ParsedURL;

public class SVGStyleSheetProcessingInstruction
extends StyleSheetProcessingInstruction
implements CSSStyleSheetNode {
    protected StyleSheet styleSheet;

    protected SVGStyleSheetProcessingInstruction() {
    }

    public SVGStyleSheetProcessingInstruction(String data, AbstractDocument owner, StyleSheetFactory f) {
        super(data, owner, f);
    }

    public String getStyleSheetURI() {
        SVGOMDocument svgDoc = (SVGOMDocument)this.getOwnerDocument();
        ParsedURL url = svgDoc.getParsedURL();
        String href = this.getPseudoAttributes().get("href");
        if (url != null) {
            return new ParsedURL(url, href).toString();
        }
        return href;
    }

    @Override
    public StyleSheet getCSSStyleSheet() {
        HashMap<String, String> attrs;
        String type2;
        if (this.styleSheet == null && "text/css".equals(type2 = (attrs = this.getPseudoAttributes()).get("type"))) {
            String title = attrs.get("title");
            String media = attrs.get("media");
            String href = attrs.get("href");
            String alternate = attrs.get("alternate");
            SVGOMDocument doc = (SVGOMDocument)this.getOwnerDocument();
            ParsedURL durl = doc.getParsedURL();
            ParsedURL burl = new ParsedURL(durl, href);
            CSSEngine e = doc.getCSSEngine();
            this.styleSheet = e.parseStyleSheet(burl, media);
            this.styleSheet.setAlternate("yes".equals(alternate));
            this.styleSheet.setTitle(title);
        }
        return this.styleSheet;
    }

    @Override
    public void setData(String data) throws DOMException {
        super.setData(data);
        this.styleSheet = null;
    }

    @Override
    protected Node newNode() {
        return new SVGStyleSheetProcessingInstruction();
    }
}

