/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.anim.dom;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import sqldelight.org.apache.batik.anim.dom.SVGOMElement;
import sqldelight.org.apache.batik.dom.svg.SVGOMPoint;
import sqldelight.org.apache.batik.dom.svg.SVGTextContent;
import sqldelight.org.w3c.dom.svg.SVGPoint;
import sqldelight.org.w3c.dom.svg.SVGRect;

public class SVGTextContentSupport {
    public static int getNumberOfChars(Element elt) {
        SVGOMElement svgelt = (SVGOMElement)elt;
        return ((SVGTextContent)((Object)svgelt.getSVGContext())).getNumberOfChars();
    }

    public static SVGRect getExtentOfChar(Element elt, final int charnum) {
        final SVGOMElement svgelt = (SVGOMElement)elt;
        if (charnum < 0 || charnum >= SVGTextContentSupport.getNumberOfChars(elt)) {
            throw svgelt.createDOMException((short)1, "", null);
        }
        final SVGTextContent context2 = (SVGTextContent)((Object)svgelt.getSVGContext());
        return new SVGRect(){

            @Override
            public float getX() {
                return (float)SVGTextContentSupport.getExtent(svgelt, context2, charnum).getX();
            }

            @Override
            public void setX(float x) throws DOMException {
                throw svgelt.createDOMException((short)7, "readonly.rect", null);
            }

            @Override
            public float getY() {
                return (float)SVGTextContentSupport.getExtent(svgelt, context2, charnum).getY();
            }

            @Override
            public void setY(float y) throws DOMException {
                throw svgelt.createDOMException((short)7, "readonly.rect", null);
            }

            @Override
            public float getWidth() {
                return (float)SVGTextContentSupport.getExtent(svgelt, context2, charnum).getWidth();
            }

            @Override
            public void setWidth(float width) throws DOMException {
                throw svgelt.createDOMException((short)7, "readonly.rect", null);
            }

            @Override
            public float getHeight() {
                return (float)SVGTextContentSupport.getExtent(svgelt, context2, charnum).getHeight();
            }

            @Override
            public void setHeight(float height) throws DOMException {
                throw svgelt.createDOMException((short)7, "readonly.rect", null);
            }
        };
    }

    protected static Rectangle2D getExtent(SVGOMElement svgelt, SVGTextContent context2, int charnum) {
        Rectangle2D r2d = context2.getExtentOfChar(charnum);
        if (r2d == null) {
            throw svgelt.createDOMException((short)1, "", null);
        }
        return r2d;
    }

    public static SVGPoint getStartPositionOfChar(Element elt, final int charnum) throws DOMException {
        SVGOMElement svgelt = (SVGOMElement)elt;
        if (charnum < 0 || charnum >= SVGTextContentSupport.getNumberOfChars(elt)) {
            throw svgelt.createDOMException((short)1, "", null);
        }
        final SVGTextContent context2 = (SVGTextContent)((Object)svgelt.getSVGContext());
        return new SVGTextPoint(svgelt){

            @Override
            public float getX() {
                return (float)SVGTextContentSupport.getStartPos(this.svgelt, context2, charnum).getX();
            }

            @Override
            public float getY() {
                return (float)SVGTextContentSupport.getStartPos(this.svgelt, context2, charnum).getY();
            }
        };
    }

    protected static Point2D getStartPos(SVGOMElement svgelt, SVGTextContent context2, int charnum) {
        Point2D p2d = context2.getStartPositionOfChar(charnum);
        if (p2d == null) {
            throw svgelt.createDOMException((short)1, "", null);
        }
        return p2d;
    }

    public static SVGPoint getEndPositionOfChar(Element elt, final int charnum) throws DOMException {
        SVGOMElement svgelt = (SVGOMElement)elt;
        if (charnum < 0 || charnum >= SVGTextContentSupport.getNumberOfChars(elt)) {
            throw svgelt.createDOMException((short)1, "", null);
        }
        final SVGTextContent context2 = (SVGTextContent)((Object)svgelt.getSVGContext());
        return new SVGTextPoint(svgelt){

            @Override
            public float getX() {
                return (float)SVGTextContentSupport.getEndPos(this.svgelt, context2, charnum).getX();
            }

            @Override
            public float getY() {
                return (float)SVGTextContentSupport.getEndPos(this.svgelt, context2, charnum).getY();
            }
        };
    }

    protected static Point2D getEndPos(SVGOMElement svgelt, SVGTextContent context2, int charnum) {
        Point2D p2d = context2.getEndPositionOfChar(charnum);
        if (p2d == null) {
            throw svgelt.createDOMException((short)1, "", null);
        }
        return p2d;
    }

    public static void selectSubString(Element elt, int charnum, int nchars) {
        SVGOMElement svgelt = (SVGOMElement)elt;
        if (charnum < 0 || charnum >= SVGTextContentSupport.getNumberOfChars(elt)) {
            throw svgelt.createDOMException((short)1, "", null);
        }
        SVGTextContent context2 = (SVGTextContent)((Object)svgelt.getSVGContext());
        context2.selectSubString(charnum, nchars);
    }

    public static float getRotationOfChar(Element elt, int charnum) {
        SVGOMElement svgelt = (SVGOMElement)elt;
        if (charnum < 0 || charnum >= SVGTextContentSupport.getNumberOfChars(elt)) {
            throw svgelt.createDOMException((short)1, "", null);
        }
        SVGTextContent context2 = (SVGTextContent)((Object)svgelt.getSVGContext());
        return context2.getRotationOfChar(charnum);
    }

    public static float getComputedTextLength(Element elt) {
        SVGOMElement svgelt = (SVGOMElement)elt;
        SVGTextContent context2 = (SVGTextContent)((Object)svgelt.getSVGContext());
        return context2.getComputedTextLength();
    }

    public static float getSubStringLength(Element elt, int charnum, int nchars) {
        SVGOMElement svgelt = (SVGOMElement)elt;
        if (charnum < 0 || charnum >= SVGTextContentSupport.getNumberOfChars(elt)) {
            throw svgelt.createDOMException((short)1, "", null);
        }
        SVGTextContent context2 = (SVGTextContent)((Object)svgelt.getSVGContext());
        return context2.getSubStringLength(charnum, nchars);
    }

    public static int getCharNumAtPosition(Element elt, float x, float y) throws DOMException {
        SVGOMElement svgelt = (SVGOMElement)elt;
        SVGTextContent context2 = (SVGTextContent)((Object)svgelt.getSVGContext());
        return context2.getCharNumAtPosition(x, y);
    }

    public static class SVGTextPoint
    extends SVGOMPoint {
        SVGOMElement svgelt;

        SVGTextPoint(SVGOMElement elem) {
            this.svgelt = elem;
        }

        @Override
        public void setX(float x) throws DOMException {
            throw this.svgelt.createDOMException((short)7, "readonly.point", null);
        }

        @Override
        public void setY(float y) throws DOMException {
            throw this.svgelt.createDOMException((short)7, "readonly.point", null);
        }
    }
}

