/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.bridge;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import sqldelight.org.apache.batik.bridge.BridgeContext;
import sqldelight.org.apache.batik.bridge.BridgeExtension;
import sqldelight.org.apache.batik.bridge.DocumentJarClassLoader;
import sqldelight.org.apache.batik.bridge.DocumentLoader;
import sqldelight.org.apache.batik.bridge.Messages;
import sqldelight.org.apache.batik.bridge.ScriptHandler;
import sqldelight.org.apache.batik.bridge.UserAgent;
import sqldelight.org.apache.batik.bridge.Window;
import sqldelight.org.apache.batik.dom.AbstractElement;
import sqldelight.org.apache.batik.dom.events.AbstractEvent;
import sqldelight.org.apache.batik.dom.events.NodeEventTarget;
import sqldelight.org.apache.batik.dom.util.XLinkSupport;
import sqldelight.org.apache.batik.util.ParsedURL;
import sqldelight.org.apache.batik.w3c.dom.Location;
import sqldelight.org.w3c.dom.svg.EventListenerInitializer;
import sqldelight.org.w3c.dom.svg.SVGDocument;
import sqldelight.org.w3c.dom.svg.SVGSVGElement;

public class BaseScriptingEnvironment {
    public static final String INLINE_SCRIPT_DESCRIPTION = "BaseScriptingEnvironment.constant.inline.script.description";
    public static final String EVENT_SCRIPT_DESCRIPTION = "BaseScriptingEnvironment.constant.event.script.description";
    protected static final String EVENT_NAME = "event";
    protected static final String ALTERNATE_EVENT_NAME = "evt";
    protected static final String APPLICATION_ECMASCRIPT = "application/ecmascript";
    protected BridgeContext bridgeContext;
    protected UserAgent userAgent;
    protected Document document;
    protected ParsedURL docPURL;
    protected Set languages = new HashSet();
    protected Object interpreter;
    protected Map windowObjects = new HashMap();
    protected WeakHashMap executedScripts = new WeakHashMap();

    public static boolean isDynamicDocument(BridgeContext ctx, Document doc) {
        Element elt = doc.getDocumentElement();
        if (elt != null && "http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
            if (elt.getAttributeNS(null, "onabort").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onresize").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onunload").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onscroll").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onzoom").length() > 0) {
                return true;
            }
            return BaseScriptingEnvironment.isDynamicElement(ctx, doc.getDocumentElement());
        }
        return false;
    }

    public static boolean isDynamicElement(BridgeContext ctx, Element elt) {
        List bridgeExtensions = ctx.getBridgeExtensions(elt.getOwnerDocument());
        return BaseScriptingEnvironment.isDynamicElement(elt, ctx, bridgeExtensions);
    }

    public static boolean isDynamicElement(Element elt, BridgeContext ctx, List bridgeExtensions) {
        for (Object bridgeExtension1 : bridgeExtensions) {
            BridgeExtension bridgeExtension = (BridgeExtension)bridgeExtension1;
            if (!bridgeExtension.isDynamicElement(elt)) continue;
            return true;
        }
        if ("http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
            if (elt.getAttributeNS(null, "onkeyup").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onkeydown").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onkeypress").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onload").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onactivate").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onclick").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onfocusin").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onfocusout").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmousedown").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmousemove").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmouseout").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmouseover").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmouseup").length() > 0) {
                return true;
            }
        }
        for (Node n = elt.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !BaseScriptingEnvironment.isDynamicElement(ctx, (Element)n)) continue;
            return true;
        }
        return false;
    }

    public BaseScriptingEnvironment(BridgeContext ctx) {
        this.bridgeContext = ctx;
        this.document = ctx.getDocument();
        this.docPURL = new ParsedURL(((SVGDocument)this.document).getURL());
        this.userAgent = this.bridgeContext.getUserAgent();
    }

    public sqldelight.org.apache.batik.bridge.Window getWindow(Object interp, String lang) {
        sqldelight.org.apache.batik.bridge.Window w = (sqldelight.org.apache.batik.bridge.Window)this.windowObjects.get(interp);
        if (w == null) {
            w = interp == null ? new Window(null, null) : this.createWindow(interp, lang);
            this.windowObjects.put(interp, w);
        }
        return w;
    }

    public sqldelight.org.apache.batik.bridge.Window getWindow() {
        return this.getWindow(null, null);
    }

    protected sqldelight.org.apache.batik.bridge.Window createWindow(Object interp, String lang) {
        return new Window(interp, lang);
    }

    public Object getInterpreter() {
        if (this.interpreter != null) {
            return this.interpreter;
        }
        SVGSVGElement root = (SVGSVGElement)this.document.getDocumentElement();
        String lang = root.getContentScriptType();
        return this.getInterpreter(lang);
    }

    public Object getInterpreter(String lang) {
        if (this.interpreter == null) {
            if (this.languages.contains(lang)) {
                return null;
            }
            this.languages.add(lang);
            return null;
        }
        if (!this.languages.contains(lang)) {
            this.languages.add(lang);
            this.initializeEnvironment(this.interpreter, lang);
        }
        return this.interpreter;
    }

    public void initializeEnvironment(Object interp, String lang) {
    }

    public void loadScripts() {
        NodeList scripts = this.document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "script");
        int len = scripts.getLength();
        for (int i = 0; i < len; ++i) {
            AbstractElement script = (AbstractElement)scripts.item(i);
            this.loadScript(script);
        }
    }

    protected void loadScript(AbstractElement script) {
        if (this.executedScripts.containsKey(script)) {
            return;
        }
        Node n = script;
        do {
            if ((n = n.getParentNode()) != null) continue;
            return;
        } while (n.getNodeType() != 9);
        String type2 = script.getAttributeNS(null, "type");
        if (type2.length() == 0) {
            type2 = "text/ecmascript";
        }
        if (type2.equals("application/java-archive")) {
            block39: {
                try {
                    String href = XLinkSupport.getXLinkHref(script);
                    ParsedURL purl = new ParsedURL(script.getBaseURI(), href);
                    this.checkCompatibleScriptURL(type2, purl);
                    URL docURL = null;
                    try {
                        docURL = new URL(this.docPURL.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    DocumentJarClassLoader cll = new DocumentJarClassLoader(new URL(purl.toString()), docURL);
                    URL url = cll.findResource("META-INF/MANIFEST.MF");
                    if (url == null) {
                        return;
                    }
                    Manifest man = new Manifest(url.openStream());
                    this.executedScripts.put(script, null);
                    String sh = man.getMainAttributes().getValue("Script-Handler");
                    if (sh != null) {
                        ScriptHandler h = (ScriptHandler)cll.loadClass(sh).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        h.run(this.document, this.getWindow());
                    }
                    if ((sh = man.getMainAttributes().getValue("SVG-Handler-Class")) != null) {
                        EventListenerInitializer initializer = (EventListenerInitializer)cll.loadClass(sh).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.getWindow();
                        initializer.initializeEventListeners((SVGDocument)this.document);
                    }
                }
                catch (Exception e) {
                    if (this.userAgent == null) break block39;
                    this.userAgent.displayError(e);
                }
            }
            return;
        }
        if (this.interpreter == null) {
            return;
        }
        try {
            String href = XLinkSupport.getXLinkHref(script);
            String desc = null;
            Reader reader = null;
            if (href.length() > 0) {
                desc = href;
                ParsedURL purl = new ParsedURL(script.getBaseURI(), href);
                this.checkCompatibleScriptURL(type2, purl);
                InputStream is = purl.openStream();
                String mediaType = purl.getContentTypeMediaType();
                String enc = purl.getContentTypeCharset();
                if (enc != null) {
                    try {
                        reader = new InputStreamReader(is, enc);
                    }
                    catch (UnsupportedEncodingException uee) {
                        enc = null;
                    }
                }
                if (reader == null) {
                    if (APPLICATION_ECMASCRIPT.equals(mediaType)) {
                        if (purl.hasContentTypeParameter("version")) {
                            return;
                        }
                        PushbackInputStream pbis = new PushbackInputStream(is, 8);
                        byte[] buf = new byte[4];
                        int read = pbis.read(buf);
                        if (read > 0) {
                            pbis.unread(buf, 0, read);
                            if (read >= 2) {
                                if (buf[0] == -1 && buf[1] == -2) {
                                    if (read >= 4 && buf[2] == 0 && buf[3] == 0) {
                                        enc = "UTF32-LE";
                                        pbis.skip(4L);
                                    } else {
                                        enc = "UTF-16LE";
                                        pbis.skip(2L);
                                    }
                                } else if (buf[0] == -2 && buf[1] == -1) {
                                    enc = "UTF-16BE";
                                    pbis.skip(2L);
                                } else if (read >= 3 && buf[0] == -17 && buf[1] == -69 && buf[2] == -65) {
                                    enc = "UTF-8";
                                    pbis.skip(3L);
                                } else if (read >= 4 && buf[0] == 0 && buf[1] == 0 && buf[2] == -2 && buf[3] == -1) {
                                    enc = "UTF-32BE";
                                    pbis.skip(4L);
                                }
                            }
                            if (enc == null) {
                                enc = "UTF-8";
                            }
                        }
                        reader = new InputStreamReader((InputStream)pbis, enc);
                    } else {
                        reader = new InputStreamReader(is);
                    }
                }
            } else {
                Node n2;
                this.checkCompatibleScriptURL(type2, this.docPURL);
                DocumentLoader dl = this.bridgeContext.getDocumentLoader();
                AbstractElement e = script;
                SVGDocument d = (SVGDocument)e.getOwnerDocument();
                int line = dl.getLineNumber(script);
                desc = Messages.formatMessage(INLINE_SCRIPT_DESCRIPTION, new Object[]{d.getURL(), "<" + script.getNodeName() + ">", line});
                if (n2 != null) {
                    StringBuffer sb = new StringBuffer();
                    for (n2 = script.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                        if (n2.getNodeType() != 4 && n2.getNodeType() != 3) continue;
                        sb.append(n2.getNodeValue());
                    }
                    reader = new StringReader(sb.toString());
                } else {
                    return;
                }
            }
            this.executedScripts.put(script, null);
        }
        catch (IOException e) {
            if (this.userAgent != null) {
                this.userAgent.displayError(e);
            }
            return;
        }
    }

    protected void checkCompatibleScriptURL(String scriptType, ParsedURL scriptPURL) {
        this.userAgent.checkLoadScript(scriptType, scriptPURL, this.docPURL);
    }

    public void dispatchSVGLoadEvent() {
        SVGSVGElement root = (SVGSVGElement)this.document.getDocumentElement();
        String lang = root.getContentScriptType();
        long documentStartTime = System.currentTimeMillis();
        this.dispatchSVGLoad(root, true, lang);
    }

    protected void dispatchSVGLoad(Element elt, boolean checkCanRun, String lang) {
        for (Node n = elt.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            this.dispatchSVGLoad((Element)n, checkCanRun, lang);
        }
        DocumentEvent de = (DocumentEvent)((Object)elt.getOwnerDocument());
        AbstractEvent ev = (AbstractEvent)de.createEvent("SVGEvents");
        String type2 = this.bridgeContext.isSVG12() ? "load" : "SVGLoad";
        ev.initEventNS("http://www.w3.org/2001/xml-events", type2, false, false);
        NodeEventTarget t = (NodeEventTarget)((Object)elt);
        String s = elt.getAttributeNS(null, "onload");
        if (s.length() == 0) {
            t.dispatchEvent(ev);
            return;
        }
        Object interp = this.getInterpreter();
        if (interp == null) {
            t.dispatchEvent(ev);
            return;
        }
        if (checkCanRun) {
            this.checkCompatibleScriptURL(lang, this.docPURL);
            checkCanRun = false;
        }
        DocumentLoader dl = this.bridgeContext.getDocumentLoader();
        SVGDocument d = (SVGDocument)elt.getOwnerDocument();
        int line = dl.getLineNumber(elt);
        String desc = Messages.formatMessage(EVENT_SCRIPT_DESCRIPTION, new Object[]{d.getURL(), "onload", line});
        EventListener l = new EventListener(){

            @Override
            public void handleEvent(Event evt) {
            }
        };
        t.addEventListenerNS("http://www.w3.org/2001/xml-events", type2, l, false, null);
        t.dispatchEvent(ev);
        t.removeEventListenerNS("http://www.w3.org/2001/xml-events", type2, l, false);
    }

    protected void dispatchSVGZoomEvent() {
        if (this.bridgeContext.isSVG12()) {
            this.dispatchSVGDocEvent("zoom");
        } else {
            this.dispatchSVGDocEvent("SVGZoom");
        }
    }

    protected void dispatchSVGScrollEvent() {
        if (this.bridgeContext.isSVG12()) {
            this.dispatchSVGDocEvent("scroll");
        } else {
            this.dispatchSVGDocEvent("SVGScroll");
        }
    }

    protected void dispatchSVGResizeEvent() {
        if (this.bridgeContext.isSVG12()) {
            this.dispatchSVGDocEvent("resize");
        } else {
            this.dispatchSVGDocEvent("SVGResize");
        }
    }

    protected void dispatchSVGDocEvent(String eventType) {
        SVGSVGElement root;
        SVGSVGElement t = root = (SVGSVGElement)this.document.getDocumentElement();
        DocumentEvent de = (DocumentEvent)((Object)this.document);
        AbstractEvent ev = (AbstractEvent)de.createEvent("SVGEvents");
        ev.initEventNS("http://www.w3.org/2001/xml-events", eventType, false, false);
        t.dispatchEvent(ev);
    }

    protected void handleInterpreterException(Object ie) {
        if (this.userAgent != null) {
            // empty if block
        }
    }

    protected void handleSecurityException(SecurityException se) {
        if (this.userAgent != null) {
            this.userAgent.displayError(se);
        }
    }

    protected class Window
    implements sqldelight.org.apache.batik.bridge.Window {
        protected Object interpreter;
        protected String language;

        public Window(Object interp, String lang) {
            this.interpreter = interp;
            this.language = lang;
        }

        @Override
        public Object setInterval(String script, long interval) {
            return null;
        }

        @Override
        public Object setInterval(Runnable r, long interval) {
            return null;
        }

        @Override
        public void clearInterval(Object interval) {
        }

        @Override
        public Object setTimeout(String script, long timeout) {
            return null;
        }

        @Override
        public Object setTimeout(Runnable r, long timeout) {
            return null;
        }

        @Override
        public void clearTimeout(Object timeout) {
        }

        @Override
        public Node parseXML(String text, Document doc) {
            return null;
        }

        @Override
        public String printNode(Node n) {
            return null;
        }

        @Override
        public void getURL(String uri, Window.URLResponseHandler h) {
            this.getURL(uri, h, "UTF8");
        }

        @Override
        public void getURL(String uri, Window.URLResponseHandler h, String enc) {
        }

        @Override
        public void postURL(String uri, String content, Window.URLResponseHandler h) {
            this.postURL(uri, content, h, "text/plain", null);
        }

        @Override
        public void postURL(String uri, String content, Window.URLResponseHandler h, String mimeType) {
            this.postURL(uri, content, h, mimeType, null);
        }

        @Override
        public void postURL(String uri, String content, Window.URLResponseHandler h, String mimeType, String fEnc) {
        }

        @Override
        public void alert(String message2) {
        }

        @Override
        public boolean confirm(String message2) {
            return false;
        }

        @Override
        public String prompt(String message2) {
            return null;
        }

        @Override
        public String prompt(String message2, String defVal) {
            return null;
        }

        @Override
        public BridgeContext getBridgeContext() {
            return BaseScriptingEnvironment.this.bridgeContext;
        }

        @Override
        public Object getInterpreter() {
            return this.interpreter;
        }

        @Override
        public Location getLocation() {
            return null;
        }

        @Override
        public sqldelight.org.apache.batik.w3c.dom.Window getParent() {
            return null;
        }
    }
}

