/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.dom.svg;

import org.w3c.dom.DOMException;
import sqldelight.org.apache.batik.dom.svg.AbstractSVGList;
import sqldelight.org.apache.batik.dom.svg.ListHandler;
import sqldelight.org.apache.batik.dom.svg.SVGItem;
import sqldelight.org.apache.batik.dom.svg.SVGPointItem;
import sqldelight.org.apache.batik.parser.ParseException;
import sqldelight.org.apache.batik.parser.PointsHandler;
import sqldelight.org.apache.batik.parser.PointsParser;
import sqldelight.org.w3c.dom.svg.SVGException;
import sqldelight.org.w3c.dom.svg.SVGPoint;
import sqldelight.org.w3c.dom.svg.SVGPointList;

public abstract class AbstractSVGPointList
extends AbstractSVGList
implements SVGPointList {
    public static final String SVG_POINT_LIST_SEPARATOR = " ";

    @Override
    protected String getItemSeparator() {
        return SVG_POINT_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    @Override
    public SVGPoint initialize(SVGPoint newItem) throws DOMException, SVGException {
        return (SVGPoint)((Object)this.initializeImpl(newItem));
    }

    @Override
    public SVGPoint getItem(int index) throws DOMException {
        return (SVGPoint)((Object)this.getItemImpl(index));
    }

    @Override
    public SVGPoint insertItemBefore(SVGPoint newItem, int index) throws DOMException, SVGException {
        return (SVGPoint)((Object)this.insertItemBeforeImpl(newItem, index));
    }

    @Override
    public SVGPoint replaceItem(SVGPoint newItem, int index) throws DOMException, SVGException {
        return (SVGPoint)((Object)this.replaceItemImpl(newItem, index));
    }

    @Override
    public SVGPoint removeItem(int index) throws DOMException {
        return (SVGPoint)((Object)this.removeItemImpl(index));
    }

    @Override
    public SVGPoint appendItem(SVGPoint newItem) throws DOMException, SVGException {
        return (SVGPoint)((Object)this.appendItemImpl(newItem));
    }

    @Override
    protected SVGItem createSVGItem(Object newItem) {
        SVGPoint point = (SVGPoint)newItem;
        return new SVGPointItem(point.getX(), point.getY());
    }

    @Override
    protected void doParse(String value, ListHandler handler) throws ParseException {
        PointsParser pointsParser = new PointsParser();
        PointsListBuilder builder = new PointsListBuilder(handler);
        pointsParser.setPointsHandler(builder);
        pointsParser.parse(value);
    }

    @Override
    protected void checkItemType(Object newItem) throws SVGException {
        if (!(newItem instanceof SVGPoint)) {
            this.createSVGException((short)0, "expected.point", null);
        }
    }

    protected static class PointsListBuilder
    implements PointsHandler {
        protected ListHandler listHandler;

        public PointsListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        @Override
        public void startPoints() throws ParseException {
            this.listHandler.startList();
        }

        @Override
        public void point(float x, float y) throws ParseException {
            this.listHandler.item(new SVGPointItem(x, y));
        }

        @Override
        public void endPoints() throws ParseException {
            this.listHandler.endList();
        }
    }
}

