/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.lucene.document;

import java.util.Objects;
import sqldelight.org.apache.lucene.document.Field;
import sqldelight.org.apache.lucene.document.FieldType;
import sqldelight.org.apache.lucene.document.RangeFieldQuery;
import sqldelight.org.apache.lucene.index.IndexableFieldType;
import sqldelight.org.apache.lucene.search.Query;
import sqldelight.org.apache.lucene.util.BytesRef;
import sqldelight.org.apache.lucene.util.NumericUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DoubleRange
extends Field {
    public static final int BYTES = 8;

    public DoubleRange(String name, double[] min, double[] max) {
        super(name, (IndexableFieldType)DoubleRange.getType((int)min.length));
        this.setRangeValues(min, max);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("DoubleRange does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 8);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(double[] min, double[] max) {
        byte[] bytes;
        DoubleRange.checkArgs((double[])min, (double[])max);
        if (min.length * 2 != this.type.pointDimensionCount() || max.length * 2 != this.type.pointDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[16 * min.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        DoubleRange.verifyAndEncode((double[])min, (double[])max, (byte[])bytes);
    }

    private static void checkArgs(double[] min, double[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min.length > 4) {
            throw new IllegalArgumentException("DoubleRange does not support greater than 4 dimensions");
        }
    }

    static byte[] encode(double[] min, double[] max) {
        DoubleRange.checkArgs((double[])min, (double[])max);
        byte[] b = new byte[16 * min.length];
        DoubleRange.verifyAndEncode((double[])min, (double[])max, (byte[])b);
        return b;
    }

    static void verifyAndEncode(double[] min, double[] max, byte[] bytes) {
        int d = 0;
        int i = 0;
        int j = min.length * 8;
        while (d < min.length) {
            if (Double.isNaN(min[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in DoubleRange");
            }
            if (Double.isNaN(max[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in DoubleRange");
            }
            if (min[d] > max[d]) {
                throw new IllegalArgumentException("min value (" + min[d] + ") is greater than max value (" + max[d] + ")");
            }
            DoubleRange.encode((double)min[d], (byte[])bytes, (int)i);
            DoubleRange.encode((double)max[d], (byte[])bytes, (int)j);
            ++d;
            i += 8;
            j += 8;
        }
    }

    private static void encode(double val, byte[] bytes, int offset) {
        NumericUtils.longToSortableBytes((long)NumericUtils.doubleToSortableLong((double)val), (byte[])bytes, (int)offset);
    }

    public double getMin(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return DoubleRange.decodeMin((byte[])((BytesRef)this.fieldsData).bytes, (int)dimension);
    }

    public double getMax(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return DoubleRange.decodeMax((byte[])((BytesRef)this.fieldsData).bytes, (int)dimension);
    }

    static double decodeMin(byte[] b, int dimension) {
        int offset = dimension * 8;
        return NumericUtils.sortableLongToDouble((long)NumericUtils.sortableBytesToLong((byte[])b, (int)offset));
    }

    static double decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 8;
        return NumericUtils.sortableLongToDouble((long)NumericUtils.sortableBytesToLong((byte[])b, (int)offset));
    }

    public static Query newIntersectsQuery(String field, double[] min, double[] max) {
        return DoubleRange.newRelationQuery((String)field, (double[])min, (double[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, double[] min, double[] max) {
        return DoubleRange.newRelationQuery((String)field, (double[])min, (double[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, double[] min, double[] max) {
        return DoubleRange.newRelationQuery((String)field, (double[])min, (double[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, double[] min, double[] max) {
        return DoubleRange.newRelationQuery((String)field, (double[])min, (double[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, double[] min, double[] max, RangeFieldQuery.QueryType relation) {
        DoubleRange.checkArgs((double[])min, (double[])max);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        DoubleRange.toString((byte[])b, (int)0);
        for (int d = 0; d < this.type.pointDimensionCount() / 2; ++d) {
            sb.append(' ');
            sb.append(DoubleRange.toString((byte[])b, (int)d));
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Double.toString(DoubleRange.decodeMin((byte[])ranges, (int)dimension)) + " : " + Double.toString(DoubleRange.decodeMax((byte[])ranges, (int)dimension)) + "]";
    }

    static /* synthetic */ String access$000(byte[] x0, int x1) {
        return DoubleRange.toString((byte[])x0, (int)x1);
    }
}

