/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import sqldelight.org.apache.lucene.index.LeafReaderContext;
import sqldelight.org.apache.lucene.index.ReaderUtil;
import sqldelight.org.apache.lucene.search.CollectorManager;
import sqldelight.org.apache.lucene.search.FieldComparator;
import sqldelight.org.apache.lucene.search.FieldDoc;
import sqldelight.org.apache.lucene.search.FieldValueHitQueue;
import sqldelight.org.apache.lucene.search.HitsThresholdChecker;
import sqldelight.org.apache.lucene.search.IndexSearcher;
import sqldelight.org.apache.lucene.search.MaxScoreAccumulator;
import sqldelight.org.apache.lucene.search.Query;
import sqldelight.org.apache.lucene.search.Scorable;
import sqldelight.org.apache.lucene.search.ScoreDoc;
import sqldelight.org.apache.lucene.search.ScoreMode;
import sqldelight.org.apache.lucene.search.Scorer;
import sqldelight.org.apache.lucene.search.ScorerSupplier;
import sqldelight.org.apache.lucene.search.Sort;
import sqldelight.org.apache.lucene.search.SortField;
import sqldelight.org.apache.lucene.search.TopDocs;
import sqldelight.org.apache.lucene.search.TopDocsCollector;
import sqldelight.org.apache.lucene.search.TopFieldCollector;
import sqldelight.org.apache.lucene.search.TopFieldDocs;
import sqldelight.org.apache.lucene.search.TotalHits;
import sqldelight.org.apache.lucene.search.Weight;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class TopFieldCollector
extends TopDocsCollector<FieldValueHitQueue.Entry> {
    private static final ScoreDoc[] EMPTY_SCOREDOCS = new ScoreDoc[0];
    final int numHits;
    final HitsThresholdChecker hitsThresholdChecker;
    final FieldComparator<?> firstComparator;
    final boolean canSetMinScore;
    Boolean searchSortPartOfIndexSort = null;
    final MaxScoreAccumulator minScoreAcc;
    float minCompetitiveScore;
    final int numComparators;
    FieldValueHitQueue.Entry bottom = null;
    boolean queueFull;
    int docBase;
    final boolean needsScores;
    final ScoreMode scoreMode;

    static boolean canEarlyTerminate(Sort searchSort, Sort indexSort) {
        return TopFieldCollector.canEarlyTerminateOnDocId((Sort)searchSort) || TopFieldCollector.canEarlyTerminateOnPrefix((Sort)searchSort, (Sort)indexSort);
    }

    private static boolean canEarlyTerminateOnDocId(Sort searchSort) {
        SortField[] fields1 = searchSort.getSort();
        return SortField.FIELD_DOC.equals((Object)fields1[0]);
    }

    private static boolean canEarlyTerminateOnPrefix(Sort searchSort, Sort indexSort) {
        if (indexSort != null) {
            SortField[] fields2;
            SortField[] fields1 = searchSort.getSort();
            if (fields1.length > (fields2 = indexSort.getSort()).length) {
                return false;
            }
            return Arrays.asList(fields1).equals(Arrays.asList(fields2).subList(0, fields1.length));
        }
        return false;
    }

    private TopFieldCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> pq, int numHits, HitsThresholdChecker hitsThresholdChecker, boolean needsScores, MaxScoreAccumulator minScoreAcc) {
        super(pq);
        this.needsScores = needsScores;
        this.numHits = numHits;
        this.hitsThresholdChecker = hitsThresholdChecker;
        this.numComparators = pq.getComparators().length;
        this.firstComparator = pq.getComparators()[0];
        int reverseMul = pq.reverseMul[0];
        if (this.firstComparator.getClass().equals(FieldComparator.RelevanceComparator.class) && reverseMul == 1 && hitsThresholdChecker.getHitsThreshold() != Integer.MAX_VALUE) {
            this.scoreMode = ScoreMode.TOP_SCORES;
            this.canSetMinScore = true;
        } else {
            this.canSetMinScore = false;
            this.scoreMode = hitsThresholdChecker.getHitsThreshold() != Integer.MAX_VALUE ? (needsScores ? ScoreMode.TOP_DOCS_WITH_SCORES : ScoreMode.TOP_DOCS) : (needsScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES);
        }
        this.minScoreAcc = minScoreAcc;
    }

    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    protected void updateGlobalMinCompetitiveScore(Scorable scorer) throws IOException {
        MaxScoreAccumulator.DocAndScore maxMinScore;
        assert (this.minScoreAcc != null);
        if (this.canSetMinScore && this.hitsThresholdChecker.isThresholdReached() && (maxMinScore = this.minScoreAcc.get()) != null && maxMinScore.score > this.minCompetitiveScore) {
            scorer.setMinCompetitiveScore(maxMinScore.score);
            this.minCompetitiveScore = maxMinScore.score;
            this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }
    }

    protected void updateMinCompetitiveScore(Scorable scorer) throws IOException {
        if (this.canSetMinScore && this.queueFull && this.hitsThresholdChecker.isThresholdReached()) {
            assert (this.bottom != null);
            float minScore = ((Float)this.firstComparator.value(this.bottom.slot)).floatValue();
            if (minScore > this.minCompetitiveScore) {
                scorer.setMinCompetitiveScore(minScore);
                this.minCompetitiveScore = minScore;
                this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                if (this.minScoreAcc != null) {
                    this.minScoreAcc.accumulate(this.docBase, minScore);
                }
            }
        }
    }

    public static TopFieldCollector create(Sort sort, int numHits, int totalHitsThreshold) {
        return TopFieldCollector.create((Sort)sort, (int)numHits, null, (int)totalHitsThreshold);
    }

    public static TopFieldCollector create(Sort sort, int numHits, FieldDoc after, int totalHitsThreshold) {
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
        }
        return TopFieldCollector.create((Sort)sort, (int)numHits, (FieldDoc)after, (HitsThresholdChecker)HitsThresholdChecker.create((int)Math.max(totalHitsThreshold, numHits)), null);
    }

    static TopFieldCollector create(Sort sort, int numHits, FieldDoc after, HitsThresholdChecker hitsThresholdChecker, MaxScoreAccumulator minScoreAcc) {
        if (sort.fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (hitsThresholdChecker == null) {
            throw new IllegalArgumentException("hitsThresholdChecker should not be null");
        }
        FieldValueHitQueue queue = FieldValueHitQueue.create((SortField[])sort.fields, (int)numHits);
        if (after == null) {
            if (queue.comparators.length == 1) {
                queue.comparators[0].setSingleSort();
            }
            return new SimpleFieldCollector(sort, queue, numHits, hitsThresholdChecker, minScoreAcc);
        }
        if (after.fields == null) {
            throw new IllegalArgumentException("after.fields wasn't set; you must pass fillFields=true for the previous search");
        }
        if (after.fields.length != sort.getSort().length) {
            throw new IllegalArgumentException("after.fields has " + after.fields.length + " values but sort has " + sort.getSort().length);
        }
        return new PagingFieldCollector(sort, queue, after, numHits, hitsThresholdChecker, minScoreAcc);
    }

    public static CollectorManager<TopFieldCollector, TopFieldDocs> createSharedManager(Sort sort, int numHits, FieldDoc after, int totalHitsThreshold) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static void populateScores(ScoreDoc[] topDocs, IndexSearcher searcher, Query query) throws IOException {
        topDocs = (ScoreDoc[])topDocs.clone();
        Arrays.sort(topDocs, Comparator.comparingInt(scoreDoc -> scoreDoc.doc));
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE, 1.0f);
        List contexts = searcher.getIndexReader().leaves();
        LeafReaderContext currentContext = null;
        Scorer currentScorer = null;
        for (ScoreDoc scoreDoc2 : topDocs) {
            if (currentContext == null || scoreDoc2.doc >= currentContext.docBase + currentContext.reader().maxDoc()) {
                Objects.checkIndex(scoreDoc2.doc, searcher.getIndexReader().maxDoc());
                int newContextIndex = ReaderUtil.subIndex((int)scoreDoc2.doc, (List)contexts);
                currentContext = (LeafReaderContext)contexts.get(newContextIndex);
                ScorerSupplier scorerSupplier = weight.scorerSupplier(currentContext);
                if (scorerSupplier == null) {
                    throw new IllegalArgumentException("Doc id " + scoreDoc2.doc + " doesn't match the query");
                }
                currentScorer = scorerSupplier.get(1L);
            }
            int leafDoc = scoreDoc2.doc - currentContext.docBase;
            assert (leafDoc >= 0);
            int advanced = currentScorer.iterator().advance(leafDoc);
            if (leafDoc != advanced) {
                throw new IllegalArgumentException("Doc id " + scoreDoc2.doc + " doesn't match the query");
            }
            scoreDoc2.score = currentScorer.score();
        }
    }

    final void add(int slot, int doc) {
        this.bottom = (FieldValueHitQueue.Entry)this.pq.add((Object)new FieldValueHitQueue.Entry(slot, this.docBase + doc));
        this.queueFull = this.totalHits == this.numHits;
    }

    final void updateBottom(int doc) {
        this.bottom.doc = this.docBase + doc;
        this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
    }

    protected void populateResults(ScoreDoc[] results, int howMany) {
        FieldValueHitQueue queue = (FieldValueHitQueue)this.pq;
        for (int i = howMany - 1; i >= 0; --i) {
            results[i] = queue.fillFields((FieldValueHitQueue.Entry)queue.pop());
        }
    }

    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            results = EMPTY_SCOREDOCS;
        }
        return new TopFieldDocs(new TotalHits((long)this.totalHits, this.totalHitsRelation), results, ((FieldValueHitQueue)this.pq).getFields());
    }

    public TopFieldDocs topDocs() {
        return (TopFieldDocs)super.topDocs();
    }

    public boolean isEarlyTerminated() {
        return this.totalHitsRelation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
    }
}

