/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.lucene.util;

import java.util.Arrays;
import sqldelight.org.apache.lucene.util.Accountable;
import sqldelight.org.apache.lucene.util.ByteBlockPool;
import sqldelight.org.apache.lucene.util.BytesRef;
import sqldelight.org.apache.lucene.util.BytesRefHash;
import sqldelight.org.apache.lucene.util.Counter;
import sqldelight.org.apache.lucene.util.RamUsageEstimator;
import sqldelight.org.apache.lucene.util.StringHelper;

public final class BytesRefHash
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(BytesRefHash.class) + (long)((Integer)RamUsageEstimator.primitiveSizes.get(Long.TYPE)).intValue();
    public static final int DEFAULT_CAPACITY = 16;
    final ByteBlockPool pool;
    int[] bytesStart;
    private int hashSize;
    private int hashHalfSize;
    private int hashMask;
    private int count;
    private int lastCount = -1;
    private int[] ids;
    private final BytesStartArray bytesStartArray;
    private Counter bytesUsed;

    public BytesRefHash() {
        this(new ByteBlockPool((ByteBlockPool.Allocator)new ByteBlockPool.DirectAllocator()));
    }

    public BytesRefHash(ByteBlockPool pool) {
        this(pool, 16, (BytesStartArray)new DirectBytesStartArray(16));
    }

    public BytesRefHash(ByteBlockPool pool, int capacity, BytesStartArray bytesStartArray) {
        this.hashSize = capacity;
        this.hashHalfSize = this.hashSize >> 1;
        this.hashMask = this.hashSize - 1;
        this.pool = pool;
        this.ids = new int[this.hashSize];
        Arrays.fill(this.ids, -1);
        this.bytesStartArray = bytesStartArray;
        this.bytesStart = bytesStartArray.init();
        this.bytesUsed = bytesStartArray.bytesUsed() == null ? Counter.newCounter() : bytesStartArray.bytesUsed();
        this.bytesUsed.addAndGet((long)(this.hashSize * 4));
    }

    public int size() {
        return this.count;
    }

    public BytesRef get(int bytesID, BytesRef ref) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        assert (bytesID < this.bytesStart.length) : "bytesID exceeds byteStart len: " + this.bytesStart.length;
        this.pool.setBytesRef(ref, this.bytesStart[bytesID]);
        return ref;
    }

    public int[] compact() {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        int upto = 0;
        for (int i = 0; i < this.hashSize; ++i) {
            if (this.ids[i] == -1) continue;
            if (upto < i) {
                this.ids[upto] = this.ids[i];
                this.ids[i] = -1;
            }
            ++upto;
        }
        assert (upto == this.count);
        this.lastCount = this.count;
        return this.ids;
    }

    public int[] sort() {
        int[] compact = this.compact();
        new /* Unavailable Anonymous Inner Class!! */.sort(0, this.count);
        return compact;
    }

    private boolean equals(int id, BytesRef b) {
        int offset;
        int length;
        int textStart = this.bytesStart[id];
        byte[] bytes = this.pool.buffers[textStart >> 15];
        int pos = textStart & Short.MAX_VALUE;
        if ((bytes[pos] & 0x80) == 0) {
            length = bytes[pos];
            offset = pos + 1;
        } else {
            length = (bytes[pos] & 0x7F) + ((bytes[pos + 1] & 0xFF) << 7);
            offset = pos + 2;
        }
        return Arrays.equals(bytes, offset, offset + length, b.bytes, b.offset, b.offset + b.length);
    }

    private boolean shrink(int targetSize) {
        int newSize;
        for (newSize = this.hashSize; newSize >= 8 && newSize / 4 > targetSize; newSize /= 2) {
        }
        if (newSize != this.hashSize) {
            this.bytesUsed.addAndGet((long)(4 * -(this.hashSize - newSize)));
            this.hashSize = newSize;
            this.ids = new int[this.hashSize];
            Arrays.fill(this.ids, -1);
            this.hashHalfSize = newSize / 2;
            this.hashMask = newSize - 1;
            return true;
        }
        return false;
    }

    public void clear(boolean resetPool) {
        this.lastCount = this.count;
        this.count = 0;
        if (resetPool) {
            this.pool.reset(false, false);
        }
        this.bytesStart = this.bytesStartArray.clear();
        if (this.lastCount != -1 && this.shrink(this.lastCount)) {
            return;
        }
        Arrays.fill(this.ids, -1);
    }

    public void clear() {
        this.clear(true);
    }

    public void close() {
        this.clear(true);
        this.ids = null;
        this.bytesUsed.addAndGet((long)(4 * -this.hashSize));
    }

    public int add(BytesRef bytes) {
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        int length = bytes.length;
        int hashPos = this.findHash(bytes);
        int e = this.ids[hashPos];
        if (e == -1) {
            int len2 = 2 + bytes.length;
            if (len2 + this.pool.byteUpto > 32768) {
                if (len2 > 32768) {
                    throw new MaxBytesLengthExceededException("bytes can be at most 32766 in length; got " + bytes.length);
                }
                this.pool.nextBuffer();
            }
            byte[] buffer = this.pool.buffer;
            int bufferUpto = this.pool.byteUpto;
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                assert (this.count < this.bytesStart.length + 1) : "count: " + this.count + " len: " + this.bytesStart.length;
            }
            e = this.count++;
            this.bytesStart[e] = bufferUpto + this.pool.byteOffset;
            if (length < 128) {
                buffer[bufferUpto] = (byte)length;
                this.pool.byteUpto += length + 1;
                assert (length >= 0) : "Length must be positive: " + length;
                System.arraycopy(bytes.bytes, bytes.offset, buffer, bufferUpto + 1, length);
            } else {
                buffer[bufferUpto] = (byte)(0x80 | length & 0x7F);
                buffer[bufferUpto + 1] = (byte)(length >> 7 & 0xFF);
                this.pool.byteUpto += length + 2;
                System.arraycopy(bytes.bytes, bytes.offset, buffer, bufferUpto + 2, length);
            }
            assert (this.ids[hashPos] == -1);
            this.ids[hashPos] = e;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, true);
            }
            return e;
        }
        return -(e + 1);
    }

    public int find(BytesRef bytes) {
        return this.ids[this.findHash(bytes)];
    }

    private int findHash(BytesRef bytes) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        int code = this.doHash(bytes.bytes, bytes.offset, bytes.length);
        int hashPos = code & this.hashMask;
        int e = this.ids[hashPos];
        if (e != -1 && !this.equals(e, bytes)) {
            while ((e = this.ids[hashPos = ++code & this.hashMask]) != -1 && !this.equals(e, bytes)) {
            }
        }
        return hashPos;
    }

    public int addByPoolOffset(int offset) {
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        int code = offset;
        int hashPos = offset & this.hashMask;
        int e = this.ids[hashPos];
        if (e != -1 && this.bytesStart[e] != offset) {
            while ((e = this.ids[hashPos = ++code & this.hashMask]) != -1 && this.bytesStart[e] != offset) {
            }
        }
        if (e == -1) {
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                assert (this.count < this.bytesStart.length + 1) : "count: " + this.count + " len: " + this.bytesStart.length;
            }
            e = this.count++;
            this.bytesStart[e] = offset;
            assert (this.ids[hashPos] == -1);
            this.ids[hashPos] = e;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, false);
            }
            return e;
        }
        return -(e + 1);
    }

    private void rehash(int newSize, boolean hashOnData) {
        int newMask = newSize - 1;
        this.bytesUsed.addAndGet((long)(4 * newSize));
        int[] newHash = new int[newSize];
        Arrays.fill(newHash, -1);
        for (int i = 0; i < this.hashSize; ++i) {
            int code;
            int e0 = this.ids[i];
            if (e0 == -1) continue;
            if (hashOnData) {
                int pos;
                int len;
                int off = this.bytesStart[e0];
                byte[] bytes = this.pool.buffers[off >> 15];
                int start = off & Short.MAX_VALUE;
                if ((bytes[start] & 0x80) == 0) {
                    len = bytes[start];
                    pos = start + 1;
                } else {
                    len = (bytes[start] & 0x7F) + ((bytes[start + 1] & 0xFF) << 7);
                    pos = start + 2;
                }
                code = this.doHash(bytes, pos, len);
            } else {
                code = this.bytesStart[e0];
            }
            int hashPos = code & newMask;
            assert (hashPos >= 0);
            if (newHash[hashPos] != -1) {
                while (newHash[hashPos = ++code & newMask] != -1) {
                }
            }
            newHash[hashPos] = e0;
        }
        this.hashMask = newMask;
        this.bytesUsed.addAndGet((long)(4 * -this.ids.length));
        this.ids = newHash;
        this.hashSize = newSize;
        this.hashHalfSize = newSize / 2;
    }

    private int doHash(byte[] bytes, int offset, int length) {
        return StringHelper.murmurhash3_x86_32((byte[])bytes, (int)offset, (int)length, (int)StringHelper.GOOD_FAST_HASH_SEED);
    }

    public void reinit() {
        if (this.bytesStart == null) {
            this.bytesStart = this.bytesStartArray.init();
        }
        if (this.ids == null) {
            this.ids = new int[this.hashSize];
            this.bytesUsed.addAndGet((long)(4 * this.hashSize));
        }
    }

    public int byteStart(int bytesID) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        assert (bytesID >= 0 && bytesID < this.count) : bytesID;
        return this.bytesStart[bytesID];
    }

    public long ramBytesUsed() {
        long size = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject((Object)this.bytesStart) + RamUsageEstimator.sizeOfObject((Object)this.ids) + RamUsageEstimator.sizeOfObject((Object)this.pool);
        return size;
    }
}

