/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import sqldelight.org.bouncycastle.asn1.ASN1BitString;
import sqldelight.org.bouncycastle.asn1.ASN1Encodable;
import sqldelight.org.bouncycastle.asn1.ASN1EncodableVector;
import sqldelight.org.bouncycastle.asn1.ASN1External;
import sqldelight.org.bouncycastle.asn1.ASN1OctetString;
import sqldelight.org.bouncycastle.asn1.ASN1Primitive;
import sqldelight.org.bouncycastle.asn1.ASN1SequenceParser;
import sqldelight.org.bouncycastle.asn1.ASN1Set;
import sqldelight.org.bouncycastle.asn1.ASN1TaggedObject;
import sqldelight.org.bouncycastle.asn1.ASN1UniversalType;
import sqldelight.org.bouncycastle.asn1.DERSequence;
import sqldelight.org.bouncycastle.asn1.DLSequence;
import sqldelight.org.bouncycastle.util.Arrays;
import sqldelight.org.bouncycastle.util.Iterable;

public abstract class ASN1Sequence
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    static final ASN1UniversalType TYPE = new /* Unavailable Anonymous Inner Class!! */;
    ASN1Encodable[] elements;

    public static ASN1Sequence getInstance(Object object) {
        if (object == null || object instanceof ASN1Sequence) {
            return (ASN1Sequence)object;
        }
        if (object instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1Sequence) {
                return (ASN1Sequence)aSN1Primitive;
            }
        } else if (object instanceof byte[]) {
            try {
                return (ASN1Sequence)TYPE.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1Sequence)TYPE.getContextInstance(aSN1TaggedObject, bl);
    }

    protected ASN1Sequence() {
        this.elements = ASN1EncodableVector.EMPTY_ELEMENTS;
    }

    protected ASN1Sequence(ASN1Encodable aSN1Encodable) {
        if (null == aSN1Encodable) {
            throw new NullPointerException("'element' cannot be null");
        }
        this.elements = new ASN1Encodable[]{aSN1Encodable};
    }

    protected ASN1Sequence(ASN1EncodableVector aSN1EncodableVector) {
        if (null == aSN1EncodableVector) {
            throw new NullPointerException("'elementVector' cannot be null");
        }
        this.elements = aSN1EncodableVector.takeElements();
    }

    protected ASN1Sequence(ASN1Encodable[] aSN1EncodableArray) {
        if (Arrays.isNullOrContainsNull((Object[])aSN1EncodableArray)) {
            throw new NullPointerException("'elements' cannot be null, or contain null");
        }
        this.elements = ASN1EncodableVector.cloneElements((ASN1Encodable[])aSN1EncodableArray);
    }

    ASN1Sequence(ASN1Encodable[] aSN1EncodableArray, boolean bl) {
        this.elements = bl ? ASN1EncodableVector.cloneElements((ASN1Encodable[])aSN1EncodableArray) : aSN1EncodableArray;
    }

    public ASN1Encodable[] toArray() {
        return ASN1EncodableVector.cloneElements((ASN1Encodable[])this.elements);
    }

    ASN1Encodable[] toArrayInternal() {
        return this.elements;
    }

    public Enumeration getObjects() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ASN1SequenceParser parser() {
        int n = this.size();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ASN1Encodable getObjectAt(int n) {
        return this.elements[n];
    }

    public int size() {
        return this.elements.length;
    }

    public int hashCode() {
        int n = this.elements.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= this.elements[n].toASN1Primitive().hashCode();
        }
        return n2;
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
        int n = this.size();
        if (aSN1Sequence.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            ASN1Primitive aSN1Primitive2;
            ASN1Primitive aSN1Primitive3 = this.elements[i].toASN1Primitive();
            if (aSN1Primitive3 == (aSN1Primitive2 = aSN1Sequence.elements[i].toASN1Primitive()) || aSN1Primitive3.asn1Equals(aSN1Primitive2)) continue;
            return false;
        }
        return true;
    }

    ASN1Primitive toDERObject() {
        return new DERSequence(this.elements, false);
    }

    ASN1Primitive toDLObject() {
        return new DLSequence(this.elements, false);
    }

    abstract ASN1BitString toASN1BitString();

    abstract ASN1External toASN1External();

    abstract ASN1OctetString toASN1OctetString();

    abstract ASN1Set toASN1Set();

    boolean encodeConstructed() {
        return true;
    }

    public String toString() {
        int n = this.size();
        if (0 == n) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n2 = 0;
        while (true) {
            stringBuffer.append(this.elements[n2]);
            if (++n2 >= n) break;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator((Object[])this.elements);
    }

    ASN1BitString[] getConstructedBitStrings() {
        int n = this.size();
        ASN1BitString[] aSN1BitStringArray = new ASN1BitString[n];
        for (int i = 0; i < n; ++i) {
            aSN1BitStringArray[i] = ASN1BitString.getInstance((Object)this.elements[i]);
        }
        return aSN1BitStringArray;
    }

    ASN1OctetString[] getConstructedOctetStrings() {
        int n = this.size();
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[n];
        for (int i = 0; i < n; ++i) {
            aSN1OctetStringArray[i] = ASN1OctetString.getInstance((Object)this.elements[i]);
        }
        return aSN1OctetStringArray;
    }
}

