/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.asn1;

import java.io.IOException;
import sqldelight.org.bouncycastle.asn1.ASN1Encodable;
import sqldelight.org.bouncycastle.asn1.ASN1OutputStream;
import sqldelight.org.bouncycastle.asn1.ASN1Primitive;
import sqldelight.org.bouncycastle.asn1.ASN1String;
import sqldelight.org.bouncycastle.asn1.ASN1TaggedObject;
import sqldelight.org.bouncycastle.asn1.ASN1UniversalType;
import sqldelight.org.bouncycastle.asn1.DERVideotexString;
import sqldelight.org.bouncycastle.util.Arrays;
import sqldelight.org.bouncycastle.util.Strings;

public abstract class ASN1VideotexString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new /* Unavailable Anonymous Inner Class!! */;
    final byte[] contents;

    public static ASN1VideotexString getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1VideotexString) {
            return (ASN1VideotexString)object;
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1VideotexString) {
            return (ASN1VideotexString)aSN1Primitive;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1VideotexString)TYPE.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1VideotexString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1VideotexString)TYPE.getContextInstance(aSN1TaggedObject, bl);
    }

    ASN1VideotexString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone((byte[])byArray) : byArray;
    }

    public final byte[] getOctets() {
        return Arrays.clone((byte[])this.contents);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL((boolean)bl, (int)this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 21, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1VideotexString)) {
            return false;
        }
        ASN1VideotexString aSN1VideotexString = (ASN1VideotexString)aSN1Primitive;
        return Arrays.areEqual((byte[])this.contents, (byte[])aSN1VideotexString.contents);
    }

    public final int hashCode() {
        return Arrays.hashCode((byte[])this.contents);
    }

    public final String getString() {
        return Strings.fromByteArray((byte[])this.contents);
    }

    static ASN1VideotexString createPrimitive(byte[] byArray) {
        return new DERVideotexString(byArray, false);
    }
}

