/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.crypto.params;

import sqldelight.org.bouncycastle.util.Arrays;

public class DSAValidationParameters {
    private int usageIndex;
    private byte[] seed;
    private int counter;

    public DSAValidationParameters(byte[] byArray, int n) {
        this(byArray, n, -1);
    }

    public DSAValidationParameters(byte[] byArray, int n, int n2) {
        this.seed = Arrays.clone((byte[])byArray);
        this.counter = n;
        this.usageIndex = n2;
    }

    public int getCounter() {
        return this.counter;
    }

    public byte[] getSeed() {
        return Arrays.clone((byte[])this.seed);
    }

    public int getUsageIndex() {
        return this.usageIndex;
    }

    public int hashCode() {
        return this.counter ^ Arrays.hashCode((byte[])this.seed);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSAValidationParameters)) {
            return false;
        }
        DSAValidationParameters dSAValidationParameters = (DSAValidationParameters)object;
        if (dSAValidationParameters.counter != this.counter) {
            return false;
        }
        return Arrays.areEqual((byte[])this.seed, (byte[])dSAValidationParameters.seed);
    }
}

