/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.io.IOException;
import java.security.interfaces.XECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.util.Optional;
import sqldelight.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import sqldelight.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqldelight.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import sqldelight.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import sqldelight.org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import sqldelight.org.bouncycastle.jcajce.provider.asymmetric.edec.BC11XDHPublicKey;
import sqldelight.org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;

class BC11XDHPrivateKey
extends BCXDHPrivateKey
implements XECPrivateKey {
    BC11XDHPrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(asymmetricKeyParameter);
    }

    BC11XDHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        super(privateKeyInfo);
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return NamedParameterSpec.X448;
        }
        return NamedParameterSpec.X25519;
    }

    public XDHPublicKey getPublicKey() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return new BC11XDHPublicKey((AsymmetricKeyParameter)((X448PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey());
        }
        return new BC11XDHPublicKey((AsymmetricKeyParameter)((X25519PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey());
    }

    @Override
    public Optional<byte[]> getScalar() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return Optional.of(((X448PrivateKeyParameters)this.xdhPrivateKey).getEncoded());
        }
        return Optional.of(((X25519PrivateKeyParameters)this.xdhPrivateKey).getEncoded());
    }
}

