/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.jcajce.provider.asymmetric.util;

import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sqldelight.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import sqldelight.org.bouncycastle.asn1.ASN1Sequence;
import sqldelight.org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import sqldelight.org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import sqldelight.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import sqldelight.org.bouncycastle.asn1.x9.X962Parameters;
import sqldelight.org.bouncycastle.asn1.x9.X9ECParameters;
import sqldelight.org.bouncycastle.crypto.ec.CustomNamedCurves;
import sqldelight.org.bouncycastle.crypto.params.ECDomainParameters;
import sqldelight.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import sqldelight.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import sqldelight.org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import sqldelight.org.bouncycastle.jce.provider.BouncyCastleProvider;
import sqldelight.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import sqldelight.org.bouncycastle.jce.spec.ECNamedCurveSpec;
import sqldelight.org.bouncycastle.jce.spec.ECParameterSpec;
import sqldelight.org.bouncycastle.math.ec.ECAlgorithms;
import sqldelight.org.bouncycastle.math.ec.ECCurve;
import sqldelight.org.bouncycastle.math.ec.ECPoint;
import sqldelight.org.bouncycastle.math.field.FiniteField;
import sqldelight.org.bouncycastle.math.field.Polynomial;
import sqldelight.org.bouncycastle.math.field.PolynomialExtensionField;
import sqldelight.org.bouncycastle.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public class EC5Util {
    private static Map customCurves;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ECCurve getCurve(ProviderConfiguration providerConfiguration, X962Parameters x962Parameters) {
        Set set = providerConfiguration.getAcceptableNamedCurves();
        if (x962Parameters.isNamedCurve()) {
            X9ECParameters x9ECParameters;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)x962Parameters.getParameters());
            if (!set.isEmpty()) {
                if (!set.contains(aSN1ObjectIdentifier)) throw new IllegalStateException("named curve not acceptable");
            }
            if ((x9ECParameters = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1ObjectIdentifier)) != null) return x9ECParameters.getCurve();
            x9ECParameters = (X9ECParameters)providerConfiguration.getAdditionalECParameters().get(aSN1ObjectIdentifier);
            return x9ECParameters.getCurve();
        }
        if (x962Parameters.isImplicitlyCA()) {
            return providerConfiguration.getEcImplicitlyCa().getCurve();
        }
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)x962Parameters.getParameters());
        if (!set.isEmpty()) throw new IllegalStateException("encoded parameters not acceptable");
        if (aSN1Sequence.size() > 3) {
            X9ECParameters x9ECParameters = X9ECParameters.getInstance((Object)aSN1Sequence);
            return x9ECParameters.getCurve();
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(0));
        return ECGOST3410NamedCurves.getByOIDX9((ASN1ObjectIdentifier)aSN1ObjectIdentifier).getCurve();
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration providerConfiguration, java.security.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters;
        if (eCParameterSpec == null) {
            ECParameterSpec eCParameterSpec2 = providerConfiguration.getEcImplicitlyCa();
            eCDomainParameters = new ECDomainParameters(eCParameterSpec2.getCurve(), eCParameterSpec2.getG(), eCParameterSpec2.getN(), eCParameterSpec2.getH(), eCParameterSpec2.getSeed());
        } else {
            eCDomainParameters = ECUtil.getDomainParameters((ProviderConfiguration)providerConfiguration, (ECParameterSpec)EC5Util.convertSpec((java.security.spec.ECParameterSpec)eCParameterSpec));
        }
        return eCDomainParameters;
    }

    public static java.security.spec.ECParameterSpec convertToSpec(X962Parameters x962Parameters, ECCurve eCCurve) {
        Object object;
        if (x962Parameters.isNamedCurve()) {
            Map map;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)x962Parameters.getParameters();
            X9ECParameters x9ECParameters = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            if (x9ECParameters == null && !(map = BouncyCastleProvider.CONFIGURATION.getAdditionalECParameters()).isEmpty()) {
                x9ECParameters = (X9ECParameters)map.get(aSN1ObjectIdentifier);
            }
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCCurve, (byte[])x9ECParameters.getSeed());
            object = new ECNamedCurveSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1ObjectIdentifier), ellipticCurve, EC5Util.convertPoint((ECPoint)x9ECParameters.getG()), x9ECParameters.getN(), x9ECParameters.getH());
        } else if (x962Parameters.isImplicitlyCA()) {
            object = null;
        } else {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)x962Parameters.getParameters());
            if (aSN1Sequence.size() > 3) {
                X9ECParameters x9ECParameters = X9ECParameters.getInstance((Object)aSN1Sequence);
                EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCCurve, (byte[])x9ECParameters.getSeed());
                object = x9ECParameters.getH() != null ? new java.security.spec.ECParameterSpec(ellipticCurve, EC5Util.convertPoint((ECPoint)x9ECParameters.getG()), x9ECParameters.getN(), x9ECParameters.getH().intValue()) : new java.security.spec.ECParameterSpec(ellipticCurve, EC5Util.convertPoint((ECPoint)x9ECParameters.getG()), x9ECParameters.getN(), 1);
            } else {
                GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = GOST3410PublicKeyAlgParameters.getInstance((Object)aSN1Sequence);
                ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec((String)ECGOST3410NamedCurves.getName((ASN1ObjectIdentifier)gOST3410PublicKeyAlgParameters.getPublicKeyParamSet()));
                eCCurve = eCNamedCurveParameterSpec.getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCCurve, (byte[])eCNamedCurveParameterSpec.getSeed());
                object = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName((ASN1ObjectIdentifier)gOST3410PublicKeyAlgParameters.getPublicKeyParamSet()), ellipticCurve, EC5Util.convertPoint((ECPoint)eCNamedCurveParameterSpec.getG()), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH());
            }
        }
        return object;
    }

    public static java.security.spec.ECParameterSpec convertToSpec(X9ECParameters x9ECParameters) {
        return new java.security.spec.ECParameterSpec(EC5Util.convertCurve((ECCurve)x9ECParameters.getCurve(), null), EC5Util.convertPoint((ECPoint)x9ECParameters.getG()), x9ECParameters.getN(), x9ECParameters.getH().intValue());
    }

    public static java.security.spec.ECParameterSpec convertToSpec(ECDomainParameters eCDomainParameters) {
        return new java.security.spec.ECParameterSpec(EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), null), EC5Util.convertPoint((ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
    }

    public static EllipticCurve convertCurve(ECCurve eCCurve, byte[] byArray) {
        ECField eCField = EC5Util.convertField((FiniteField)eCCurve.getField());
        BigInteger bigInteger = eCCurve.getA().toBigInteger();
        BigInteger bigInteger2 = eCCurve.getB().toBigInteger();
        return new EllipticCurve(eCField, bigInteger, bigInteger2, null);
    }

    public static ECCurve convertCurve(EllipticCurve ellipticCurve) {
        ECField eCField = ellipticCurve.getField();
        BigInteger bigInteger = ellipticCurve.getA();
        BigInteger bigInteger2 = ellipticCurve.getB();
        if (eCField instanceof ECFieldFp) {
            ECCurve.Fp fp = new ECCurve.Fp(((ECFieldFp)eCField).getP(), bigInteger, bigInteger2);
            if (customCurves.containsKey(fp)) {
                return (ECCurve)customCurves.get(fp);
            }
            return fp;
        }
        ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
        int n = eCFieldF2m.getM();
        int[] nArray = ECUtil.convertMidTerms((int[])eCFieldF2m.getMidTermsOfReductionPolynomial());
        return new ECCurve.F2m(n, nArray[0], nArray[1], nArray[2], bigInteger, bigInteger2);
    }

    public static ECField convertField(FiniteField finiteField) {
        if (ECAlgorithms.isFpField((FiniteField)finiteField)) {
            return new ECFieldFp(finiteField.getCharacteristic());
        }
        Polynomial polynomial = ((PolynomialExtensionField)finiteField).getMinimalPolynomial();
        int[] nArray = polynomial.getExponentsPresent();
        int[] nArray2 = Arrays.reverseInPlace((int[])Arrays.copyOfRange((int[])nArray, (int)1, (int)(nArray.length - 1)));
        return new ECFieldF2m(polynomial.getDegree(), nArray2);
    }

    public static java.security.spec.ECParameterSpec convertSpec(EllipticCurve ellipticCurve, ECParameterSpec eCParameterSpec) {
        java.security.spec.ECPoint eCPoint = EC5Util.convertPoint((ECPoint)eCParameterSpec.getG());
        if (eCParameterSpec instanceof ECNamedCurveParameterSpec) {
            String string = ((ECNamedCurveParameterSpec)eCParameterSpec).getName();
            return new ECNamedCurveSpec(string, ellipticCurve, eCPoint, eCParameterSpec.getN(), eCParameterSpec.getH());
        }
        return new java.security.spec.ECParameterSpec(ellipticCurve, eCPoint, eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
    }

    public static ECParameterSpec convertSpec(java.security.spec.ECParameterSpec eCParameterSpec) {
        ECCurve eCCurve = EC5Util.convertCurve((EllipticCurve)eCParameterSpec.getCurve());
        ECPoint eCPoint = EC5Util.convertPoint((ECCurve)eCCurve, (java.security.spec.ECPoint)eCParameterSpec.getGenerator());
        BigInteger bigInteger = eCParameterSpec.getOrder();
        BigInteger bigInteger2 = BigInteger.valueOf(eCParameterSpec.getCofactor());
        byte[] byArray = eCParameterSpec.getCurve().getSeed();
        if (eCParameterSpec instanceof ECNamedCurveSpec) {
            return new ECNamedCurveParameterSpec(((ECNamedCurveSpec)eCParameterSpec).getName(), eCCurve, eCPoint, bigInteger, bigInteger2, byArray);
        }
        return new ECParameterSpec(eCCurve, eCPoint, bigInteger, bigInteger2, byArray);
    }

    public static ECPoint convertPoint(java.security.spec.ECParameterSpec eCParameterSpec, java.security.spec.ECPoint eCPoint) {
        return EC5Util.convertPoint((ECCurve)EC5Util.convertCurve((EllipticCurve)eCParameterSpec.getCurve()), (java.security.spec.ECPoint)eCPoint);
    }

    public static ECPoint convertPoint(ECCurve eCCurve, java.security.spec.ECPoint eCPoint) {
        return eCCurve.createPoint(eCPoint.getAffineX(), eCPoint.getAffineY());
    }

    public static java.security.spec.ECPoint convertPoint(ECPoint eCPoint) {
        eCPoint = eCPoint.normalize();
        return new java.security.spec.ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger());
    }

    static {
        ECCurve eCCurve;
        Object object;
        customCurves = new HashMap();
        Enumeration enumeration = CustomNamedCurves.getNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            eCCurve = ECNamedCurveTable.getByName((String)object);
            if (eCCurve == null) continue;
            customCurves.put(eCCurve.getCurve(), CustomNamedCurves.getByName((String)object).getCurve());
        }
        object = CustomNamedCurves.getByName((String)"Curve25519");
        eCCurve = object.getCurve();
        customCurves.put(new ECCurve.Fp(eCCurve.getField().getCharacteristic(), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), eCCurve.getOrder(), eCCurve.getCofactor()), eCCurve);
    }
}

