/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.math.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import sqldelight.org.bouncycastle.math.ec.ECAlgorithms;
import sqldelight.org.bouncycastle.math.ec.ECCurve;
import sqldelight.org.bouncycastle.math.ec.ECFieldElement;
import sqldelight.org.bouncycastle.math.ec.ECLookupTable;
import sqldelight.org.bouncycastle.math.ec.ECMultiplier;
import sqldelight.org.bouncycastle.math.ec.ECPoint;
import sqldelight.org.bouncycastle.math.ec.GLVMultiplier;
import sqldelight.org.bouncycastle.math.ec.PreCompCallback;
import sqldelight.org.bouncycastle.math.ec.PreCompInfo;
import sqldelight.org.bouncycastle.math.ec.WNafL2RMultiplier;
import sqldelight.org.bouncycastle.math.ec.endo.ECEndomorphism;
import sqldelight.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import sqldelight.org.bouncycastle.math.field.FiniteField;
import sqldelight.org.bouncycastle.util.BigIntegers;
import sqldelight.org.bouncycastle.util.Integers;

public abstract class ECCurve {
    public static final int COORD_AFFINE = 0;
    public static final int COORD_HOMOGENEOUS = 1;
    public static final int COORD_JACOBIAN = 2;
    public static final int COORD_JACOBIAN_CHUDNOVSKY = 3;
    public static final int COORD_JACOBIAN_MODIFIED = 4;
    public static final int COORD_LAMBDA_AFFINE = 5;
    public static final int COORD_LAMBDA_PROJECTIVE = 6;
    public static final int COORD_SKEWED = 7;
    protected FiniteField field;
    protected ECFieldElement a;
    protected ECFieldElement b;
    protected BigInteger order;
    protected BigInteger cofactor;
    protected int coord = 0;
    protected ECEndomorphism endomorphism = null;
    protected ECMultiplier multiplier = null;

    public static int[] getAllCoordinateSystems() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    protected ECCurve(FiniteField finiteField) {
        this.field = finiteField;
    }

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract boolean isValidFieldElement(BigInteger var1);

    public abstract ECFieldElement randomFieldElement(SecureRandom var1);

    public abstract ECFieldElement randomFieldElementMult(SecureRandom var1);

    public synchronized Config configure() {
        return new Config(this, this.coord, this.endomorphism, this.multiplier);
    }

    public ECPoint validatePoint(BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint = this.createPoint(bigInteger, bigInteger2);
        if (!eCPoint.isValid()) {
            throw new IllegalArgumentException("Invalid point coordinates");
        }
        return eCPoint;
    }

    public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2) {
        return this.createRawPoint(this.fromBigInteger(bigInteger), this.fromBigInteger(bigInteger2));
    }

    protected abstract ECCurve cloneCurve();

    protected abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2);

    protected abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2, ECFieldElement[] var3);

    protected ECMultiplier createDefaultMultiplier() {
        if (this.endomorphism instanceof GLVEndomorphism) {
            return new GLVMultiplier(this, (GLVEndomorphism)this.endomorphism);
        }
        return new WNafL2RMultiplier();
    }

    public boolean supportsCoordinateSystem(int n) {
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreCompInfo getPreCompInfo(ECPoint eCPoint, String string) {
        Hashtable hashtable;
        this.checkPoint(eCPoint);
        Object object = eCPoint;
        synchronized (object) {
            hashtable = eCPoint.preCompTable;
        }
        if (null == hashtable) {
            return null;
        }
        object = hashtable;
        synchronized (object) {
            return (PreCompInfo)hashtable.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreCompInfo precompute(ECPoint eCPoint, String string, PreCompCallback preCompCallback) {
        Hashtable<String, PreCompInfo> hashtable;
        this.checkPoint(eCPoint);
        Object object = eCPoint;
        synchronized (object) {
            hashtable = eCPoint.preCompTable;
            if (null == hashtable) {
                eCPoint.preCompTable = hashtable = new Hashtable<String, PreCompInfo>(4);
            }
        }
        object = hashtable;
        synchronized (object) {
            PreCompInfo preCompInfo = (PreCompInfo)hashtable.get(string);
            PreCompInfo preCompInfo2 = preCompCallback.precompute(preCompInfo);
            if (preCompInfo2 != preCompInfo) {
                hashtable.put(string, preCompInfo2);
            }
            return preCompInfo2;
        }
    }

    public ECPoint importPoint(ECPoint eCPoint) {
        if (this == eCPoint.getCurve()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this.getInfinity();
        }
        eCPoint = eCPoint.normalize();
        return this.createPoint(eCPoint.getXCoord().toBigInteger(), eCPoint.getYCoord().toBigInteger());
    }

    public void normalizeAll(ECPoint[] eCPointArray) {
        this.normalizeAll(eCPointArray, 0, eCPointArray.length, null);
    }

    public void normalizeAll(ECPoint[] eCPointArray, int n, int n2, ECFieldElement eCFieldElement) {
        int n3;
        this.checkPoints(eCPointArray, n, n2);
        switch (this.getCoordinateSystem()) {
            case 0: 
            case 5: {
                if (eCFieldElement != null) {
                    throw new IllegalArgumentException("'iso' not valid for affine coordinates");
                }
                return;
            }
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[n2];
        int[] nArray = new int[n2];
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            ECPoint eCPoint = eCPointArray[n + n3];
            if (null == eCPoint || eCFieldElement == null && eCPoint.isNormalized()) continue;
            eCFieldElementArray[n4] = eCPoint.getZCoord(0);
            nArray[n4++] = n + n3;
        }
        if (n4 == 0) {
            return;
        }
        ECAlgorithms.montgomeryTrick((ECFieldElement[])eCFieldElementArray, (int)0, (int)n4, (ECFieldElement)eCFieldElement);
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            eCPointArray[n5] = eCPointArray[n5].normalize(eCFieldElementArray[n3]);
        }
    }

    public abstract ECPoint getInfinity();

    public FiniteField getField() {
        return this.field;
    }

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public BigInteger getOrder() {
        return this.order;
    }

    public BigInteger getCofactor() {
        return this.cofactor;
    }

    public int getCoordinateSystem() {
        return this.coord;
    }

    protected abstract ECPoint decompressPoint(int var1, BigInteger var2);

    public ECEndomorphism getEndomorphism() {
        return this.endomorphism;
    }

    public ECMultiplier getMultiplier() {
        if (this.multiplier == null) {
            this.multiplier = this.createDefaultMultiplier();
        }
        return this.multiplier;
    }

    public ECPoint decodePoint(byte[] byArray) {
        ECPoint eCPoint = null;
        int n = (this.getFieldSize() + 7) / 8;
        byte by = byArray[0];
        switch (by) {
            case 0: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("Incorrect length for infinity encoding");
                }
                eCPoint = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                if (byArray.length != n + 1) {
                    throw new IllegalArgumentException("Incorrect length for compressed encoding");
                }
                int n2 = by & 1;
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)1, (int)n);
                eCPoint = this.decompressPoint(n2, bigInteger);
                if (eCPoint.implIsValid(true, true)) break;
                throw new IllegalArgumentException("Invalid point");
            }
            case 4: {
                if (byArray.length != 2 * n + 1) {
                    throw new IllegalArgumentException("Incorrect length for uncompressed encoding");
                }
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)1, (int)n);
                BigInteger bigInteger2 = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)(1 + n), (int)n);
                eCPoint = this.validatePoint(bigInteger, bigInteger2);
                break;
            }
            case 6: 
            case 7: {
                if (byArray.length != 2 * n + 1) {
                    throw new IllegalArgumentException("Incorrect length for hybrid encoding");
                }
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)1, (int)n);
                BigInteger bigInteger3 = BigIntegers.fromUnsignedByteArray((byte[])byArray, (int)(1 + n), (int)n);
                if (bigInteger3.testBit(0) != (by == 7)) {
                    throw new IllegalArgumentException("Inconsistent Y coordinate in hybrid encoding");
                }
                eCPoint = this.validatePoint(bigInteger, bigInteger3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid point encoding 0x" + Integer.toString(by, 16));
            }
        }
        if (by != 0 && eCPoint.isInfinity()) {
            throw new IllegalArgumentException("Invalid infinity encoding");
        }
        return eCPoint;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int n3 = this.getFieldSize() + 7 >>> 3;
        byte[] byArray = new byte[n2 * n3 * 2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            byte[] byArray2 = eCPoint.getRawXCoord().toBigInteger().toByteArray();
            byte[] byArray3 = eCPoint.getRawYCoord().toBigInteger().toByteArray();
            int n5 = byArray2.length > n3 ? 1 : 0;
            int n6 = byArray2.length - n5;
            int n7 = byArray3.length > n3 ? 1 : 0;
            int n8 = byArray3.length - n7;
            System.arraycopy(byArray2, n5, byArray, n4 + n3 - n6, n6);
            System.arraycopy(byArray3, n7, byArray, (n4 += n3) + n3 - n8, n8);
            n4 += n3;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void checkPoint(ECPoint eCPoint) {
        if (null == eCPoint || this != eCPoint.getCurve()) {
            throw new IllegalArgumentException("'point' must be non-null and on this curve");
        }
    }

    protected void checkPoints(ECPoint[] eCPointArray) {
        this.checkPoints(eCPointArray, 0, eCPointArray.length);
    }

    protected void checkPoints(ECPoint[] eCPointArray, int n, int n2) {
        if (eCPointArray == null) {
            throw new IllegalArgumentException("'points' cannot be null");
        }
        if (n < 0 || n2 < 0 || n > eCPointArray.length - n2) {
            throw new IllegalArgumentException("invalid range specified for 'points'");
        }
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            if (null == eCPoint || this == eCPoint.getCurve()) continue;
            throw new IllegalArgumentException("'points' entries must be null or on this curve");
        }
    }

    public boolean equals(ECCurve eCCurve) {
        return this == eCCurve || null != eCCurve && this.getField().equals(eCCurve.getField()) && this.getA().toBigInteger().equals(eCCurve.getA().toBigInteger()) && this.getB().toBigInteger().equals(eCCurve.getB().toBigInteger());
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ECCurve && this.equals((ECCurve)object);
    }

    public int hashCode() {
        return this.getField().hashCode() ^ Integers.rotateLeft((int)this.getA().toBigInteger().hashCode(), (int)8) ^ Integers.rotateLeft((int)this.getB().toBigInteger().hashCode(), (int)16);
    }
}

