/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.math.ec;

import java.math.BigInteger;
import sqldelight.org.bouncycastle.math.ec.AbstractECMultiplier;
import sqldelight.org.bouncycastle.math.ec.ECAlgorithms;
import sqldelight.org.bouncycastle.math.ec.ECCurve;
import sqldelight.org.bouncycastle.math.ec.ECPoint;
import sqldelight.org.bouncycastle.math.ec.endo.ECEndomorphism;
import sqldelight.org.bouncycastle.math.ec.endo.EndoUtil;
import sqldelight.org.bouncycastle.math.ec.endo.GLVEndomorphism;

public class GLVMultiplier
extends AbstractECMultiplier {
    protected final ECCurve curve;
    protected final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve eCCurve, GLVEndomorphism gLVEndomorphism) {
        if (eCCurve == null || eCCurve.getOrder() == null) {
            throw new IllegalArgumentException("Need curve with known group order");
        }
        this.curve = eCCurve;
        this.glvEndomorphism = gLVEndomorphism;
    }

    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        if (!this.curve.equals(eCPoint.getCurve())) {
            throw new IllegalStateException();
        }
        BigInteger bigInteger2 = eCPoint.getCurve().getOrder();
        BigInteger[] bigIntegerArray = this.glvEndomorphism.decomposeScalar(bigInteger.mod(bigInteger2));
        BigInteger bigInteger3 = bigIntegerArray[0];
        BigInteger bigInteger4 = bigIntegerArray[1];
        if (this.glvEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implShamirsTrickWNaf((ECEndomorphism)this.glvEndomorphism, (ECPoint)eCPoint, (BigInteger)bigInteger3, (BigInteger)bigInteger4);
        }
        ECPoint eCPoint2 = EndoUtil.mapPoint((ECEndomorphism)this.glvEndomorphism, (ECPoint)eCPoint);
        return ECAlgorithms.implShamirsTrickWNaf((ECPoint)eCPoint, (BigInteger)bigInteger3, (ECPoint)eCPoint2, (BigInteger)bigInteger4);
    }
}

