/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import sqldelight.org.bouncycastle.math.ec.ECFieldElement;
import sqldelight.org.bouncycastle.math.ec.custom.sec.SecP192K1Field;
import sqldelight.org.bouncycastle.math.raw.Nat192;
import sqldelight.org.bouncycastle.util.Arrays;
import sqldelight.org.bouncycastle.util.encoders.Hex;

public class SecP192K1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict((String)"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFEE37"));
    protected int[] x;

    public SecP192K1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP192K1FieldElement");
        }
        this.x = SecP192K1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP192K1FieldElement() {
        this.x = Nat192.create();
    }

    protected SecP192K1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat192.isZero((int[])this.x);
    }

    public boolean isOne() {
        return Nat192.isOne((int[])this.x);
    }

    public boolean testBitZero() {
        return Nat192.getBit((int[])this.x, (int)0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat192.toBigInteger((int[])this.x);
    }

    public String getFieldName() {
        return "SecP192K1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192K1Field.add((int[])this.x, (int[])((SecP192K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP192K1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat192.create();
        SecP192K1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP192K1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192K1Field.subtract((int[])this.x, (int[])((SecP192K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP192K1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192K1Field.multiply((int[])this.x, (int[])((SecP192K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP192K1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192K1Field.inv((int[])((SecP192K1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP192K1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP192K1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat192.create();
        SecP192K1Field.negate((int[])this.x, (int[])nArray);
        return new SecP192K1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat192.create();
        SecP192K1Field.square((int[])this.x, (int[])nArray);
        return new SecP192K1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat192.create();
        SecP192K1Field.inv((int[])this.x, (int[])nArray);
        return new SecP192K1FieldElement(nArray);
    }

    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat192.isZero((int[])nArray) || Nat192.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat192.create();
        SecP192K1Field.square((int[])nArray, (int[])nArray2);
        SecP192K1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        int[] nArray3 = Nat192.create();
        SecP192K1Field.square((int[])nArray2, (int[])nArray3);
        SecP192K1Field.multiply((int[])nArray3, (int[])nArray, (int[])nArray3);
        int[] nArray4 = Nat192.create();
        SecP192K1Field.squareN((int[])nArray3, (int)3, (int[])nArray4);
        SecP192K1Field.multiply((int[])nArray4, (int[])nArray3, (int[])nArray4);
        int[] nArray5 = nArray4;
        SecP192K1Field.squareN((int[])nArray4, (int)2, (int[])nArray5);
        SecP192K1Field.multiply((int[])nArray5, (int[])nArray2, (int[])nArray5);
        int[] nArray6 = nArray2;
        SecP192K1Field.squareN((int[])nArray5, (int)8, (int[])nArray6);
        SecP192K1Field.multiply((int[])nArray6, (int[])nArray5, (int[])nArray6);
        int[] nArray7 = nArray5;
        SecP192K1Field.squareN((int[])nArray6, (int)3, (int[])nArray7);
        SecP192K1Field.multiply((int[])nArray7, (int[])nArray3, (int[])nArray7);
        int[] nArray8 = Nat192.create();
        SecP192K1Field.squareN((int[])nArray7, (int)16, (int[])nArray8);
        SecP192K1Field.multiply((int[])nArray8, (int[])nArray6, (int[])nArray8);
        int[] nArray9 = nArray6;
        SecP192K1Field.squareN((int[])nArray8, (int)35, (int[])nArray9);
        SecP192K1Field.multiply((int[])nArray9, (int[])nArray8, (int[])nArray9);
        int[] nArray10 = nArray8;
        SecP192K1Field.squareN((int[])nArray9, (int)70, (int[])nArray10);
        SecP192K1Field.multiply((int[])nArray10, (int[])nArray9, (int[])nArray10);
        int[] nArray11 = nArray9;
        SecP192K1Field.squareN((int[])nArray10, (int)19, (int[])nArray11);
        SecP192K1Field.multiply((int[])nArray11, (int[])nArray7, (int[])nArray11);
        int[] nArray12 = nArray11;
        SecP192K1Field.squareN((int[])nArray12, (int)20, (int[])nArray12);
        SecP192K1Field.multiply((int[])nArray12, (int[])nArray7, (int[])nArray12);
        SecP192K1Field.squareN((int[])nArray12, (int)4, (int[])nArray12);
        SecP192K1Field.multiply((int[])nArray12, (int[])nArray3, (int[])nArray12);
        SecP192K1Field.squareN((int[])nArray12, (int)6, (int[])nArray12);
        SecP192K1Field.multiply((int[])nArray12, (int[])nArray3, (int[])nArray12);
        SecP192K1Field.square((int[])nArray12, (int[])nArray12);
        int[] nArray13 = nArray3;
        SecP192K1Field.square((int[])nArray12, (int[])nArray13);
        return Nat192.eq((int[])nArray, (int[])nArray13) ? new SecP192K1FieldElement(nArray12) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP192K1FieldElement)) {
            return false;
        }
        SecP192K1FieldElement secP192K1FieldElement = (SecP192K1FieldElement)object;
        return Nat192.eq((int[])this.x, (int[])secP192K1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode((int[])this.x, (int)0, (int)6);
    }
}

