/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.security.SecureRandom;
import sqldelight.org.bouncycastle.math.raw.Mod;
import sqldelight.org.bouncycastle.math.raw.Nat;
import sqldelight.org.bouncycastle.math.raw.Nat192;
import sqldelight.org.bouncycastle.util.Pack;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecP192R1Field {
    private static final long M = 0xFFFFFFFFL;
    static final int[] P = new int[]{-1, -1, -2, -1, -1, -1};
    private static final int[] PExt = new int[]{1, 0, 2, 0, 1, 0, -2, -1, -3, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-1, -1, -3, -1, -2, -1, 1, 0, 2};
    private static final int P5 = -1;
    private static final int PExt11 = -1;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat192.add((int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0 || nArray3[5] == -1 && Nat192.gte((int[])nArray3, (int[])P)) {
            SecP192R1Field.addPInvTo((int[])nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.add((int)12, (int[])nArray, (int[])nArray2, (int[])nArray3);
        if ((n != 0 || nArray3[11] == -1 && Nat.gte((int)12, (int[])nArray3, (int[])PExt)) && Nat.addTo((int)PExtInv.length, (int[])PExtInv, (int[])nArray3) != 0) {
            Nat.incAt((int)12, (int[])nArray3, (int)PExtInv.length);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        int n = Nat.inc((int)6, (int[])nArray, (int[])nArray2);
        if (n != 0 || nArray2[5] == -1 && Nat192.gte((int[])nArray2, (int[])P)) {
            SecP192R1Field.addPInvTo((int[])nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        int[] nArray = Nat192.fromBigInteger((BigInteger)bigInteger);
        if (nArray[5] == -1 && Nat192.gte((int[])nArray, (int[])P)) {
            Nat192.subFrom((int[])P, (int[])nArray);
        }
        return nArray;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit((int)6, (int[])nArray, (int)0, (int[])nArray2);
        } else {
            int n = Nat192.add((int[])nArray, (int[])P, (int[])nArray2);
            Nat.shiftDownBit((int)6, (int[])nArray2, (int)n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse((int[])P, (int[])nArray, (int[])nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            n |= nArray[i];
        }
        n = n >>> 1 | n & 1;
        return n - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat192.createExt();
        Nat192.mul((int[])nArray, (int[])nArray2, (int[])nArray4);
        SecP192R1Field.reduce((int[])nArray4, (int[])nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat192.mulAddTo((int[])nArray, (int[])nArray2, (int[])nArray3);
        if ((n != 0 || nArray3[11] == -1 && Nat.gte((int)12, (int[])nArray3, (int[])PExt)) && Nat.addTo((int)PExtInv.length, (int[])PExtInv, (int[])nArray3) != 0) {
            Nat.incAt((int)12, (int[])nArray3, (int)PExtInv.length);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (0 != SecP192R1Field.isZero((int[])nArray)) {
            Nat192.sub((int[])P, (int[])P, (int[])nArray2);
        } else {
            Nat192.sub((int[])P, (int[])nArray, (int[])nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        byte[] byArray = new byte[24];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt((byte[])byArray, (int)0, (int[])nArray, (int)0, (int)6);
        } while (0 == Nat.lessThan((int)6, (int[])nArray, (int[])P));
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP192R1Field.random((SecureRandom)secureRandom, (int[])nArray);
        } while (0 != SecP192R1Field.isZero((int[])nArray));
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l = (long)nArray[6] & 0xFFFFFFFFL;
        long l2 = (long)nArray[7] & 0xFFFFFFFFL;
        long l3 = (long)nArray[8] & 0xFFFFFFFFL;
        long l4 = (long)nArray[9] & 0xFFFFFFFFL;
        long l5 = (long)nArray[10] & 0xFFFFFFFFL;
        long l6 = (long)nArray[11] & 0xFFFFFFFFL;
        long l7 = l + l5;
        long l8 = l2 + l6;
        long l9 = 0L;
        int n = (int)(l9 += ((long)nArray[0] & 0xFFFFFFFFL) + l7);
        l9 >>= 32;
        nArray2[1] = (int)(l9 += ((long)nArray[1] & 0xFFFFFFFFL) + l8);
        l9 >>= 32;
        long l10 = (l9 += ((long)nArray[2] & 0xFFFFFFFFL) + (l7 += l3)) & 0xFFFFFFFFL;
        l9 >>= 32;
        nArray2[3] = (int)(l9 += ((long)nArray[3] & 0xFFFFFFFFL) + (l8 += l4));
        l9 >>= 32;
        nArray2[4] = (int)(l9 += ((long)nArray[4] & 0xFFFFFFFFL) + (l7 -= l));
        l9 >>= 32;
        nArray2[5] = (int)(l9 += ((long)nArray[5] & 0xFFFFFFFFL) + (l8 -= l2));
        l10 += (l9 >>= 32);
        nArray2[0] = (int)(l9 += (long)n & 0xFFFFFFFFL);
        if ((l9 >>= 32) != 0L) {
            nArray2[1] = (int)(l9 += (long)nArray2[1] & 0xFFFFFFFFL);
            l10 += l9 >> 32;
        }
        nArray2[2] = (int)l10;
        l9 = l10 >> 32;
        if (l9 != 0L && Nat.incAt((int)6, (int[])nArray2, (int)3) != 0 || nArray2[5] == -1 && Nat192.gte((int[])nArray2, (int[])P)) {
            SecP192R1Field.addPInvTo((int[])nArray2);
        }
    }

    public static void reduce32(int n, int[] nArray) {
        long l = 0L;
        if (n != 0) {
            long l2 = (long)n & 0xFFFFFFFFL;
            nArray[0] = (int)(l += ((long)nArray[0] & 0xFFFFFFFFL) + l2);
            if ((l >>= 32) != 0L) {
                nArray[1] = (int)(l += (long)nArray[1] & 0xFFFFFFFFL);
                l >>= 32;
            }
            nArray[2] = (int)(l += ((long)nArray[2] & 0xFFFFFFFFL) + l2);
            l >>= 32;
        }
        if (l != 0L && Nat.incAt((int)6, (int[])nArray, (int)3) != 0 || nArray[5] == -1 && Nat192.gte((int[])nArray, (int[])P)) {
            SecP192R1Field.addPInvTo((int[])nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat192.createExt();
        Nat192.square((int[])nArray, (int[])nArray3);
        SecP192R1Field.reduce((int[])nArray3, (int[])nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat192.createExt();
        Nat192.square((int[])nArray, (int[])nArray3);
        SecP192R1Field.reduce((int[])nArray3, (int[])nArray2);
        while (--n > 0) {
            Nat192.square((int[])nArray2, (int[])nArray3);
            SecP192R1Field.reduce((int[])nArray3, (int[])nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat192.sub((int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0) {
            SecP192R1Field.subPInvFrom((int[])nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.sub((int)12, (int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0 && Nat.subFrom((int)PExtInv.length, (int[])PExtInv, (int[])nArray3) != 0) {
            Nat.decAt((int)12, (int[])nArray3, (int)PExtInv.length);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        int n = Nat.shiftUpBit((int)6, (int[])nArray, (int)0, (int[])nArray2);
        if (n != 0 || nArray2[5] == -1 && Nat192.gte((int[])nArray2, (int[])P)) {
            SecP192R1Field.addPInvTo((int[])nArray2);
        }
    }

    private static void addPInvTo(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            nArray[1] = (int)(l += (long)nArray[1] & 0xFFFFFFFFL);
            l >>= 32;
        }
        nArray[2] = (int)(l += ((long)nArray[2] & 0xFFFFFFFFL) + 1L);
        if ((l >>= 32) != 0L) {
            Nat.incAt((int)6, (int[])nArray, (int)3);
        }
    }

    private static void subPInvFrom(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            nArray[1] = (int)(l += (long)nArray[1] & 0xFFFFFFFFL);
            l >>= 32;
        }
        nArray[2] = (int)(l += ((long)nArray[2] & 0xFFFFFFFFL) - 1L);
        if ((l >>= 32) != 0L) {
            Nat.decAt((int)6, (int[])nArray, (int)3);
        }
    }
}

