/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.security.SecureRandom;
import sqldelight.org.bouncycastle.math.ec.ECConstants;
import sqldelight.org.bouncycastle.math.ec.ECCurve;
import sqldelight.org.bouncycastle.math.ec.ECFieldElement;
import sqldelight.org.bouncycastle.math.ec.ECLookupTable;
import sqldelight.org.bouncycastle.math.ec.ECPoint;
import sqldelight.org.bouncycastle.math.ec.custom.sec.SecP256K1Field;
import sqldelight.org.bouncycastle.math.ec.custom.sec.SecP256K1FieldElement;
import sqldelight.org.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import sqldelight.org.bouncycastle.math.raw.Nat256;
import sqldelight.org.bouncycastle.util.encoders.Hex;

public class SecP256K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP256K1FieldElement.Q;
    private static final int SECP256K1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP256K1_AFFINE_ZS = new ECFieldElement[]{new SecP256K1FieldElement(ECConstants.ONE)};
    protected SecP256K1Point infinity = new SecP256K1Point((ECCurve)this, null, null);

    public SecP256K1Curve() {
        super(q);
        this.a = this.fromBigInteger(ECConstants.ZERO);
        this.b = this.fromBigInteger(BigInteger.valueOf(7L));
        this.order = new BigInteger(1, Hex.decodeStrict((String)"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP256K1Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP256K1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP256K1Point((ECCurve)this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP256K1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 8 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat256.copy((int[])((SecP256K1FieldElement)eCPoint.getRawXCoord()).x, (int)0, (int[])nArray, (int)n3);
            Nat256.copy((int[])((SecP256K1FieldElement)eCPoint.getRawYCoord()).x, (int)0, (int[])nArray, (int)(n3 += 8));
            n3 += 8;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        SecP256K1Field.random((SecureRandom)secureRandom, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        SecP256K1Field.randomMult((SecureRandom)secureRandom, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    static /* synthetic */ ECFieldElement[] access$000() {
        return SECP256K1_AFFINE_ZS;
    }
}

