/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.security.SecureRandom;
import sqldelight.org.bouncycastle.math.raw.Mod;
import sqldelight.org.bouncycastle.math.raw.Nat;
import sqldelight.org.bouncycastle.math.raw.Nat384;
import sqldelight.org.bouncycastle.util.Pack;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecP384R1Field {
    private static final long M = 0xFFFFFFFFL;
    static final int[] P = new int[]{-1, 0, 0, -1, -2, -1, -1, -1, -1, -1, -1, -1};
    private static final int[] PExt = new int[]{1, -2, 0, 2, 0, -2, 0, 2, 1, 0, 0, 0, -2, 1, 0, -2, -3, -1, -1, -1, -1, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-1, 1, -1, -3, -1, 1, -1, -3, -2, -1, -1, -1, 1, -2, -1, 1, 2};
    private static final int P11 = -1;
    private static final int PExt23 = -1;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.add((int)12, (int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0 || nArray3[11] == -1 && Nat.gte((int)12, (int[])nArray3, (int[])P)) {
            SecP384R1Field.addPInvTo((int[])nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.add((int)24, (int[])nArray, (int[])nArray2, (int[])nArray3);
        if ((n != 0 || nArray3[23] == -1 && Nat.gte((int)24, (int[])nArray3, (int[])PExt)) && Nat.addTo((int)PExtInv.length, (int[])PExtInv, (int[])nArray3) != 0) {
            Nat.incAt((int)24, (int[])nArray3, (int)PExtInv.length);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        int n = Nat.inc((int)12, (int[])nArray, (int[])nArray2);
        if (n != 0 || nArray2[11] == -1 && Nat.gte((int)12, (int[])nArray2, (int[])P)) {
            SecP384R1Field.addPInvTo((int[])nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        int[] nArray = Nat.fromBigInteger((int)384, (BigInteger)bigInteger);
        if (nArray[11] == -1 && Nat.gte((int)12, (int[])nArray, (int[])P)) {
            Nat.subFrom((int)12, (int[])P, (int[])nArray);
        }
        return nArray;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit((int)12, (int[])nArray, (int)0, (int[])nArray2);
        } else {
            int n = Nat.add((int)12, (int[])nArray, (int[])P, (int[])nArray2);
            Nat.shiftDownBit((int)12, (int[])nArray2, (int)n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse((int[])P, (int[])nArray, (int[])nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 12; ++i) {
            n |= nArray[i];
        }
        n = n >>> 1 | n & 1;
        return n - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat.create((int)24);
        Nat384.mul((int[])nArray, (int[])nArray2, (int[])nArray4);
        SecP384R1Field.reduce((int[])nArray4, (int[])nArray3);
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (0 != SecP384R1Field.isZero((int[])nArray)) {
            Nat.sub((int)12, (int[])P, (int[])P, (int[])nArray2);
        } else {
            Nat.sub((int)12, (int[])P, (int[])nArray, (int[])nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        byte[] byArray = new byte[48];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt((byte[])byArray, (int)0, (int[])nArray, (int)0, (int)12);
        } while (0 == Nat.lessThan((int)12, (int[])nArray, (int[])P));
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP384R1Field.random((SecureRandom)secureRandom, (int[])nArray);
        } while (0 != SecP384R1Field.isZero((int[])nArray));
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l = (long)nArray[16] & 0xFFFFFFFFL;
        long l2 = (long)nArray[17] & 0xFFFFFFFFL;
        long l3 = (long)nArray[18] & 0xFFFFFFFFL;
        long l4 = (long)nArray[19] & 0xFFFFFFFFL;
        long l5 = (long)nArray[20] & 0xFFFFFFFFL;
        long l6 = (long)nArray[21] & 0xFFFFFFFFL;
        long l7 = (long)nArray[22] & 0xFFFFFFFFL;
        long l8 = (long)nArray[23] & 0xFFFFFFFFL;
        long l9 = ((long)nArray[12] & 0xFFFFFFFFL) + l5 - 1L;
        long l10 = ((long)nArray[13] & 0xFFFFFFFFL) + l7;
        long l11 = ((long)nArray[14] & 0xFFFFFFFFL) + l7 + l8;
        long l12 = ((long)nArray[15] & 0xFFFFFFFFL) + l8;
        long l13 = l2 + l6;
        long l14 = l6 - l8;
        long l15 = l7 - l8;
        long l16 = l9 + l14;
        long l17 = 0L;
        nArray2[0] = (int)(l17 += ((long)nArray[0] & 0xFFFFFFFFL) + l16);
        l17 >>= 32;
        nArray2[1] = (int)(l17 += ((long)nArray[1] & 0xFFFFFFFFL) + l8 - l9 + l10);
        l17 >>= 32;
        nArray2[2] = (int)(l17 += ((long)nArray[2] & 0xFFFFFFFFL) - l6 - l10 + l11);
        l17 >>= 32;
        nArray2[3] = (int)(l17 += ((long)nArray[3] & 0xFFFFFFFFL) - l11 + l12 + l16);
        l17 >>= 32;
        nArray2[4] = (int)(l17 += ((long)nArray[4] & 0xFFFFFFFFL) + l + l6 + l10 - l12 + l16);
        l17 >>= 32;
        nArray2[5] = (int)(l17 += ((long)nArray[5] & 0xFFFFFFFFL) - l + l10 + l11 + l13);
        l17 >>= 32;
        nArray2[6] = (int)(l17 += ((long)nArray[6] & 0xFFFFFFFFL) + l3 - l2 + l11 + l12);
        l17 >>= 32;
        nArray2[7] = (int)(l17 += ((long)nArray[7] & 0xFFFFFFFFL) + l + l4 - l3 + l12);
        l17 >>= 32;
        nArray2[8] = (int)(l17 += ((long)nArray[8] & 0xFFFFFFFFL) + l + l2 + l5 - l4);
        l17 >>= 32;
        nArray2[9] = (int)(l17 += ((long)nArray[9] & 0xFFFFFFFFL) + l3 - l5 + l13);
        l17 >>= 32;
        nArray2[10] = (int)(l17 += ((long)nArray[10] & 0xFFFFFFFFL) + l3 + l4 - l14 + l15);
        l17 >>= 32;
        nArray2[11] = (int)(l17 += ((long)nArray[11] & 0xFFFFFFFFL) + l4 + l5 - l15);
        l17 >>= 32;
        SecP384R1Field.reduce32((int)((int)(++l17)), (int[])nArray2);
    }

    public static void reduce32(int n, int[] nArray) {
        long l = 0L;
        if (n != 0) {
            long l2 = (long)n & 0xFFFFFFFFL;
            nArray[0] = (int)(l += ((long)nArray[0] & 0xFFFFFFFFL) + l2);
            l >>= 32;
            nArray[1] = (int)(l += ((long)nArray[1] & 0xFFFFFFFFL) - l2);
            if ((l >>= 32) != 0L) {
                nArray[2] = (int)(l += (long)nArray[2] & 0xFFFFFFFFL);
                l >>= 32;
            }
            nArray[3] = (int)(l += ((long)nArray[3] & 0xFFFFFFFFL) + l2);
            l >>= 32;
            nArray[4] = (int)(l += ((long)nArray[4] & 0xFFFFFFFFL) + l2);
            l >>= 32;
        }
        if (l != 0L && Nat.incAt((int)12, (int[])nArray, (int)5) != 0 || nArray[11] == -1 && Nat.gte((int)12, (int[])nArray, (int[])P)) {
            SecP384R1Field.addPInvTo((int[])nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat.create((int)24);
        Nat384.square((int[])nArray, (int[])nArray3);
        SecP384R1Field.reduce((int[])nArray3, (int[])nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat.create((int)24);
        Nat384.square((int[])nArray, (int[])nArray3);
        SecP384R1Field.reduce((int[])nArray3, (int[])nArray2);
        while (--n > 0) {
            Nat384.square((int[])nArray2, (int[])nArray3);
            SecP384R1Field.reduce((int[])nArray3, (int[])nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.sub((int)12, (int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0) {
            SecP384R1Field.subPInvFrom((int[])nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.sub((int)24, (int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0 && Nat.subFrom((int)PExtInv.length, (int[])PExtInv, (int[])nArray3) != 0) {
            Nat.decAt((int)24, (int[])nArray3, (int)PExtInv.length);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        int n = Nat.shiftUpBit((int)12, (int[])nArray, (int)0, (int[])nArray2);
        if (n != 0 || nArray2[11] == -1 && Nat.gte((int)12, (int[])nArray2, (int[])P)) {
            SecP384R1Field.addPInvTo((int[])nArray2);
        }
    }

    private static void addPInvTo(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l;
        l >>= 32;
        nArray[1] = (int)(l += ((long)nArray[1] & 0xFFFFFFFFL) - 1L);
        if ((l >>= 32) != 0L) {
            nArray[2] = (int)(l += (long)nArray[2] & 0xFFFFFFFFL);
            l >>= 32;
        }
        nArray[3] = (int)(l += ((long)nArray[3] & 0xFFFFFFFFL) + 1L);
        l >>= 32;
        nArray[4] = (int)(l += ((long)nArray[4] & 0xFFFFFFFFL) + 1L);
        if ((l >>= 32) != 0L) {
            Nat.incAt((int)12, (int[])nArray, (int)5);
        }
    }

    private static void subPInvFrom(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l;
        l >>= 32;
        nArray[1] = (int)(l += ((long)nArray[1] & 0xFFFFFFFFL) + 1L);
        if ((l >>= 32) != 0L) {
            nArray[2] = (int)(l += (long)nArray[2] & 0xFFFFFFFFL);
            l >>= 32;
        }
        nArray[3] = (int)(l += ((long)nArray[3] & 0xFFFFFFFFL) - 1L);
        l >>= 32;
        nArray[4] = (int)(l += ((long)nArray[4] & 0xFFFFFFFFL) - 1L);
        if ((l >>= 32) != 0L) {
            Nat.decAt((int)12, (int[])nArray, (int)5);
        }
    }
}

