/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import sqldelight.org.bouncycastle.math.ec.ECFieldElement;
import sqldelight.org.bouncycastle.math.ec.custom.sec.SecP384R1Field;
import sqldelight.org.bouncycastle.math.raw.Nat;
import sqldelight.org.bouncycastle.util.Arrays;
import sqldelight.org.bouncycastle.util.encoders.Hex;

public class SecP384R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict((String)"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF"));
    protected int[] x;

    public SecP384R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP384R1FieldElement");
        }
        this.x = SecP384R1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP384R1FieldElement() {
        this.x = Nat.create((int)12);
    }

    protected SecP384R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat.isZero((int)12, (int[])this.x);
    }

    public boolean isOne() {
        return Nat.isOne((int)12, (int[])this.x);
    }

    public boolean testBitZero() {
        return Nat.getBit((int[])this.x, (int)0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat.toBigInteger((int)12, (int[])this.x);
    }

    public String getFieldName() {
        return "SecP384R1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create((int)12);
        SecP384R1Field.add((int[])this.x, (int[])((SecP384R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP384R1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat.create((int)12);
        SecP384R1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP384R1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create((int)12);
        SecP384R1Field.subtract((int[])this.x, (int[])((SecP384R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP384R1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create((int)12);
        SecP384R1Field.multiply((int[])this.x, (int[])((SecP384R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP384R1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create((int)12);
        SecP384R1Field.inv((int[])((SecP384R1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP384R1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP384R1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat.create((int)12);
        SecP384R1Field.negate((int[])this.x, (int[])nArray);
        return new SecP384R1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat.create((int)12);
        SecP384R1Field.square((int[])this.x, (int[])nArray);
        return new SecP384R1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat.create((int)12);
        SecP384R1Field.inv((int[])this.x, (int[])nArray);
        return new SecP384R1FieldElement(nArray);
    }

    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat.isZero((int)12, (int[])nArray) || Nat.isOne((int)12, (int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat.create((int)12);
        int[] nArray3 = Nat.create((int)12);
        int[] nArray4 = Nat.create((int)12);
        int[] nArray5 = Nat.create((int)12);
        SecP384R1Field.square((int[])nArray, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray2, (int)2, (int[])nArray3);
        SecP384R1Field.multiply((int[])nArray3, (int[])nArray2, (int[])nArray3);
        SecP384R1Field.square((int[])nArray3, (int[])nArray3);
        SecP384R1Field.multiply((int[])nArray3, (int[])nArray, (int[])nArray3);
        SecP384R1Field.squareN((int[])nArray3, (int)5, (int[])nArray4);
        SecP384R1Field.multiply((int[])nArray4, (int[])nArray3, (int[])nArray4);
        SecP384R1Field.squareN((int[])nArray4, (int)5, (int[])nArray5);
        SecP384R1Field.multiply((int[])nArray5, (int[])nArray3, (int[])nArray5);
        SecP384R1Field.squareN((int[])nArray5, (int)15, (int[])nArray3);
        SecP384R1Field.multiply((int[])nArray3, (int[])nArray5, (int[])nArray3);
        SecP384R1Field.squareN((int[])nArray3, (int)2, (int[])nArray4);
        SecP384R1Field.multiply((int[])nArray2, (int[])nArray4, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray4, (int)28, (int[])nArray4);
        SecP384R1Field.multiply((int[])nArray3, (int[])nArray4, (int[])nArray3);
        SecP384R1Field.squareN((int[])nArray3, (int)60, (int[])nArray4);
        SecP384R1Field.multiply((int[])nArray4, (int[])nArray3, (int[])nArray4);
        int[] nArray6 = nArray3;
        SecP384R1Field.squareN((int[])nArray4, (int)120, (int[])nArray6);
        SecP384R1Field.multiply((int[])nArray6, (int[])nArray4, (int[])nArray6);
        SecP384R1Field.squareN((int[])nArray6, (int)15, (int[])nArray6);
        SecP384R1Field.multiply((int[])nArray6, (int[])nArray5, (int[])nArray6);
        SecP384R1Field.squareN((int[])nArray6, (int)33, (int[])nArray6);
        SecP384R1Field.multiply((int[])nArray6, (int[])nArray2, (int[])nArray6);
        SecP384R1Field.squareN((int[])nArray6, (int)64, (int[])nArray6);
        SecP384R1Field.multiply((int[])nArray6, (int[])nArray, (int[])nArray6);
        SecP384R1Field.squareN((int[])nArray6, (int)30, (int[])nArray2);
        SecP384R1Field.square((int[])nArray2, (int[])nArray3);
        return Nat.eq((int)12, (int[])nArray, (int[])nArray3) ? new SecP384R1FieldElement(nArray2) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP384R1FieldElement)) {
            return false;
        }
        SecP384R1FieldElement secP384R1FieldElement = (SecP384R1FieldElement)object;
        return Nat.eq((int)12, (int[])this.x, (int[])secP384R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode((int[])this.x, (int)0, (int)12);
    }
}

